/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;

public class GenerationMvtSaisieVenteFacture
extends GenerationEcritures
implements Runnable {
    public static final String ID = "accounting.records.invoice.sales";
    public static final String NOT_GEN_ECRITURE = "accounting.invoice.generation.disable";
    private static final String source = "SAISIE_VENTE_FACTURE";
    public static final Integer journal = 3;
    private int idSaisieVenteFacture;
    private boolean useComptePCEVente;
    private static final SQLTable saisieVFTable = base.getTable("SAISIE_VENTE_FACTURE");
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private static final SQLTable ecrTable = base.getTable("ECRITURE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private final boolean genereReglement;

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente, boolean genereReglement) {
        this(idSaisieVenteFacture, idMvt, useComptePCEVente, genereReglement, false);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente, boolean genereReglement, boolean threadSafe) {
        System.err.println("********* init GeneRation");
        this.idMvt = idMvt;
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        this.useComptePCEVente = useComptePCEVente;
        this.genereReglement = genereReglement;
        if (!threadSafe) {
            SheetXml.submitInQueue(this);
        }
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt, boolean useComptePCEVente) {
        this(idSaisieVenteFacture, idMvt, useComptePCEVente, true);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt) {
        this(idSaisieVenteFacture, idMvt, false, true);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture) {
        this(idSaisieVenteFacture, false);
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, boolean threadSafe) {
        this(idSaisieVenteFacture, 1, false, true, threadSafe);
    }

    public final void genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = saisieVFTable.getRow(this.idSaisieVenteFacture);
        this.setRowAnalytiqueSource(saisieRow);
        boolean genEcrDisabled = DefaultNXProps.getInstance().getBooleanValue(NOT_GEN_ECRITURE, false);
        this.putValue("ID_JOURNAL", journal);
        SQLRow clientRow = saisieRow.getForeignRow("ID_CLIENT");
        int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
        Boolean acompte = saisieRow.getBoolean("ACOMPTE");
        this.nom = acompte != null && acompte != false ? "Fact. acompte client" + saisieRow.getObject("NUMERO").toString() : "Fact. vente " + saisieRow.getObject("NUMERO").toString();
        boolean typeCaisse = false;
        SQLRow modeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
        SQLRow typeRegRow = modeRegl.getForeignRow("ID_TYPE_REGLEMENT");
        SQLRowAccessor nonEmptyForeign = modeRegl.getNonEmptyForeign("ID_BANQUE");
        if (nonEmptyForeign != null && nonEmptyForeign.getTable().contains("TYPE_CAISSE") && nonEmptyForeign.getBoolean("TYPE_CAISSE").booleanValue()) {
            typeCaisse = true;
            idCompteClient = nonEmptyForeign.getForeignID("ID_COMPTE_PCE");
            Number idJournal = nonEmptyForeign.getNonEmptyForeignIDNumber("ID_JOURNAL");
            if (idJournal != null) {
                this.putValue("ID_JOURNAL", idJournal);
            } else {
                this.putValue("ID_JOURNAL", 5);
            }
            this.nom = String.valueOf(this.nom) + " (" + typeRegRow.getString("NOM") + ") " + StringUtils.limitLength(clientRow.getString("NOM"), 20);
        } else {
            this.nom = String.valueOf(this.nom) + " " + StringUtils.limitLength(clientRow.getString("NOM"), 20);
        }
        if (SQLPreferences.getMemCached(saisieRow.getTable().getDBRoot()).getBoolean("RefFactureEcritureLibelle", false) && saisieRow.getString("NOM") != null && saisieRow.getString("NOM").trim().length() > 0) {
            this.nom = String.valueOf(this.nom) + " " + StringUtils.limitLength(saisieRow.getString("NOM"), 30);
        }
        PrixTTC prixTTC = new PrixTTC(((Long)saisieRow.getObject("T_TTC")).longValue());
        long montantAcompteTTC = 0L;
        this.putValue("NOM", this.nom);
        this.date = (Date)saisieRow.getObject("DATE");
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        provider.putLabel(saisieRow, this.mEcritures);
        this.putValue("DATE", this.date);
        this.putValue("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(saisieRow, rowValsPiece);
            this.getNewMouvement(source, this.idSaisieVenteFacture, 1, rowValsPiece);
        } else {
            this.putValue("ID_MOUVEMENT", this.idMvt);
            rowValsPiece = mvtTable.getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(saisieRow, rowValsPiece);
            rowValsPiece.update();
        }
        SQLTable tableEchantillon = null;
        BigDecimal portHT = BigDecimal.valueOf(saisieRow.getLong("PORT_HT")).movePointLeft(2);
        BigDecimal fraisDocHT = BigDecimal.valueOf(saisieRow.getLong("FRAIS_DOCUMENT_HT")).movePointLeft(2);
        SQLRow taxeDoc = saisieRow.getNonEmptyForeign("ID_TAXE_FRAIS_DOCUMENT") == null ? TaxeCache.getCache().getFirstTaxe() : TaxeCache.getCache().getRowFromId(saisieRow.getForeignID("ID_TAXE_FRAIS_DOCUMENT")).asRow();
        SQLRow taxePort = saisieRow.getNonEmptyForeign("ID_TAXE_PORT") == null ? TaxeCache.getCache().getFirstTaxe() : TaxeCache.getCache().getRowFromId(saisieRow.getForeignID("ID_TAXE_PORT")).asRow();
        boolean compteProduitAvanceClient = SQLPreferences.getMemCached(saisieRow.getTable().getDBRoot()).getBoolean("CompteProduitAvanceClient", false);
        Boolean factureSolde = saisieRow.getBoolean("SOLDE");
        Boolean factureIntermediaire = saisieRow.getBoolean("PARTIAL");
        TotalCalculator calc = clientRow.getTable().contains("ID_COMPTE_PCE_PRODUIT") && !clientRow.isForeignEmpty("ID_COMPTE_PCE_PRODUIT") ? this.getValuesFromElement(false, false, "T_PV_HT", saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), portHT, taxePort, fraisDocHT, taxeDoc, tableEchantillon, clientRow.getForeign("ID_COMPTE_PCE_PRODUIT")) : this.getValuesFromElement(saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), portHT, taxePort, fraisDocHT, taxeDoc, tableEchantillon);
        long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
        if (acompte == null || !acompte.booleanValue()) {
            if (compteProduitAvanceClient && factureIntermediaire.booleanValue()) {
                int compteAvanceClientID = rowPrefsCompte.getInt("ID_COMPTE_PCE_AVANCE_CLIENT");
                long total = 0L;
                for (SQLRowAccessor row : calc.getMapHt().keySet()) {
                    long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    total += b;
                }
                this.putValue("ID_COMPTE_PCE", compteAvanceClientID);
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", total);
                if (!genEcrDisabled) {
                    this.ajoutEcriture();
                }
            } else if (compteProduitAvanceClient && factureSolde.booleanValue()) {
                Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> taxeCompl = calc.getMapHtTaxeComplSansFacturable();
                for (SQLRowAccessor row : calc.getMapHtSansFacturable().keySet()) {
                    long b = calc.getMapHtSansFacturable().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    if (b == 0L) continue;
                    long taxe = 0L;
                    if (taxeCompl.containsKey(row)) {
                        Map<SQLRowAccessor, BigDecimal> compl = taxeCompl.get(row);
                        for (SQLRowAccessor sQLRowAccessor : compl.keySet()) {
                            if (compl.get(sQLRowAccessor) == null) continue;
                            long taxeC = compl.get(sQLRowAccessor).multiply(sQLRowAccessor.getBigDecimal("POURCENT").movePointLeft(2)).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                            this.putValue("ID_COMPTE_PCE", sQLRowAccessor.getForeignID("ID_COMPTE_PCE"));
                            this.putValue("DEBIT", 0L);
                            this.putValue("CREDIT", taxeC);
                            if (!genEcrDisabled) {
                                this.ajoutEcriture();
                            }
                            taxe += taxeC;
                        }
                    }
                    Integer idComptePCE = this.useComptePCEVente ? Integer.valueOf(saisieRow.getInt("ID_COMPTE_PCE_VENTE")) : Integer.valueOf(row.getID());
                    this.putValue("ID_COMPTE_PCE", idComptePCE);
                    this.putValue("DEBIT", 0L);
                    this.putValue("CREDIT", b - taxe);
                    if (genEcrDisabled) continue;
                    this.ajoutEcriture();
                }
                int compteAvanceClientID = rowPrefsCompte.getInt("ID_COMPTE_PCE_AVANCE_CLIENT");
                this.putValue("ID_COMPTE_PCE", compteAvanceClientID);
                this.putValue("DEBIT", calc.getTotalHTSansFActurable().subtract(calc.getTotalHT()).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue());
                this.putValue("CREDIT", 0L);
                if (!genEcrDisabled && !genEcrDisabled) {
                    this.ajoutEcriture();
                }
            } else {
                for (SQLRowAccessor row : calc.getMapHt().keySet()) {
                    long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    if (b == 0L) continue;
                    long taxe = 0L;
                    if (calc.getMapHtTaxeCompl().containsKey(row)) {
                        Map<SQLRowAccessor, BigDecimal> compl = calc.getMapHtTaxeCompl().get(row);
                        for (SQLRowAccessor rowCompl : compl.keySet()) {
                            if (compl.get(rowCompl) == null) continue;
                            long taxeC = compl.get(rowCompl).multiply(rowCompl.getBigDecimal("POURCENT").movePointLeft(2)).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                            this.putValue("ID_COMPTE_PCE", rowCompl.getForeignID("ID_COMPTE_PCE"));
                            this.putValue("DEBIT", 0L);
                            this.putValue("CREDIT", taxeC);
                            if (!genEcrDisabled) {
                                this.ajoutEcriture();
                            }
                            taxe += taxeC;
                        }
                    }
                    Integer idComptePCE = this.useComptePCEVente ? Integer.valueOf(saisieRow.getInt("ID_COMPTE_PCE_VENTE")) : Integer.valueOf(row.getID());
                    this.putValue("ID_COMPTE_PCE", idComptePCE);
                    this.putValue("DEBIT", 0L);
                    this.putValue("CREDIT", b - taxe);
                    if (genEcrDisabled) continue;
                    this.ajoutEcriture();
                }
            }
            Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
            for (SQLRowAccessor rowAc : tvaMap.keySet()) {
                long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                if (longValue == 0L) continue;
                this.putValue("ID_COMPTE_PCE", rowAc.getID());
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", longValue);
                if (genEcrDisabled) continue;
                this.ajoutEcriture();
            }
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            this.putValue("ID_COMPTE_PCE", idCompteClient);
            if (ecrTable.contains("CODE_CLIENT")) {
                this.putValue("CODE_CLIENT", clientRow.getString("CODE"));
            }
            this.putValue("DEBIT", ttcLongValue);
            this.putValue("CREDIT", 0L);
            if (!genEcrDisabled) {
                this.ajoutEcriture();
            }
        }
        SQLRowValues valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("DATE_REGLEMENT", null);
        valSasieVF.update(this.idSaisieVenteFacture);
        if (this.genereReglement) {
            SQLRow rowCptTiers;
            SQLRow rowClient;
            String label = String.valueOf(this.nom) + " (" + typeRegRow.getString("NOM") + ") ";
            int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
            if (idAvoir > 1) {
                long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
                prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
            }
            long totalNet = saisieRow.getLong("NET_A_PAYER");
            if (typeCaisse) {
                rowClient = null;
                rowCptTiers = modeRegl.getForeign("ID_BANQUE").getForeign("ID_COMPTE_PCE");
            } else {
                rowClient = clientRow;
                rowCptTiers = null;
            }
            String tiers = clientRow.getString("NOM");
            if (saisieRow.contains("POURCENT_RG") && saisieRow.getBigDecimal("POURCENT_RG") != null && saisieRow.getBigDecimal("POURCENT_RG").signum() != 0) {
                long totalRG = new BigDecimal(totalNet).multiply(saisieRow.getBigDecimal("POURCENT_RG"), DecimalUtils.HIGH_PRECISION).movePointLeft(2).setScale(0, RoundingMode.HALF_UP).longValue();
                PrixTTC prixTTC2 = new PrixTTC(totalRG);
                prixTTC = new PrixTTC(totalNet - totalRG);
                if (prixTTC.getLongValue() > 0L) {
                    new GenerationReglementVenteNG(label.trim(), rowClient, prixTTC, this.date, modeRegl, saisieRow, mvtTable.getRow(this.idMvt), true, false, tiers, rowCptTiers);
                }
                if (prixTTC2.getLongValue() > 0L) {
                    SQLRowValues rowValsMdrRg = new SQLRowValues(modeRegl.getTable());
                    rowValsMdrRg.put("AJOURS", 365);
                    rowValsMdrRg.put("LENJOUR", 0);
                    rowValsMdrRg.put("COMPTANT", Boolean.FALSE);
                    rowValsMdrRg.put("FIN_MOIS", Boolean.FALSE);
                    rowValsMdrRg.put("DATE_FACTURE", Boolean.TRUE);
                    rowValsMdrRg.put("RG", Boolean.TRUE);
                    rowValsMdrRg.put("ID_TYPE_REGLEMENT", 7);
                    SQLRow rowMdrRG = rowValsMdrRg.commit();
                    new GenerationReglementVenteNG(label.trim(), rowClient, prixTTC2, this.date, rowMdrRG, saisieRow, mvtTable.getRow(this.idMvt), true, false, tiers, rowCptTiers);
                }
            } else {
                prixTTC = new PrixTTC(totalNet);
                if (prixTTC.getLongValue() > 0L) {
                    new GenerationReglementVenteNG(label.trim(), rowClient, prixTTC, this.date, modeRegl, saisieRow, mvtTable.getRow(this.idMvt), true, false, tiers, rowCptTiers);
                }
            }
        }
        valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valSasieVF.getInvalid() == null) {
            valSasieVF.update(this.idSaisieVenteFacture);
            this.displayMvtNumber();
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

