/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.erp.generationEcritures.AssociationAnalytique;
import org.openconcerto.erp.generationEcritures.Compte;
import org.openconcerto.erp.generationEcritures.Ecriture;
import org.openconcerto.erp.generationEcritures.Journal;
import org.openconcerto.erp.generationEcritures.Mouvement;
import org.openconcerto.erp.generationEcritures.MouvementGED;
import org.openconcerto.erp.generationEcritures.Piece;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class Exercice {
    private Date debut;
    private Date fin;
    private static final Logger LOGGER = Logger.getLogger(Exercice.class.getName());

    public Exercice() {
    }

    public Exercice(Date debut, Date fin) {
        if (debut != null && debut.after(fin)) {
            throw new IllegalArgumentException("date de fin invalide");
        }
        this.debut = debut;
        this.fin = fin;
    }

    public String toString() {
        return "Exercice " + this.debut + " -> " + this.fin;
    }

    public void insert(SQLElementDirectory directory, final DBRoot root, final User user, final List<Piece> pieces) throws SQLException {
        final DBSystemRoot sysRoot = root.getDBSystemRoot();
        final ArrayList<SQLInsert> insertsPiece = new ArrayList<SQLInsert>();
        LOGGER.log(Level.INFO, "insertion de {0} pi\u00e8ces comptables", pieces.size());
        for (Piece p : pieces) {
            insertsPiece.add(p.createInsert(root, user));
            List<Mouvement> mouvements = p.getMouvements();
            if (mouvements.isEmpty()) {
                throw new IllegalStateException("Piece vide : " + p);
            }
            for (Mouvement m : mouvements) {
                if (!m.isBalanced()) {
                    throw new IllegalStateException("Mouvement non balanc\u00e9 : " + m);
                }
                if (m.isEmpty()) {
                    throw new IllegalStateException("Mouvement vide : " + m);
                }
                for (Ecriture e : m.getEcritures()) {
                    if (this.debut != null && e.getDate().before(this.debut)) {
                        throw new IllegalStateException("Mouvement invalide : " + m + " : une \u00e9criture est d\u00e9finie avant la date de d\u00e9but d'exercice : " + e);
                    }
                    if (e.getNom() != null) continue;
                    throw new IllegalStateException("Ecriture sans nom : " + e);
                }
                if (this.fin == null) continue;
                for (Ecriture e : m.getEcritures()) {
                    if (!e.getDate().after(this.fin)) continue;
                    throw new IllegalStateException("Mouvement invalide : " + m + " : une \u00e9criture est d\u00e9finie apr\u00e8s la date de fin d'exercice : " + e.getDate() + ">" + this.fin);
                }
            }
        }
        SQLUtils.executeAtomic(sysRoot.getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                int i;
                HashSet<Journal> journauxACreerOuFetcher = new HashSet<Journal>();
                HashSet<Number> journauxAresoudre = new HashSet<Number>();
                HashSet<Compte> comptesACreerOuFetcher = new HashSet<Compte>();
                HashSet<Number> comptesAresoudre = new HashSet<Number>();
                LinkedList<Ecriture> ecrituresSansJournalID = new LinkedList<Ecriture>();
                LinkedList<Ecriture> ecrituresSansCompteID = new LinkedList<Ecriture>();
                for (Piece p : pieces) {
                    for (Mouvement m : p.getMouvements()) {
                        for (Ecriture e : m.getEcritures()) {
                            if (e.getJournalID() == null) {
                                journauxACreerOuFetcher.add(new Journal(null, e.getJournalCode(), e.getJournalNom()));
                                ecrituresSansJournalID.add(e);
                            } else {
                                journauxAresoudre.add(e.getJournalID());
                            }
                            if (e.getCompteID() == null) {
                                comptesACreerOuFetcher.add(new Compte(null, e.getCompteNumero(), e.getCompteNom()));
                                ecrituresSansCompteID.add(e);
                                continue;
                            }
                            comptesAresoudre.add(e.getCompteID());
                        }
                    }
                }
                final HashMap<Long, Journal> mapJournaux = new HashMap<Long, Journal>();
                if (!journauxACreerOuFetcher.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.valueOf(journauxACreerOuFetcher.size()) + " journaux \u00e0 cr\u00e9er : " + journauxACreerOuFetcher);
                    }
                    Map<String, Journal> codesDesJournauxExistants = Exercice.this.getCodesJournaux(root);
                    ArrayList<SQLInsert> insertsJournaux = new ArrayList<SQLInsert>();
                    ArrayList<Journal> list = new ArrayList<Journal>();
                    for (Journal journal : journauxACreerOuFetcher) {
                        if (codesDesJournauxExistants.get(journal.getCode().toLowerCase()) != null) continue;
                        list.add(journal);
                        insertsJournaux.add(journal.createInsert(root, user));
                    }
                    ArrayList<Number> journauxIds = new ArrayList<Number>();
                    if (!insertsJournaux.isEmpty()) {
                        journauxIds.addAll(SQLInsert.executeSimilarInserts(sysRoot, insertsJournaux, true));
                        journauxAresoudre.addAll(journauxIds);
                    }
                    int size = list.size();
                    int i2 = 0;
                    while (i2 < size) {
                        String journalCode = ((Journal)list.get(i2)).getCode();
                        Number journalID = (Number)journauxIds.get(i2);
                        Iterator it = ecrituresSansJournalID.iterator();
                        while (it.hasNext()) {
                            Ecriture e = (Ecriture)it.next();
                            if (!e.getJournalCode().equalsIgnoreCase(journalCode)) continue;
                            e.setJournalID(journalID);
                            e.setJournal(journalCode, ((Journal)list.get(i2)).getNom());
                            it.remove();
                        }
                        ++i2;
                    }
                    Iterator it = ecrituresSansJournalID.iterator();
                    while (it.hasNext()) {
                        Ecriture e = (Ecriture)it.next();
                        Journal journal = codesDesJournauxExistants.get(e.getJournalCode().toLowerCase());
                        e.setJournalID(journal.getId());
                        it.remove();
                    }
                    for (Journal journal : codesDesJournauxExistants.values()) {
                        mapJournaux.put(journal.getId(), journal);
                    }
                }
                final HashMap<Long, Compte> mapComptes = new HashMap<Long, Compte>();
                if (!comptesACreerOuFetcher.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.valueOf(comptesACreerOuFetcher.size()) + " comptes \u00e0 cr\u00e9er ou fetcher: " + comptesACreerOuFetcher);
                    }
                    Map<String, Compte> numerosDesComptesExistants = Exercice.this.getNumeroDesComptes(root, pieces);
                    ArrayList<SQLInsert> insertsComptes = new ArrayList<SQLInsert>();
                    ArrayList<Compte> list = new ArrayList<Compte>();
                    for (Compte c : comptesACreerOuFetcher) {
                        if (numerosDesComptesExistants.get(c.getNumero().toLowerCase()) != null) continue;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("cr\u00e9ation du compte : " + c.getNumero().toLowerCase());
                        }
                        list.add(c);
                        insertsComptes.add(c.createInsert(root, user));
                    }
                    ArrayList<Number> comptesIds = new ArrayList<Number>();
                    if (!insertsComptes.isEmpty()) {
                        List<Number> insertedIDs = SQLInsert.executeSimilarInserts(sysRoot, insertsComptes, true);
                        comptesIds.addAll(insertedIDs);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("IDs des comptes cr\u00e9\u00e9s : " + comptesIds);
                        }
                        comptesAresoudre.addAll(comptesIds);
                    }
                    int size = list.size();
                    int i3 = 0;
                    while (i3 < size) {
                        String compteCode = ((Compte)list.get(i3)).getNumero();
                        Number compteID = (Number)comptesIds.get(i3);
                        Iterator it = ecrituresSansCompteID.iterator();
                        while (it.hasNext()) {
                            Ecriture e = (Ecriture)it.next();
                            if (!e.getCompteNumero().equalsIgnoreCase(compteCode)) continue;
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("mise \u00e0 jour de l'\u00e9criture " + e + " avec le compte d'ID " + compteID);
                            }
                            e.setCompteID(compteID);
                            e.setCompte(compteCode, ((Compte)list.get(i3)).getNom());
                            it.remove();
                        }
                        ++i3;
                    }
                    Iterator<Mouvement> it = ecrituresSansCompteID.iterator();
                    while (it.hasNext()) {
                        Ecriture e = (Ecriture)((Object)it.next());
                        Compte compte = numerosDesComptesExistants.get(e.getCompteNumero().toLowerCase());
                        if (compte == null) continue;
                        e.setCompteID(compte.getId());
                        it.remove();
                    }
                    for (Compte compte : numerosDesComptesExistants.values()) {
                        mapComptes.put(compte.getId(), compte);
                    }
                }
                ArrayList<String> queries = new ArrayList<String>();
                ArrayList<ResultSetHandler> handlers = new ArrayList<ResultSetHandler>();
                if (!comptesAresoudre.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.valueOf(comptesAresoudre.size()) + " comptes \u00e0 r\u00e9soudre : ids " + comptesAresoudre);
                    }
                    SQLTable tableCompte = root.getTable("COMPTE_PCE");
                    SQLSelect selCompte = new SQLSelect();
                    selCompte.addSelect(tableCompte.getKey());
                    selCompte.addSelect(tableCompte.getField("NUMERO"));
                    selCompte.addSelect(tableCompte.getField("NOM"));
                    selCompte.setWhere(new Where(tableCompte.getKey(), comptesAresoudre));
                    queries.add(selCompte.asString());
                    handlers.add(new ResultSetHandler(){

                        @Override
                        public Object handle(ResultSet rs) throws SQLException {
                            while (rs.next()) {
                                Long id = rs.getLong(1);
                                String numero = rs.getString(2);
                                String nom = rs.getString(3);
                                mapComptes.put(id, new Compte(id, numero, nom));
                            }
                            return null;
                        }
                    });
                }
                if (!journauxAresoudre.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.valueOf(journauxAresoudre.size()) + " journaux \u00e0 r\u00e9soudre ids : " + journauxAresoudre);
                    }
                    SQLTable tableJournal = root.getTable("JOURNAL");
                    SQLSelect selJournal = new SQLSelect();
                    selJournal.addSelect(tableJournal.getKey());
                    selJournal.addSelect(tableJournal.getField("CODE"));
                    selJournal.addSelect(tableJournal.getField("NOM"));
                    selJournal.setWhere(new Where(tableJournal.getKey(), journauxAresoudre));
                    queries.add(selJournal.asString());
                    handlers.add(new ResultSetHandler(){

                        @Override
                        public Object handle(ResultSet rs) throws SQLException {
                            while (rs.next()) {
                                Long id = rs.getLong(1);
                                String code = rs.getString(2);
                                String nom = rs.getString(3);
                                mapJournaux.put(id, new Journal(id, code, nom));
                            }
                            return null;
                        }
                    });
                }
                SQLUtils.executeMultiple(sysRoot, queries, handlers);
                for (Piece p : pieces) {
                    for (Mouvement m : p.getMouvements()) {
                        for (Ecriture e : m.getEcritures()) {
                            Number compteID = e.getCompteID();
                            if (compteID == null) {
                                throw new IllegalStateException("pas d'ID compte dans l'\u00e9criture " + e);
                            }
                            Long idCompte = compteID.longValue();
                            if (e.getCompteNom() == null || e.getCompteNumero() == null) {
                                Compte c = (Compte)mapComptes.get(idCompte);
                                if (c == null) {
                                    throw new IllegalStateException("pas de compte d'ID " + idCompte + " dans la map " + mapComptes.keySet());
                                }
                                e.setCompte(c.getNumero(), c.getNom());
                            }
                            Long idJournal = e.getJournalID().longValue();
                            if (e.getJournalNom() != null && e.getJournalCode() != null) continue;
                            Journal j = (Journal)mapJournaux.get(idJournal);
                            if (j == null) {
                                throw new IllegalStateException("pas de journal d'ID " + idJournal + " dans la map " + mapJournaux.keySet());
                            }
                            e.setJournal(j.getCode(), j.getNom());
                        }
                    }
                }
                List<Number> idsPieces = SQLInsert.executeSimilarInserts(sysRoot, insertsPiece, true);
                ArrayList<SQLInsert> insertsMouvement = new ArrayList<SQLInsert>(insertsPiece.size() * 3);
                ArrayList<Mouvement> listMvtWithoutIDs = new ArrayList<Mouvement>(insertsPiece.size() * 3);
                int i4 = 0;
                while (i4 < pieces.size()) {
                    Piece piece = (Piece)pieces.get(i4);
                    piece.setId(idsPieces.get(i4));
                    for (Mouvement m : piece.getMouvements()) {
                        listMvtWithoutIDs.add(m);
                        insertsMouvement.add(m.createInsert(root, user));
                    }
                    ++i4;
                }
                List<Number> idsMouvements = SQLInsert.executeSimilarInserts(sysRoot, insertsMouvement, true);
                SQLSelect sel = new SQLSelect();
                SQLTable tableMvt = root.getTable("MOUVEMENT");
                sel.addSelect(tableMvt.getField("NUMERO"), "MAX");
                Number maxMvtNumber = (Number)sysRoot.getDataSource().executeScalar(sel.asString());
                int maxMvt = 1;
                if (maxMvtNumber != null) {
                    maxMvt = maxMvtNumber.intValue();
                }
                ArrayList<SQLUpdate> mvtUpdate = new ArrayList<SQLUpdate>();
                int i5 = 0;
                while (i5 < idsMouvements.size()) {
                    Number mvtId = idsMouvements.get(i5);
                    SQLUpdate update = new SQLUpdate(new Where((FieldRef)tableMvt.getKey(), "=", (Object)mvtId));
                    update.add(tableMvt.getField("NUMERO"), ++maxMvt);
                    mvtUpdate.add(update);
                    ((Mouvement)listMvtWithoutIDs.get(i5)).setId(mvtId);
                    ++i5;
                }
                SQLUpdate.executeMultipleWithBatch(sysRoot, mvtUpdate);
                ArrayList<SQLInsert> insertsURL = new ArrayList<SQLInsert>(insertsMouvement.size());
                int i6 = 0;
                while (i6 < pieces.size()) {
                    Piece piece = (Piece)pieces.get(i6);
                    piece.setId(idsPieces.get(i6));
                    for (Mouvement m : piece.getMouvements()) {
                        if (!m.hasURLs()) continue;
                        List<MouvementGED> urLs = m.getURLs();
                        for (MouvementGED mouvementGED : urLs) {
                            insertsURL.add(mouvementGED.createInsert(root, user));
                        }
                    }
                    ++i6;
                }
                if (!insertsURL.isEmpty()) {
                    SQLInsert.executeSimilarInserts(sysRoot, insertsURL, false);
                }
                ArrayList<SQLInsert> insertsEcrituresSansLiens = new ArrayList<SQLInsert>(insertsMouvement.size() * 2);
                ArrayList<SQLInsert> insertsEcrituresAvecLiens = new ArrayList<SQLInsert>(insertsMouvement.size() * 2);
                ArrayList<Ecriture> ecrituresAvecLiens = new ArrayList<Ecriture>(insertsEcrituresAvecLiens.size());
                ArrayList<Ecriture> ecrituresSansLiens = new ArrayList<Ecriture>(insertsEcrituresSansLiens.size());
                for (Piece p : pieces) {
                    List<Mouvement> mouvements = p.getMouvements();
                    int stop = mouvements.size();
                    i = 0;
                    while (i < stop) {
                        Mouvement m = mouvements.get(i);
                        for (Ecriture e : m.getEcritures()) {
                            if (e.hasAnalytique()) {
                                insertsEcrituresAvecLiens.add(e.createInsert(root, user));
                                ecrituresAvecLiens.add(e);
                                continue;
                            }
                            insertsEcrituresSansLiens.add(e.createInsert(root, user));
                            ecrituresSansLiens.add(e);
                        }
                        ++i;
                    }
                }
                if (!insertsEcrituresSansLiens.isEmpty()) {
                    List<Number> idsEcritures = SQLInsert.executeSimilarInserts(sysRoot, insertsEcrituresSansLiens, true);
                    int n = idsEcritures.size();
                    int i7 = 0;
                    while (i7 < n) {
                        Ecriture e = (Ecriture)ecrituresSansLiens.get(i7);
                        e.setId(idsEcritures.get(i7));
                        ++i7;
                    }
                }
                if (!ecrituresAvecLiens.isEmpty()) {
                    List<Number> idsEcritues = SQLInsert.executeSimilarInserts(sysRoot, insertsEcrituresAvecLiens, true);
                    ArrayList<SQLInsert> arrayList = new ArrayList<SQLInsert>(insertsEcrituresAvecLiens.size());
                    ArrayList<SQLInsert> insertsURLs = new ArrayList<SQLInsert>(insertsEcrituresAvecLiens.size());
                    int size = ecrituresAvecLiens.size();
                    i = 0;
                    while (i < size) {
                        Ecriture e = (Ecriture)ecrituresAvecLiens.get(i);
                        e.setId(idsEcritues.get(i));
                        if (e.hasAnalytique()) {
                            for (AssociationAnalytique a : e.getAssociationsAnalytiques()) {
                                arrayList.add(a.createInsert(root, user));
                            }
                        }
                        ++i;
                    }
                    if (!arrayList.isEmpty()) {
                        SQLInsert.executeSimilarInserts(sysRoot, arrayList, false);
                    }
                    if (!insertsURLs.isEmpty()) {
                        SQLInsert.executeSimilarInserts(sysRoot, insertsURLs, false);
                    }
                }
                for (Piece p : pieces) {
                    List<Mouvement> mouvements = p.getMouvements();
                    for (Mouvement m : mouvements) {
                        if (m.getPostInsertionAction() == null) continue;
                        m.getPostInsertionAction().afterInsert(m);
                    }
                }
                return null;
            }
        });
    }

    protected Map<String, Compte> getNumeroDesComptes(DBRoot root, List<Piece> pieces) {
        HashSet<String> numerosDesComptes = new HashSet<String>();
        for (Piece p : pieces) {
            List<Mouvement> mouvements = p.getMouvements();
            for (Mouvement m : mouvements) {
                for (Ecriture e : m.getEcritures()) {
                    numerosDesComptes.add(e.getCompteNumero().toLowerCase());
                }
            }
        }
        final HashMap<String, Compte> result = new HashMap<String, Compte>();
        SQLTable tableCompte = root.getTable("COMPTE_PCE");
        SQLSelect selCompte = new SQLSelect();
        selCompte.addSelect(tableCompte.getKey());
        final SQLField fNumero = tableCompte.getField("NUMERO");
        selCompte.addSelect(fNumero);
        selCompte.addSelect(tableCompte.getField("NOM"));
        String numeros = CollectionUtils.join(numerosDesComptes, ",", new ITransformer<Object, String>(){

            @Override
            public String transformChecked(Object input) {
                return fNumero.getField().getType().toString(input);
            }
        });
        Where w = Where.createRaw("lower(" + fNumero.getFieldRef() + ") in (" + numeros + ")", fNumero);
        selCompte.setWhere(w);
        ResultSetHandler resultSetHandler = new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    String numero = rs.getString(2);
                    String nom = rs.getString(3);
                    result.put(numero.toLowerCase(), new Compte(id, numero, nom));
                }
                return null;
            }
        };
        root.getDBSystemRoot().getDataSource().execute(selCompte.asString(), resultSetHandler);
        return result;
    }

    protected Map<String, Journal> getCodesJournaux(DBRoot root) {
        final HashMap<String, Journal> result = new HashMap<String, Journal>();
        SQLTable tableJournal = root.getTable("JOURNAL");
        SQLSelect selJournal = new SQLSelect();
        selJournal.addSelect(tableJournal.getKey());
        selJournal.addSelect(tableJournal.getField("CODE"));
        selJournal.addSelect(tableJournal.getField("NOM"));
        ResultSetHandler resultSetHandler = new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    String code = rs.getString(2);
                    String nom = rs.getString(3);
                    result.put(code.toLowerCase(), new Journal(id, code, nom));
                }
                return null;
            }
        };
        root.getDBSystemRoot().getDataSource().execute(selJournal.asString(), resultSetHandler);
        return result;
    }
}

