/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.sql.view.list.SQLTableElement;

public class SupplierPriceListTable
extends RowValuesTablePanel {
    public SupplierPriceListTable() {
        this.init();
        this.uiInit();
    }

    @Override
    protected void init() {
        SQLElement eProductCost = this.getSQLElement();
        SQLTable productPropertyTable = eProductCost.getTable();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eSupplier = new SQLTableElement(productPropertyTable.getField("ID_FOURNISSEUR"));
        list.add(eSupplier);
        list.add(new SQLTableElement(productPropertyTable.getField("CODE_PAYS_ORIGINE")));
        SQLTableElement ePrixAchatDevise = new SQLTableElement(productPropertyTable.getField("PRIX_ACHAT_DEVISE_F"));
        Path p = (Path)((Path)new Path(this.getSQLElement().getTable()).addForeignTable("FOURNISSEUR")).addForeignField("ID_DEVISE");
        ePrixAchatDevise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
        list.add(ePrixAchatDevise);
        SQLTableElement ePrixAchat = new SQLTableElement(productPropertyTable.getField("PRIX_ACHAT"));
        ePrixAchat.setRenderer(new CurrencyWithSymbolRenderer());
        final CurrencyConverter c = new CurrencyConverter();
        ePrixAchat.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getObject("ID_FOURNISSEUR") == null) {
                    return row.getBigDecimal("PRIX_ACHAT_DEVISE_F");
                }
                String supplierCurrency = row.getForeign("ID_FOURNISSEUR").getForeign("ID_DEVISE").getString("CODE");
                BigDecimal prixAchatDevice = row.getBigDecimal("PRIX_ACHAT_DEVISE_F");
                if (prixAchatDevice == null) {
                    return BigDecimal.ZERO;
                }
                try {
                    BigDecimal p = c.convert(prixAchatDevice, supplierCurrency, c.getCompanyCurrencyCode(), new Date(), true);
                    return p.setScale(2, RoundingMode.HALF_UP);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return BigDecimal.ZERO;
                }
            }
        });
        ePrixAchat.setEditable(false);
        list.add(ePrixAchat);
        ePrixAchatDevise.addModificationListener(ePrixAchat);
        ePrixAchatDevise.addModificationListener(eSupplier);
        list.add(new SQLTableElement(productPropertyTable.getField("QTE")));
        list.add(new SQLTableElement(productPropertyTable.getField("DATE_PRIX")));
        list.add(new SQLTableElement(productPropertyTable.getField("DELAI_REAPPRO")));
        list.add(new SQLTableElement(productPropertyTable.getField("DELAI_TRANSPORT")));
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.defaultRowVals.put("QTE", 1);
        this.defaultRowVals.put("PRIORITE", 1);
        this.model = new RowValuesTableModel(eProductCost, list, productPropertyTable.getField("ID_FOURNISSEUR"), false, this.defaultRowVals);
        this.table = new RowValuesTable(this.model, null);
    }

    protected String multiply(List<String> asList) {
        return null;
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ARTICLE_TARIF_FOURNISSEUR");
    }
}

