/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivrePDF;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;

public class BatchHistoryPDF {
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    private final SQLRow rowSociete;
    public static final String TEMPLATE_ID = "BatchHistory";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationGrandLivre";
    private static final int LINE_HEIGHT = 10;
    private static final float COL_1_SIZE = 100.0f;
    private static final float COL_2_SIZE = 35.0f;
    private static final float COL_3_SIZE = 375.0f;
    private static final float COL_1_X = 40.0f;
    private static final float COL_2_X = 140.0f;
    private static final float COL_3_X = 175.0f;
    private final DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", DecimalFormatSymbols.getInstance(Locale.FRANCE));
    private final SQLRowAccessor rowLot;

    public BatchHistoryPDF(ComptaPropsConfiguration conf, SQLRowAccessor rowLot) {
        this.rowSociete = conf.getRowSociete();
        DBRoot b = conf.getRootSociete();
        this.rowLot = rowLot;
    }

    public void getGeneratedPDFFile(File f) throws IOException {
        int y = 0;
        String companyName = String.valueOf(this.rowSociete.getString("TYPE")) + " " + this.rowSociete.getString("NOM");
        List<SQLRowValues> fetchLivraisonReception = this.fetchLivraisonReception(this.rowLot);
        SQLRowValues sqlRowValuesFetched = fetchLivraisonReception.get(0);
        Collection<SQLRowValues> receptionRows = sqlRowValuesFetched.getReferentRows(this.rowLot.getTable().getTable("LOT_RECEPTION"));
        Collection<SQLRowValues> livraisonRows = sqlRowValuesFetched.getReferentRows(this.rowLot.getTable().getTable("LOT_LIVRAISON"));
        Throwable throwable = null;
        Object var9_10 = null;
        try (PDDocument doc = new PDDocument();){
            int length;
            PDPageContentStream contents = null;
            int size = receptionRows.size();
            Iterator<SQLRowValues> iterator = receptionRows.iterator();
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            if (contents != null) {
                contents.close();
            }
            contents = new PDPageContentStream(doc, page);
            y = this.drawHeader(contents, companyName, sqlRowValuesFetched);
            contents.beginText();
            contents.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
            contents.newLineAtOffset(40.0f, (float)(y -= 51));
            contents.showText("R\u00e9ception");
            contents.endText();
            y = this.drawTableHeader(contents, y, "FOURNISSEURS");
            int i = 0;
            while (i < size) {
                SQLRowValues rowRecep = iterator.next();
                y = this.drawTAbleLine(contents, y, rowRecep);
                ++i;
            }
            contents.beginText();
            contents.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
            contents.newLineAtOffset(40.0f, (float)(y -= 68));
            contents.showText("Livraison");
            contents.endText();
            y = this.drawTableHeader(contents, y, "CLIENTS");
            int sizeLivraison = livraisonRows.size();
            Iterator<SQLRowValues> iteratorLivraison = livraisonRows.iterator();
            int i2 = 0;
            while (i2 < sizeLivraison) {
                SQLRowValues rowLivraison = iteratorLivraison.next();
                y = this.drawTAbleLine(contents, y, rowLivraison);
                ++i2;
            }
            if (contents != null) {
                contents.close();
            }
            InputStream sImage = GrandLivrePDF.class.getResourceAsStream("OpenConcerto_2000px.png");
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((length = sImage.read(buf)) > 0) {
                bOut.write(buf, 0, length);
            }
            sImage.close();
            bOut.close();
            float ratio = 20.0f;
            int pageCount = doc.getNumberOfPages();
            int index = 0;
            while (index < pageCount) {
                PDPage currentPage = doc.getPage(index);
                contents = new PDPageContentStream(doc, currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
                if (index == 0 || index == pageCount - 1) {
                    PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])bOut.toByteArray(), (String)"openconcerto.png");
                    float h = (float)pdImage.getHeight() / 20.0f;
                    contents.drawImage(pdImage, 40.0f, 10.0f, (float)pdImage.getWidth() / 20.0f, h);
                }
                contents.beginText();
                contents.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
                contents.newLineAtOffset(250.0f, 20.0f);
                contents.showText(StringUtils.cleanPDFString("Edition du " + this.dateFormatEcr.format(new Date())));
                contents.endText();
                contents.beginText();
                contents.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
                contents.newLineAtOffset(500.0f, 20.0f);
                contents.showText("Page " + (index + 1) + " / " + pageCount);
                contents.endText();
                contents.close();
                ++index;
            }
            doc.save(f);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int drawTAbleLine(PDPageContentStream contents, int y, SQLRowAccessor r) throws IOException {
        String doc;
        String date;
        String tiers;
        y -= 10;
        contents.setFont((PDFont)PDType1Font.HELVETICA, 7.0f);
        DateFormat format = DateFormat.getDateInstance(3);
        if (r.getTable().getName().equals("LOT_LIVRAISON")) {
            SQLRowAccessor bl = r.getForeign("ID_BON_DE_LIVRAISON_ELEMENT").getForeign("ID_BON_DE_LIVRAISON");
            SQLRowAccessor client = bl.getForeign("ID_CLIENT");
            tiers = client.getString("NOM");
            date = format.format(bl.getDate("DATE").getTime());
            doc = bl.getString("NUMERO");
        } else {
            SQLRowAccessor br = r.getForeign("ID_BON_RECEPTION_ELEMENT").getForeign("ID_BON_RECEPTION");
            SQLRowAccessor four = br.getForeign("ID_FOURNISSEUR");
            tiers = four.getString("NOM");
            date = format.format(br.getDate("DATE").getTime());
            doc = br.getString("NUMERO");
        }
        contents.beginText();
        contents.newLineAtOffset(40.0f, (float)y);
        contents.showText(StringUtils.cleanPDFString(doc));
        contents.endText();
        contents.beginText();
        contents.newLineAtOffset(140.0f, (float)y);
        contents.showText(StringUtils.cleanPDFString(date));
        contents.endText();
        contents.beginText();
        contents.newLineAtOffset(175.0f, (float)y);
        contents.showText(StringUtils.cleanPDFString(tiers));
        contents.endText();
        contents.setLineWidth(0.5f);
        contents.setStrokingColor(Color.LIGHT_GRAY);
        contents.moveTo(36.0f, (float)y - 2.0f);
        contents.lineTo(554.0f, (float)y - 2.0f);
        contents.stroke();
        return y;
    }

    private void drawRightAlign(PDPageContentStream contents, float x, float y, float width, String text) throws IOException {
        contents.beginText();
        float w = PDType1Font.HELVETICA.getStringWidth(StringUtils.cleanPDFString(text)) / 1000.0f * 7.0f;
        contents.newLineAtOffset(x + width - w, y);
        contents.showText(StringUtils.cleanPDFString(text));
        contents.endText();
    }

    private int drawHeader(PDPageContentStream contents, String companyName, SQLRowAccessor rLot) throws IOException {
        int y = 795;
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        contents.newLineAtOffset(40.0f, (float)y);
        contents.showText(StringUtils.cleanPDFString(companyName.toUpperCase()));
        contents.endText();
        y -= 17;
        SQLRowAccessor foreign = rLot.getForeign("ID_STOCK").getForeign("ID_ARTICLE");
        y = this.drawLine(contents, "Article " + foreign.getString("NOM"), y);
        y = this.drawLine(contents, "Code : " + foreign.getString("CODE"), y);
        DateFormat format = DateFormat.getDateInstance(3);
        StringBuilder res = new StringBuilder();
        Calendar dluo = rLot.getDate("DLUO");
        Calendar dlc = rLot.getDate("DLC");
        String lot = rLot.getString("NUMERO_LOT");
        String serie = rLot.getString("NUMERO_SERIE");
        if (serie != null && serie.trim().length() > 0) {
            y = this.drawLine(contents, "Num\u00e9ro S\u00e9rie : " + serie, y);
        }
        if (lot != null && lot.trim().length() > 0) {
            y = this.drawLine(contents, "Num\u00e9ro Lot : " + lot, y);
        }
        if (dlc != null) {
            y = this.drawLine(contents, "DLC : " + format.format(dlc.getTime()), y);
        }
        if (dluo != null) {
            y = this.drawLine(contents, "DLUO : " + format.format(dluo.getTime()), y);
        }
        return y;
    }

    private int drawLine(PDPageContentStream contents, String text, int y) throws IOException {
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
        contents.newLineAtOffset(40.0f, (float)(y -= 17));
        contents.showText(StringUtils.cleanPDFString(text));
        contents.endText();
        return y;
    }

    private int drawTableHeader(PDPageContentStream contents, int y, String tiers) throws IOException {
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        contents.beginText();
        contents.newLineAtOffset(45.0f, (float)(y -= 20));
        contents.showText("NUMERO DOCUMENT");
        contents.endText();
        contents.beginText();
        contents.newLineAtOffset(140.0f, (float)y);
        contents.showText("DATE");
        contents.endText();
        contents.beginText();
        contents.newLineAtOffset(175.0f, (float)y);
        contents.showText(tiers);
        contents.endText();
        contents.setStrokingColor(Color.BLACK);
        contents.setLineWidth(1.0f);
        contents.moveTo(36.0f, (float)(y -= 4));
        contents.lineTo(554.0f, (float)y);
        contents.stroke();
        return y;
    }

    private List<SQLRowValues> fetchLivraisonReception(SQLRowAccessor rowLot) {
        SQLRowValues vals = new SQLRowValues(rowLot.getTable());
        vals.setAllToNull();
        SQLRowValues putRowValuesARticle = vals.putRowValues("ID_STOCK").putRowValues("ID_ARTICLE");
        putRowValuesARticle.putNulls("CODE", "NOM");
        putRowValuesARticle.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("NOM");
        putRowValuesARticle.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("NOM");
        SQLRowValues valsReception = new SQLRowValues(rowLot.getTable().getTable("LOT_RECEPTION"));
        valsReception.setAllToNull();
        valsReception.put("ID_LOT", (Object)vals);
        SQLRowValues rowValsBR = valsReception.putRowValues("ID_BON_RECEPTION_ELEMENT").putRowValues("ID_BON_RECEPTION");
        rowValsBR.putNulls("NUMERO", "DATE");
        rowValsBR.putRowValues("ID_FOURNISSEUR").putNulls("CODE", "NOM");
        SQLRowValues valsLivraison = new SQLRowValues(rowLot.getTable().getTable("LOT_LIVRAISON"));
        valsLivraison.setAllToNull();
        valsLivraison.put("ID_LOT", (Object)vals);
        SQLRowValues rowValsBL = valsLivraison.putRowValues("ID_BON_DE_LIVRAISON_ELEMENT").putRowValues("ID_BON_DE_LIVRAISON");
        rowValsBL.putNulls("NUMERO", "DATE");
        rowValsBL.putRowValues("ID_CLIENT").putNulls("CODE", "NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(vals);
        return fetcher.fetch(new Where((FieldRef)rowLot.getTable().getKey(), "=", rowLot.getID()));
    }
}

