/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.openconcerto.erp.core.sales.pos.io.Barcode;
import org.openconcerto.erp.core.sales.pos.io.BarcodeListener;
import org.openconcerto.erp.gs1.GS1Util;

public class BarcodeReader
implements KeyEventDispatcher {
    private int maxInterKeyDelay = 200;
    private static final int MIN_BARCODE_LENGTH = 2;
    private final List<BarcodeListener> listeners = new ArrayList<BarcodeListener>(1);
    private List<KeyEventDispatcher> dispatchers = null;
    private String value = "";
    private final List<KeyEvent> eve = new ArrayList<KeyEvent>();
    private long firstTime = -1L;
    private Timer timer = null;
    private TimerTask task = null;
    private boolean enable = true;
    private boolean debug = true;
    private List<Integer> valueCode = new ArrayList<Integer>();
    int lastPressedkeyCode = 0;
    static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public BarcodeReader(int maxInterKeyDelay) {
        this.maxInterKeyDelay = maxInterKeyDelay;
    }

    public void setMaxInterKeyDelay(int maxInterKeyDelay) {
        this.maxInterKeyDelay = maxInterKeyDelay;
    }

    public void addKeyEventDispatcher(KeyEventDispatcher d) {
        if (this.dispatchers == null) {
            this.dispatchers = new ArrayList<KeyEventDispatcher>();
        }
        this.dispatchers.add(d);
    }

    public synchronized void removeBarcodeListener(BarcodeListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
    }

    public synchronized void addBarcodeListener(BarcodeListener l) {
        if (this.timer == null) {
            this.start();
        }
        this.listeners.add(l);
    }

    private void fire(Barcode code) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).barcodeRead(code);
            ++i;
        }
    }

    public synchronized void start() {
        if (this.timer == null) {
            this.timer = new Timer(this.getClass().getName(), true);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            System.err.println("BarcodeReader start : scan delay between keys" + this.maxInterKeyDelay + " ms");
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            System.err.println("BarcodeReader stop");
            this.timer.cancel();
            this.timer = null;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.enable) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.dispatchers != null) {
            for (KeyEventDispatcher d : this.dispatchers) {
                d.dispatchKeyEvent(e);
            }
        }
        long t = e.getWhen();
        if (this.firstTime < 0L) {
            this.firstTime = t;
        }
        int keyCode = e.getKeyCode();
        long delay = t - this.firstTime;
        if (keyCode == 8 || keyCode == 127 || delay > (long)this.maxInterKeyDelay && keyCode != 16) {
            if (this.debug) {
                System.err.println("Touche normale " + keyCode + " delai:" + delay);
            }
            this.eve.add(e);
            this.redispatch();
            return true;
        }
        char keyChar = e.getKeyChar();
        this.eve.add(e);
        if (e.getID() == 401) {
            this.lastPressedkeyCode = e.getKeyCode();
        }
        if (e.getID() == 402 && keyCode == 119) {
            this.value = String.valueOf(this.value) + '\u001d';
            this.valueCode.add(this.lastPressedkeyCode);
        } else if (e.getID() == 402 && keyCode == 10 && this.value.length() >= 2) {
            if (this.debug) {
                System.err.println("BARCODE OK ENTER OR LENGHT " + keyCode + " length = " + this.value.length() + " min length =" + 2);
            }
            this.value = this.value.trim();
            if (this.value.startsWith("$")) {
                StringBuilder b = new StringBuilder(this.value.length());
                int i = 0;
                while (i < this.value.length()) {
                    char c = this.value.charAt(i);
                    int kCode = this.valueCode.get(i);
                    if (c == '&') {
                        b.append('1');
                    } else if (c == '\u00e9') {
                        b.append('2');
                    } else if (c == '\"') {
                        b.append('3');
                    } else if (c == '\'') {
                        b.append('4');
                    } else if (c == '(') {
                        b.append('5');
                    } else if (c == '-') {
                        if (kCode == 109) {
                            b.append('-');
                        } else {
                            b.append('6');
                        }
                    } else if (c == '\u00e8') {
                        b.append('7');
                    } else if (c == '_') {
                        b.append('8');
                    } else if (c == '\u00e7') {
                        b.append('9');
                    } else if (c == '\u00e0') {
                        b.append('0');
                    } else if (c == '$') {
                        b.append(']');
                    } else if (c == 'M') {
                        b.append(':');
                    } else if (c == '!') {
                        b.append('/');
                    } else if (c == 'q') {
                        b.append('a');
                    } else if (c == 'a') {
                        b.append('q');
                    } else if (c == 'z') {
                        b.append('w');
                    } else if (c == 'w') {
                        b.append('z');
                    } else if (c == 'Q') {
                        b.append('A');
                    } else if (c == 'A') {
                        b.append('Q');
                    } else if (c == 'Z') {
                        b.append('W');
                    } else if (c == 'W') {
                        b.append('Z');
                    } else if (c == ',') {
                        b.append('m');
                    } else if (c == '?') {
                        b.append('M');
                    } else if (c == ':') {
                        b.append('.');
                    } else if (c == '\u00d2') {
                        b.append('\u00b0');
                    } else if (c == '\u00aa') {
                        b.append('\u00e9');
                    } else if (c == '%') {
                        b.append('\"');
                    } else if (c == '\u00f9') {
                        b.append('\'');
                    } else if (c == '\u00a8') {
                        b.append('{');
                    } else if (c == '\u00a3') {
                        b.append('}');
                    } else if (c == '\u00f1') {
                        if (kCode == 18) {
                            b.append('\u00e0');
                        } else {
                            b.append('&');
                        }
                    } else if (c == '0') {
                        b.append(')');
                    } else if (c == '1') {
                        b.append('!');
                    } else if (c == '2') {
                        b.append('@');
                    } else if (c == '3') {
                        b.append('#');
                    } else if (c == '4') {
                        b.append('$');
                    } else if (c == '5') {
                        b.append('%');
                    } else if (c == '6') {
                        if (kCode == 54) {
                            b.append('^');
                        } else {
                            b.append('\u00e7');
                        }
                    } else if (c == '7') {
                        b.append('&');
                    } else if (c == '9') {
                        b.append('(');
                    } else if (c == '^') {
                        b.append('[');
                    } else if (c == '\u00b5') {
                        b.append('|');
                    } else if (c == '\u00bf') {
                        b.append('\u00e8');
                    } else if (c == '\u00b2') {
                        b.append('`');
                    } else if (c == '\u00b0') {
                        b.append('_');
                    } else if (c == '/') {
                        b.append('>');
                    } else if (c == '.') {
                        b.append('<');
                    } else if (c == '\u00fd') {
                        b.append('\u00a7');
                    } else if (c == 'm') {
                        b.append(';');
                    } else if (c == '\u2524') {
                        b.append('\u00f9');
                    } else if (c == '\\') {
                        b.append('*');
                    } else if (c == '\u00a7') {
                        b.append('?');
                    } else if (c == ';') {
                        b.append(',');
                    } else if (c == '*') {
                        if (kCode == 106) {
                            b.append('*');
                        } else {
                            b.append('\\');
                        }
                    } else {
                        b.append(c);
                    }
                    ++i;
                }
                this.value = b.toString();
                this.fire(new Barcode(this.value));
            } else {
                this.fire(new Barcode(this.value));
            }
            this.reset();
        } else if (e.getID() == 400) {
            this.value = String.valueOf(this.value) + keyChar;
            this.valueCode.add(this.lastPressedkeyCode);
        }
        if (!this.eve.isEmpty()) {
            this.firstTime = t;
            this.task = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BarcodeReader.this.redispatch();
                        }
                    });
                }
            };
            try {
                this.timer.schedule(this.task, this.maxInterKeyDelay);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        assert (!this.eve.isEmpty() || this.firstTime == -1L);
        return true;
    }

    private void redispatch() {
        int i = 0;
        while (i < this.eve.size()) {
            KeyEvent ee = this.eve.get(i);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(ee.getComponent(), ee);
            int j = 0;
            while (j < this.listeners.size()) {
                this.listeners.get(j).keyReceived(ee);
                ++j;
            }
            ++i;
        }
        this.reset();
    }

    private void reset() {
        this.value = "";
        this.valueCode.clear();
        this.lastPressedkeyCode = 0;
        this.eve.clear();
        this.firstTime = -1L;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        final String delay = args.length > 0 ? args[0] : "40";
        final int d = Integer.parseInt(delay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                final BarcodeReader reader = new BarcodeReader(d);
                System.out.println("BarCode reader");
                System.out.println("Using inter key delay: " + d);
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                final JPanel panel = new JPanel();
                f.setTitle("Barcode reader tester (AIM ID required for GS1)");
                f.setContentPane(panel);
                panel.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.weighty = 0.5;
                c.fill = 1;
                BarcodeReader barcodeReader = reader;
                barcodeReader.getClass();
                final KeyEventTableModel keyEventTableModel = barcodeReader.new KeyEventTableModel();
                JTable table = new JTable(keyEventTableModel);
                final SimpleDateFormat df = new SimpleDateFormat(" hh:mm:ss.SSS");
                table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Date d = (Date)value;
                        value = df.format(d);
                        if (table.getModel().getRowCount() > 0) {
                            Date d1 = (Date)table.getModel().getValueAt(0, 0);
                            value = String.valueOf(value) + " " + (d.getTime() - d1.getTime()) + " ms";
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
                table.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        String id;
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        String str = (String)value;
                        if (str.equals("CHAR_UNDEFINED") && (id = table.getModel().getValueAt(row, 0).toString()).equals("Key Typed")) {
                            c.setBackground(Color.YELLOW);
                        }
                        return c;
                    }
                });
                panel.add((Component)new JScrollPane(table), c);
                JLabel l = new JLabel("BarCode reader output :");
                panel.add((Component)l, c);
                ++c.gridy;
                c.weighty = 1.0;
                c.weightx = 1.0;
                final JTextArea t1 = new JTextArea(20, 10);
                t1.setLineWrap(true);
                t1.setWrapStyleWord(true);
                t1.setMinimumSize(new Dimension(t1.getMinimumSize()));
                panel.add((Component)new JScrollPane(t1), c);
                JPanel tools = new JPanel();
                tools.setLayout(new FlowLayout(2));
                final JSpinner spin = new JSpinner(new SpinnerNumberModel(d, 5, 800, 10));
                spin.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        int v = ((Number)spin.getValue()).intValue();
                        reader.setMaxInterKeyDelay(v);
                    }
                });
                tools.add(spin);
                JButton b = new JButton("Reset");
                tools.add(b);
                JButton bExport = new JButton("Export");
                tools.add(bExport);
                c.weighty = 0.0;
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 2;
                panel.add((Component)tools, c);
                reader.setDebug(true);
                bExport.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object string;
                        int colCount = keyEventTableModel.getColumnCount();
                        int rowCount = keyEventTableModel.getRowCount();
                        StringBuilder b = new StringBuilder();
                        SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss.SSS");
                        int i = 0;
                        while (i < rowCount) {
                            int j = 0;
                            while (j < colCount) {
                                Object o = keyEventTableModel.getValueAt(i, j);
                                if (o instanceof Date) {
                                    b.append(df.format((Date)o));
                                } else {
                                    string = o.toString();
                                    if (((String)string).equals("\n")) {
                                        b.append("\\n");
                                    } else if (((String)string).equals("\r")) {
                                        b.append("\\r");
                                    } else {
                                        b.append((String)string);
                                    }
                                }
                                b.append(';');
                                ++j;
                            }
                            b.append("\n");
                            ++i;
                        }
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setSelectedFile(new File("OpenConcerto-KeyEvents.txt"));
                        int retval = fileChooser.showSaveDialog(panel);
                        if (retval == 0) {
                            File file = fileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            if (!file.getName().toLowerCase().endsWith(".txt")) {
                                file = new File(file.getParentFile(), String.valueOf(file.getName()) + ".txt");
                            }
                            try {
                                string = null;
                                Object var10_14 = null;
                                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");){
                                    out.write(b.toString());
                                    out.write(t1.getText());
                                    out.write("\n");
                                    out.write("Delay: " + delay);
                                    out.flush();
                                }
                                catch (Throwable throwable) {
                                    if (string == null) {
                                        string = throwable;
                                    } else if (string != throwable) {
                                        ((Throwable)string).addSuppressed(throwable);
                                    }
                                    throw string;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (file.exists()) {
                                try {
                                    Desktop.getDesktop().open(file);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                });
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        t1.setText("");
                        keyEventTableModel.clear();
                    }
                });
                reader.addKeyEventDispatcher(new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent e) {
                        keyEventTableModel.add(e);
                        return false;
                    }
                });
                reader.addBarcodeListener(new BarcodeListener(){

                    @Override
                    public void keyReceived(KeyEvent ee) {
                        System.err.println("BarcodeReader keyReceived() : " + ee);
                    }

                    @Override
                    public void barcodeRead(Barcode code) {
                        t1.append("Barcode OK : '" + code.getCode() + "'\nType : " + (Object)((Object)code.getType()) + " \n");
                        t1.append("Hex: " + BarcodeReader.bytesToHexString(code.getCode().getBytes()) + "'\n");
                        t1.append("Data : '" + code.getData() + "'\n");
                        GS1Util e = new GS1Util();
                        try {
                            t1.append("GS1 : " + e.parse(code).formatHumanReadable());
                        }
                        catch (Exception ex) {
                            String message = ex.getMessage();
                            if (message == null) {
                                t1.append("Not a GS1 code");
                            }
                            t1.append("Not a GS1 code : " + message);
                        }
                        t1.append("\n\n");
                    }
                });
                t1.setEditable(false);
                f.setSize(new Dimension(640, 580));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public void setEnabled(boolean b) {
        this.enable = b;
    }

    public static String charToHex(char c) {
        int v = c & 0xFF;
        char[] hexChars = new char[]{hexArray[v >>> 4], hexArray[v & 0xF]};
        return new String(hexChars);
    }

    public static String bytesToHexString(byte[] bytes) {
        int length = bytes.length;
        char[] hexChars = new char[length * 2];
        int j = 0;
        while (j < length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public class KeyEventTableModel
    implements TableModel {
        public static final String CHAR_UNDEFINED = "CHAR_UNDEFINED";
        public static final String KEY_TYPED = "Key Typed";
        List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        List<KeyEvent> list = new ArrayList<KeyEvent>();
        Timer t = new Timer();

        private KeyEventTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Date";
                }
                case 1: {
                    return "ID";
                }
                case 2: {
                    return "Code";
                }
                case 3: {
                    return "Character";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Date.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            KeyEvent e = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new Date(e.getWhen());
                }
                case 1: {
                    int id = e.getID();
                    if (id == 400) {
                        return KEY_TYPED;
                    }
                    if (id == 401) {
                        return "Key Pressed";
                    }
                    if (id == 402) {
                        return "Key Released";
                    }
                    return String.valueOf(id);
                }
                case 2: {
                    int code = e.getKeyCode();
                    String name = "";
                    if (code == 10) {
                        name = "ENTER";
                    } else if (code == 8) {
                        name = "BACK SPACE";
                    } else if (code == 16) {
                        name = "SHIFT";
                    } else if (code >= 48 && code <= 57) {
                        name = "DIGIT";
                    } else if (code >= 65 && code <= 90) {
                        name = "CHAR";
                    } else if (code == 119) {
                        name = "F8";
                    }
                    return (String.valueOf(name) + " " + String.valueOf(code) + "  0x" + BarcodeReader.charToHex((char)code)).trim();
                }
                case 3: {
                    char kc = e.getKeyChar();
                    if (kc == '\uffff') {
                        return CHAR_UNDEFINED;
                    }
                    if (kc == '\u001d') {
                        return "<GS>";
                    }
                    return String.valueOf(kc);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void fire() {
            this.t.cancel();
            this.t = new Timer();
            this.t.schedule(new TimerTask(){

                @Override
                public void run() {
                    for (TableModelListener l : KeyEventTableModel.this.listeners) {
                        l.tableChanged(new TableModelEvent(KeyEventTableModel.this));
                    }
                }
            }, 400L);
        }

        public void clear() {
            this.list.clear();
            this.fire();
        }

        public void add(KeyEvent e) {
            this.list.add(e);
            this.fire();
        }
    }
}

