/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.payment.element.ChequeSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.ReleveChequeSheet;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementChequeClient;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class ChequeAEncaisserSQLElement
extends ChequeSQLElement {
    public ChequeAEncaisserSQLElement() {
        super("CHEQUE_A_ENCAISSER", "un ch\u00e9que client", "ch\u00e9ques clients");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_MOUVEMENT");
        l.add("ID_CLIENT");
        l.add("ID_" + BanqueSQLElement.TABLENAME);
        l.add("DATE");
        l.add("ETS");
        l.add("NUMERO");
        l.add("DATE_VENTE");
        l.add("DATE_DEPOT");
        l.add("MONTANT");
        l.add("REG_COMPTA");
        l.add("ENCAISSE");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("REG_COMPTA");
    }

    @Override
    public String getDoneFieldName() {
        return "ENCAISSE";
    }

    @Override
    public String getDateFieldName() {
        return "DATE_DEPOT";
    }

    @Override
    public String getMinDateFieldName() {
        return "DATE_MIN_DEPOT";
    }

    @Override
    public void print(List<Integer> listeCheque, boolean preview, Date d) {
        ReleveChequeSheet sheet = new ReleveChequeSheet(listeCheque, d, preview);
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(true, false, true, Collections.emptyList());
    }

    @Override
    public void handle(SQLRowAccessor rowBanque, SQLRowAccessor rowCheque, Date d, String label) throws Exception {
        GenerationMvtReglementChequeClient gen = new GenerationMvtReglementChequeClient(rowCheque.getForeignID("ID_MOUVEMENT"), rowCheque.getLong("MONTANT"), d, rowCheque.getID(), label, rowBanque);
        gen.genere();
    }

    @Override
    public SQLTableModelSourceOnline createDepositTableSource() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ETS");
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_MOUVEMENT");
        l.add("DATE_VENTE");
        l.add(this.getMinDateFieldName());
        l.add("ID_CLIENT");
        ShowAs showAs = new ShowAs(this.getTable().getDBRoot());
        if (this.getTable().contains("ID_BANQUE")) {
            l.add("ID_BANQUE");
            showAs.show(this.getTable().getForeignTable("ID_BANQUE"), "NOM");
        }
        l.add("MONTANT");
        SQLTable mvtT = this.getTable().getForeignTable("ID_MOUVEMENT");
        showAs.show(mvtT, "ID_PIECE");
        showAs.show(mvtT.getForeignTable("ID_PIECE"), "NOM");
        SQLTable clientERP = this.getTable().getForeignTable("ID_CLIENT");
        showAs.show(clientERP, "NOM");
        return this.createDepositTableSource(l, showAs, new Where((FieldRef)this.getTable().getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE_VENTE");
        l.add("MONTANT");
        l.add("ID_CLIENT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField textMontant;
            {
                this.textMontant = new DeviseField();
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelMontant = new JLabel("Montant ");
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textMontant, c);
                JLabel labelDate = new JLabel("Date ");
                c.weightx = 0.0;
                ++c.gridx;
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDate, c);
                JDate dateVente = new JDate(true);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)dateVente, c);
                JLabel labelDateEcheance = new JLabel("Date d'\u00e9ch\u00e9ance");
                c.weightx = 0.0;
                ++c.gridy;
                c.gridwidth = 1;
                c.gridx = 0;
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDateEcheance, c);
                JDate dateEcheance = new JDate(true);
                ++c.gridx;
                c.gridwidth = 1;
                this.add((Component)dateEcheance, c);
                ++c.gridy;
                c.gridx = 0;
                JLabel labelClientNom = new JLabel("Client ");
                this.add((Component)labelClientNom, c);
                ElementComboBox nomClient = new ElementComboBox();
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)nomClient, c);
                this.addRequiredSQLObject(nomClient, "ID_CLIENT");
                this.addRequiredSQLObject(this.textMontant, "MONTANT");
                this.addRequiredSQLObject(dateVente, "DATE_VENTE");
                this.addRequiredSQLObject(dateEcheance, "DATE_MIN_DEPOT");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".cheque";
    }
}

