/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;

public class SuppressionEcrituresPanel
extends JPanel {
    public SuppressionEcrituresPanel(final int idMvt) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMouvement = base.getTable("MOUVEMENT");
        SQLRow rowMvt = tableMouvement.getRow(idMvt);
        JLabel label = new JLabel("Vous allez supprimer la pi\u00e9ce n\u00b0" + rowMvt.getInt("ID_PIECE"));
        JLabelWarning warning = new JLabelWarning();
        JPanel panelLabel = new JPanel();
        panelLabel.add(warning);
        panelLabel.add(label);
        c.gridwidth = 0;
        this.add((Component)panelLabel, c);
        boolean pointee = false;
        int[] idS = this.getMouvement(rowMvt.getInt("ID_PIECE"));
        if (idS == null) {
            JOptionPane.showMessageDialog(null, "Aucun mouvement associ\u00e9 \u00e0 la pi\u00e9ce n\u00b0" + (rowMvt != null ? Integer.valueOf(rowMvt.getInt("ID_PIECE")) : "mouvement nul"));
        } else {
            StringBuffer s = new StringBuffer();
            s.append("Elle est compos\u00e9e par les mouvements : (");
            JLabel labelMouv = new JLabel();
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)labelMouv, c);
            s.append(idS[0]);
            ArrayList<Integer> idMvts = new ArrayList<Integer>();
            int i = 1;
            while (i < idS.length) {
                idMvts.add(idS[i]);
                s.append(", ");
                s.append(idS[i]);
                ++i;
            }
            s.append(')');
            Tuple2<Set<String>, Set<String>> result = this.getLettragePointage(idMvts);
            if (!result.get0().isEmpty()) {
                s.append("\nAttention certaines \u00e9critures sont lettr\u00e9es avec les codes(" + CollectionUtils.join((Collection)result.get0(), ",") + "!");
            }
            if (!result.get1().isEmpty()) {
                pointee = true;
                s.append("\n\nSuppression impossible car certaines \u00e9critures sont point\u00e9es (code pointage : " + CollectionUtils.join((Collection)result.get1(), ",") + ")");
            }
            labelMouv.setText(s.toString());
        }
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Annuler");
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)buttonOK, c);
        buttonOK.setEnabled(!pointee);
        ++c.gridx;
        this.add((Component)buttonCancel, c);
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(SuppressionEcrituresPanel.this)).dispose();
                try {
                    EcritureSQLElement elt = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                    elt.archiveMouvement(idMvt);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Impossible de supprimer le mouvement associ\u00e9.\n" + ex.getMessage());
                }
            }
        });
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(SuppressionEcrituresPanel.this)).dispose();
            }
        });
    }

    private int[] getMouvement(int idPiece) {
        int[] idS = null;
        SQLBase b = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = b.getTable("MOUVEMENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableMvt.getField("ID"));
        sel.setWhere(tableMvt.getField("ID_PIECE"), "=", idPiece);
        List l = (List)b.getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (!l.isEmpty()) {
            idS = new int[l.size()];
        }
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            idS[i] = ((Number)tmp[0]).intValue();
            ++i;
        }
        return idS;
    }

    private Tuple2<Set<String>, Set<String>> getLettragePointage(List<Integer> mvtIds) {
        HashSet<String> codesLettrage = new HashSet<String>();
        HashSet<String> codesPointage = new HashSet<String>();
        SQLBase b = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcr = b.getTable("ECRITURE");
        SQLSelect sel = new SQLSelect();
        sel.setDistinct(true);
        sel.addSelect(tableEcr.getField("LETTRAGE"));
        sel.addSelect(tableEcr.getField("POINTEE"));
        Where andLettre = new Where((FieldRef)tableEcr.getField("LETTRAGE"), "!=", (Object)"").and(new Where((FieldRef)tableEcr.getField("LETTRAGE"), "!=", (Object)null));
        Where andPointe = new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)"").and(new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)null));
        sel.setWhere(Where.inValues(tableEcr.getField("ID_MOUVEMENT"), mvtIds).and(andLettre.or(andPointe)));
        List l = (List)b.getDataSource().execute(sel.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            String codeP;
            Object[] tmp = (Object[])l.get(i);
            String codeL = (String)tmp[0];
            if (codeL != null && codeL.trim().length() > 0) {
                codesLettrage.add(codeL);
            }
            if ((codeP = (String)tmp[1]) != null && codeP.trim().length() > 0) {
                codesPointage.add(codeP);
            }
            ++i;
        }
        return Tuple2.create(codesLettrage, codesPointage);
    }
}

