/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;

public class GrandLivrePDF {
    public static final int MODEALL = 1;
    public static final int MODELETTREE = 2;
    public static final int MODENONLETTREE_PERIODE = 3;
    public static final int MODENONLETTREE_ALL = 4;
    private final SQLTable tableEcriture;
    private final SQLTable tableMvt;
    private final SQLTable tableCompte;
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    private final SQLRow rowSociete;
    private final Date dateDu;
    private final Date dateAu;
    private final String compteDeb;
    private final String compteEnd;
    private final int lettrage;
    private boolean cumul = false;
    private boolean excludeCompteSolde = true;
    private boolean centralClient = false;
    private boolean centralFourn = false;
    private int idJrnlExclude = -1;
    private boolean includeEcritureFermeture = false;
    private final List<Map<String, Object>> recapSousTotaux = new ArrayList<Map<String, Object>>();
    public static final String TEMPLATE_ID = "GrandLivre";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationGrandLivre";
    private static final int LINE_HEIGHT = 10;
    private static final float COL_DATE_1_SIZE = 34.0f;
    private static final float COL_JRNL_2_SIZE = 35.0f;
    private static final float COL_MVT_3_SIZE = 35.0f;
    private static final float COL_LETTRAGE_4_SIZE = 25.0f;
    private static final float COL_LIBELLE_5_SIZE = 221.0f;
    private static final float COL_DEBIT_6_SIZE = 50.0f;
    private static final float COL_CREDIT_7_SIZE = 50.0f;
    private static final float COL_SOLDE_8_SIZE = 60.0f;
    private static final float COL_DATE_1_X = 40.0f;
    private static final float COL_JRNL_2_X = 74.0f;
    private static final float COL_MVT_3_X = 109.0f;
    private static final float COL_LET_4_X = 144.0f;
    private static final float COL_LIB_5_X = 169.0f;
    private static final float COL_DEB_6_X = 390.0f;
    private static final float COL_CRE_7_X = 440.0f;
    private static final float COL_SOL_8_X = 490.0f;
    private final DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", DecimalFormatSymbols.getInstance(Locale.FRANCE));

    public GrandLivrePDF(ComptaPropsConfiguration conf, Date du, Date au, String compteDep, String compteEnd, int lettrage, boolean cumul, boolean excludeCptSolde, boolean centralClient, boolean centralFourn, int idJrnlExclude, boolean includeEcritureFermeture) {
        this.rowSociete = conf.getRowSociete();
        DBRoot b = conf.getRootSociete();
        this.tableEcriture = b.getTable("ECRITURE");
        this.tableMvt = b.getTable("MOUVEMENT");
        this.tableCompte = b.getTable("COMPTE_PCE");
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.idJrnlExclude = idJrnlExclude;
        this.dateAu = au;
        this.dateDu = du;
        this.compteDeb = compteDep.trim();
        this.compteEnd = compteEnd.trim();
        this.lettrage = lettrage;
        this.cumul = cumul;
        this.excludeCompteSolde = excludeCptSolde;
        this.centralClient = centralClient;
        this.centralFourn = centralFourn;
        this.includeEcritureFermeture = includeEcritureFermeture;
    }

    public void getGeneratedPDFFile(File f) throws IOException {
        List<Integer> lCompteSolde = this.excludeCompteSolde ? this.getListeCompteSolde() : null;
        Map<Integer, Long> mapCumul = this.getCumulsAnterieur(this.dateDu, lCompteSolde);
        List<SQLRowValues> list = this.fetchEcritures(lCompteSolde);
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalCredit = 0L;
        long sousTotalDebit = 0L;
        String nomCpt = "";
        String numCpt = "";
        int y = 0;
        String companyName = String.valueOf(this.rowSociete.getString("TYPE")) + " " + this.rowSociete.getString("NOM");
        String title = "Compte : " + this.compteDeb + " \u00e0 " + this.compteEnd + ". P\u00e9riode du " + this.dateFormatEcr.format(this.dateDu) + " au " + this.dateFormatEcr.format(this.dateAu);
        Double doubleZero = Double.valueOf("0");
        Throwable throwable = null;
        Object var20_17 = null;
        try (PDDocument doc = new PDDocument();){
            int length;
            PDPageContentStream contents = null;
            int size = list.size();
            int i = 0;
            while (i < size) {
                String nextNum;
                String prevNum;
                if (y < 70) {
                    PDPage page = new PDPage(PDRectangle.A4);
                    doc.addPage(page);
                    if (contents != null) {
                        contents.close();
                    }
                    contents = new PDPageContentStream(doc, page);
                    y = this.drawHeader(contents, companyName, title, true);
                }
                SQLRowValues rowEcr = list.get(i);
                int idCpt = rowEcr.getInt("ID_COMPTE_PCE");
                nomCpt = rowEcr.getString("COMPTE_NOM");
                numCpt = rowEcr.getString("COMPTE_NUMERO");
                String string = prevNum = i == 0 ? null : list.get(i - 1).getString("COMPTE_NUMERO");
                if (!(prevNum != null && (prevNum.equals(numCpt) || this.centralFourn && prevNum.startsWith("401") && numCpt.startsWith("401") || this.centralClient && prevNum.startsWith("411") && numCpt.startsWith("411")))) {
                    if (this.centralClient && nomCpt.startsWith("411")) {
                        nomCpt = "411";
                        numCpt = "Centralisation clients";
                    }
                    if (this.centralFourn && nomCpt.startsWith("401")) {
                        nomCpt = "401";
                        numCpt = "Centralisation fournisseurs";
                    }
                    y = this.drawNomCompte(contents, y, numCpt, nomCpt);
                    if (this.cumul) {
                        Long longSolde = mapCumul.get(idCpt);
                        if (longSolde == null) {
                            longSolde = 0L;
                        }
                        long debitCumulAnt = 0L;
                        long creditCumulAnt = 0L;
                        if (longSolde > 0L) {
                            debitCumulAnt = longSolde;
                        } else {
                            creditCumulAnt = -longSolde.longValue();
                        }
                        Double debit = debitCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(debitCumulAnt, false));
                        Double credit = creditCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(creditCumulAnt, false));
                        Double solde = longSolde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(longSolde, false));
                        totalCredit += creditCumulAnt;
                        totalDebit += debitCumulAnt;
                        sousTotalCredit += creditCumulAnt;
                        sousTotalDebit += debitCumulAnt;
                        y = this.drawCumul(contents, y, debit, credit, solde);
                    }
                }
                long cred = rowEcr.getLong("CREDIT");
                long deb = rowEcr.getLong("DEBIT");
                Date dateEcriture = rowEcr.getDate("DATE").getTime();
                String journal = rowEcr.getString("JOURNAL_CODE");
                String mouvement = rowEcr.getForeign("ID_MOUVEMENT").getString("NUMERO");
                String piece = rowEcr.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM");
                String libelle = rowEcr.getString("NOM");
                String codeLettrage = rowEcr.getString("LETTRAGE");
                String codePointage = rowEcr.getString("POINTEE");
                Calendar dateLettrage = rowEcr.getDate("DATE_LETTRAGE");
                Calendar datePointage = rowEcr.getDate("DATE_POINTEE");
                totalCredit += cred;
                totalDebit += deb;
                long ssolde = (sousTotalDebit += deb) - (sousTotalCredit += cred);
                Double debit = deb == 0L ? doubleZero : (double)deb / 100.0;
                Double credit = cred == 0L ? doubleZero : (double)cred / 100.0;
                Double solde = ssolde == 0L ? doubleZero : (double)ssolde / 100.0;
                y = this.drawLine(contents, y, dateEcriture, journal, mouvement, piece, libelle, codeLettrage, codePointage, dateLettrage, datePointage, debit, credit, solde);
                String string2 = nextNum = i >= size - 1 ? null : list.get(i + 1).getString("COMPTE_NUMERO");
                if (!(nextNum != null && (nextNum.equals(numCpt) || this.centralFourn && nextNum.startsWith("401") && numCpt.startsWith("401") || this.centralClient && nextNum.startsWith("411") && numCpt.startsWith("411")))) {
                    if (this.centralClient && nomCpt.startsWith("411")) {
                        nomCpt = "411";
                        numCpt = "Centralisation clients";
                    }
                    if (this.centralFourn && nomCpt.startsWith("401")) {
                        nomCpt = "401";
                        numCpt = "Centralisation fournisseurs";
                    }
                    y = this.drawSousTotal(contents, y, numCpt, nomCpt, sousTotalDebit, sousTotalCredit);
                    sousTotalCredit = 0L;
                    sousTotalDebit = 0L;
                }
                ++i;
            }
            if (contents != null) {
                contents.close();
            }
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            contents = new PDPageContentStream(doc, page);
            y = this.drawHeader(contents, companyName, title, false);
            for (Map<String, Object> recap : this.recapSousTotaux) {
                if (y < 70) {
                    page = new PDPage(PDRectangle.A4);
                    doc.addPage(page);
                    if (contents != null) {
                        contents.close();
                    }
                    contents = new PDPageContentStream(doc, page);
                    y = this.drawHeader(contents, companyName, title, false);
                }
                String numero = (String)recap.get("NUMERO");
                String libelle = (String)recap.get("LIBELLE");
                double debit = (double)((Long)recap.get("DEBIT")).longValue() / 100.0;
                double credit = (double)((Long)recap.get("CREDIT")).longValue() / 100.0;
                double solde = debit - credit;
                y = this.drawRecapLine(contents, y, numero, libelle, debit, credit, solde, false);
            }
            Double debit = totalDebit == 0L ? 0.0 : (double)totalDebit / 100.0;
            Double credit = totalCredit == 0L ? 0.0 : (double)totalCredit / 100.0;
            Double solde = totalDebit - totalCredit == 0L ? 0.0 : (double)(totalDebit - totalCredit) / 100.0;
            y = this.drawRecapLine(contents, y, "", "GLOBAL", debit, credit, solde, true);
            contents.close();
            InputStream sImage = this.getClass().getResourceAsStream("OpenConcerto_2000px.png");
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((length = sImage.read(buf)) > 0) {
                bOut.write(buf, 0, length);
            }
            sImage.close();
            bOut.close();
            float ratio = 20.0f;
            int pageCount = doc.getNumberOfPages();
            int index = 0;
            while (index < pageCount) {
                PDPage currentPage = doc.getPage(index);
                contents = new PDPageContentStream(doc, currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
                if (index == 0 || index == pageCount - 1) {
                    PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])bOut.toByteArray(), (String)"openconcerto.png");
                    float h = (float)pdImage.getHeight() / 20.0f;
                    contents.drawImage(pdImage, 40.0f, 10.0f, (float)pdImage.getWidth() / 20.0f, h);
                }
                contents.beginText();
                contents.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
                contents.newLineAtOffset(250.0f, 20.0f);
                contents.showText("Edition du " + StringUtils.cleanPDFString(this.dateFormatEcr.format(new Date())));
                contents.endText();
                contents.beginText();
                contents.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
                contents.newLineAtOffset(500.0f, 20.0f);
                contents.showText("Page " + (index + 1) + " / " + pageCount);
                contents.endText();
                contents.close();
                ++index;
            }
            doc.save(f);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int drawLine(PDPageContentStream contents, int y, Date dateEcriture, String journal, String mouvement, String piece, String libelle, String codeLettrage, String codePointage, Calendar dateLettrage, Calendar datePointage, Double debit, Double credit, Double solde) throws IOException {
        y -= 10;
        contents.setFont((PDFont)PDType1Font.HELVETICA, 7.0f);
        if (dateEcriture != null) {
            this.drawRightAlign(contents, 40.0f, y, 29.0f, this.dateFormatEcr.format(dateEcriture));
        }
        if (journal != null) {
            contents.beginText();
            contents.newLineAtOffset(74.0f, (float)y);
            contents.showText(StringUtils.cleanPDFString(journal));
            contents.endText();
        }
        if (mouvement != null) {
            contents.beginText();
            contents.newLineAtOffset(109.0f, (float)y);
            contents.showText(StringUtils.cleanPDFString(mouvement));
            contents.endText();
        }
        if (codeLettrage != null) {
            contents.beginText();
            contents.newLineAtOffset(144.0f, (float)y);
            contents.showText(StringUtils.cleanPDFString(codeLettrage));
            contents.endText();
        }
        contents.beginText();
        contents.newLineAtOffset(169.0f, (float)y);
        contents.showText(StringUtils.limitLength(StringUtils.cleanPDFString(libelle), 60));
        contents.endText();
        this.drawRightAlign(contents, 390.0f, y, 50.0f, this.decimalFormat.format(debit));
        this.drawRightAlign(contents, 440.0f, y, 50.0f, this.decimalFormat.format(credit));
        this.drawRightAlign(contents, 490.0f, y, 60.0f, this.decimalFormat.format(solde));
        contents.setLineWidth(0.5f);
        contents.setStrokingColor(Color.LIGHT_GRAY);
        contents.moveTo(36.0f, (float)y - 2.0f);
        contents.lineTo(554.0f, (float)y - 2.0f);
        contents.stroke();
        return y;
    }

    private int drawRecapLine(PDPageContentStream contents, int y, String num, String libelle, Double debit, Double credit, Double solde, boolean total) throws IOException {
        y -= 10;
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        if (!total) {
            contents.beginText();
            contents.newLineAtOffset(40.0f, (float)y);
            contents.showText(StringUtils.cleanPDFString(num));
            contents.endText();
            contents.setFont((PDFont)PDType1Font.HELVETICA, 7.0f);
            contents.beginText();
            contents.newLineAtOffset(109.0f, (float)y);
            contents.showText(StringUtils.cleanPDFString(libelle));
            contents.endText();
        }
        this.drawRightAlign(contents, 390.0f, y, 50.0f, this.decimalFormat.format(debit));
        this.drawRightAlign(contents, 440.0f, y, 50.0f, this.decimalFormat.format(credit));
        this.drawRightAlign(contents, 490.0f, y, 60.0f, this.decimalFormat.format(solde));
        if (!total) {
            contents.setLineWidth(0.5f);
            contents.setStrokingColor(Color.LIGHT_GRAY);
            contents.moveTo(36.0f, (float)y - 2.0f);
            contents.lineTo(554.0f, (float)y - 2.0f);
            contents.stroke();
        }
        return y;
    }

    private void drawRightAlign(PDPageContentStream contents, float x, float y, float width, String text) throws IOException {
        contents.beginText();
        float w = PDType1Font.HELVETICA.getStringWidth(StringUtils.cleanPDFString(text)) / 1000.0f * 7.0f;
        contents.newLineAtOffset(x + width - w, y);
        contents.showText(StringUtils.cleanPDFString(text));
        contents.endText();
    }

    private int drawNomCompte(PDPageContentStream contents, int y, String numCpt, String nomCpt) throws IOException {
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        contents.newLineAtOffset(40.0f, (float)(y -= 10));
        String string = String.valueOf(numCpt) + " " + nomCpt.toUpperCase();
        contents.showText(StringUtils.cleanPDFString(string));
        contents.endText();
        return y;
    }

    private int drawCumul(PDPageContentStream contents, int y, Double debit, Double credit, Double solde) throws IOException {
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        contents.beginText();
        contents.newLineAtOffset(169.0f, (float)(y -= 10));
        contents.showText(StringUtils.cleanPDFString("Cumuls ant\u00e9rieurs"));
        contents.endText();
        this.drawRightAlign(contents, 390.0f, y, 50.0f, this.decimalFormat.format(debit));
        this.drawRightAlign(contents, 440.0f, y, 50.0f, this.decimalFormat.format(credit));
        this.drawRightAlign(contents, 490.0f, y, 60.0f, this.decimalFormat.format(solde));
        return y;
    }

    private int drawHeader(PDPageContentStream contents, String companyName, String title, boolean full) throws IOException {
        int y = 795;
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        contents.newLineAtOffset(40.0f, (float)y);
        contents.showText("GRAND LIVRE    " + StringUtils.cleanPDFString(companyName.toUpperCase()));
        contents.endText();
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
        contents.newLineAtOffset(40.0f, (float)(y -= 17));
        contents.showText(StringUtils.cleanPDFString(title));
        contents.endText();
        y -= 20;
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        if (full) {
            contents.beginText();
            contents.newLineAtOffset(45.0f, (float)y);
            contents.showText("DATE");
            contents.endText();
            contents.beginText();
            contents.newLineAtOffset(74.0f, (float)y);
            contents.showText("JOURNAL");
            contents.endText();
            contents.beginText();
            contents.newLineAtOffset(109.0f, (float)y);
            contents.showText(" MVT");
            contents.endText();
            contents.beginText();
            contents.newLineAtOffset(144.0f, (float)y);
            contents.showText("LET");
            contents.endText();
            contents.beginText();
            contents.newLineAtOffset(169.0f, (float)y);
            contents.showText("LIBELLE");
            contents.endText();
        } else {
            contents.beginText();
            contents.newLineAtOffset(40.0f, (float)y);
            contents.showText("COMPTE");
            contents.endText();
        }
        this.drawRightAlign(contents, 390.0f, y, 50.0f, "DEBIT");
        this.drawRightAlign(contents, 440.0f, y, 50.0f, "CREDIT");
        this.drawRightAlign(contents, 490.0f, y, 60.0f, "SOLDE CUMULE");
        contents.setStrokingColor(Color.BLACK);
        contents.setLineWidth(1.0f);
        contents.moveTo(36.0f, (float)(y -= 4));
        contents.lineTo(554.0f, (float)y);
        contents.stroke();
        return y;
    }

    private int drawSousTotal(PDPageContentStream contents, int y, String numCpt, String nomCpt, long debit, long credit) throws IOException {
        HashMap<String, Object> lineRecap = new HashMap<String, Object>();
        lineRecap.put("NUMERO", numCpt);
        lineRecap.put("LIBELLE", nomCpt);
        lineRecap.put("DEBIT", debit);
        lineRecap.put("CREDIT", credit);
        this.recapSousTotaux.add(lineRecap);
        contents.beginText();
        contents.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        contents.newLineAtOffset(169.0f, (float)(y -= 10));
        contents.showText("Sous-total");
        contents.endText();
        this.drawRightAlign(contents, 390.0f, y, 50.0f, this.decimalFormat.format((double)debit / 100.0));
        this.drawRightAlign(contents, 440.0f, y, 50.0f, this.decimalFormat.format((double)credit / 100.0));
        this.drawRightAlign(contents, 490.0f, y, 60.0f, this.decimalFormat.format((double)(debit - credit) / 100.0));
        return y -= 10;
    }

    private List<SQLRowValues> fetchEcritures(final List<Integer> lCompteSolde) {
        SQLRowValues vals = new SQLRowValues(this.tableEcriture);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        if (this.tableEcriture.contains("NOM_PIECE")) {
            vals.put("NOM_PIECE", null);
        }
        vals.put("ID_JOURNAL", null);
        vals.put("JOURNAL_CODE", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null).putRowValues("ID_PIECE").put("NOM", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        vals.put("LETTRAGE", null);
        vals.put("POINTEE", null);
        vals.put("DATE_LETTRAGE", null);
        vals.put("DATE_POINTEE", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = GrandLivrePDF.this.getWhere(lCompteSolde);
                sel.setWhere(w);
                sel.addFieldOrder(GrandLivrePDF.this.tableEcriture.getField("COMPTE_NUMERO"));
                sel.addFieldOrder(GrandLivrePDF.this.tableEcriture.getField("DATE"));
                sel.addFieldOrder(GrandLivrePDF.this.tableMvt.getField("NUMERO"));
                return sel;
            }
        });
        return fetcher.fetch();
    }

    private List<Integer> getListeCompteSolde() {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(this.tableEcriture.getField("ID_COMPTE_PCE"));
        sel.addSelect(this.tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(this.tableEcriture.getField("CREDIT"), "SUM");
        Where w = this.getWhere(null);
        sel.setWhere(w);
        sel.addGroupBy(this.tableEcriture.getField("ID_COMPTE_PCE"));
        String req = sel.asString();
        List l = (List)this.tableCompte.getBase().getDataSource().execute(req, new ArrayListHandler());
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object[] o : l) {
            long credit = 0L;
            if (o[2] != null) {
                credit = Long.parseLong(o[2].toString());
            }
            long debit = 0L;
            if (o[1] != null) {
                debit = Long.parseLong(o[1].toString());
            }
            int id = Integer.parseInt(o[0].toString());
            long solde = debit - credit;
            if (solde != 0L) continue;
            list.add(id);
        }
        return list;
    }

    private Where getWhere(List<Integer> lCompteSolde) {
        Where w = new Where((FieldRef)this.tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu);
        w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)this.tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)this.tableEcriture.getField("COMPTE_NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
        w = w.and(new Where((FieldRef)this.tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        w = w.and(new Where((FieldRef)this.tableEcriture.getField("ID_MOUVEMENT"), "=", this.tableMvt.getField("ID")));
        if (this.lettrage == 2) {
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "<>", (Object)null));
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("DATE_LETTRAGE"), "<=", (Object)this.dateAu));
        } else if (this.lettrage == 3) {
            Where w2 = new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)null);
            Where wSTTC = new Where((FieldRef)this.tableEcriture.getField("DATE_LETTRAGE"), "<>", (Object)null);
            wSTTC = wSTTC.and(new Where((FieldRef)this.tableEcriture.getField("DATE_LETTRAGE"), ">", (Object)this.dateAu));
            w2 = w2.or(wSTTC);
            w = w.and(w2.or(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        } else if (this.lettrage == 4) {
            Where w2 = new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)null);
            w = w.and(w2.or(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        if (this.excludeCompteSolde && lCompteSolde != null) {
            w = w.and(new Where(this.tableEcriture.getField("ID_COMPTE_PCE"), lCompteSolde).not());
        }
        if (!this.includeEcritureFermeture) {
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("NOM"), "NOT LIKE", (Object)"Fermeture du compte%"));
        }
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        return w;
    }

    private Map<Integer, Long> getCumulsAnterieur(Date d, List<Integer> listCompteSolde) {
        Object o;
        SQLSelect sel = new SQLSelect();
        sel.addSelect(this.tableEcriture.getField("ID_COMPTE_PCE"));
        sel.addSelect(this.tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(this.tableEcriture.getField("CREDIT"), "SUM");
        sel.addSelect(this.tableEcriture.getField("COMPTE_NUMERO"));
        Where w = new Where((FieldRef)this.tableEcriture.getField("DATE"), "<", (Object)d);
        w = w.and(new Where((FieldRef)this.tableEcriture.getField("ID_MOUVEMENT"), "=", this.tableMvt.getKey()));
        w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)this.tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)this.tableEcriture.getField("COMPTE_NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
        if (this.lettrage == 2) {
            o = null;
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
            w = w.and(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.lettrage == 4 || this.lettrage == 3) {
            o = null;
            Where w2 = new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)this.tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        w = w.and(new Where((FieldRef)this.tableEcriture.getField("ID_COMPTE_PCE"), "=", this.tableCompte.getField("ID")));
        w = w.and(new Where((FieldRef)this.tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        if (listCompteSolde != null) {
            w = w.and(new Where(this.tableEcriture.getField("ID_COMPTE_PCE"), listCompteSolde).not());
        }
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"ECRITURE\".\"ID_COMPTE_PCE\", \"ECRITURE\".\"COMPTE_NUMERO\"";
        List l = (List)this.tableEcriture.getBase().getDataSource().execute(req, new ArrayListHandler());
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        int idCptFourn = ComptePCESQLElement.getId("401", "Fournisseurs");
        int idCptClient = ComptePCESQLElement.getId("411", "Clients");
        for (Object[] o2 : l) {
            Long lS;
            long credit = 0L;
            if (o2[2] != null) {
                credit = Long.parseLong(o2[2].toString());
            }
            long debit = 0L;
            if (o2[1] != null) {
                debit = Long.parseLong(o2[1].toString());
            }
            int id = Integer.parseInt(o2[0].toString());
            long solde = debit - credit;
            map.put(id, solde);
            if (o2[3] == null) continue;
            String numero = o2[3].toString();
            if (this.centralFourn && numero.startsWith("401")) {
                lS = (Long)map.get(idCptFourn);
                lS = lS != null ? Long.valueOf(lS + solde) : Long.valueOf(solde);
                map.put(idCptFourn, lS);
            }
            if (!this.centralClient || !numero.startsWith("411")) continue;
            lS = (Long)map.get(idCptClient);
            lS = lS != null ? Long.valueOf(lS + solde) : Long.valueOf(solde);
            map.put(idCptClient, lS);
        }
        return map;
    }
}

