/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.io.File;
import java.io.Serializable;
import org.openconcerto.sql.model.SQLRowValues;

public class Attachment
implements Serializable {
    private final int id;
    private String name;
    private String mimeType;
    private String fileName;
    private int fileSize;
    private String storagePath;
    private String storageFileName;
    private String sourceTable;
    private int sourceId;
    private int parentId;
    private boolean encrypted;
    public static final String MIMETYPE_URL = "application/url-mime-type";
    public static final String MIMETYPE_FOLDER = "inode/directory";

    public Attachment(SQLRowValues rowAttachment) {
        this.id = rowAttachment.getID();
        this.name = rowAttachment.getString("NAME");
        this.mimeType = rowAttachment.getString("MIMETYPE");
        this.fileName = rowAttachment.getString("FILENAME");
        this.fileSize = rowAttachment.getInt("FILESIZE");
        this.storagePath = rowAttachment.getString("STORAGE_PATH").replace('\\', File.separatorChar);
        this.storageFileName = rowAttachment.getString("STORAGE_FILENAME");
        this.sourceTable = rowAttachment.getString("SOURCE_TABLE");
        this.sourceId = rowAttachment.getInt("SOURCE_ID");
        this.parentId = rowAttachment.getInt("ID_PARENT");
        this.encrypted = rowAttachment.getBoolean("ENCRYPTED");
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getStorageFileName() {
        return this.storageFileName;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public boolean isFolder() {
        return this.mimeType.equals(MIMETYPE_FOLDER);
    }

    public boolean isURL() {
        return this.mimeType.equals(MIMETYPE_URL);
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " attachment id:" + this.getId() + " name:" + this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getId() == ((Attachment)obj).getId();
    }

    public int hashCode() {
        return this.getId();
    }
}

