/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public class TotalCalculator {
    private static String FIELD_SERVICE = "SERVICE";
    private static String FIELD_POIDS = "T_POIDS";
    private final String fieldHT;
    private final String fieldHA;
    private final String fieldDevise;
    private boolean imputEcart = true;
    private SQLRowAccessor rowDefaultCptProduit;
    private SQLRowAccessor rowDefaultCptService;
    private SQLRowAccessor rowDefaultCptTVACollecte;
    private SQLRowAccessor rowDefaultCptTVADeductible;
    private SQLRowAccessor rowDefaultCptAchat;
    private final SQLRowAccessor rowCatComptable;
    private SQLRowAccessor rowDefaultCptProduitStandard;
    private double totalPoids;
    private BigDecimal totalDevise;
    private BigDecimal totalDeviseSel;
    private BigDecimal totalHA;
    private BigDecimal totalHASel;
    private BigDecimal totalEco;
    private BigDecimal totalEcoSel;
    private BigDecimal totalService;
    private BigDecimal totalServiceSel;
    private BigDecimal totalHTSansFActurable;
    private BigDecimal totalTTC;
    private BigDecimal totalTTCSel;
    private long remiseHT;
    private long remiseRestante;
    private final boolean achat;
    private Map<SQLRowAccessor, BigDecimal> mapHt = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtSansFacturable = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtSel = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVA = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> mapHtTaxeCompl = new HashMap<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>>();
    private Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> mapHtTaxeComplSansFacturable = new HashMap<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVAIntra = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVASel = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> mapHtTVARowTaux = new HashMap<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>>();
    private int[] selectedRows;
    private Boolean bServiceActive;
    private BigDecimal totalHTAvantRemise;
    private boolean intraComm = false;
    private boolean interfel = false;
    private static Map<Integer, SQLRowAccessor> mapTVA;
    private static Map<Integer, SQLRowAccessor> mapInterfel;
    private static long lastTVAfetchedTime;
    final SQLTable tvaTable = Configuration.getInstance().getRoot().findTable("TAXE");
    final SQLTable compteTable = Configuration.getInstance().getRoot().findTable("COMPTE_PCE");

    static {
        lastTVAfetchedTime = 0L;
    }

    public TotalCalculator(String fieldHA, String fieldHT, String fieldDeviseTotal, SQLRowAccessor rowCatComptable) {
        this(fieldHA, fieldHT, fieldDeviseTotal, false, null, rowCatComptable);
    }

    public void setRowDefaultCptService(SQLRowAccessor rowDefaultCptService) {
        this.rowDefaultCptService = rowDefaultCptService;
    }

    public void setIntraComm(boolean intraComm) {
        this.intraComm = intraComm;
    }

    public void setInterfel(boolean interfel) {
        this.interfel = interfel;
    }

    public TotalCalculator(String fieldHA, String fieldHT, String fieldDeviseTotal, boolean achat, SQLRowAccessor defaultCompte, SQLRowAccessor rowCatComptable) {
        this.achat = achat;
        this.initValues();
        this.fieldDevise = fieldDeviseTotal;
        this.fieldHA = fieldHA;
        this.fieldHT = fieldHT;
        SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
        SQLBackgroundTableCacheItem cacheForTablePref = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte);
        SQLBackgroundTableCacheItem cacheForTableCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte.getTable("COMPTE_PCE"));
        SQLRow rowPrefsCompte = cacheForTablePref.getRowFromId(2);
        SQLPreferences prefs = SQLPreferences.getMemCached(tablePrefCompte.getDBRoot());
        this.imputEcart = prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.IMPUT_ECART, true);
        this.rowDefaultCptService = cacheForTableCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_VENTE_SERVICE"));
        if (this.rowDefaultCptService == null || this.rowDefaultCptService.isUndefined()) {
            try {
                this.rowDefaultCptService = ComptePCESQLElement.getRowComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowCatComptable = rowCatComptable;
        if (defaultCompte == null || defaultCompte.isUndefined()) {
            if (rowCatComptable != null && !rowCatComptable.isUndefined() && !rowCatComptable.isForeignEmpty("ID_COMPTE_PCE_VENTE")) {
                this.rowDefaultCptProduit = cacheForTableCompte.getRowFromId(rowCatComptable.getForeignID("ID_COMPTE_PCE_VENTE"));
            } else {
                this.rowDefaultCptProduit = cacheForTableCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_VENTE_PRODUIT"));
                if (this.rowDefaultCptProduit == null || this.rowDefaultCptProduit.isUndefined()) {
                    try {
                        this.rowDefaultCptProduit = ComptePCESQLElement.getRowComptePceDefault("VentesProduits");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.rowDefaultCptProduit = defaultCompte;
        }
        this.rowDefaultCptProduitStandard = this.rowDefaultCptProduit;
        this.rowDefaultCptTVACollecte = cacheForTableCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_TVA_VENTE"));
        if (this.rowDefaultCptTVACollecte == null || this.rowDefaultCptTVACollecte.isUndefined()) {
            try {
                this.rowDefaultCptTVACollecte = ComptePCESQLElement.getRowComptePceDefault("TVACollectee");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowDefaultCptTVADeductible = cacheForTableCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_TVA_ACHAT"));
        if (this.rowDefaultCptTVADeductible == null || this.rowDefaultCptTVADeductible.isUndefined()) {
            try {
                this.rowDefaultCptTVADeductible = ComptePCESQLElement.getRowComptePceDefault("TVADeductible");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (defaultCompte == null || defaultCompte.isUndefined()) {
            if (rowCatComptable != null && !rowCatComptable.isUndefined() && !rowCatComptable.isForeignEmpty("ID_COMPTE_PCE_ACHAT")) {
                this.rowDefaultCptProduit = cacheForTableCompte.getRowFromId(rowCatComptable.getForeignID("ID_COMPTE_PCE_ACHAT"));
            } else {
                this.rowDefaultCptAchat = cacheForTableCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_ACHAT"));
                if (this.rowDefaultCptAchat == null || this.rowDefaultCptAchat.isUndefined()) {
                    try {
                        this.rowDefaultCptAchat = ComptePCESQLElement.getRowComptePceDefault("Achats");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.rowDefaultCptAchat = defaultCompte;
        }
    }

    public void setRowDefaultCptProduit(SQLRowAccessor rowDefaultCptProduit) {
        this.rowDefaultCptProduit = rowDefaultCptProduit;
    }

    public void retoreRowDefaultCptProduit() {
        this.rowDefaultCptProduit = this.rowDefaultCptProduitStandard;
    }

    public void setRemise(long remiseHT, BigDecimal totalHTAvantRemise) {
        this.remiseHT = remiseHT;
        this.remiseRestante = remiseHT;
        this.totalHTAvantRemise = totalHTAvantRemise;
    }

    public void addTVAAdjust(BigDecimal tvaFix) {
        SQLRowAccessor rowCptTva;
        SQLBackgroundTableCacheItem cacheForTableCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(this.compteTable);
        SQLRow tva = TaxeCache.getCache().getFirstTaxe();
        if (this.intraComm) {
            SQLRowAccessor rowCptTvaIntra;
            rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_DED_INTRA"));
            if (rowCptTva == null || rowCptTva.isUndefined()) {
                rowCptTva = this.rowDefaultCptTVADeductible;
            }
            if ((rowCptTvaIntra = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_COLLECTE_INTRA"))) == null || rowCptTvaIntra.isUndefined()) {
                rowCptTvaIntra = this.rowDefaultCptTVADeductible;
            }
            if (this.mapHtTVAIntra.get(rowCptTvaIntra) == null) {
                this.mapHtTVAIntra.put(rowCptTvaIntra, tvaFix);
            } else {
                BigDecimal l = this.mapHtTVAIntra.get(rowCptTvaIntra);
                this.mapHtTVAIntra.put(rowCptTvaIntra, l.add(tvaFix));
            }
        } else if (this.achat) {
            rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_DED"));
            if (rowCptTva == null || rowCptTva.isUndefined()) {
                rowCptTva = this.rowDefaultCptTVADeductible;
            }
        } else {
            rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_COLLECTE"));
            if (rowCptTva == null || rowCptTva.isUndefined()) {
                rowCptTva = this.rowDefaultCptTVACollecte;
            }
        }
        if (this.mapHtTVA.get(rowCptTva) == null) {
            this.mapHtTVA.put(rowCptTva, tvaFix);
        } else {
            BigDecimal l = this.mapHtTVA.get(rowCptTva);
            this.mapHtTVA.put(rowCptTva, l.add(tvaFix));
        }
        this.totalTTC = this.totalTTC.add(tvaFix);
    }

    public void setServiceActive(boolean b) {
        this.bServiceActive = b;
    }

    public void initValues() {
        this.remiseHT = 0L;
        this.remiseRestante = 0L;
        this.totalHTAvantRemise = BigDecimal.ZERO;
        this.selectedRows = null;
        this.totalHTSansFActurable = BigDecimal.ZERO;
        this.totalTTC = BigDecimal.ZERO;
        this.totalTTCSel = BigDecimal.ZERO;
        this.totalEco = BigDecimal.ZERO;
        this.totalEcoSel = BigDecimal.ZERO;
        this.totalHA = BigDecimal.ZERO;
        this.totalHASel = BigDecimal.ZERO;
        this.totalService = BigDecimal.ZERO;
        this.totalServiceSel = BigDecimal.ZERO;
        this.totalDeviseSel = BigDecimal.ZERO;
        this.totalDevise = BigDecimal.ZERO;
        this.totalPoids = 0.0;
        this.mapHt.clear();
        this.mapHtSansFacturable.clear();
        this.mapHtSel.clear();
        this.mapHtTVA.clear();
        this.mapHtTaxeCompl.clear();
        this.mapHtTVAIntra.clear();
        this.mapHtTVARowTaux.clear();
        this.mapHtTVASel.clear();
    }

    public void setSelectedRows(int[] selectedRows) {
        this.selectedRows = selectedRows;
    }

    public void addEchantillon(BigDecimal ht, SQLRowAccessor tva) {
        this.addHT(ht, ht, tva, this.rowDefaultCptProduit, false);
    }

    private void fetchTaxe() {
        mapTVA = new HashMap<Integer, SQLRowAccessor>();
        Set<SQLRowAccessor> taxes = TaxeCache.getCache().getAllTaxe();
        for (SQLRowAccessor sqlRowAccessor : taxes) {
            mapTVA.put(sqlRowAccessor.getID(), sqlRowAccessor);
        }
        mapInterfel = new HashMap<Integer, SQLRowAccessor>();
        SQLRowValues rowValsInter = new SQLRowValues(this.tvaTable.getTable("TAXE_INTERFEL")).setAllToNull();
        List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowValsInter).fetch();
        for (SQLRowAccessor sQLRowAccessor : fetch) {
            mapInterfel.put(sQLRowAccessor.getID(), sQLRowAccessor);
        }
        lastTVAfetchedTime = System.currentTimeMillis();
    }

    private void addHT(BigDecimal ht, BigDecimal htSansFacturable, SQLRowAccessor tva, SQLRowAccessor cptArticle, boolean selection) {
        BigDecimal l;
        BigDecimal totalTVA;
        BigDecimal ttc;
        SQLBackgroundTableCacheItem cacheForTableCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(cptArticle.getTable());
        if (tva == null || tva.isUndefined()) {
            ttc = ht;
            totalTVA = BigDecimal.ZERO;
        } else {
            BigDecimal tauxTVA = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(tva.getID()).floatValue()).movePointLeft(2);
            ttc = tauxTVA.add(BigDecimal.ONE).multiply(ht, DecimalUtils.HIGH_PRECISION);
            totalTVA = ttc.subtract(ht);
        }
        if (tva != null && !tva.isUndefined()) {
            Object l2;
            SQLRowAccessor rowCptTva;
            if (this.intraComm) {
                SQLRowAccessor rowCptTvaIntra;
                rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_DED_INTRA"));
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVADeductible;
                }
                if ((rowCptTvaIntra = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_COLLECTE_INTRA"))) == null || rowCptTvaIntra.isUndefined()) {
                    rowCptTvaIntra = this.rowDefaultCptTVADeductible;
                }
                if (this.mapHtTVAIntra.get(rowCptTvaIntra) == null) {
                    this.mapHtTVAIntra.put(rowCptTvaIntra, totalTVA);
                } else {
                    BigDecimal l3 = this.mapHtTVAIntra.get(rowCptTvaIntra);
                    this.mapHtTVAIntra.put(rowCptTvaIntra, l3.add(totalTVA));
                }
                ttc = ht;
            } else if (this.achat) {
                rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_DED"));
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVADeductible;
                }
            } else {
                rowCptTva = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_COLLECTE"));
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVACollecte;
                }
            }
            if (this.mapHtTVA.get(rowCptTva) == null) {
                this.mapHtTVA.put(rowCptTva, totalTVA);
            } else {
                l2 = this.mapHtTVA.get(rowCptTva);
                this.mapHtTVA.put(rowCptTva, ((BigDecimal)l2).add(totalTVA));
            }
            if (ht.signum() != 0) {
                if (this.mapHtTVARowTaux.get(tva) == null) {
                    this.mapHtTVARowTaux.put(tva, Tuple2.create(ht, totalTVA));
                } else {
                    l2 = this.mapHtTVARowTaux.get(tva);
                    this.mapHtTVARowTaux.put(tva, Tuple2.create(ht.add((BigDecimal)((Tuple2)l2).get0()), ((BigDecimal)((Tuple2)l2).get1()).add(totalTVA)));
                }
            }
            if (selection) {
                if (this.mapHtTVASel.get(rowCptTva) == null) {
                    this.mapHtTVASel.put(rowCptTva, totalTVA);
                } else {
                    l2 = this.mapHtTVASel.get(rowCptTva);
                    this.mapHtTVASel.put(rowCptTva, ((BigDecimal)l2).add(totalTVA));
                }
            }
        }
        if (this.mapHt.get(cptArticle) == null) {
            this.mapHt.put(cptArticle, ht);
        } else {
            l = this.mapHt.get(cptArticle);
            this.mapHt.put(cptArticle, l.add(ht));
        }
        if (this.mapHtSansFacturable.get(cptArticle) == null) {
            this.mapHtSansFacturable.put(cptArticle, htSansFacturable);
        } else {
            l = this.mapHtSansFacturable.get(cptArticle);
            this.mapHtSansFacturable.put(cptArticle, l.add(htSansFacturable));
        }
        this.totalTTC = this.totalTTC.add(ttc);
        this.totalHTSansFActurable = this.totalHTSansFActurable.add(htSansFacturable);
        if (selection) {
            if (this.mapHtSel.get(cptArticle) == null) {
                this.mapHtSel.put(cptArticle, ht);
            } else {
                l = this.mapHtSel.get(cptArticle);
                this.mapHtSel.put(cptArticle, l.add(ht));
            }
            this.totalTTCSel = this.totalTTCSel.add(ttc);
        }
    }

    private static boolean containsInt(int[] tab, int i) {
        if (tab == null) {
            return false;
        }
        int j = 0;
        while (j < tab.length) {
            if (tab[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void addLine(SQLRowAccessor rowAccessorLine, SQLRowAccessor article, int lineNumber, boolean last) {
        this.addLine(rowAccessorLine, article, lineNumber, last, false);
    }

    public void addLine(SQLRowAccessor rowAccessorLine, SQLRowAccessor article, int lineNumber, boolean last, boolean leafOK) {
        if (!leafOK && rowAccessorLine.getFields().contains("NIVEAU") && rowAccessorLine.getInt("NIVEAU") != 1) {
            return;
        }
        BigDecimal totalLineHT = rowAccessorLine.getObject(this.fieldHT) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHT);
        BigDecimal totalLineEco = rowAccessorLine.getObject("T_ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("T_ECO_CONTRIBUTION");
        BigDecimal totalLineHTSansFacturable = totalLineHT;
        if (!this.achat) {
            totalLineHTSansFacturable = rowAccessorLine.getObject("PV_HT") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("PV_HT");
            BigDecimal qteUV = rowAccessorLine.getObject("QTE_UNITAIRE") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("QTE_UNITAIRE");
            int qte = rowAccessorLine.getInt("QTE");
            totalLineHTSansFacturable = totalLineHTSansFacturable.multiply(qteUV).multiply(new BigDecimal(qte));
        }
        BigDecimal totalHALigne = rowAccessorLine.getObject(this.fieldHA) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHA);
        Boolean service = rowAccessorLine.getBoolean(FIELD_SERVICE);
        BigDecimal totalLineDevise = this.fieldDevise == null || rowAccessorLine.getObject(this.fieldDevise) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldDevise);
        Number nPoids = (Number)rowAccessorLine.getObject(FIELD_POIDS);
        if (this.remiseHT != 0L && this.remiseRestante > 0L && this.totalHTAvantRemise != null && this.totalHTAvantRemise.signum() != 0) {
            if (last) {
                totalLineHT = totalLineHT.subtract(new BigDecimal(this.remiseRestante).movePointLeft(2));
                totalLineHTSansFacturable = totalLineHTSansFacturable.subtract(new BigDecimal(this.remiseRestante).movePointLeft(2));
                this.remiseRestante = 0L;
            } else {
                BigDecimal percent = totalLineHT.divide(this.totalHTAvantRemise, DecimalUtils.HIGH_PRECISION);
                BigDecimal remiseApply = percent.multiply(new BigDecimal(this.remiseHT), DecimalUtils.HIGH_PRECISION).setScale(0, RoundingMode.HALF_UP);
                totalLineHT = totalLineHT.subtract(remiseApply.movePointLeft(2));
                totalLineHTSansFacturable = totalLineHTSansFacturable.subtract(remiseApply.movePointLeft(2));
                this.remiseRestante -= remiseApply.longValue();
            }
        }
        if (mapTVA == null || lastTVAfetchedTime + 30000L < System.currentTimeMillis()) {
            this.fetchTaxe();
        }
        Integer idTVA = null;
        if (rowAccessorLine.getObject("ID_TAXE") != null && !rowAccessorLine.isForeignEmpty("ID_TAXE")) {
            idTVA = rowAccessorLine.getForeignID("ID_TAXE");
        } else {
            SQLRowAccessor foreignTVA = rowAccessorLine.getForeign("ID_TAXE");
            if (foreignTVA != null) {
                idTVA = foreignTVA.getID();
            }
        }
        SQLRowAccessor tva = mapTVA.get(idTVA);
        SQLRowAccessor cpt = this.achat ? this.rowDefaultCptAchat : this.rowDefaultCptProduit;
        SQLBackgroundTableCacheItem cacheForTableCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(cpt.getTable());
        boolean compteCategorieTaxeSpecifique = false;
        if (!this.achat) {
            if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
                cpt = this.rowDefaultCptService;
                if (tva != null && !tva.isForeignEmpty("ID_COMPTE_PCE_VENTE_SERVICE")) {
                    cpt = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_VENTE_SERVICE"));
                }
            } else if (tva != null && !tva.isForeignEmpty("ID_COMPTE_PCE_VENTE")) {
                cpt = cacheForTableCompte.getRowFromId(tva.getForeignID("ID_COMPTE_PCE_VENTE"));
            }
            if (tva != null && !tva.isUndefined() && this.rowCatComptable != null && !this.rowCatComptable.isUndefined()) {
                Number foreignID;
                SQLTable tableTaxeCat = this.rowCatComptable.getTable().getTable("TAXE_CATEGORIE_COMPTABLE");
                SQLRowValues rowVals = new SQLRowValues(tableTaxeCat);
                rowVals.putNulls(tableTaxeCat.getFieldsName());
                List<SQLRowValues> fetchTaxeCat = SQLRowValuesListFetcher.create(rowVals).fetch(new Where((FieldRef)tableTaxeCat.getField("ID_CATEGORIE_COMPTABLE"), "=", this.rowCatComptable.getID()).and(new Where((FieldRef)tableTaxeCat.getField("ID_TAXE"), "=", tva.getID())));
                if (!fetchTaxeCat.isEmpty() && (foreignID = fetchTaxeCat.get(0).getNonEmptyForeignIDNumber("ID_COMPTE_PCE_VENTE")) != null) {
                    cpt = cacheForTableCompte.getRowFromId(foreignID.intValue());
                    compteCategorieTaxeSpecifique = true;
                }
            }
        }
        boolean compteSpec = false;
        if (rowAccessorLine.getTable().contains("ID_COMPTE_PCE") && rowAccessorLine.getObject("ID_COMPTE_PCE") != null && !rowAccessorLine.isForeignEmpty("ID_COMPTE_PCE")) {
            compteSpec = true;
            cpt = cacheForTableCompte.getRowFromId(rowAccessorLine.getForeignID("ID_COMPTE_PCE"));
        }
        if (article != null && !article.isUndefined()) {
            SQLRowAccessor taxeCompl;
            if (!compteSpec) {
                String suffix;
                SQLRowAccessor cptCatComptable;
                SQLRowAccessor sQLRowAccessor = cptCatComptable = compteCategorieTaxeSpecifique ? cpt : null;
                if (!compteCategorieTaxeSpecifique && this.rowCatComptable != null && !this.rowCatComptable.isUndefined()) {
                    String string = suffix = this.achat ? "_ACHAT" : "_VENTE";
                    if (!this.rowCatComptable.isForeignEmpty("ID_COMPTE_PCE" + suffix)) {
                        cptCatComptable = cacheForTableCompte.getRowFromId(this.rowCatComptable.getForeignID("ID_COMPTE_PCE" + suffix));
                    }
                    Collection<? extends SQLRowAccessor> rows = article.getReferentRows(this.compteTable.getTable("ARTICLE_CATEGORIE_COMPTABLE"));
                    for (SQLRowAccessor sQLRowAccessor2 : rows) {
                        if (sQLRowAccessor2.getForeignID("ID_CATEGORIE_COMPTABLE") != this.rowCatComptable.getID() || sQLRowAccessor2.isForeignEmpty("ID_COMPTE_PCE" + suffix)) continue;
                        cptCatComptable = cacheForTableCompte.getRowFromId(sQLRowAccessor2.getForeignID("ID_COMPTE_PCE" + suffix));
                    }
                }
                if (cptCatComptable == null) {
                    suffix = this.achat ? "_ACHAT" : "";
                    SQLRow compteArticle = cacheForTableCompte.getRowFromId(article.getForeignID("ID_COMPTE_PCE" + suffix));
                    if (compteArticle != null && !compteArticle.isUndefined()) {
                        cpt = compteArticle;
                    } else {
                        SQLBackgroundTableCacheItem sQLBackgroundTableCacheItem = SQLBackgroundTableCache.getInstance().getCacheForTable(article.getTable().getForeignTable("ID_FAMILLE_ARTICLE"));
                        SQLRow familleArticle = sQLBackgroundTableCacheItem.getRowFromId(article.getForeignID("ID_FAMILLE_ARTICLE"));
                        HashSet<SQLRow> unique = new HashSet<SQLRow>();
                        while (familleArticle != null && !familleArticle.isUndefined() && !unique.contains(familleArticle)) {
                            SQLRow compteFamilleArticle;
                            unique.add(familleArticle);
                            if (((SQLRowAccessor)familleArticle).getObject("ID_COMPTE_PCE" + suffix) != null && !familleArticle.isForeignEmpty("ID_COMPTE_PCE" + suffix) && (compteFamilleArticle = cacheForTableCompte.getRowFromId(familleArticle.getForeignID("ID_COMPTE_PCE" + suffix))) != null && !compteFamilleArticle.isUndefined()) {
                                cpt = compteFamilleArticle;
                                break;
                            }
                            familleArticle = sQLBackgroundTableCacheItem.getRowFromId(familleArticle.getForeignID("ID_FAMILLE_ARTICLE_PERE"));
                        }
                    }
                } else {
                    cpt = cptCatComptable;
                }
            }
            if (!this.achat) {
                SQLRowAccessor sQLRowAccessor = taxeCompl = article.getFields().contains("ID_TAXE_COMPLEMENTAIRE") && article.getObject("ID_TAXE_COMPLEMENTAIRE") != null && !article.isForeignEmpty("ID_TAXE_COMPLEMENTAIRE") ? article.getForeign("ID_TAXE_COMPLEMENTAIRE") : null;
                if (taxeCompl != null && !taxeCompl.isUndefined()) {
                    BigDecimal b;
                    Map<SQLRowAccessor, BigDecimal> mapCptTaxeValue = this.mapHtTaxeCompl.get(cpt);
                    if (mapCptTaxeValue == null) {
                        mapCptTaxeValue = new HashMap<SQLRowAccessor, BigDecimal>();
                        this.mapHtTaxeCompl.put(cpt, mapCptTaxeValue);
                    }
                    if ((b = mapCptTaxeValue.get(taxeCompl)) == null) {
                        b = BigDecimal.ZERO;
                    }
                    b = b.add(totalLineHT);
                    mapCptTaxeValue.put(taxeCompl, b);
                    mapCptTaxeValue = this.mapHtTaxeComplSansFacturable.get(cpt);
                    if (mapCptTaxeValue == null) {
                        mapCptTaxeValue = new HashMap<SQLRowAccessor, BigDecimal>();
                        this.mapHtTaxeComplSansFacturable.put(cpt, mapCptTaxeValue);
                    }
                    if ((b = mapCptTaxeValue.get(taxeCompl)) == null) {
                        b = BigDecimal.ZERO;
                    }
                    b = b.add(totalLineHTSansFacturable);
                    mapCptTaxeValue.put(taxeCompl, b);
                }
            }
            if (this.interfel) {
                SQLRowAccessor sQLRowAccessor = taxeCompl = article != null && article.getFields().contains("ID_TAXE_INTERFEL") && article.getObject("ID_TAXE_INTERFEL") != null && !article.isForeignEmpty("ID_TAXE_INTERFEL") ? article.getForeign("ID_TAXE_INTERFEL") : null;
                if (taxeCompl != null && !taxeCompl.isUndefined()) {
                    SQLRowValues rowValsInterfel = new SQLRowValues(rowAccessorLine.getTable());
                    SQLRowAccessor sqlRowAccessorTaxeInterfel = mapInterfel.get(taxeCompl.getID());
                    rowValsInterfel.put("T_PV_HT", rowAccessorLine.getBigDecimal("T_PV_HT").multiply(sqlRowAccessorTaxeInterfel.getBigDecimal("TAUX")).setScale(0, RoundingMode.HALF_UP).movePointLeft(2));
                    rowValsInterfel.put("QTE", 1);
                    rowValsInterfel.put("ID_TAXE", TaxeCache.getCache().getIdFromTaux(Float.valueOf(20.0f)));
                    SQLRowValues sQLRowValues = rowValsInterfel.putRowValues("ID_ARTICLE");
                    sQLRowValues.put("ID_COMPTE_PCE", sqlRowAccessorTaxeInterfel.getForeignID("ID_COMPTE_PCE_PRODUITS"));
                    sQLRowValues.put("ID_COMPTE_PCE_ACHAT", sqlRowAccessorTaxeInterfel.getForeignID("ID_COMPTE_PCE"));
                    this.addLine(rowValsInterfel, sQLRowValues, -1, false);
                }
            }
        }
        if (!compteSpec && this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
            this.totalService = this.totalService.add(totalLineHT);
            cpt = this.rowDefaultCptService;
        }
        this.totalHA = this.totalHA.add(totalHALigne);
        if (totalLineDevise != null) {
            this.totalDevise = this.totalDevise.add(totalLineDevise);
        }
        this.totalPoids += nPoids == null ? 0.0 : nPoids.doubleValue();
        this.totalEco = this.totalEco.add(totalLineEco);
        boolean selection = TotalCalculator.containsInt(this.selectedRows, lineNumber);
        if (selection) {
            this.totalHASel = this.totalHASel.add(totalHALigne);
            if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
                this.totalServiceSel = this.totalServiceSel.add(totalLineHT);
            }
            this.totalEcoSel = this.totalEcoSel.add(totalLineEco);
            if (totalLineDevise != null) {
                this.totalDeviseSel = this.totalDeviseSel.add(totalLineDevise);
            }
        }
        this.addHT(totalLineHT, totalLineHTSansFacturable, tva, cpt, selection);
    }

    public void checkResult() {
        BigDecimal input;
        BigDecimal ht = this.getTotalHT();
        BigDecimal tva = this.getTotalTVA();
        BigDecimal totalTTC2 = this.getTotalTTC();
        BigDecimal reste = totalTTC2.subtract(ht.add(tva));
        if (!this.intraComm && reste.compareTo(BigDecimal.ZERO) != 0) {
            System.err.print("Ecarts: " + reste + "(HT:" + ht);
            System.err.print(" TVA:" + tva);
            System.err.println(" TTC:" + totalTTC2);
            if (!this.imputEcart) {
                for (SQLRowAccessor rHT : this.mapHt.keySet()) {
                    input = this.mapHt.get(rHT);
                    if (input == null || input.signum() == 0) continue;
                    this.mapHt.put(rHT, input.add(reste));
                    break;
                }
                for (SQLRowAccessor rHT : this.mapHtSansFacturable.keySet()) {
                    input = this.mapHtSansFacturable.get(rHT);
                    if (input == null || input.signum() == 0) continue;
                    this.mapHtSansFacturable.put(rHT, input.add(reste));
                    break;
                }
            } else {
                SQLRow row = ComptePCESQLElement.getRow(this.achat ? "658" : "758", "Ecarts arrondis");
                this.mapHt.put(row, reste);
                this.mapHtSansFacturable.put(row, reste);
            }
        }
        ht = this.getTotalHTSel();
        tva = this.getTotalTVASel();
        totalTTC2 = this.getTotalTTCSel();
        reste = totalTTC2.subtract(ht.add(tva));
        if (!this.intraComm && reste.compareTo(BigDecimal.ZERO) != 0) {
            for (SQLRowAccessor rHT : this.mapHtSel.keySet()) {
                input = this.mapHtSel.get(rHT);
                if (input == null || input.signum() == 0) continue;
                this.mapHtSel.put(rHT, input.add(reste));
                break;
            }
        }
    }

    public BigDecimal getTotalDevise() {
        return this.totalDevise;
    }

    public BigDecimal getTotalDeviseSel() {
        return this.totalDeviseSel;
    }

    public BigDecimal getTotalHA() {
        return this.totalHA;
    }

    public BigDecimal getTotalHASel() {
        return this.totalHASel;
    }

    public double getTotalPoids() {
        return this.totalPoids;
    }

    public BigDecimal getTotalService() {
        return this.totalService;
    }

    public BigDecimal getTotalServiceSel() {
        return this.totalServiceSel;
    }

    public Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> getMapHtTaxeCompl() {
        return this.mapHtTaxeCompl;
    }

    public Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> getMapHtTaxeComplSansFacturable() {
        return this.mapHtTaxeComplSansFacturable;
    }

    public BigDecimal getTotalHT() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHt.keySet()) {
            ht = ht.add(this.mapHt.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVA() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVA.keySet()) {
            tva = tva.add(this.mapHtTVA.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalEco() {
        return this.totalEco.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalEcoSel() {
        return this.totalEcoSel.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalHTSansFActurable() {
        return this.totalHTSansFActurable;
    }

    public BigDecimal getTotalTTC() {
        return this.totalTTC.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalHTSel() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtSel.keySet()) {
            ht = ht.add(this.mapHtSel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVASel() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVASel.keySet()) {
            tva = tva.add(this.mapHtTVASel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalTTCSel() {
        return this.totalTTCSel.setScale(2, RoundingMode.HALF_UP);
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHt() {
        return this.mapHt;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtSansFacturable() {
        return this.mapHtSansFacturable;
    }

    public Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> getMapHtTVARowTaux() {
        return this.mapHtTVARowTaux;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtTVA() {
        return this.mapHtTVA;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtTVAIntra() {
        return this.mapHtTVAIntra;
    }
}

