/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIFileUpload
extends LightUserControl {
    private static final String SEND_FILE_URL_JSON_KEY = "send-file-url";
    private String sendFileUrl;

    public LightUIFileUpload() {
    }

    public LightUIFileUpload(LightUIFileUpload file) {
        super(file);
    }

    public LightUIFileUpload(String id, String sendFileUrl) {
        super(id);
        this.setType(28);
        this.sendFileUrl = sendFileUrl;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIFileUpload)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUIFileUpload files = (LightUIFileUpload)element;
        this.sendFileUrl = files.sendFileUrl;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.sendFileUrl = JSONConverter.getParameterFromJSON(json, SEND_FILE_URL_JSON_KEY, String.class);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(SEND_FILE_URL_JSON_KEY, this.sendFileUrl);
        return json;
    }

    @Override
    public void _setValueFromContext(Object value) {
        this.setValue((String)value);
    }

    @Override
    public Object getValueForContext() {
        return this.getValue();
    }
}

