/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.ui.textmenu.TextFieldMenuItem;
import org.openconcerto.sql.ui.textmenu.TextFieldWithMenuItemsFetcher;

public class TextFieldWithMenuItemsTableFetcher
implements TextFieldWithMenuItemsFetcher {
    private final SQLField field;

    public TextFieldWithMenuItemsTableFetcher(SQLField field) {
        this.field = field;
    }

    @Override
    public List<TextFieldMenuItem> getItems(List<String> selectedItems, SQLRowAccessor selectedRow) {
        SQLTable table = this.field.getTable();
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.put(table.getKey().getName(), null);
        rowVals.put(this.field.getName(), null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> rowValsItems = fetcher.fetch();
        ArrayList<TextFieldMenuItem> items = new ArrayList<TextFieldMenuItem>(rowValsItems.size());
        for (SQLRowValues sqlRowValues : rowValsItems) {
            String menuName = sqlRowValues.getString(this.field.getName()).trim();
            TextFieldMenuItem item = new TextFieldMenuItem(menuName, true, selectedItems.contains(menuName));
            items.add(item);
        }
        Collections.sort(items);
        return items;
    }

    @Override
    public String getItemName() {
        return Configuration.getInstance().getTranslator().getLabelFor(this.field);
    }
}

