/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.ArchivedGraph;
import org.openconcerto.sql.element.JoinSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinks;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.SQLElementRowR;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.element.UpdateScript;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.ui.light.CustomRowEditor;
import org.openconcerto.sql.ui.light.GroupToLightUIConvertor;
import org.openconcerto.sql.ui.light.LightEditFrame;
import org.openconcerto.sql.ui.light.LightUIPanelFiller;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOffline;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.light.ComboValueConvertor;
import org.openconcerto.ui.light.IntValueConvertor;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.StringValueConvertor;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.LinkedListMap;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecorder;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;

public abstract class SQLElement {
    public static final String DEFAULT_COMP_ID = "default component code";
    public static final String DEFERRED_CODE = new String("deferred code");
    @GuardedBy(value="this")
    private SQLElementDirectory directory;
    private Phrase defaultName;
    private final SQLTable primaryTable;
    private String code;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private SQLTableModelSourceOnline tableSrc;
    @Deprecated
    private final ListChangeRecorder<IListeAction> rowActions;
    private final ListChangeRecorder<SQLRowValuesAction> rowValuesActions;
    private final LinkedListMap<String, ITransformer<Tuple2<SQLElement, String>, SQLComponent>> components;
    private SQLElementLinks ownedLinks;
    private SQLElementLinks otherLinks;
    private String parentFF;
    @GuardedBy(value="this")
    private SQLCache<SQLRow, Object> modelCache;
    private final Map<String, Supplier<? extends JComponent>> additionalFields;
    private final List<SQLTableModelColumn> additionalListCols;
    @GuardedBy(value="this")
    private List<String> mdPath;
    private Group defaultGroup;
    private Group groupForCreation;
    private Group groupForModification;
    private static final SQLTable.VirtualFields JOIN_SAFE_FIELDS = SQLTable.VirtualFields.ALL.difference(SQLTable.VirtualFields.PRIMARY_KEY, SQLTable.VirtualFields.ORDER);
    private static final SQLTable.VirtualFields SAFE_FIELDS = JOIN_SAFE_FIELDS.difference(SQLTable.VirtualFields.FOREIGN_KEYS);
    private static final Tuple2<Boolean, SQLRowValuesCluster.DiffResult> TRUE_NULL = new Tuple2<Boolean, Object>(true, null);
    private static final Tuple2<Boolean, SQLRowValuesCluster.DiffResult> FALSE_NULL = new Tuple2<Boolean, Object>(false, null);

    private static Phrase createPhrase(String singular, String plural) {
        String base;
        NounClass nounClass;
        if (singular.startsWith("une ")) {
            nounClass = NounClass.FEMININE;
            base = singular.substring(4);
        } else if (singular.startsWith("un ")) {
            nounClass = NounClass.MASCULINE;
            base = singular.substring(3);
        } else {
            nounClass = null;
            base = singular;
        }
        Phrase res = new Phrase(Grammar_fr.getInstance(), base, nounClass);
        if (nounClass != null) {
            res.putVariantIfDifferent(Grammar.INDEFINITE_ARTICLE_SINGULAR, singular);
        }
        res.putVariantIfDifferent(Grammar.PLURAL, plural);
        return res;
    }

    @Deprecated
    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this(primaryTable, SQLElement.createPhrase(singular, plural));
    }

    public SQLElement(SQLTable primaryTable) {
        this(primaryTable, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name) {
        this(primaryTable, name, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name, String code) {
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this.getClass());
        }
        this.primaryTable = primaryTable;
        this.setDefaultName(name);
        this.code = code == null ? this.createCode() : code;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(Collections.synchronizedList(new ArrayList()));
        this.rowActions.getRecipe().addListener(new IClosure<ListChangeIndex<IListeAction>>(){
            private final Map<IListeAction, SQLRowValuesAction> map = new IdentityHashMap<IListeAction, SQLRowValuesAction>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeChecked(ListChangeIndex<IListeAction> listChange) {
                ArrayList<SQLRowValuesAction> oldActions = new ArrayList<SQLRowValuesAction>();
                for (IListeAction action : listChange.getItemsRemoved()) {
                    1 var5_5 = this;
                    synchronized (var5_5) {
                        SQLRowValuesAction ra = this.map.remove(action);
                        if (ra != null) {
                            oldActions.add(ra);
                        }
                    }
                }
                SQLElement.this.getRowValuesActions().removeAll(oldActions);
                ArrayList<IListe.ConvertedAction> newActions = new ArrayList<IListe.ConvertedAction>();
                for (IListeAction action : listChange.getItemsAdded()) {
                    if (!(action instanceof RowAction)) continue;
                    1 var6_6 = this;
                    synchronized (var6_6) {
                        if (!this.map.containsKey(action)) {
                            IListe.ConvertedAction converted = new IListe.ConvertedAction((RowAction)action);
                            this.map.put(action, converted);
                            newActions.add(converted);
                        }
                    }
                }
                SQLElement.this.getRowValuesActions().addAll(newActions);
            }
        });
        this.rowValuesActions = new ListChangeRecorder(Collections.synchronizedList(new ArrayList()));
        this.resetRelationships();
        this.components = new LinkedListMap();
        this.modelCache = null;
        this.additionalFields = new LinkedHashMap<String, Supplier<? extends JComponent>>();
        this.additionalListCols = new ArrayList<SQLTableModelColumn>();
        this.mdPath = Collections.emptyList();
    }

    public void destroy() {
    }

    protected String createCode() {
        return String.valueOf(this.getClass().getName()) + "-" + this.getTable().getName();
    }

    public Group getGroupForCreation() {
        if (this.groupForCreation != null) {
            return this.groupForCreation;
        }
        return this.getDefaultGroup();
    }

    public Group getGroupForModification() {
        if (this.groupForModification != null) {
            return this.groupForModification;
        }
        return this.getDefaultGroup();
    }

    public Group getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(Group defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public Group getEditGroup(EditPanel.EditMode editMode) {
        if (editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            return this.getGroupForCreation();
        }
        return this.getGroupForModification();
    }

    public SQLRowValues createDefaultRowValues(String token) {
        return new SQLRowValues(this.getTable());
    }

    public LightEditFrame createEditFrame(PropsConfiguration configuration, LightUIFrame parentFrame, EditPanel.EditMode editMode, SQLRowAccessor sqlRow, String sessionSecurityToken) {
        Group editGroup = this.getEditGroup(editMode);
        if (editGroup == null) {
            Log.get().severe("The edit group is null for this element : " + this);
            return null;
        }
        GroupToLightUIConvertor convertor = this.getGroupToLightUIConvertor(configuration, editMode, sqlRow, sessionSecurityToken);
        LightEditFrame editFrame = convertor.convert(editGroup, sqlRow, parentFrame, editMode);
        if (editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            editFrame.createTitlePanel(this.getCreationFrameTitle());
        } else if (editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
            editFrame.createTitlePanel(this.getModificationFrameTitle(sqlRow));
            new LightUIPanelFiller(editFrame.getContentPanel()).fillFromRow(configuration, this, sqlRow, sessionSecurityToken);
        } else if (editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            editFrame.createTitlePanel(this.getReadOnlyFrameTitle(sqlRow));
            new LightUIPanelFiller(editFrame.getContentPanel()).fillFromRow(configuration, this, sqlRow, sessionSecurityToken);
        }
        this.setEditFrameModifiers(editFrame, sessionSecurityToken);
        return editFrame;
    }

    protected String getReadOnlyFrameTitle(SQLRowAccessor sqlRow) {
        return EditFrame.getReadOnlyMessage(this);
    }

    protected String getModificationFrameTitle(SQLRowAccessor sqlRow) {
        return EditFrame.getModifyMessage(this);
    }

    protected String getCreationFrameTitle() {
        return EditFrame.getCreateMessage(this);
    }

    public GroupToLightUIConvertor getGroupToLightUIConvertor(PropsConfiguration configuration, EditPanel.EditMode editMode, SQLRowAccessor sqlRow, String token) {
        GroupToLightUIConvertor convertor = new GroupToLightUIConvertor(configuration);
        convertor.putAllCustomEditorProvider(this.getCustomRowEditors(configuration, token));
        return convertor;
    }

    public Map<String, ComboValueConvertor<?>> getComboConvertors() {
        return new HashMap();
    }

    public void setEditFrameModifiers(LightEditFrame frame, String sessionToken) {
    }

    public List<CustomRowEditor> getCustomRowEditors(final Configuration configuration, String sessionToken) {
        Map<String, ComboValueConvertor<?>> comboConvertors = this.getComboConvertors();
        ArrayList<CustomRowEditor> result = new ArrayList<CustomRowEditor>();
        for (Map.Entry<String, ComboValueConvertor<?>> entry : comboConvertors.entrySet()) {
            String itemId = entry.getKey();
            result.add(new CustomRowEditor(itemId, entry){
                final ComboValueConvertor<?> convertor;
                {
                    super($anonymous0);
                    this.convertor = (ComboValueConvertor)entry.getValue();
                }

                @Override
                public LightUIElement createUIElement() {
                    LightUIComboBox uiCombo = new LightUIComboBox(this.getItemId());
                    this.convertor.fillCombo(uiCombo, null);
                    return uiCombo;
                }

                @Override
                public void fillFrom(LightUIElement uiElement, SQLRowAccessor sqlRow) {
                    LightUIComboBox uiCombo = (LightUIComboBox)uiElement;
                    SQLField field = configuration.getFieldMapper().getSQLFieldForItem(this.getItemId());
                    if (this.convertor instanceof StringValueConvertor) {
                        ((StringValueConvertor)this.convertor).fillCombo(uiCombo, sqlRow.getString(field.getFieldName()));
                    } else if (this.convertor instanceof IntValueConvertor && sqlRow.getObject(field.getFieldName()) != null) {
                        ((IntValueConvertor)this.convertor).fillCombo(uiCombo, sqlRow.getInt(field.getFieldName()));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void store(LightUIElement uiElement, SQLRowValues sqlRow) {
                    LightUIComboBox combobox = (LightUIComboBox)uiElement;
                    String fieldName = configuration.getFieldMapper().getSQLFieldForItem(this.getItemId()).getName();
                    if (combobox.hasSelectedValue()) {
                        if (this.convertor instanceof StringValueConvertor) {
                            sqlRow.put(fieldName, ((StringValueConvertor)this.convertor).getIdFromIndex(combobox.getSelectedValue().getId()));
                            return;
                        } else {
                            if (!(this.convertor instanceof IntValueConvertor)) throw new IllegalArgumentException("the save is not implemented for the class: " + this.convertor.getClass().getName() + " - ui id: " + this.getItemId());
                            sqlRow.put(fieldName, combobox.getSelectedValue().getId());
                        }
                        return;
                    } else {
                        sqlRow.put(fieldName, null);
                    }
                }
            });
        }
        return result;
    }

    public void doAfterLightInsert(LightEditFrame editFrame, SQLRow sqlRow, String sessionToken) throws Exception {
    }

    public void doAfterLightDelete(LightUIFrame frame, SQLRowValues sqlRow, String sessionToken) throws Exception {
    }

    public void doBeforeLightDelete(LightUIFrame frame, SQLRowValues sqlRow, String sessionToken) throws Exception {
    }

    public void doBeforeLightInsert(LightEditFrame editFrame, SQLRowValues sqlRow, String sessionToken) throws Exception {
    }

    public SQLRowValues getValuesOfShowAs(Number id) {
        SQLRowValues tmp = new SQLRowValues(this.getTable());
        ListMap<String, String> showAs = this.getShowAs();
        for (List listStr : showAs.values()) {
            tmp.putNulls(listStr);
        }
        this.getDirectory().getShowAs().expand(tmp);
        SQLRowValues fetched = SQLRowValuesListFetcher.create(tmp).fetchOne(id);
        if (fetched == null) {
            throw new IllegalArgumentException("Impossible to find Row in database - table: " + this.getTable().getName() + ", id: " + id);
        }
        return fetched;
    }

    public synchronized void resetRelationships() {
        if (this.areRelationshipsInited()) {
            for (SQLElementLink l : this.ownedLinks.getByPath().values()) {
                l.getOwned().resetRelationshipsOf(this);
            }
        }
        this.ownedLinks = this instanceof JoinSQLElement ? new SQLElementLinks(SetMap.empty()) : null;
        this.otherLinks = this instanceof JoinSQLElement ? new SQLElementLinks(SetMap.empty()) : null;
        this.parentFF = null;
    }

    private synchronized void resetRelationshipsOf(SQLElement changed) {
        this.otherLinks = null;
    }

    protected final synchronized boolean areRelationshipsInited() {
        return this.ownedLinks != null;
    }

    private final Set<Path> createPaths(boolean wantedOwned) {
        if (this instanceof JoinSQLElement) {
            return Collections.emptySet();
        }
        SQLTable thisTable = this.getTable();
        Set<Link> allLinks = thisTable.getDBSystemRoot().getGraph().getAllLinks(this.getTable());
        HashSet<Path> res = new HashSet<Path>();
        for (Link l : allLinks) {
            boolean owned;
            Path pathFromOwner;
            SQLElement sourceElem = this.getElementLenient((SQLTable)l.getSource());
            if (sourceElem instanceof JoinSQLElement) {
                JoinSQLElement joinElem = (JoinSQLElement)sourceElem;
                pathFromOwner = joinElem.getPathFromOwner();
                owned = joinElem.getLinkToOwner().equals(l);
            } else if (l.getSource() == l.getTarget()) {
                owned = wantedOwned;
                pathFromOwner = ((PathBuilder)new PathBuilder((SQLTable)l.getSource()).add(l, Link.Direction.FOREIGN)).build();
            } else {
                owned = l.getSource() == thisTable;
                pathFromOwner = ((PathBuilder)new PathBuilder((SQLTable)l.getSource()).add(l)).build();
            }
            if (owned != wantedOwned) continue;
            res.add(pathFromOwner);
        }
        return res;
    }

    final SetMap<SQLElementLink.LinkType, Path> getDefaultLinkTypes() {
        List<String> privateFields;
        Set<Path> ownedPaths = this.createPaths(true);
        SetMap<SQLElementLink.LinkType, Path> res = new SetMap<SQLElementLink.LinkType, Path>();
        String parentFFName = this.getParentFFName();
        if (parentFFName != null) {
            Path pathToParent = ((PathBuilder)new PathBuilder(this.getTable()).addForeignField(parentFFName)).build();
            if (!ownedPaths.remove(pathToParent)) {
                throw new IllegalStateException("getParentFFName() " + pathToParent + " isn't in " + ownedPaths);
            }
            res.add(SQLElementLink.LinkType.PARENT, pathToParent);
        }
        if (!(privateFields = this.getPrivateFields()).isEmpty()) {
            Log.get().warning("getPrivateFields() is deprecated use setupLinks(), " + this + " : " + privateFields);
        }
        Iterator<Path> iter = ownedPaths.iterator();
        while (iter.hasNext()) {
            Path ownedPath = iter.next();
            if (this.getElement(ownedPath.getLast()).isPrivate()) {
                iter.remove();
                res.add(SQLElementLink.LinkType.COMPOSITION, ownedPath);
                continue;
            }
            if (ownedPath.length() != 1 || !ownedPath.isSingleField() || !privateFields.contains(ownedPath.getSingleField(0).getName())) continue;
            throw new IllegalStateException("getPrivateFields() contains " + ownedPath + " which points to an element which isn't private");
        }
        res.addAll(SQLElementLink.LinkType.ASSOCIATION, (Collection<Path>)ownedPaths);
        return res;
    }

    final List<ReferenceAction> getPossibleActions(SQLElementLink.LinkType lt, SQLElement targetElem) {
        List<ReferenceAction> res;
        if (lt == SQLElementLink.LinkType.PARENT) {
            res = Arrays.asList(ReferenceAction.CASCADE, ReferenceAction.RESTRICT);
        } else if (lt == SQLElementLink.LinkType.COMPOSITION) {
            res = Arrays.asList(ReferenceAction.SET_EMPTY, ReferenceAction.RESTRICT);
        } else {
            assert (lt == SQLElementLink.LinkType.ASSOCIATION);
            res = targetElem.isShared() ? Arrays.asList(ReferenceAction.RESTRICT, ReferenceAction.SET_EMPTY) : Arrays.asList(ReferenceAction.values());
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void initFF() {
        if (this.areRelationshipsInited()) {
            return;
        }
        SQLElementLinksSetup paths = new SQLElementLinksSetup(this);
        this.setupLinks(paths);
        this.ownedLinks = new SQLElementLinks(paths.getResult());
        SQLElementLink parentLink = this.getParentLink();
        if (parentLink != null) {
            if (parentLink.getSingleField() == null) throw new UnsupportedOperationException("Parent field name not supported : " + parentLink);
            this.parentFF = parentLink.getSingleField().getName();
        } else {
            this.parentFF = null;
        }
        assert (this.assertPrivateDefaultValues());
        HashSet<SQLElement> toReset = new HashSet<SQLElement>();
        for (SQLElementLink l : this.ownedLinks.getByPath().values()) {
            toReset.add(l.getOwned());
        }
        for (SQLElement e : toReset) {
            e.resetRelationshipsOf(this);
        }
        this.ffInited();
    }

    private final boolean assertPrivateDefaultValues() {
        Set<SQLElementLink> privates = this.getOwnedLinks().getByType(SQLElementLink.LinkType.COMPOSITION);
        for (SQLElementLink e : privates) {
            if (e.isJoin()) continue;
            SQLField singleField = e.getSingleField();
            Number privateDefault = (Number)singleField.getParsedDefaultValue().getValue();
            Number foreignUndef = e.getPath().getLast().getUndefinedIDNumber();
            assert (NumberUtils.areNumericallyEqual(privateDefault, foreignUndef)) : singleField + " not empty : " + privateDefault;
        }
        return true;
    }

    public boolean isPrivate() {
        return false;
    }

    protected void setupLinks(SQLElementLinksSetup links) {
    }

    protected void ffInited() {
    }

    private final Set<SQLField> getSingleFields(SQLElementLinks links, SQLElementLink.LinkType type) {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLElementLink l : links.getByType(type)) {
            SQLField singleField = l.getSingleField();
            if (singleField == null) {
                throw new IllegalStateException("Not single field : " + l);
            }
            res.add(singleField);
        }
        return res;
    }

    private synchronized void initRF() {
        if (this.otherLinks != null) {
            return;
        }
        Set<Path> otherPaths = this.createPaths(false);
        if (otherPaths.isEmpty()) {
            this.otherLinks = SQLElementLinks.empty();
        } else {
            SetMap<SQLElementLink.LinkType, SQLElementLink> tmp = new SetMap<SQLElementLink.LinkType, SQLElementLink>();
            for (Path p : otherPaths) {
                SQLElementLink elementLink;
                SQLElement refElem = this.getElementLenient(p.getFirst());
                if (refElem == null) {
                    elementLink = new SQLElementLink(null, p, this, SQLElementLink.LinkType.ASSOCIATION, null, ReferenceAction.RESTRICT);
                } else {
                    elementLink = refElem.getOwnedLinks().getByPath(p);
                    assert (elementLink.getOwned() == this);
                }
                tmp.add(elementLink.getLinkType(), elementLink);
            }
            this.otherLinks = new SQLElementLinks(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDirectory(SQLElementDirectory directory) {
        assert (directory == null || directory.getElement(this.getTable()) == this);
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            if (this.directory != directory) {
                if (this.areRelationshipsInited()) {
                    this.resetRelationships();
                }
                this.directory = directory;
            }
        }
    }

    public final synchronized SQLElementDirectory getDirectory() {
        return this.directory;
    }

    final SQLElement getElement(SQLTable table) {
        SQLElement res = this.getElementLenient(table);
        if (res == null) {
            throw new IllegalStateException("no element for " + table.getSQLName());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLElement getElementLenient(SQLTable table) {
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            return this.getDirectory().getElement(table);
        }
    }

    public final SQLElement getForeignElement(String foreignField) {
        try {
            return this.getElement(this.getForeignTable(foreignField));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("no element for " + foreignField + " in " + this, e);
        }
    }

    private final SQLTable getForeignTable(String foreignField) {
        return this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(foreignField));
    }

    public final synchronized void setDefaultName(Phrase name) {
        this.defaultName = name != null ? name : Phrase.getInvariant(this.getTable().getName());
    }

    public final synchronized Phrase getDefaultName() {
        return this.defaultName;
    }

    public final Phrase getName() {
        SQLElementDirectory dir = this.getDirectory();
        SQLFieldTranslator trns = dir == null ? null : dir.getTranslator();
        Phrase res = trns == null ? null : trns.getElementName(this);
        return res == null ? this.getDefaultName() : res;
    }

    public String getPluralName() {
        return this.getName().getVariant(Grammar.PLURAL);
    }

    public String getSingularName() {
        return this.getName().getVariant(Grammar.INDEFINITE_ARTICLE_SINGULAR);
    }

    public ListMap<String, String> getShowAs() {
        return null;
    }

    public Set<String> getReadOnlyFields() {
        return Collections.emptySet();
    }

    public Set<String> getInsertOnlyFields() {
        return Collections.emptySet();
    }

    private final synchronized SQLCache<SQLRow, Object> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = new SQLCache(60, -1, "modelObjects of " + this.getCode());
        }
        return this.modelCache;
    }

    public final UpdateScript update(SQLRowValues from, SQLRowValues to) {
        return this.update(from, to, false);
    }

    public final UpdateScript update(SQLRowValues from, SQLRowValues to, boolean allowedToChangeTo) {
        return this.update(from, to, allowedToChangeTo, Transformer.nopTransformer());
    }

    private final UpdateScript update(SQLRowValues from, SQLRowValues to, boolean allowedToChangeTo, ITransformer<SQLRowValues, SQLRowValues> copy2originalRows) {
        this.check(from);
        this.check(to);
        for (SQLRowValues v : from.getGraph().getItems()) {
            if (v.hasID()) continue;
            throw new IllegalArgumentException("missing id in " + v + " : " + from.printGraph());
        }
        if (!to.hasID()) {
            if (!allowedToChangeTo) {
                Map<SQLRowValues, SQLRowValues> copied = to.getGraph().deepCopy(false);
                to = copied.get(to);
                allowedToChangeTo = true;
                copy2originalRows = Transformer.fromMap(CollectionUtils.invertMap(new IdentityHashMap(), copied));
            }
            to.fillWith(SQLRowValues.SQL_DEFAULT, false);
            to.setPrimaryKey(from);
        }
        if (from.getID() != to.getID()) {
            throw new IllegalArgumentException("not the same row: " + from + " != " + to);
        }
        UpdateScript res = new UpdateScript(this, from, copy2originalRows.transformChecked(to));
        for (SQLTable.FieldGroup group : to.getFieldGroups()) {
            if (group.getKeyType() != SQLKey.Type.FOREIGN_KEY) {
                res.getUpdateRow().putAll(to.getAbsolutelyAll(), group.getFields());
                continue;
            }
            SQLKey k = group.getKey();
            if (k.getFields().size() > 1) {
                throw new IllegalStateException("Multi-field not supported : " + k);
            }
            String field = group.getSingleField();
            assert (field != null);
            Path p = ((PathBuilder)new PathBuilder(this.getTable()).add(k.getForeignLink(), Link.Direction.FOREIGN)).build();
            SQLElementLink elemLink = this.getOwnedLinks().getByPath(p);
            if (elemLink.getLinkType() == SQLElementLink.LinkType.COMPOSITION) {
                boolean toIsEmpty;
                SQLElement privateElem = elemLink.getOwned();
                Object fromPrivate = from.getObject(field);
                Object toPrivate = to.getObject(field);
                assert (!from.isDefault(field)) : "A row in the DB cannot have DEFAULT";
                boolean fromIsEmpty = from.isForeignEmpty(field);
                boolean bl = toIsEmpty = to.isDefault(field) || to.isForeignEmpty(field);
                if (fromIsEmpty && toIsEmpty) continue;
                if (fromIsEmpty) {
                    SQLRowValues toPR = (SQLRowValues)toPrivate;
                    assert (CollectionUtils.getSole(toPR.getReferentRows(elemLink.getSingleField())) == to) : "Shared private " + toPR.printGraph();
                    SQLRowValues copy = toPR.deepCopy().removeReferents(elemLink.getSingleField());
                    res.getUpdateRow().put(field, (Object)copy);
                    res.mapRow(copy2originalRows.transformChecked(toPR), copy);
                    continue;
                }
                if (toIsEmpty) {
                    res.getUpdateRow().putEmptyLink(field);
                    res.addToArchive(privateElem, from.getForeign(field));
                    continue;
                }
                Number fromForeignID = from.getForeignIDNumber(field);
                if (fromForeignID == null) {
                    throw new IllegalArgumentException("Non-empty private in old row, but null ID for " + elemLink);
                }
                if (toPrivate == null) {
                    throw new IllegalArgumentException("Non-empty private in new row, but null value for " + elemLink);
                }
                assert (toPrivate instanceof Number || toPrivate instanceof SQLRowValues);
                Number toForeignID = to.getForeignIDNumber(field);
                if (toForeignID != null && !NumberUtils.areNumericallyEqual(fromForeignID, toForeignID)) {
                    throw new IllegalArgumentException("private have changed for " + field + " : " + fromPrivate + " != " + toPrivate);
                }
                if (toPrivate instanceof SQLRowValues) {
                    if (!(fromPrivate instanceof SQLRowValues)) {
                        throw new IllegalArgumentException("Asymetric graph, old row doesn't contain a row for " + elemLink + " : " + fromPrivate);
                    }
                    SQLRowValues fromPR = (SQLRowValues)fromPrivate;
                    SQLRowValues toPR = (SQLRowValues)toPrivate;
                    res.put(field, privateElem.update(fromPR, toPR, allowedToChangeTo, copy2originalRows));
                    continue;
                }
                assert (toPrivate instanceof Number && toForeignID != null);
                continue;
            }
            if (to.isDefault(field)) {
                res.getUpdateRow().putDefault(field);
                continue;
            }
            res.getUpdateRow().put(field, to.getForeignIDNumber(field));
        }
        for (SQLElementLink elemLink : this.getOwnedLinks().getByPath().values()) {
            if (!elemLink.isJoin()) continue;
            Path pathToFK = elemLink.getPath().minusLast();
            Set<String> joinTableLocalContentFields = pathToFK.getLast().getFieldsNames(SQLTable.VirtualFields.LOCAL_CONTENT);
            if (elemLink.getLinkType() == SQLElementLink.LinkType.COMPOSITION) {
                BigDecimal toOrder;
                Tuple2<List<SQLRowValues>, Map<Number, SQLRowValues>> fromPrivatesTuple = SQLElement.indexRows(from.followPath(elemLink.getPath(), SQLRowValues.CreateMode.CREATE_NONE, false));
                assert (fromPrivatesTuple.get0().isEmpty()) : "Existing rows without ID : " + fromPrivatesTuple.get0();
                Map<Number, SQLRowValues> fromPrivates = fromPrivatesTuple.get1();
                BigDecimal minOrder = null;
                BigDecimal maxOrder = null;
                for (SQLRowValues fromJoin : from.followPath(pathToFK, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                    BigDecimal order = fromJoin.getOrder();
                    assert (order != null);
                    if (minOrder == null || minOrder.compareTo(order) > 0) {
                        minOrder = order;
                    }
                    if (maxOrder != null && maxOrder.compareTo(order) >= 0) continue;
                    maxOrder = order;
                }
                Collection<SQLRowValues> toValues = to.followPath(elemLink.getPath(), SQLRowValues.CreateMode.CREATE_NONE, false);
                Tuple2<List<SQLRowValues>, Map<Number, SQLRowValues>> toPrivatesTuple = SQLElement.indexRows(toValues);
                Map<Number, SQLRowValues> toPrivates = toPrivatesTuple.get1();
                if (minOrder == null || BigDecimal.valueOf(toValues.size()).compareTo(minOrder) < 0) {
                    toOrder = BigDecimal.ONE;
                } else {
                    assert (maxOrder != null) : "Minimum order isn't null but maximum order is";
                    toOrder = maxOrder.add(BigDecimal.ONE);
                }
                IdentityHashMap<SQLRowValues, BigDecimal> toPrivatesOrder = new IdentityHashMap<SQLRowValues, BigDecimal>();
                for (SQLRowValues toVals : toValues) {
                    toPrivatesOrder.put(toVals, toOrder);
                    toOrder = toOrder.add(BigDecimal.ONE);
                }
                ArrayList<Number> onlyInFrom = new ArrayList<Number>(fromPrivates.keySet());
                onlyInFrom.removeAll(toPrivates.keySet());
                HashSet<Number> onlyInTo = new HashSet<Number>(toPrivates.keySet());
                onlyInTo.removeAll(fromPrivates.keySet());
                HashSet<Number> inFromAndTo = new HashSet<Number>(toPrivates.keySet());
                inFromAndTo.retainAll(fromPrivates.keySet());
                if (!onlyInTo.isEmpty()) {
                    throw new IllegalStateException("Unknown IDs : " + onlyInTo + " for " + elemLink + " from IDs : " + fromPrivates);
                }
                ArrayList<SQLRowValues> matchedPrivates = new ArrayList<SQLRowValues>();
                for (Number inBoth : inFromAndTo) {
                    matchedPrivates.add(fromPrivates.get(inBoth));
                    matchedPrivates.add(toPrivates.get(inBoth));
                }
                SQLElement privateElem = elemLink.getOwned();
                boolean hasReferences = !privateElem.getLinksOwnedByOthers().getByType(SQLElementLink.LinkType.ASSOCIATION).isEmpty();
                SQLField toMainField = elemLink.getPath().getStep(0).getSingleField();
                SQLField toPrivateField = elemLink.getPath().getStep(-1).getSingleField();
                for (SQLRowValues privateSansID : toPrivatesTuple.get0()) {
                    if (!hasReferences && !onlyInFrom.isEmpty()) {
                        matchedPrivates.add(fromPrivates.get(onlyInFrom.remove(0)));
                        matchedPrivates.add(privateSansID);
                        continue;
                    }
                    SQLRowValues copy = privateSansID.deepCopy().removeReferents(toPrivateField);
                    res.getUpdateRow().put(elemLink.getPath(), true, copy);
                    SQLRowValues toJoinRow = (SQLRowValues)CollectionUtils.getSole(privateSansID.getReferentRows(toPrivateField));
                    SQLRowValues joinRow = (SQLRowValues)CollectionUtils.getSole(copy.getReferentRows(toPrivateField));
                    SQLElement.setContentFields(joinTableLocalContentFields, joinRow, toJoinRow);
                    SQLElement.setOrder(joinRow, (BigDecimal)toPrivatesOrder.get(privateSansID));
                    res.mapRow(copy2originalRows.transformChecked(privateSansID), copy);
                }
                Iterator iter = matchedPrivates.iterator();
                while (iter.hasNext()) {
                    SQLRowValues fromPrivate = (SQLRowValues)iter.next();
                    SQLRowValues toPrivate = (SQLRowValues)iter.next();
                    SQLRowValues fromJoin = (SQLRowValues)CollectionUtils.getSole(fromPrivate.getReferentRows(toPrivateField));
                    if (fromJoin == null) {
                        throw new IllegalStateException("Shared private " + fromPrivate.printGraph());
                    }
                    SQLRowValues toJoin = (SQLRowValues)CollectionUtils.getSole(toPrivate.getReferentRows(toPrivateField));
                    UpdateScript updateScript = privateElem.update(fromPrivate, toPrivate, allowedToChangeTo, copy2originalRows);
                    SQLRowValues joinCopy = new SQLRowValues(fromJoin.getTable());
                    joinCopy.setID(fromJoin.getIDNumber());
                    assert (joinCopy.getGraphSize() == 1);
                    SQLElement.setContentFields(joinTableLocalContentFields, joinCopy, toJoin);
                    SQLElement.setOrder(joinCopy, (BigDecimal)toPrivatesOrder.get(toPrivate));
                    joinCopy.put(toMainField.getName(), (Object)res.getUpdateRow());
                    joinCopy.put(toPrivateField.getName(), (Object)updateScript.getUpdateRow());
                    res.add(updateScript);
                }
                for (Number id : onlyInFrom) {
                    res.addToArchive(privateElem, fromPrivates.get(id));
                }
                continue;
            }
            Step fkStep = elemLink.getPath().getStep(-1);
            String fkField = fkStep.getSingleField().getName();
            ArrayList<SQLRowValues> fromFKs = new ArrayList<SQLRowValues>(from.followPath(pathToFK, SQLRowValues.CreateMode.CREATE_NONE, false));
            ArrayList<SQLRowValues> toFKs = new ArrayList<SQLRowValues>(to.followPath(pathToFK, SQLRowValues.CreateMode.CREATE_NONE, false));
            for (SQLRowValues rowWithFK : toFKs) {
                SQLRowValues toUse;
                int ownedID = rowWithFK.getForeignID(fkField);
                if (fromFKs.isEmpty()) {
                    toUse = res.getUpdateRow().putRowValues(pathToFK, true);
                } else {
                    SQLRowValues fromJoin = (SQLRowValues)fromFKs.remove(0);
                    if (ownedID == fromJoin.getForeignID(fkField) && joinTableLocalContentFields.isEmpty()) {
                        toUse = null;
                    } else {
                        toUse = new SQLRowValues(fromJoin.getTable()).setID(fromJoin.getIDNumber());
                        res.getUpdateRow().put(elemLink.getPath().getStep(0), toUse);
                    }
                }
                if (toUse == null) continue;
                SQLElement.setContentFields(joinTableLocalContentFields, toUse, rowWithFK);
                toUse.put(fkField, ownedID);
                res.mapRow(copy2originalRows.transformChecked(rowWithFK), toUse);
            }
            for (SQLRowValues rowWithFK : fromFKs) {
                res.addToDelete(rowWithFK);
            }
        }
        return res;
    }

    private static Tuple2<List<SQLRowValues>, Map<Number, SQLRowValues>> indexRows(Collection<SQLRowValues> rows) {
        ArrayList<SQLRowValues> sansID = new ArrayList<SQLRowValues>();
        HashMap<Number, SQLRowValues> map = new HashMap<Number, SQLRowValues>();
        for (SQLRowValues r : rows) {
            if (r.hasID()) {
                SQLRowValues previous = map.put(r.getIDNumber(), r);
                if (previous == null) continue;
                throw new IllegalStateException("Duplicate " + r.asRow());
            }
            sansID.add(r);
        }
        return Tuple2.create(sansID, map);
    }

    private static void setOrder(SQLRowValues row, BigDecimal order) {
        assert (order != null);
        row.put(row.getTable().getOrderField().getName(), order);
    }

    private static void setContentFields(Set<String> joinTableLocalContentFields, SQLRowValues newJoinRow, SQLRowValues rowToStore) {
        if (!joinTableLocalContentFields.isEmpty()) {
            newJoinRow.putAll(rowToStore.getValues(joinTableLocalContentFields));
            if (newJoinRow.hasID()) {
                newJoinRow.fill(joinTableLocalContentFields, SQLRowValues.SQL_DEFAULT, false, true);
            }
        }
    }

    public final void unarchiveNonRec(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id), false);
    }

    public final void unarchive(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id));
    }

    public final void unarchive(SQLRow row) throws SQLException {
        this.unarchive(row, true);
    }

    public void unarchive(SQLRow row, boolean desc) throws SQLException {
        this.checkUndefined(row);
        SQLRow upToDate = row.getTable().getRow(row.getID());
        SQLRowValues descsAndMe = desc ? this.getTree(upToDate, true) : upToDate.asRowValues();
        final SQLRowValues connectedRows = new ArchivedGraph(this.getDirectory(), descsAndMe).expand();
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SQLElement.setArchive(Collections.singletonList(connectedRows.getGraph()), false);
                return null;
            }
        });
    }

    public final void archive(int id) throws SQLException {
        this.archiveIDs(Collections.singleton(id));
    }

    public final void archiveIDs(Collection<? extends Number> ids) throws SQLException {
        this.archive(TreesOfSQLRows.createFromIDs(this, ids), true);
    }

    public final void archive(Collection<? extends SQLRowAccessor> rows) throws SQLException {
        this.archive(new TreesOfSQLRows(this, rows), true);
    }

    public final void archive(SQLRow row) throws SQLException {
        this.archive(row, true);
    }

    public final void archiveNoCut(int id) throws SQLException {
        this.archive(this.getTable().getRow(id), false);
    }

    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        this.archive(new TreesOfSQLRows(this, row), cutLinks);
    }

    protected void archive(final TreesOfSQLRows trees, final boolean cutLinks) throws SQLException {
        if (trees.getElem() != this) {
            throw new IllegalArgumentException(this + " != " + trees.getElem());
        }
        if ((trees.isFetched() ? trees.getTrees().keySet() : trees.getRows()).isEmpty()) {
            return;
        }
        for (SQLRow row : trees.getRows()) {
            this.checkUndefined(row);
        }
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                if (!trees.isFetched()) {
                    trees.fetch(SQLSelect.LockStrength.UPDATE);
                }
                if (cutLinks) {
                    CollectionMap2Itf.ListMapItf<SQLElementLink, SQLRowValues> externReferences = trees.getExternReferences().getMap();
                    if (Log.get().isLoggable(Level.FINEST)) {
                        Log.get().finest("will cut : " + externReferences);
                    }
                    for (Map.Entry e : externReferences.entrySet()) {
                        SQLElementLink linkToCut = (SQLElementLink)e.getKey();
                        try {
                            if (linkToCut.isJoin()) {
                                Path joinPath = linkToCut.getPath();
                                Path toJoinTable = joinPath.minusLast();
                                SQLTable joinTable = toJoinTable.getLast();
                                if (!$assertionsDisabled && !(SQLElement.this.getElement(joinTable) instanceof JoinSQLElement)) {
                                    throw new AssertionError();
                                }
                                HashSet<Number> ids = new HashSet<Number>();
                                for (SQLRowValues joinRow : (Collection)e.getValue()) {
                                    if (!$assertionsDisabled && joinRow.getTable() != joinTable) {
                                        throw new AssertionError();
                                    }
                                    ids.add(joinRow.getIDNumber());
                                }
                                String query = "DELETE FROM " + joinTable.getSQLName() + " WHERE " + new Where(joinTable.getKey(), ids);
                                SQLElement.this.getTable().getDBSystemRoot().getDataSource().execute(query);
                                for (Number id : ids) {
                                    joinTable.fireRowDeleted(id.intValue());
                                }
                                continue;
                            }
                            Link refKey = linkToCut.getSingleLink();
                            for (SQLRowAccessor ref : (Collection)e.getValue()) {
                                ref.createEmptyUpdateRow().putEmptyLink(refKey.getSingleField().getName()).update();
                            }
                        }
                        catch (Exception e1) {
                            throw new SQLException("Couldn't cut " + linkToCut + " in " + trees, e1);
                        }
                    }
                    Log.get().finest("done cutting links");
                }
                SQLElement.setArchive(trees.getClusters(), true);
                return null;
            }
        });
    }

    private static final SQLRowValues setArchive(SQLRowValues r, boolean archive) throws SQLException {
        SQLField archiveField = r.getTable().getArchiveField();
        Comparable<Boolean> newVal = Boolean.class.equals(archiveField.getType().getJavaType()) ? (Comparable<Boolean>)Boolean.valueOf(archive) : (Comparable<Boolean>)Integer.valueOf(archive ? 1 : 0);
        r.put(archiveField.getName(), newVal);
        return r;
    }

    private static void setArchive(Collection<SQLRowValuesCluster> clustersToArchive, final boolean archive) throws SQLException {
        Set toArchive = Collections.newSetFromMap(new IdentityHashMap());
        for (SQLRowValuesCluster c : clustersToArchive) {
            toArchive.addAll(c.getItems());
        }
        HashMap<SQLRow, SQLRowValues> linksCut = new HashMap<SQLRow, SQLRowValues>();
        while (!toArchive.isEmpty()) {
            int archivedCount = -1;
            while (archivedCount != 0) {
                archivedCount = 0;
                Iterator iter = toArchive.iterator();
                while (iter.hasNext()) {
                    boolean correct;
                    SQLRowValues desc = (SQLRowValues)iter.next();
                    if (desc.isArchived() == archive) {
                        assert (!linksCut.containsKey(desc.asRow()));
                        correct = true;
                    } else if (archive && !desc.hasReferents() || !archive && !desc.hasForeigns()) {
                        SQLRowValues updateVals = (SQLRowValues)linksCut.remove(desc.asRow());
                        if (updateVals == null) {
                            updateVals = new SQLRowValues(desc.getTable());
                        }
                        SQLElement.setArchive(updateVals, archive).setID(desc.getIDNumber());
                        assert (updateVals.getGraphSize() == 1) : "Archiving a graph : " + updateVals.printGraph();
                        updateVals.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                        correct = true;
                    } else {
                        correct = false;
                    }
                    if (!correct) continue;
                    desc.clear();
                    desc.clearReferents();
                    assert (desc.getGraphSize() == 1) : "Next loop won't progress : " + desc.printGraph();
                    ++archivedCount;
                    iter.remove();
                }
            }
            if (toArchive.isEmpty()) continue;
            SQLRowValues first = (SQLRowValues)toArchive.iterator().next();
            final AtomicReference<Object> cutLinksRef = new AtomicReference<Object>(null);
            first.getGraph().walk(first, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    SQLRowValues last = input.getCurrent();
                    boolean cycleFound = false;
                    int minLinksCount = -1;
                    SQLRowValues leastLinks = null;
                    Iterator<SQLRowValues> iter = input.getValsPath().iterator();
                    while (iter.hasNext()) {
                        int linksCount;
                        SQLRowValues v = iter.next();
                        if (!cycleFound) {
                            boolean bl = cycleFound = iter.hasNext() && v == last;
                        }
                        if (!cycleFound) continue;
                        int n = linksCount = archive ? v.getReferentsMap().allValues().size() : v.getForeigns().size();
                        if (!$assertionsDisabled && linksCount <= 0) {
                            throw new AssertionError();
                        }
                        if (leastLinks != null && linksCount >= minLinksCount) continue;
                        leastLinks = v;
                        minLinksCount = linksCount;
                    }
                    if (cycleFound) {
                        cutLinksRef.set(leastLinks);
                        throw new SQLRowValuesCluster.StopRecurseException();
                    }
                    return null;
                }
            }, new SQLRowValuesCluster.WalkOptions(Link.Direction.REFERENT).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(false).setCycleAllowed(true));
            SQLRowValues cutLinks = cutLinksRef.get();
            assert (cutLinks != null);
            if (archive) {
                for (Map.Entry e : new SetMap(cutLinks.getReferentsMap()).entrySet()) {
                    String fieldName = ((SQLField)e.getKey()).getName();
                    for (SQLRowValues v : (Set)e.getValue()) {
                        SQLRowValues cutVals = (SQLRowValues)linksCut.get(v.asRow());
                        if (cutVals == null) {
                            cutVals = new SQLRowValues(v.getTable());
                            linksCut.put(v.asRow(), cutVals);
                        }
                        assert (!cutVals.getFields().contains(fieldName)) : String.valueOf(fieldName) + " already cut for " + v;
                        assert (!v.isForeignEmpty(fieldName)) : "Nothing to cut";
                        cutVals.put(fieldName, v.getForeignIDNumber(fieldName));
                        v.putEmptyLink(fieldName);
                        new SQLRowValues(v.getTable()).putEmptyLink(fieldName).update(v.getID());
                    }
                }
            } else {
                HashSet<String> foreigns = new HashSet<String>(cutLinks.getForeigns().keySet());
                SQLRowValues oldVal = linksCut.put(cutLinks.asRow(), new SQLRowValues(cutLinks, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM));
                assert (oldVal == null) : "Already cut";
                cutLinks.removeAll(foreigns);
                SQLRowValues updateVals = new SQLRowValues(cutLinks.getTable());
                for (String fieldName : foreigns) {
                    updateVals.putEmptyLink(fieldName);
                }
                updateVals.update(cutLinks.getID());
            }
            assert (archive && !cutLinks.hasReferents() || !archive && !cutLinks.hasForeigns());
        }
        assert (!archive || linksCut.isEmpty()) : "Some links weren't restored : " + linksCut;
        if (!archive) {
            for (Map.Entry e : linksCut.entrySet()) {
                ((SQLRowValues)e.getValue()).update(((SQLRow)e.getKey()).getID());
            }
        }
    }

    public void delete(SQLRowAccessor r) throws SQLException {
        this.check(r);
        throw new UnsupportedOperationException("not yet implemented.");
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public final synchronized String getCode() {
        if (this.code == DEFERRED_CODE) {
            String createCode = this.createCode();
            if (createCode == DEFERRED_CODE) {
                throw new IllegalStateException("createCode() returned DEFERRED_CODE");
            }
            this.code = createCode;
        }
        return this.code;
    }

    public boolean isShared() {
        return false;
    }

    public boolean dontDeepCopy() {
        return false;
    }

    public final synchronized SQLElementLinks getLinksOwnedByOthers() {
        this.initRF();
        return this.otherLinks;
    }

    private final Set<SQLField> getReferentFields(SQLElementLink.LinkType type) {
        return this.getSingleFields(this.getLinksOwnedByOthers(), type);
    }

    public final Set<SQLField> getChildrenReferentFields() {
        return this.getReferentFields(SQLElementLink.LinkType.PARENT);
    }

    public final synchronized SQLElementLinks getOwnedLinks() {
        this.initFF();
        return this.ownedLinks;
    }

    public final SQLElementLink getOwnedLink(String fieldName) {
        return this.getOwnedLink(fieldName, null);
    }

    public final SQLElementLink getOwnedLink(String fieldName, SQLElementLink.LinkType type) {
        Link foreignLink = this.getTable().getDBSystemRoot().getGraph().getForeignLink(this.getTable().getField(fieldName));
        if (foreignLink == null) {
            return null;
        }
        return this.getOwnedLinks().getByPath(((PathBuilder)new PathBuilder(this.getTable()).add(foreignLink, Link.Direction.FOREIGN)).build(), type);
    }

    public final boolean hasOwnedLinks(SQLElementLink.LinkType type) {
        return !this.getOwnedLinks().getByType(type).isEmpty();
    }

    public final SQLField getParentForeignField() {
        return this.getOptionalField(this.getParentForeignFieldName());
    }

    public final synchronized String getParentForeignFieldName() {
        this.initFF();
        return this.parentFF;
    }

    public final SQLElementLink getParentLink() {
        return CollectionUtils.getSole(this.getOwnedLinks().getByType(SQLElementLink.LinkType.PARENT));
    }

    public final Set<SQLElementLink> getChildrenLinks() {
        return this.getLinksOwnedByOthers().getByType(SQLElementLink.LinkType.PARENT);
    }

    public final SQLElement getChildElement(String tableName) {
        HashSet<SQLElementLink> links = new HashSet<SQLElementLink>();
        for (SQLElementLink childLink : this.getChildrenLinks()) {
            if (!childLink.getOwner().getTable().getName().equals(tableName)) continue;
            links.add(childLink);
        }
        if (links.size() != 1) {
            throw new IllegalStateException("no exactly one child table named " + tableName + " : " + links);
        }
        return ((SQLElementLink)links.iterator().next()).getOwner();
    }

    private final SQLField getOptionalField(String name) {
        return name == null ? null : this.getTable().getField(name);
    }

    protected String getParentFFName() {
        return null;
    }

    public final SQLElement getParentElement() {
        if (this.getParentForeignFieldName() == null) {
            return null;
        }
        return this.getForeignElement(this.getParentForeignFieldName());
    }

    public final SQLElement getPrivateElement(String foreignField) {
        SQLElementLink privateLink = this.getOwnedLink(foreignField, SQLElementLink.LinkType.COMPOSITION);
        return privateLink == null ? null : privateLink.getOwned();
    }

    public final SQLRowValues getPrivateGraph() {
        return this.createGraph();
    }

    public final SQLRowValues createGraph() {
        return this.createGraph(SQLTable.VirtualFields.ALL);
    }

    public final SQLRowValues createGraph(SQLTable.VirtualFields fields) {
        return this.createGraph(fields, PrivateMode.ALL_PRIVATES, true);
    }

    private static final SQLRowValues putNulls(SQLRowValues res, SQLTable.VirtualFields fields) {
        return res.fill(res.getTable().getFieldsNames(fields), null, false, true);
    }

    public final SQLRowValues createGraph(SQLTable.VirtualFields fields, PrivateMode privateMode, boolean includeJoins) {
        SQLRowValues res = SQLElement.putNulls(new SQLRowValues(this.getTable()), fields);
        if (includeJoins) {
            for (SQLElementLink link : this.getOwnedLinks().getByPath().values()) {
                if (!link.isJoin()) continue;
                SQLElement.putNulls(res.putRowValues(link.getPath().getStep(0)), fields);
            }
        }
        if (privateMode != PrivateMode.NO_PRIVATES) {
            for (SQLElementLink link : this.getOwnedLinks().getByType(SQLElementLink.LinkType.COMPOSITION)) {
                SQLElement owned = link.getOwned();
                if (privateMode == PrivateMode.DEEP_COPIED_PRIVATES && owned.dontDeepCopy()) {
                    res.remove(link.getPath().getStep(0));
                    continue;
                }
                res.put(link.getPath(), false, owned.createGraph(fields, privateMode, includeJoins));
            }
        }
        return res;
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    public final void clearPrivateFields(SQLRowValues rowVals) {
        for (SQLElementLink l : this.getOwnedLinks().getByType(SQLElementLink.LinkType.COMPOSITION)) {
            rowVals.remove(l.getPath().getStep(0));
        }
    }

    public final void setAction(String ff, ReferenceAction action) throws IllegalArgumentException {
        Path p = ((PathBuilder)new PathBuilder(this.getTable()).addForeignField(ff)).build();
        this.getOwnedLinks().getByPath(p).setAction(action);
    }

    public final SQLElementLinks getContainerLinks() {
        return this.getContainerLinks(true, true);
    }

    public final SQLElementLinks getContainerLinks(boolean privateParent, boolean parent) {
        SetMap<SQLElementLink.LinkType, SQLElementLink> byType = new SetMap<SQLElementLink.LinkType, SQLElementLink>();
        if (parent) {
            byType.addAll(SQLElementLink.LinkType.PARENT, (Collection<SQLElementLink>)this.getOwnedLinks().getByType(SQLElementLink.LinkType.PARENT));
        }
        if (privateParent) {
            byType.addAll(SQLElementLink.LinkType.COMPOSITION, (Collection<SQLElementLink>)this.getLinksOwnedByOthers().getByType(SQLElementLink.LinkType.COMPOSITION));
        }
        SQLElementLinks res = new SQLElementLinks(byType);
        assert (res.getByType().size() <= 1) : "Child and private at the same time";
        return res;
    }

    public final ComboSQLRequest getComboRequest() {
        return this.getComboRequest(false);
    }

    public final ComboSQLRequest getComboRequest(boolean create) {
        if (!create) {
            if (this.combo == null) {
                this.combo = this.createComboRequest();
            }
            return this.combo;
        }
        return this.createComboRequest();
    }

    public final ComboSQLRequest createComboRequest() {
        return this.createComboRequest(null, null);
    }

    public final ComboSQLRequest createComboRequest(List<String> fields, Where w) {
        ComboSQLRequest res = new ComboSQLRequest(this.getTable(), fields == null ? this.getComboFields() : fields, w, this.getDirectory());
        this._initComboRequest(res);
        return res;
    }

    protected void _initComboRequest(ComboSQLRequest req) {
    }

    protected List<String> getComboFields() {
        return this.getListFields();
    }

    public final synchronized ListSQLRequest getListRequest() {
        if (this.list == null) {
            this.list = this.createListRequest();
        }
        return this.list;
    }

    protected FieldExpander getListExpander() {
        return this.getDirectory().getShowAs();
    }

    public final ListSQLRequest createListRequest() {
        return this.createListRequest(null);
    }

    public final ListSQLRequest createListRequest(List<String> fields) {
        return this.createListRequest(fields, null, null);
    }

    public final ListSQLRequest createListRequest(List<String> fields, Where w, FieldExpander expander) {
        ListSQLRequest res = this.instantiateListRequest(fields == null ? this.getListFields() : fields, w, expander == null ? this.getListExpander() : expander);
        this._initListRequest(res);
        return res;
    }

    protected ListSQLRequest instantiateListRequest(List<String> fields, Where w, FieldExpander expander) {
        return new ListSQLRequest(this.getTable(), fields, w, expander);
    }

    protected void _initListRequest(ListSQLRequest req) {
    }

    public final SQLTableModelSourceOnline getTableSource() {
        return this.getTableSource(!this.cacheTableSource());
    }

    public final synchronized SQLTableModelSourceOnline getTableSource(boolean create) {
        if (!create) {
            if (this.tableSrc == null) {
                this.tableSrc = this.createTableSource();
            }
            return this.tableSrc;
        }
        return this.createTableSource();
    }

    public final SQLTableModelSourceOnline createTableSource() {
        return this.createTableSource((Where)null);
    }

    public final SQLTableModelSourceOnline createTableSource(List<String> fields) {
        return this.createTableSourceOnline(this.createListRequest(fields));
    }

    public final SQLTableModelSourceOnline createTableSource(Where w) {
        return this.createTableSourceOnline(this.createListRequest(null, w, null));
    }

    public final SQLTableModelSourceOnline createTableSourceOnline(ListSQLRequest req) {
        return this.initTableSource(this.instantiateTableSourceOnline(req));
    }

    protected SQLTableModelSourceOnline instantiateTableSourceOnline(ListSQLRequest req) {
        return new SQLTableModelSourceOnline(req, this);
    }

    protected synchronized void _initTableSource(SQLTableModelSource res) {
        if (!this.additionalListCols.isEmpty()) {
            res.getColumns().addAll(this.additionalListCols);
        }
    }

    public final <S extends SQLTableModelSource> S initTableSource(S res) {
        return this.initTableSource(res, false);
    }

    public final synchronized <S extends SQLTableModelSource> S initTableSource(S res, boolean minimal) {
        res.init();
        if (!minimal) {
            this._initTableSource(res);
        }
        Set<String> dontModif = CollectionUtils.union(this.getReadOnlyFields(), this.getInsertOnlyFields());
        for (String f : dontModif) {
            for (SQLTableModelColumn col : res.getColumns(this.getTable().getField(f))) {
                if (!(col instanceof SQLTableModelColumnPath)) continue;
                ((SQLTableModelColumnPath)col).setEditable(false);
            }
        }
        return res;
    }

    public final SQLTableModelSourceOffline createTableSourceOffline() {
        return this.createTableSourceOfflineWithWhere(null);
    }

    public final SQLTableModelSourceOffline createTableSourceOfflineWithWhere(Where w) {
        return this.createTableSourceOffline(this.createListRequest(null, w, null));
    }

    public final SQLTableModelSourceOffline createTableSourceOffline(ListSQLRequest req) {
        return this.initTableSource(this.instantiateTableSourceOffline(req));
    }

    protected SQLTableModelSourceOffline instantiateTableSourceOffline(ListSQLRequest req) {
        return new SQLTableModelSourceOffline(req, this);
    }

    protected boolean cacheTableSource() {
        return true;
    }

    protected abstract List<String> getListFields();

    public final void addListFields(List<String> fields) {
        for (String f : fields) {
            this.addListColumn(new SQLTableModelColumnPath(this.getTable().getField(f)));
        }
    }

    public final void addListColumn(SQLTableModelColumn col) {
        this.additionalListCols.add(col);
    }

    @Deprecated
    public final Collection<IListeAction> getRowActions() {
        return this.rowActions;
    }

    public final List<SQLRowValuesAction> getRowValuesActions() {
        return this.rowValuesActions;
    }

    public final void addRowActionsListener(IClosure<? super ListChangeIndex<SQLRowValuesAction>> listener) {
        this.rowValuesActions.getRecipe().addListener(listener);
    }

    public final void removeRowActionsListener(IClosure<? super ListChangeIndex<SQLRowValuesAction>> listener) {
        this.rowValuesActions.getRecipe().rmListener(listener);
    }

    public String getDescription(SQLRow fromRow) {
        return fromRow.toString();
    }

    private <R extends SQLRowAccessor> void forChildrenDo(R row, ChildProcessor<? super R> c, boolean deep, boolean archived) throws SQLException {
        for (SQLElementLink childLink : this.getChildrenLinks()) {
            if (!deep && childLink.getChild().dontDeepCopy()) continue;
            SQLField childField = childLink.getSingleField();
            List<SQLRow> children = row.asRow().getReferentRows(childField, archived ? SQLSelect.ARCHIVED : SQLSelect.UNARCHIVED);
            for (SQLRow child : children) {
                c.process(row, childField, this.convert(child, row));
            }
        }
    }

    private <R extends SQLRowAccessor> R convert(SQLRow toConv, R row) {
        SQLRowAccessor ch;
        if (row instanceof SQLRow) {
            ch = toConv;
        } else if (row instanceof SQLRowValues) {
            ch = toConv.createUpdateRow();
        } else {
            throw new IllegalStateException("SQLRowAccessor is neither SQLRow nor SQLRowValues: " + toConv);
        }
        return (R)ch;
    }

    private void forDescendantsDo(SQLRow row, ChildProcessor<SQLRow> c, boolean deep) throws SQLException {
        this.forDescendantsDo(row, c, deep, true, false);
    }

    <R extends SQLRowAccessor> void forDescendantsDo(R row, final ChildProcessor<R> c, final boolean deep, final boolean leavesFirst, final boolean archived) throws SQLException {
        this.check(row);
        this.forChildrenDo(row, new ChildProcessor<R>(){

            @Override
            public void process(R parent, SQLField joint, R child) throws SQLException {
                if (!leavesFirst) {
                    c.process(parent, joint, child);
                }
                SQLElement.this.getElement(((SQLRowAccessor)child).getTable()).forDescendantsDo(child, c, deep, leavesFirst, archived);
                if (leavesFirst) {
                    c.process(parent, joint, child);
                }
            }
        }, deep, archived);
    }

    protected final void check(SQLRowAccessor row) {
        if (!row.getTable().equals(this.getTable())) {
            throw new IllegalArgumentException("row must of table " + this.getTable() + " : " + row);
        }
    }

    private void checkUndefined(SQLRow row) {
        this.check(row);
        if (row.isUndefined()) {
            throw new IllegalArgumentException("row is undefined: " + row);
        }
    }

    public final SQLRow copyRecursive(int id) throws SQLException {
        return this.copyRecursive(this.getTable().getRow(id));
    }

    public final SQLRow copyRecursive(SQLRow row) throws SQLException {
        return this.copyRecursive(row, null);
    }

    public SQLRow copyRecursive(SQLRow row, SQLRow parent) throws SQLException {
        return this.copyRecursive(row, parent, null);
    }

    public SQLRow copyRecursive(SQLRow row, SQLRow parent, IClosure<SQLRowValues> c) throws SQLException {
        return this.copyRecursive(row, false, parent, c);
    }

    public SQLRow copyRecursive(final SQLRow row, final boolean full, final SQLRow parent, final IClosure<SQLRowValues> c) throws SQLException {
        this.check(row);
        if (row.isUndefined()) {
            return row;
        }
        final HashMap copies = new HashMap();
        return SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<SQLRow>(){

            @Override
            public SQLRow create() throws SQLException {
                SQLRowValues copy = SQLElement.this.createTransformedCopy(row, full, parent, copies, c);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        SQLRowValues parentCopy = (SQLRowValues)copies.get(parent);
                        if (parentCopy == null) {
                            throw new IllegalStateException("null copy of " + parent);
                        }
                        SQLRowValues descCopy = SQLElement.this.createTransformedCopy(desc, full, null, copies, c);
                        descCopy.put(joint.getName(), (Object)parentCopy);
                    }
                }, full, false, false);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        for (SQLElementLink link : SQLElement.this.getElement(desc.getTable()).getOwnedLinks().getByType(SQLElementLink.LinkType.ASSOCIATION)) {
                            Path toRowWFK = link.getPath().minusLast();
                            Step lastStep = link.getPath().getStep(-1);
                            for (SQLRow rowWithFK : desc.getDistantRows(toRowWFK)) {
                                SQLRow ref = rowWithFK.getForeignRow(lastStep.getSingleLink(), SQLRowMode.NO_CHECK);
                                SQLRowValues refCopy = (SQLRowValues)copies.get(ref);
                                if (refCopy == null) continue;
                                SQLRowValues rowWithFKCopy = (SQLRowValues)copies.get(rowWithFK);
                                rowWithFKCopy.put(lastStep, refCopy);
                            }
                        }
                    }
                }, full);
                return copy.insert();
            }
        });
    }

    private final SQLRowValues createTransformedCopy(SQLRow desc, boolean full, SQLRow parent, Map<SQLRow, SQLRowValues> map, IClosure<SQLRowValues> c) throws SQLException {
        SQLRowValues copiedVals = this.getElement(desc.getTable()).createCopy(desc, full, parent, null, map);
        assert (copiedVals != null) : "failed to copy " + desc;
        if (c != null) {
            c.executeChecked(copiedVals);
        }
        return copiedVals;
    }

    public final SQLRow copy(int id) throws SQLException {
        return this.copy(this.getTable().getRow(id));
    }

    public final SQLRow copy(SQLRow row) throws SQLException {
        return this.copy(row, null);
    }

    public final SQLRow copy(SQLRow row, SQLRow parent) throws SQLException {
        SQLRowValues copy = this.createCopy(row, parent);
        return copy == null ? row : copy.insert();
    }

    public final SQLRowValues createCopy(int id) {
        SQLRow row = this.getTable().getRow(id);
        return this.createCopy(row, null);
    }

    public final SQLRowValues createCopy(SQLRowAccessor row, SQLRowAccessor parent) {
        return this.createCopy(row, false, parent);
    }

    public final SQLRowValues createCopy(SQLRowAccessor row, boolean full, SQLRowAccessor parent) {
        return this.createCopy(row, full, parent, null, null);
    }

    public SQLRowValues createCopy(SQLRowAccessor row, boolean full, SQLRowAccessor parent, IdentityHashMap<SQLRowValues, SQLRowValues> valsMap, Map<SQLRow, SQLRowValues> rowMap) {
        SQLRowValues rowVals;
        if (row == null || row.isUndefined()) {
            return null;
        }
        this.check(row);
        Set<SQLElementLink> privates = this.getOwnedLinks().getByType(SQLElementLink.LinkType.COMPOSITION);
        SQLRowValues privateGraph = this.createGraph(SQLTable.VirtualFields.ALL, !full ? PrivateMode.DEEP_COPIED_PRIVATES : PrivateMode.ALL_PRIVATES, true);
        if (row instanceof SQLRowValues) {
            rowVals = (SQLRowValues)row;
        } else if (privateGraph.getGraphSize() == 1) {
            rowVals = null;
        } else {
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(privateGraph);
            fetcher.setSelID(row.getIDNumber());
            rowVals = CollectionUtils.getSole(fetcher.fetch());
            if (rowVals == null) {
                throw new IllegalStateException("Not exactly one row for " + row);
            }
        }
        SQLRowAccessor upToDateRow = rowVals != null ? rowVals : row;
        SQLRowValues copy = new SQLRowValues(this.getTable());
        this.loadAllSafe(copy, upToDateRow);
        if (valsMap != null) {
            if (rowVals == null) {
                throw new IllegalArgumentException("Cannot fill map since no SQLRowValues were provided");
            }
            valsMap.put(rowVals, copy);
        }
        if (rowMap != null) {
            if (!upToDateRow.hasID()) {
                throw new IllegalArgumentException("Cannot fill map since no SQLRow were provided");
            }
            rowMap.put(upToDateRow.asRow(), copy);
        }
        for (SQLElementLink privateLink : privates) {
            boolean deepCopy;
            SQLElement privateElement = privateLink.getOwned();
            boolean bl = deepCopy = full || !privateElement.dontDeepCopy();
            if (!privateLink.isJoin()) {
                String privateName = privateLink.getSingleField().getName();
                if (deepCopy && !rowVals.isForeignEmpty(privateName)) {
                    SQLRowValues foreign = this.checkPrivateLoaded(privateLink, rowVals.getForeign(privateName));
                    SQLRowValues child = privateElement.createCopy(foreign, full, null, valsMap, rowMap);
                    copy.put(privateName, (Object)child);
                    continue;
                }
                if (!upToDateRow.getFields().contains(privateName)) continue;
                copy.putEmptyLink(privateName);
                continue;
            }
            assert (privateLink.getPath().getStep(0).getDirection() == Link.Direction.REFERENT);
            if (!deepCopy) continue;
            this.copyJoin(rowVals, full, valsMap, rowMap, copy, privateLink);
        }
        for (SQLElementLink association : this.getOwnedLinks().getByType(SQLElementLink.LinkType.ASSOCIATION)) {
            if (!association.isJoin()) continue;
            this.copyJoin(rowVals, full, valsMap, rowMap, copy, association);
        }
        if (parent != null) {
            SQLTable foreignTable = this.getParentForeignField().getForeignTable();
            if (!parent.getTable().equals(foreignTable)) {
                throw new IllegalArgumentException(parent + " is not a parent of " + row);
            }
            copy.put(this.getParentForeignFieldName(), parent instanceof SQLRowValues ? parent : parent.getIDNumber());
        }
        return copy;
    }

    private SQLRowValues checkPrivateLoaded(SQLElementLink privateLink, SQLRowAccessor foreign) {
        assert (privateLink.getLinkType() == SQLElementLink.LinkType.COMPOSITION && privateLink.getOwned().getTable() == foreign.getTable());
        if (!(foreign instanceof SQLRowValues)) {
            throw new IllegalStateException("Graph missing non-empty private for " + privateLink);
        }
        return (SQLRowValues)foreign;
    }

    private final void copyJoin(SQLRowValues rowVals, boolean full, IdentityHashMap<SQLRowValues, SQLRowValues> valsMap, Map<SQLRow, SQLRowValues> rowMap, SQLRowValues copy, SQLElementLink link) {
        assert (link.isJoin());
        Step firstStep = link.getPath().getStep(0);
        SQLElement joinElem = this.getElement(firstStep.getTo());
        Step lastStep = link.getPath().getStep(-1);
        for (SQLRowValues joinToCopy : rowVals.followPath(link.getPath().minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false)) {
            SQLRowValues joinCopy = new SQLRowValues(joinElem.getTable());
            joinElem.loadAllSafe(joinCopy, joinToCopy, link.getLinkType() == SQLElementLink.LinkType.COMPOSITION);
            copy.put(firstStep, joinCopy);
            if (valsMap != null) {
                valsMap.put(joinToCopy, joinCopy);
            }
            if (rowMap != null) {
                rowMap.put(joinToCopy.asRow(), joinCopy);
            }
            if (link.getLinkType() == SQLElementLink.LinkType.COMPOSITION) {
                SQLElement privateElement = link.getOwned();
                SQLRowAccessor privateRow = joinToCopy.getForeign(lastStep.getSingleLink());
                if (privateRow.isUndefined()) {
                    throw new IllegalStateException("Joined to undefined " + link);
                }
                this.checkPrivateLoaded(link, privateRow);
                SQLRowValues privateCopy = privateElement.createCopy(privateRow, full, null, valsMap, rowMap);
                joinCopy.put(lastStep, privateCopy);
            }
            assert (!joinCopy.hasID() && joinCopy.getFields().containsAll(lastStep.getSingleLink().getCols()));
        }
    }

    public final void loadAllSafe(SQLRowValues vals, SQLRowAccessor row) {
        this.loadAllSafe(vals, row, null);
    }

    private final void loadAllSafe(SQLRowValues vals, SQLRowAccessor row, Boolean isPrivateJoinElement) {
        this.check(vals);
        this.check(row);
        if (this instanceof JoinSQLElement) {
            if (isPrivateJoinElement == null) {
                throw new IllegalStateException("joins are not public");
            }
            assert (this.getOwnedLinks().getByPath().size() == 0);
            vals.setAll(row.getValues(JOIN_SAFE_FIELDS));
            Path pathFromOwner = ((JoinSQLElement)this).getPathFromOwner();
            assert (pathFromOwner.length() == 2);
            if (isPrivateJoinElement.booleanValue()) {
                vals.remove(pathFromOwner.getStep(1));
            }
        } else {
            if (isPrivateJoinElement != null) {
                throw new IllegalStateException("should a join : " + this);
            }
            vals.setAll(row.getValues(SAFE_FIELDS));
            for (SQLElementLink l : this.getOwnedLinks().getByPath().values()) {
                if (l.getLinkType() == SQLElementLink.LinkType.COMPOSITION || l.isJoin()) continue;
                vals.putAll(row.getValues(l.getSingleLink().getCols()));
            }
        }
    }

    public final ListMap<SQLTable, SQLRow> getDescendants(SQLRow row) {
        this.check(row);
        final ListMap<SQLTable, SQLRow> mm = new ListMap<SQLTable, SQLRow>();
        try {
            this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.add(joint.getTable(), child);
                }
            }, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    private SQLRowValues getTree(SQLRow row, boolean archived) {
        this.check(row);
        SQLRowValues res = row.asRowValues();
        try {
            this.forDescendantsDo(res, new ChildProcessor<SQLRowValues>(){

                @Override
                public void process(SQLRowValues parent, SQLField joint, SQLRowValues desc) throws SQLException {
                    desc.put(joint.getName(), (Object)parent);
                }
            }, true, false, archived);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return res;
    }

    public ListMap<SQLTable, SQLRow> getChildrenRows(SQLRow row) {
        this.check(row);
        final ListMap<SQLTable, SQLRow> mm = new ListMap<SQLTable, SQLRow>();
        try {
            this.forChildrenDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.add(child.getTable(), child);
                }
            }, true, false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    public SQLRowValues getContainer(SQLRowValues row) {
        return this.getContainer(row, true, true);
    }

    public final SQLRowValues getContainer(SQLRowValues row, boolean privateParent, boolean parent) {
        this.check(row);
        if (row.isUndefined() || !privateParent && !parent) {
            return null;
        }
        ArrayList<SQLRowValues> parents = new ArrayList<SQLRowValues>();
        for (SQLElementLink l : this.getContainerLinks(privateParent, parent).getByPath().values()) {
            parents.addAll(row.followPath(l.getPathToParent(), SQLRowValues.CreateMode.CREATE_NONE, true));
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("More than one parent for " + row + " : " + parents);
        }
        return parents.size() == 0 ? null : (SQLRowValues)parents.get(0);
    }

    @Deprecated
    public SQLRow getForeignParent(SQLRow row) {
        return this.getForeignParent(row, SQLRowMode.VALID);
    }

    @Deprecated
    private SQLRow getForeignParent(SQLRow row, SQLRowMode mode) {
        this.check(row);
        return this.getParentForeignFieldName() == null ? null : row.getForeignRow(this.getParentForeignFieldName(), mode);
    }

    public final SQLRowValues fetchPrivateParent(SQLRowAccessor row, boolean modifyParameter) {
        return this.fetchPrivateParent(row, modifyParameter, SQLSelect.ArchiveMode.UNARCHIVED);
    }

    public final SQLRowValues fetchPrivateParent(SQLRowAccessor row, boolean modifyParameter, SQLSelect.ArchiveMode archiveMode) {
        return this.fetchContainer(row, modifyParameter, archiveMode, true, false);
    }

    public final SQLRowValues fetchContainer(SQLRowAccessor row) {
        return this.fetchContainer(row, SQLSelect.ArchiveMode.UNARCHIVED);
    }

    public final SQLRowValues fetchContainer(SQLRowAccessor row, SQLSelect.ArchiveMode archiveMode) {
        return this.fetchContainer(row, false, archiveMode, true, true);
    }

    private static SQLField getToID(Step s) {
        return s.isForeign() != false ? s.getSingleField() : s.getTo().getKey();
    }

    public final SQLRowValues fetchContainer(SQLRowAccessor row, boolean modifyParameter, SQLSelect.ArchiveMode archiveMode, boolean privateParent, boolean parent) {
        SQLRowValues rowWithFK;
        this.check(row);
        if (row.isUndefined() || !privateParent && !parent) {
            return null;
        }
        SQLSyntax syntax = SQLSyntax.get(this.getTable());
        ArrayList<SQLElementLink> parentLinks = new ArrayList<SQLElementLink>(this.getContainerLinks(privateParent, parent).getByPath().values());
        if (parentLinks.isEmpty()) {
            return null;
        }
        ListIterator listIter = parentLinks.listIterator();
        ArrayList<String> selects = new ArrayList<String>(parentLinks.size());
        while (listIter.hasNext()) {
            SQLElementLink parentLink = (SQLElementLink)listIter.next();
            SQLSelect sel = new SQLSelect(true);
            sel.addSelect(SQLElement.getToID(parentLink.getStepToParent()), null, "parentID");
            SQLField joinPK = parentLink.getPath().getTable(1).getKey();
            if (parentLink.isJoin()) {
                sel.addSelect(joinPK, null, "joinID");
            } else {
                sel.addRawSelect(syntax.cast("NULL", joinPK.getType()), "joinID");
            }
            sel.addRawSelect(String.valueOf(listIter.previousIndex()), "fieldIndex");
            sel.setArchivedPolicy(archiveMode);
            sel.setWhere(new Where((FieldRef)SQLElement.getToID(parentLink.getStepToChild()), "=", (Object)row.getIDNumber()));
            assert (sel.getTableRefs().size() == 1) : "Non optimal query";
            selects.add(sel.asString());
        }
        List parentIDs = this.getTable().getDBSystemRoot().getDataSource().executeA(CollectionUtils.join(selects, "\nUNION ALL "));
        if (parentIDs.size() > 1) {
            throw new IllegalStateException("More than one parent for " + row + " : " + parentIDs);
        }
        if (parentIDs.size() == 0) {
            return null;
        }
        Object[] idAndIndex = (Object[])parentIDs.get(0);
        Number mainID = (Number)idAndIndex[0];
        Number joinID = (Number)idAndIndex[1];
        SQLElementLink parentLink = (SQLElementLink)parentLinks.get(((Number)idAndIndex[2]).intValue());
        Path toChildPath = parentLink.getPathToChild();
        SQLRowValues res = new SQLRowValues(toChildPath.getTable(0)).setID(mainID);
        if (parentLink.isJoin()) {
            if (joinID == null) {
                throw new IllegalStateException("Missing join ID for " + parentLink);
            }
            Step parentToJoin = toChildPath.getStep(0);
            rowWithFK = res.putRowValues(parentToJoin).setID(joinID);
        } else {
            rowWithFK = res;
        }
        assert (rowWithFK.hasID());
        rowWithFK.put(toChildPath.getStep(-1), (modifyParameter ? row : row.asRow()).asRowValues());
        return res;
    }

    public final SQLRowValues fetchPrivateRoot(SQLRowAccessor row, SQLSelect.ArchiveMode archiveMode) {
        SQLRowValues prev = null;
        SQLRowValues res = this.fetchPrivateParent(row, true, archiveMode);
        while (res != null) {
            prev = res;
            res = this.getElement(res.getTable()).fetchPrivateParent(res, true, archiveMode);
        }
        return prev;
    }

    Map<SQLField, List<SQLRow>> getNonChildrenReferents(SQLRow row) {
        this.check(row);
        HashMap<SQLField, List<SQLRow>> mm = new HashMap<SQLField, List<SQLRow>>();
        HashSet<SQLField> nonChildren = new HashSet<SQLField>(row.getTable().getDBSystemRoot().getGraph().getReferentKeys(row.getTable()));
        nonChildren.removeAll(this.getChildrenReferentFields());
        for (SQLField refField : nonChildren) {
            mm.put(refField, (List<SQLRow>)row.getReferentRows(refField));
        }
        return mm;
    }

    public final Object fetchModelObject(Number id) {
        SQLRowValues r = this.createModelFetcher().fetchOne(id, true);
        if (r == null) {
            throw new IllegalStateException("Missing " + id + " for " + this);
        }
        return this.getModelObject(r);
    }

    protected final SQLRowValuesListFetcher createModelFetcher() {
        return SQLRowValuesListFetcher.create(this.createGraph());
    }

    public final Map<Number, Object> fetchModelObjects(Collection<? extends Number> ids) {
        return this.fetchModelObjects(ids, Object.class);
    }

    public final <T> Map<Number, T> fetchModelObjects(Collection<? extends Number> ids, Class<T> clazz) {
        List<SQLRowValues> rows = this.createModelFetcher().fetch(new Where(this.getTable().getKey(), ids), true);
        LinkedHashMap<Number, T> res = new LinkedHashMap<Number, T>();
        for (SQLRowValues r : rows) {
            res.put(r.getIDNumber(), clazz.cast(this.getModelObject(r)));
        }
        return res;
    }

    public final Object getModelObject(SQLRowAccessor row) {
        Object res;
        this.check(row);
        if (!this.canCreateModelObject()) {
            return null;
        }
        if (row instanceof SQLRow) {
            CacheResult cached = this.getModelCache().check(row.asRow(), Collections.singleton(row));
            if (cached.getState() == CacheResult.State.INTERRUPTED) {
                throw new RTInterruptedException("interrupted while waiting for the cache");
            }
            if (cached.getState() == CacheResult.State.VALID) {
                return cached.getRes();
            }
            try {
                res = this.createModelObject(row);
                this.getModelCache().put(cached, res);
            }
            catch (RuntimeException exn) {
                this.getModelCache().removeRunning((SQLRow)((Object)cached));
                throw exn;
            }
        } else {
            res = this.createModelObject(row);
        }
        return res;
    }

    protected final Object createModelObject(SQLRowAccessor row) {
        return this.getModelClass().cast(this._createModelObject(row));
    }

    protected Object _createModelObject(SQLRowAccessor row) {
        Constructor<?> ctor = ReflectUtils.getMatchingConstructor(this.getModelClass(), row.getClass(), this.getClass());
        if (ctor == null) {
            try {
                ctor = this.getModelClass().getConstructor(SQLRowAccessor.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(this + " found no public suitable constructor in " + this.getModelClass());
            }
        }
        try {
            return ctor.getParameterTypes().length == 2 ? ctor.newInstance(row, this) : ctor.newInstance(row);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(RuntimeException.class, "pb creating instance", e);
        }
    }

    public boolean canCreateModelObject() {
        return this.getModelClass() != null;
    }

    protected Class<?> getModelClass() {
        return null;
    }

    public boolean equals(SQLRow row, SQLRow row2) {
        return this.equals(row, row2, false);
    }

    public boolean equals(SQLRow row, SQLRow row2, boolean ignoreNotDeepCopied) {
        return this.equals(row, row2, EqualOption.fromIgnoreNotDeepCopied(ignoreNotDeepCopied));
    }

    public boolean equals(SQLRow row, SQLRow row2, EqualOption option) {
        return this.diff(row, row2, option).get0();
    }

    Tuple2<Boolean, SQLRowValuesCluster.DiffResult> diff(SQLRow row, SQLRow row2, EqualOption option) {
        this.check(row);
        if (!row2.getTable().equals(this.getTable())) {
            return FALSE_NULL;
        }
        if (row.equals(row2)) {
            return TRUE_NULL;
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(this.getPrivateGraphForEquals(option));
        List<SQLRowValues> fetched = fetcher.fetch(new Where(this.getTable().getKey(), Arrays.asList(row.getIDNumber(), row2.getIDNumber())));
        if (fetched.size() > 2) {
            throw new IllegalStateException("More than 2 rows for " + row + " and " + row2);
        }
        if (fetched.size() < 2) {
            return FALSE_NULL;
        }
        SQLRowValuesCluster.DiffResult res = SQLElement.equalsPruned(fetched.get(0), fetched.get(1));
        return Tuple2.create(res.isEqual(), res);
    }

    public boolean equals(SQLRowValues row, SQLRowValues row2, boolean ignoreNotDeepCopied) {
        return this.equals(row, row2, EqualOption.fromIgnoreNotDeepCopied(ignoreNotDeepCopied));
    }

    public boolean equals(SQLRowValues row, SQLRowValues row2, EqualOption option) {
        this.check(row);
        if (row == row2) {
            return true;
        }
        if (!row2.getTable().equals(this.getTable())) {
            return false;
        }
        SQLRowValues privateGraphForEquals = this.getPrivateGraphForEquals(option);
        return SQLElement.equalsPruned(row.prune(privateGraphForEquals), row2.prune(privateGraphForEquals)).isEqual();
    }

    private final SQLRowValues getPrivateGraphForEquals(EqualOption option) {
        SQLRowValues res = this.createGraph(option.fields, option.isIgnoreNotDeepCopied() ? PrivateMode.DEEP_COPIED_PRIVATES : PrivateMode.ALL_PRIVATES, false);
        for (SQLRowValues item : new HashSet<SQLRowValues>(res.getGraph().getItems())) {
            SQLElement elem = this.getElement(item.getTable());
            SQLElementLink parentLink = elem.getParentLink();
            this.setLink(item, parentLink, option.isParentTested());
            for (SQLElementLink normalLink : elem.getOwnedLinks().getByType(SQLElementLink.LinkType.ASSOCIATION)) {
                this.setLink(item, normalLink, option.isNonSharedTested() || normalLink.getOwned().isShared());
            }
        }
        return res;
    }

    private final void setLink(SQLRowValues item, SQLElementLink link, boolean shouldBeTested) {
        if (link == null) {
            return;
        }
        if (shouldBeTested) {
            if (link.isJoin()) {
                assert (link.getPath().getStep(0).getDirection() == Link.Direction.REFERENT);
                item.assurePath(link.getPath().minusLast()).fillWith(null, false);
            }
        } else if (!link.isJoin()) {
            item.removeForeignKey(link.getSingleLink());
        }
    }

    private static SQLRowValuesCluster.DiffResult equalsPruned(SQLRowValues row, SQLRowValues row2) {
        return row.getGraph().getFirstDifference(row, row2, false, false, false);
    }

    public boolean equalsRecursive(SQLRow row, SQLRow row2) throws SQLException {
        return this.equalsRecursive(row, row2, EqualOption.ALL);
    }

    public boolean equalsRecursive(SQLRow row, SQLRow row2, EqualOption option) throws SQLException {
        return new SQLElementRowR(this, row).equals(new SQLElementRowR(this, row2), option);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getTable().getSQLName();
    }

    public final void addComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.add(id, t);
    }

    public final void removeComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.removeOne(id, t);
    }

    private final SQLComponent createComponentFromFactory(String id, boolean defaultItem) {
        String actualID = defaultItem ? DEFAULT_COMP_ID : id;
        Tuple2<SQLElement, String> t = Tuple2.create(this, id);
        Iterator iter = ((LinkedList)this.components.getNonNull(actualID)).descendingIterator();
        while (iter.hasNext()) {
            SQLComponent res = (SQLComponent)((ITransformer)iter.next()).transformChecked(t);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public final SQLComponent createDefaultComponent() {
        return this.createComponent(DEFAULT_COMP_ID);
    }

    public final SQLComponent createComponent(String id) throws IllegalStateException {
        return this.createComponent(id, true);
    }

    public final SQLComponent createComponent(String id, boolean required) throws IllegalStateException {
        SQLComponent res = this.createComponentFromFactory(id, false);
        if (res == null) {
            res = CompareUtils.equals(id, DEFAULT_COMP_ID) ? this.createComponent() : this.createComponentFromFactory(id, true);
        }
        if (res != null) {
            res.setCode(id);
        } else if (required) {
            throw new IllegalStateException("No component for " + id);
        }
        return res;
    }

    protected abstract SQLComponent createComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToMDPath(String mdVariant) {
        if (mdVariant == null) {
            throw new NullPointerException();
        }
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            LinkedList<String> newL = new LinkedList<String>(this.mdPath);
            newL.addFirst(mdVariant);
            this.mdPath = Collections.unmodifiableList(newL);
        }
    }

    public final synchronized void removeFromMDPath(String mdVariant) {
        LinkedList<String> newL = new LinkedList<String>(this.mdPath);
        if (newL.remove(mdVariant)) {
            this.mdPath = Collections.unmodifiableList(newL);
        }
    }

    public final synchronized List<String> getMDPath() {
        return this.mdPath;
    }

    public final boolean putAdditionalField(String field) {
        return this.putAdditionalField(field, null);
    }

    public final boolean putAdditionalTextField(String field, Supplier<? extends JTextComponent> comp) {
        return this.putAdditionalField(field, comp);
    }

    public final boolean putAdditionalTextCombo(String field, Supplier<? extends SQLTextCombo> comp) {
        return this.putAdditionalField(field, comp);
    }

    public final boolean putAdditionalCombo(String field, Supplier<? extends SQLRequestComboBox> comp) {
        return this.putAdditionalField(field, comp);
    }

    private final boolean putAdditionalField(String field, Supplier<? extends JComponent> comp) {
        if (this.additionalFields.containsKey(field)) {
            return false;
        }
        this.additionalFields.put(field, comp);
        return true;
    }

    public final Map<String, Supplier<? extends JComponent>> getAdditionalFields() {
        return Collections.unmodifiableMap(this.additionalFields);
    }

    public final void removeAdditionalField(String field) {
        this.additionalFields.remove(field);
    }

    public final boolean askArchive(Component comp, Number ids) {
        return Value.hasValue(this.askArchive(comp, Collections.singleton(ids)));
    }

    public final Value<TreesOfSQLRows> askArchive(Component comp, Collection<? extends Number> ids) {
        Boolean agreed;
        TreesOfSQLRows trees;
        block4: {
            trees = TreesOfSQLRows.createFromIDs(this, ids);
            try {
                trees.fetch(SQLSelect.LockStrength.NONE);
                agreed = this.ask(comp, trees);
                if (agreed != null) break block4;
                return null;
            }
            catch (SQLException e) {
                ExceptionHandler.handle(comp, TM.tr("sqlElement.archiveError", this, ids), e);
                return null;
            }
        }
        if (agreed.booleanValue()) {
            this.archive(trees, true);
            return Value.getSome(trees);
        }
        return Value.getNone();
    }

    public Boolean ask(Component comp, TreesOfSQLRows trees) {
        boolean shouldArchive = false;
        if (!trees.isFetched()) {
            throw new IllegalStateException("Trees not yet fetched");
        }
        try {
            int rowCount = trees.getTrees().size();
            if (rowCount == 0) {
                return true;
            }
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            Map<SQLTable, List<SQLRowAccessor>> descs = trees.getDescendantsByTable();
            SortedMap<TreesOfSQLRows.LinkToCut, Integer> externRefs = trees.getExternReferences().countByLink();
            String confirmDelete = TM.getTM().trA("sqlElement.confirmDelete", new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowCount", rowCount);
            int descsSize = descs.size();
            int externsSize = externRefs.size();
            if (descsSize + externsSize > 0) {
                String descsS = descsSize > 0 ? this.toString(descs) : null;
                String externsS = externsSize > 0 ? this.toStringExtern(externRefs) : null;
                map.put("descsSize", descsSize);
                map.put("descs", descsS);
                map.put("externsSize", externsSize);
                map.put("externs", externsS);
                map.put("times", "once");
                int i = this.askSerious(comp, String.valueOf(TM.getTM().trM("sqlElement.deleteRef.details", map)) + TM.getTM().trM("sqlElement.deleteRef", map), confirmDelete);
                if (i == 0) {
                    map.put("times", "twice");
                    String msg = externsSize > 0 ? TM.getTM().trM("sqlElement.deleteRef.details2", map) : "";
                    i = this.askSerious(comp, String.valueOf(msg) + TM.getTM().trM("sqlElement.deleteRef", map), confirmDelete);
                    if (i == 0) {
                        shouldArchive = true;
                    } else {
                        JOptionPane.showMessageDialog(comp, TM.getTM().trA("sqlElement.noLinesDeleted", new Object[0]), TM.getTM().trA("sqlElement.noLinesDeletedTitle", new Object[0]), 1);
                    }
                }
            } else {
                int i = this.askSerious(comp, TM.getTM().trM("sqlElement.deleteNoRef", map), confirmDelete);
                if (i == 0) {
                    shouldArchive = true;
                }
            }
            return shouldArchive;
        }
        catch (Exception e) {
            ExceptionHandler.handle(comp, TM.tr("sqlElement.rowsToArchiveError", this), e);
            return null;
        }
    }

    private final String toString(Map<SQLTable, List<SQLRowAccessor>> descs) {
        ArrayList<String> l = new ArrayList<String>(descs.size());
        for (Map.Entry<SQLTable, List<SQLRowAccessor>> e : descs.entrySet()) {
            SQLTable t = e.getKey();
            SQLElement elem = this.getElement(t);
            l.add(SQLElement.elemToString(e.getValue().size(), elem));
        }
        return CollectionUtils.join(l, "\n");
    }

    private static final String elemToString(int count, SQLElement elem) {
        return "- " + elem.getName().getNumeralVariant(count, Grammar.INDEFINITE_NUMERAL);
    }

    private final String toStringExtern(SortedMap<TreesOfSQLRows.LinkToCut, Integer> externRefs) {
        ArrayList<String> l = new ArrayList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        for (Map.Entry<TreesOfSQLRows.LinkToCut, Integer> entry : externRefs.entrySet()) {
            TreesOfSQLRows.LinkToCut foreignKey = entry.getKey();
            int count = entry.getValue();
            String label = foreignKey.getLabel();
            SQLElement elem = this.getElement(foreignKey.getTable());
            map.put("elementName", elem.getName());
            map.put("count", count);
            map.put("linkName", label);
            l.add(TM.getTM().trM("sqlElement.linksWillBeCut", map));
        }
        return CollectionUtils.join(l, "\n");
    }

    private final int askSerious(Component comp, String msg, String title) {
        return JOptionPane.showConfirmDialog(comp, msg, String.valueOf(title) + " (" + this.getPluralName() + ")", 0, 2);
    }

    static interface ChildProcessor<R extends SQLRowAccessor> {
        public void process(R var1, SQLField var2, R var3) throws SQLException;
    }

    @Immutable
    public static final class EqualOption {
        private static final SQLTable.VirtualFields EQUALS_FIELDS = SQLTable.VirtualFields.CONTENT.union(SQLTable.VirtualFields.ARCHIVE);
        private static final SQLTable.VirtualFields EQUALS_WITH_MD_FIELDS = EQUALS_FIELDS.union(SQLTable.VirtualFields.METADATA);
        public static final EqualOption ALL = new EqualOption(false, true, true, true);
        public static final EqualOption ALL_BUT_IGNORE_NOT_DEEP_COPIED = ALL.createBuilder().setIgnoreNotDeepCopied(true).build();
        public static final EqualOption IGNORE_NOT_DEEP_COPIED = new EqualOptionBuilder().setIgnoreNotDeepCopied(true).build();
        public static final EqualOption TEST_NOT_DEEP_COPIED = new EqualOptionBuilder().setIgnoreNotDeepCopied(false).build();
        private final boolean ignoreNotDeepCopied;
        private final boolean testNonShared;
        private final boolean testParent;
        private final SQLTable.VirtualFields fields;

        static final EqualOption fromIgnoreNotDeepCopied(boolean ignoreNotDeepCopied) {
            return ignoreNotDeepCopied ? IGNORE_NOT_DEEP_COPIED : TEST_NOT_DEEP_COPIED;
        }

        protected EqualOption(boolean ignoreNotDeepCopied, boolean testNonShared, boolean testParent, boolean testMetadata) {
            this.ignoreNotDeepCopied = ignoreNotDeepCopied;
            this.testNonShared = testNonShared;
            this.testParent = testParent;
            this.fields = testMetadata ? EQUALS_WITH_MD_FIELDS : EQUALS_FIELDS;
        }

        public boolean isIgnoreNotDeepCopied() {
            return this.ignoreNotDeepCopied;
        }

        public boolean isNonSharedTested() {
            return this.testNonShared;
        }

        public boolean isParentTested() {
            return this.testParent;
        }

        public EqualOptionBuilder createBuilder() {
            return new EqualOptionBuilder().setIgnoreNotDeepCopied(this.isIgnoreNotDeepCopied()).setNonSharedTested(this.isNonSharedTested()).setParentTested(this.isParentTested()).setMetadataTested(this.fields == EQUALS_WITH_MD_FIELDS);
        }
    }

    public static final class EqualOptionBuilder {
        private boolean ignoreNotDeepCopied = false;
        private boolean testNonShared = false;
        private boolean testParent = false;
        private boolean testMetadata = false;

        public boolean isIgnoreNotDeepCopied() {
            return this.ignoreNotDeepCopied;
        }

        public EqualOptionBuilder setIgnoreNotDeepCopied(boolean ignoreNotDeepCopied) {
            this.ignoreNotDeepCopied = ignoreNotDeepCopied;
            return this;
        }

        public boolean isNonSharedTested() {
            return this.testNonShared;
        }

        public EqualOptionBuilder setNonSharedTested(boolean testNonShared) {
            this.testNonShared = testNonShared;
            return this;
        }

        public boolean isParentTested() {
            return this.testParent;
        }

        public EqualOptionBuilder setParentTested(boolean testParent) {
            this.testParent = testParent;
            return this;
        }

        public boolean isMetadataTested() {
            return this.testMetadata;
        }

        public EqualOptionBuilder setMetadataTested(boolean testMetadata) {
            this.testMetadata = testMetadata;
            return this;
        }

        public EqualOption build() {
            return new EqualOption(this.ignoreNotDeepCopied, this.testNonShared, this.testParent, this.testMetadata);
        }
    }

    public static enum PrivateMode {
        NO_PRIVATES,
        DEEP_COPIED_PRIVATES,
        ALL_PRIVATES;

    }

    public static enum ReferenceAction {
        SET_EMPTY,
        CASCADE,
        RESTRICT;

    }
}

