/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ListMap;

public class BonDeLivraisonSQLElement
extends ComptaSQLConfElement {
    private final List<SQLTableModifiedListener> listenerCmdInserted = new ArrayList<SQLTableModifiedListener>();

    public BonDeLivraisonSQLElement(String single, String plural) {
        super("BON_DE_LIVRAISON", single, plural);
        if (this.getTable().contains("VERROU_FACTURATION")) {
            RowAction.PredicateRowAction lock = new RowAction.PredicateRowAction(new AbstractAction("Verrouiller"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BonDeLivraisonSQLElement.this.updateVerrouFacture(IListe.get(e).getSelectedRowAccessors(), true);
                }
            }, false);
            lock.setPredicate(ListEvent.getNonEmptySelectionPredicate());
            lock.setPath(Arrays.asList("Verrou facturaction", "Verrou facturaction", "Verrou facturaction"));
            RowAction.PredicateRowAction unlock = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9verrouiller"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BonDeLivraisonSQLElement.this.updateVerrouFacture(IListe.get(e).getSelectedRowAccessors(), false);
                }
            }, false);
            unlock.setPath(Arrays.asList("Verrou facturaction", "Verrou facturaction", "Verrou facturaction"));
            unlock.setPredicate(ListEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(lock);
            this.getRowActions().add(unlock);
        }
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("MONTANT_INTERFEL_HT");
        return s;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("VERROU_FACTURATION");
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        this.addCommercialFilter(res, this.getTable().getField("ID_COMMERCIAL"));
    }

    private void updateVerrouFacture(List<SQLRowAccessor> rows, boolean state) {
        UpdateBuilder builder = new UpdateBuilder(this.getTable());
        builder.setObject("VERROU_FACTURATION", (Object)state);
        builder.setWhere(Where.inValues(this.getTable().getKey(), SQLRow.getIDs(rows)));
        this.getTable().getDBSystemRoot().getDataSource().execute(builder.asString());
        this.getTable().fireTableModified();
    }

    public BonDeLivraisonSQLElement() {
        this("un bon de livraison", "bons de livraison");
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        if (this.getTable().contains("ID_COMMERCIAL")) {
            l.add("ID_COMMERCIAL");
        }
        l.add("ID_CLIENT");
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        if (b.booleanValue()) {
            l.add("TOTAL_POIDS");
        }
        l.add("NOM");
        l.add("TOTAL_HT");
        l.add("TOTAL_TTC");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("NUMERO");
        l.add("DATE");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"NUMERO", "DATE"});
    }

    @Override
    public SQLComponent createComponent() {
        return new BonDeLivraisonSQLComponent();
    }

    public List<Object> getSourceTrRowsFrom(int blOrigin, String tableSourceItems, String tableSourceRoot) {
        SQLTable tableBLElement = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLTable tableCmdElement = this.getTable().getTable(tableSourceItems);
        String idRoot = "c2.\"" + this.getTable().getTable(tableSourceRoot).getKey().getFieldName() + "\"";
        String up = "SELECT DISTINCT c2.\"ID_" + tableSourceRoot + "\" FROm " + new SQLName(tableBLElement.getDBRoot().getName(), tableBLElement.getName()).quote() + " b2, " + new SQLName(tableCmdElement.getDBRoot().getName(), tableCmdElement.getName()).quote() + " c2 WHERE b2.\"ID_BON_DE_LIVRAISON\"=" + blOrigin + " AND c2.\"ARCHIVE\"=0 AND b2.\"ARCHIVE\"=0 AND " + idRoot + ">1 AND b2.\"ID\">1 AND b2.\"ID_" + tableSourceItems + "\"=" + idRoot;
        return this.getTable().getDBSystemRoot().getDataSource().executeCol(up);
    }

    public void updateQteLivree(List<Object> items, String tableItems, String tableRoot) {
        if (items != null && !items.isEmpty()) {
            SQLTable tableBLElement = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
            SQLTable tableCmdElement = this.getTable().getTable(tableItems);
            String itemsKey = "c.\"" + this.getTable().getTable(tableItems).getKey().getName() + "\"";
            UpdateBuilder build = new UpdateBuilder(tableCmdElement);
            build.set("QTE_LIVREE", "(SELECT SUM(b.\"QTE_LIVREE\" * b.\"QTE_UNITAIRE\") from " + new SQLName(tableBLElement.getDBRoot().getName(), tableBLElement.getName()).quote() + " b where " + itemsKey + "=b.\"ID_" + tableItems + "\" AND " + itemsKey + ">1 AND c.\"ARCHIVE\"=0 AND b.\"ID\">1 AND b.\"ARCHIVE\"=0 )");
            AliasedTable alias = new AliasedTable(tableCmdElement, "c");
            build.setWhere(new Where(alias.getField("ID_" + tableRoot), items));
            this.getTable().getDBSystemRoot().getDataSource().execute(build.asString().replaceAll(" SET", " c SET "));
            if (tableRoot.equalsIgnoreCase("COMMANDE_CLIENT")) {
                SQLTable tableCmd = this.getTable().getTable("COMMANDE_CLIENT");
                AliasedTable aliasCmd = new AliasedTable(tableCmd, "c");
                Where wIN = Where.inValues(aliasCmd.getKey(), items);
                String req = "UPDATE " + tableCmd.getSQLName().quote() + " c SET \"ETAT_COMMANDE\"=5 WHERE " + wIN.getClause() + "and  (\"ETAT_COMMANDE\"=1 or \"ETAT_COMMANDE\"=2 or c.\"ETAT_COMMANDE\"=3 or c.\"ETAT_COMMANDE\"=4) " + "and (select SUM((i.\"QTE\"*i.\"QTE_UNITAIRE\")-i.\"QTE_LIVREE\") from " + tableCmdElement.getSQLName().quote() + " i" + " where i.\"ID_COMMANDE_CLIENT\"=c.\"ID\" and i.\"ARCHIVE\"=0)<=0";
                this.getTable().getDBSystemRoot().getDataSource().execute(req);
            }
            this.getTable().getTable(tableItems).fireTableModified();
        }
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        ArrayList<Object> cmds = new ArrayList<Object>();
        ArrayList<Object> devis = new ArrayList<Object>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SQLRow row : trees.getRows()) {
            cmds.addAll(this.getSourceTrRowsFrom(row.getID(), "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT"));
            devis.addAll(this.getSourceTrRowsFrom(row.getID(), "DEVIS_ELEMENT", "DEVIS"));
            ids.add(row.getID());
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        this.getDirectory().getElement(LotSQLElement.class).removeLotQuantiteFromBL((Collection<Integer>)ids);
        super.archive(trees, cutLinks);
        this.updateQteLivree(devis, "DEVIS_ELEMENT", "DEVIS");
        this.updateQteLivree(cmds, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                EditFrame editFrame = new EditFrame(BonDeLivraisonSQLElement.this, EditPanel.CREATION);
                ((BonDeLivraisonSQLComponent)editFrame.getSQLComponent()).duplicate(((SQLRowAccessor)selectedRow).getID());
                editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    public void addInsertedCmdListener(SQLTableModifiedListener l) {
        this.listenerCmdInserted.add(l);
    }

    public void removeInsertedCmdListener(SQLTableModifiedListener l) {
        this.listenerCmdInserted.remove(l);
    }

    public void fireInsertedCmdListener(SQLRow row) {
        for (SQLTableModifiedListener sqlTableModifiedListener : this.listenerCmdInserted) {
            sqlTableModifiedListener.tableModified(new SQLTableEvent(row, SQLTableEvent.Mode.ROW_ADDED, null));
        }
    }

    @Override
    protected String createCodeSuffix() {
        return ".delivery.note";
    }
}

