/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;

public class LivrePayeSheetV2
extends SheetInterface {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private final SQLTable tableSalarie;
    private final SQLTable tableMois;
    private final SQLTable tableRubriqueCotisation;
    public static final String TEMPLATE_ID = "LivrePaye";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationLivrePaye";
    private Date dateGen;
    private final Date du;
    private final Date au;
    private final DBRoot root;
    private int moisDu;
    private int moisAu;
    private String annee;
    private static int debutFill;
    private static int endFill;
    private static int nbCol;
    private Set<Integer> listSalarie = new LinkedHashSet<Integer>();

    static {
        LivrePayeSheetV2.setSize(9, 72, 6);
    }

    public static void setSize(int debut, int fin, int col) {
        debutFill = debut;
        endFill = fin;
        nbCol = col;
    }

    @Override
    protected String getYear() {
        return "";
    }

    public LivrePayeSheetV2(int moisDu, int moisAu, String annee, DBRoot root) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("LivrePayePrinter");
        this.modele = "LivrePaye.ods";
        this.moisAu = moisAu;
        this.moisDu = moisDu;
        this.annee = annee;
        this.tableSalarie = root.getTable("SALARIE");
        this.tableMois = root.getTable("MOIS");
        this.tableRubriqueCotisation = root.findTable("RUBRIQUE_COTISATION");
        this.nbRowsPerPage = 72;
        Calendar c = Calendar.getInstance();
        c.set(1, Integer.valueOf(annee));
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(2, moisDu);
        this.du = c.getTime();
        c.set(2, moisAu);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        this.au = c.getTime();
        this.root = root;
        this.createMap();
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    private List<LineLivrePaye> getListeValues() {
        SQLSelect sel = new SQLSelect();
        SQLTable tableFichePaye = this.root.getTable("FICHE_PAYE");
        SQLTable tableFichePayeElement = this.root.getTable("FICHE_PAYE_ELEMENT");
        SQLTable tableSalarie = this.root.getTable("SALARIE");
        sel.addSelect(tableFichePaye.getField("ID"));
        sel.addSelect(tableFichePayeElement.getField("ID"));
        sel.addSelect(tableSalarie.getField("ID"));
        Where w = new Where((FieldRef)tableFichePayeElement.getField("ID_FICHE_PAYE"), "=", tableFichePaye.getField("ID"));
        Where w2 = new Where((FieldRef)tableFichePaye.getField("ID_SALARIE"), "=", tableSalarie.getField("ID"));
        Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), new Integer(this.moisDu), (Object)new Integer(this.moisAu));
        Where w4 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", (Object)new Integer(this.annee));
        Where w5 = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
        Where wUsed = new Where((FieldRef)tableFichePayeElement.getField("MONTANT_PAT"), "!=", 0).or(new Where((FieldRef)tableFichePayeElement.getField("MONTANT_SAL_DED"), "!=", 0)).or(new Where((FieldRef)tableFichePayeElement.getField("MONTANT_SAL_AJ"), "!=", 0));
        sel.setWhere(w);
        sel.andWhere(w2);
        sel.andWhere(w3);
        sel.andWhere(w4);
        sel.andWhere(w5);
        sel.andWhere(wUsed);
        String req = sel.asString();
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap<Tuple2<TypeLineLivre, Integer>, LineLivrePaye> mapLines = new HashMap<Tuple2<TypeLineLivre, Integer>, LineLivrePaye>();
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            int idFicheElt = Integer.parseInt(tmp[1].toString());
            int idSal = Integer.parseInt(tmp[2].toString());
            SQLRow rowFicheElt = tableFichePayeElement.getRow(idFicheElt);
            this.listSalarie.add(idSal);
            TypeLineLivre type = null;
            if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_BRUT")) {
                type = TypeLineLivre.BRUT;
            } else if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_NET")) {
                type = TypeLineLivre.NET;
            } else if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                type = TypeLineLivre.COTISATION;
            }
            if (type != null) {
                LineLivrePaye line;
                int idSource = rowFicheElt.getInt("IDSOURCE");
                Tuple2<TypeLineLivre, Integer> key = Tuple2.create(type, idSource);
                if (!mapLines.containsKey(key)) {
                    String caisse = rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_COTISATION") ? this.tableRubriqueCotisation.getRow(idSource).getForeign("ID_CAISSE_COTISATION").getString("NOM") : "";
                    line = new LineLivrePaye(rowFicheElt.getString("NOM"), caisse, type);
                    mapLines.put(key, line);
                } else {
                    line = (LineLivrePaye)mapLines.get(key);
                }
                line.cumul(rowFicheElt, idSal);
            }
            ++i;
        }
        ArrayList<LineLivrePaye> lines = new ArrayList<LineLivrePaye>(mapLines.values());
        return this.sortAndSumByType(lines);
    }

    private List<LineLivrePaye> sortAndSumByType(List<LineLivrePaye> lines) {
        Collections.sort(lines);
        ArrayList<LineLivrePaye> resultAll = new ArrayList<LineLivrePaye>();
        ArrayList<LineLivrePaye> resultBrut = new ArrayList<LineLivrePaye>();
        ArrayList<LineLivrePaye> resultNet = new ArrayList<LineLivrePaye>();
        HashMap<String, LineLivrePaye> resultTotalCaisseCotisation = new HashMap<String, LineLivrePaye>();
        ListMap<String, LineLivrePaye> resultCotisation = new ListMap<String, LineLivrePaye>();
        LineLivrePaye lineTotalBrut = new LineLivrePaye("Total rubriques de brut", "", TypeLineLivre.BRUT);
        lineTotalBrut.setSousTotal(true);
        for (LineLivrePaye lineLivrePaye : lines) {
            if (lineLivrePaye.type != TypeLineLivre.BRUT) continue;
            resultBrut.add(lineLivrePaye);
            lineTotalBrut.addInfos(lineLivrePaye);
        }
        resultBrut.add(lineTotalBrut);
        resultBrut.add(new LineLivrePaye("", "", TypeLineLivre.BRUT));
        LineLivrePaye lineTotalCotisations = new LineLivrePaye("Total rubriques de cotisation", "", TypeLineLivre.BRUT);
        lineTotalCotisations.setSousTotal(true);
        for (LineLivrePaye lineLivrePaye : lines) {
            if (lineLivrePaye.type != TypeLineLivre.COTISATION) continue;
            String caisse = lineLivrePaye.caisse;
            if (!resultTotalCaisseCotisation.containsKey(caisse)) {
                LineLivrePaye lineSub = new LineLivrePaye("Total cotisation " + caisse, caisse, TypeLineLivre.COTISATION);
                lineSub.setSousTotal(true);
                resultTotalCaisseCotisation.put(caisse, lineSub);
            }
            resultCotisation.add(caisse, lineLivrePaye);
            ((LineLivrePaye)resultTotalCaisseCotisation.get(caisse)).addInfos(lineLivrePaye);
            lineTotalCotisations.addInfos(lineLivrePaye);
        }
        LineLivrePaye lineTotalNet = new LineLivrePaye("Total rubriques de net", "", TypeLineLivre.NET);
        lineTotalNet.setSousTotal(true);
        for (LineLivrePaye lineLivrePaye : lines) {
            if (lineLivrePaye.type != TypeLineLivre.NET) continue;
            resultNet.add(lineLivrePaye);
            lineTotalNet.addInfos(lineLivrePaye);
        }
        resultNet.add(lineTotalNet);
        resultAll.addAll(resultBrut);
        for (String caisse : resultCotisation.keySet()) {
            resultAll.addAll((Collection)resultCotisation.get(caisse));
            resultAll.add((LineLivrePaye)resultTotalCaisseCotisation.get(caisse));
            resultAll.add(new LineLivrePaye("", "", TypeLineLivre.COTISATION));
        }
        resultAll.add(lineTotalCotisations);
        resultAll.add(new LineLivrePaye("", "", TypeLineLivre.COTISATION));
        resultAll.addAll(resultNet);
        return resultAll;
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        List<LineLivrePaye> lines = this.getListeValues();
        int posLine = 1;
        int firstLine = 1;
        int nbSalPerPage = 3;
        System.err.println("NB Pages = " + Math.ceil((double)this.listSalarie.size() / (double)nbSalPerPage));
        int n = 0;
        while ((double)n < Math.ceil((double)(this.listSalarie.size() + 1) / (double)nbSalPerPage)) {
            Integer id;
            SQLRow rowSal;
            this.makeEntete(posLine);
            posLine += debutFill - 1;
            int numFirstSal = n * nbSalPerPage;
            int idSal = -1;
            int idSal2 = -1;
            int idSal3 = -1;
            if (numFirstSal < this.listSalarie.size()) {
                Integer idFirstSal = (Integer)this.listSalarie.toArray()[numFirstSal];
                idSal = idFirstSal;
                rowSal = this.tableSalarie.getRow(idFirstSal);
                this.mCell.put("B" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("B" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal == this.listSalarie.size()) {
                idSal = -100;
                System.err.println("Cumuls B");
                this.mCell.put("B" + (posLine - 3), "Cumuls");
                this.mCell.put("B" + (posLine - 2), "");
            }
            if (numFirstSal + 1 < this.listSalarie.size()) {
                id = (Integer)this.listSalarie.toArray()[numFirstSal + 1];
                idSal2 = id;
                rowSal = this.tableSalarie.getRow(id);
                this.mCell.put("D" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("D" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal + 1 == this.listSalarie.size()) {
                idSal2 = -100;
                System.err.println("Cumuls C");
                this.mCell.put("D" + (posLine - 3), "Cumuls");
                this.mCell.put("D" + (posLine - 2), "");
            }
            if (numFirstSal + 2 < this.listSalarie.size()) {
                id = (Integer)this.listSalarie.toArray()[numFirstSal + 2];
                idSal3 = id;
                rowSal = this.tableSalarie.getRow(id);
                this.mCell.put("F" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("F" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal + 2 == this.listSalarie.size()) {
                System.err.println("Cumuls D");
                idSal3 = -100;
                this.mCell.put("F" + (posLine - 3), "Cumuls");
                this.mCell.put("F" + (posLine - 2), "");
            }
            int i = 0;
            while (i < lines.size()) {
                LineLivrePaye line = lines.get(i);
                this.mapStyleRow.put(posLine, line.isSousTotal() ? "Titre 1" : "Normal");
                this.mCell.put("A" + posLine, StringUtils.limitLength(line.libelle, 55));
                this.mCell.put("B" + posLine, this.fillLine(line, idSal, false));
                this.mCell.put("C" + posLine, this.fillLine(line, idSal, true));
                this.mCell.put("D" + posLine, this.fillLine(line, idSal2, false));
                this.mCell.put("E" + posLine, this.fillLine(line, idSal2, true));
                this.mCell.put("F" + posLine, this.fillLine(line, idSal3, false));
                this.mCell.put("G" + posLine, this.fillLine(line, idSal3, true));
                ++posLine;
                ++i;
            }
            firstLine = posLine = firstLine + endFill;
            ++n;
        }
        this.nbPage = new Double(Math.ceil((double)(this.listSalarie.size() + 1) / (double)nbSalPerPage)).intValue();
        if (this.nbPage < 1) {
            this.nbPage = 1;
        }
        System.err.println("Nombre de page " + this.nbPage);
    }

    private Object fillLine(LineLivrePaye line, int numSal, boolean pat) {
        BigDecimal value;
        if (line.mapVals.containsKey(numSal)) {
            Tuple2 tuple2 = (Tuple2)line.mapVals.get(numSal);
            value = tuple2 != null ? (pat ? (BigDecimal)tuple2.get1() : (BigDecimal)tuple2.get0()) : null;
        } else if (numSal == -100) {
            value = pat ? (BigDecimal)line.totalLine.get1() : (BigDecimal)line.totalLine.get0();
        } else {
            return null;
        }
        if (value != null && value.signum() == 0) {
            return null;
        }
        return value;
    }

    private void makeEntete(int row) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + row, rowSociete.getObject("NOM"));
        this.mCell.put("G" + row, "Edition du " + this.dateFormat.format(new Date()));
        SQLRow rowMoisDu = this.tableMois.getRow(this.moisDu);
        SQLRow rowMoisAu = this.tableMois.getRow(this.moisAu);
        this.mCell.put("A" + row + 3, "P\u00e9riode de " + rowMoisDu.getString("NOM") + " \u00e0 " + rowMoisAu.getString("NOM") + " " + this.annee);
        System.err.println("MAKE ENTETE");
    }

    class LineLivrePaye
    implements Comparable<LineLivrePaye> {
        private final String libelle;
        private final String caisse;
        private final Map<Integer, Tuple2<BigDecimal, BigDecimal>> mapVals;
        private final TypeLineLivre type;
        private Tuple2<BigDecimal, BigDecimal> totalLine;
        private boolean sousTotal = false;

        public LineLivrePaye(String libelle, String caisse, TypeLineLivre type) {
            this.libelle = libelle;
            this.caisse = caisse;
            this.type = type;
            this.mapVals = new LinkedHashMap<Integer, Tuple2<BigDecimal, BigDecimal>>();
            this.totalLine = Tuple2.create(BigDecimal.ZERO, BigDecimal.ZERO);
        }

        public void setSousTotal(boolean sousTotal) {
            this.sousTotal = sousTotal;
        }

        public boolean isSousTotal() {
            return this.sousTotal;
        }

        public void cumul(SQLRowAccessor rowFicheElt, int indexSal) {
            if (!this.mapVals.containsKey(indexSal)) {
                this.mapVals.put(indexSal, Tuple2.create(BigDecimal.ZERO, BigDecimal.ZERO));
            }
            if (rowFicheElt.getObject("MONTANT_SAL_AJ") != null) {
                this.totalLine = Tuple2.create(this.totalLine.get0().add(new BigDecimal(rowFicheElt.getFloat("MONTANT_SAL_AJ"))), this.totalLine.get1());
                this.mapVals.put(indexSal, Tuple2.create(this.mapVals.get(indexSal).get0().add(new BigDecimal(rowFicheElt.getFloat("MONTANT_SAL_AJ"))), this.mapVals.get(indexSal).get1()));
            }
            if (rowFicheElt.getObject("MONTANT_SAL_DED") != null) {
                this.totalLine = Tuple2.create(this.totalLine.get0().subtract(new BigDecimal(rowFicheElt.getFloat("MONTANT_SAL_DED"))), this.totalLine.get1());
                this.mapVals.put(indexSal, Tuple2.create(this.mapVals.get(indexSal).get0().subtract(new BigDecimal(rowFicheElt.getFloat("MONTANT_SAL_DED"))), this.mapVals.get(indexSal).get1()));
            }
            if (rowFicheElt.getObject("MONTANT_PAT") != null) {
                this.totalLine = Tuple2.create(this.totalLine.get0(), this.totalLine.get1().add(new BigDecimal(rowFicheElt.getFloat("MONTANT_PAT"))));
                this.mapVals.put(indexSal, Tuple2.create(this.mapVals.get(indexSal).get0(), this.mapVals.get(indexSal).get1().add(new BigDecimal(rowFicheElt.getFloat("MONTANT_PAT")))));
            }
        }

        public void addInfos(LineLivrePaye line2Add) {
            for (Integer i : line2Add.mapVals.keySet()) {
                Tuple2<BigDecimal, BigDecimal> t = this.mapVals.get(i);
                Tuple2<BigDecimal, BigDecimal> t2 = line2Add.mapVals.get(i);
                if (t2 != null && t != null) {
                    t = Tuple2.create(t.get0().add(t2.get0()), t.get1().add(t2.get1()));
                    this.totalLine = Tuple2.create(this.totalLine.get0().add(t2.get0()), this.totalLine.get1().add(t2.get1()));
                } else if (t2 == null && t == null) {
                    t = Tuple2.create(BigDecimal.ZERO, BigDecimal.ZERO);
                } else if (t == null) {
                    t = t2;
                    this.totalLine = Tuple2.create(this.totalLine.get0().add(t2.get0()), this.totalLine.get1().add(t2.get1()));
                }
                this.mapVals.put(i, t);
            }
        }

        @Override
        public int compareTo(LineLivrePaye line2Compare) {
            if (line2Compare.type.ordinal() < this.type.ordinal()) {
                return 1;
            }
            if (line2Compare.type.ordinal() > this.type.ordinal()) {
                return -1;
            }
            int compareToIgnoreCaseCaisse = line2Compare.caisse.compareToIgnoreCase(this.caisse);
            if (compareToIgnoreCaseCaisse == 0) {
                return compareToIgnoreCaseCaisse;
            }
            return line2Compare.libelle.compareToIgnoreCase(this.libelle);
        }
    }

    private static enum TypeLineLivre {
        BRUT,
        COTISATION,
        NET;

    }
}

