/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import com.ibm.icu.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ReportingDecadeXmlSheet
extends AbstractListeSheetXml {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    public static final String TEMPLATE_ID = "ReportingDecade";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationReportingDecade";
    private final Date debut;
    private final Date fin;
    private final SQLRow rowClient;
    private final String table;
    private final SQLElementDirectory directory;
    private Date d;

    public ReportingDecadeXmlSheet(SQLElementDirectory directory, String table, Date debut, Date fin, SQLRow rowClient) {
        super(rowClient);
        this.table = table;
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.debut = debut;
        this.fin = fin;
        this.rowClient = rowClient;
        this.directory = directory;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return TEMPLATE_ID + this.d.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return TEMPLATE_ID;
    }

    @Override
    protected void createListeValues() {
        SQLElement element = this.directory.getElement(this.table);
        SQLTable tableVenteFacture = element.getTable();
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(tableVenteFacture);
        Where w = new Where((FieldRef)tableVenteFacture.getField("DATE"), this.debut, (Object)this.fin);
        w = w.and(new Where((FieldRef)tableVenteFacture.getField("ID_CLIENT"), "=", this.rowClient.getID()));
        sel.setWhere(w);
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        ArrayList<SQLRow> result = new ArrayList<SQLRow>();
        result.addAll(l);
        if (this.table.equals("SAISIE_VENTE_FACTURE")) {
            SQLSelect selAvoir = new SQLSelect();
            SQLTable tableAvoir = tableVenteFacture.getTable("AVOIR_CLIENT");
            selAvoir.addSelectStar(tableAvoir);
            Where wA = new Where((FieldRef)tableAvoir.getField("DATE"), this.debut, (Object)this.fin);
            wA = wA.and(new Where((FieldRef)tableAvoir.getField("ID_CLIENT"), "=", this.rowClient.getID()));
            selAvoir.setWhere(wA);
            List<SQLRow> executeA = SQLRowListRSH.execute(selAvoir);
            result.addAll(executeA);
        }
        long tht = 0L;
        long ttva = 0L;
        long tttc = 0L;
        ArrayList listValues = new ArrayList();
        for (SQLRow sqlRow : result) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String nom = "Facture";
            if (sqlRow.getTable().getName().equals("BON_DE_LIVRAISON")) {
                nom = "Bon de livraison";
            } else if (sqlRow.getTable().getName().equals("AVOIR_CLIENT")) {
                nom = "Avoir";
            }
            map.put("NOM", String.valueOf(nom) + " n\u00b0" + sqlRow.getString("NUMERO") + " du " + this.dateFormat.format(sqlRow.getDate("DATE").getTime()));
            String prefix = "T_";
            if (sqlRow.getTable().getName().equals("BON_DE_LIVRAISON")) {
                prefix = "TOTAL_";
            } else if (sqlRow.getTable().getName().equals("AVOIR_CLIENT")) {
                prefix = "MONTANT_";
            }
            long totalHT = sqlRow.getLong(String.valueOf(prefix) + "HT");
            long totalTVA = sqlRow.getLong(String.valueOf(prefix) + "TVA");
            long totalTTC = sqlRow.getLong(String.valueOf(prefix) + "TTC");
            if (sqlRow.getTable().getName().equals("AVOIR_CLIENT")) {
                totalHT = -totalHT;
                totalTVA = -totalTVA;
                totalTTC = -totalTTC;
            }
            tht += totalHT;
            ttva += totalTVA;
            tttc += totalTTC;
            map.put("T_HT", new BigDecimal(totalHT).movePointLeft(2));
            map.put("T_TVA", new BigDecimal(totalTVA).movePointLeft(2));
            map.put("T_TTC", new BigDecimal(totalTTC).movePointLeft(2));
            listValues.add(map);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("PERIODE", "P\u00e9riode du " + this.dateFormat.format(this.debut) + " au " + this.dateFormat.format(this.fin));
        SQLRow rowSociete = ComptaPropsConfiguration.getInstanceCompta().getRowSociete();
        values.put("SOCIETE_NOM", rowSociete.getString("NOM"));
        values.put("SOCIETE_ADRESSE", rowSociete.getForeign("ID_ADRESSE_COMMON").getString("RUE"));
        values.put("SOCIETE_VILLE", String.valueOf(rowSociete.getForeign("ID_ADRESSE_COMMON").getString("CODE_POSTAL")) + " " + rowSociete.getForeign("ID_ADRESSE_COMMON").getString("VILLE"));
        values.put("SOCIETE_TEL", rowSociete.getString("NUM_TEL"));
        values.put("SOCIETE_SIRET", rowSociete.getString("NUM_SIRET"));
        values.put("SOCIETE_TVA", rowSociete.getString("NUM_NII"));
        values.put("SOCIETE_MAIL", rowSociete.getString("MAIL"));
        values.put("CLIENT", this.rowClient.getString("NOM"));
        values.put("CLIENT_NUMERO", this.rowClient.getString("CODE"));
        SQLRow adrClient = this.rowClient.getForeign("ID_ADRESSE");
        values.put("CLIENT_ADRESSE", adrClient.getString("RUE"));
        values.put("CLIENT_VILLE", String.valueOf(adrClient.getString("CODE_POSTAL")) + " " + adrClient.getString("VILLE"));
        values.put("T_HT", new BigDecimal(tht).movePointLeft(2));
        values.put("T_TVA", new BigDecimal(ttva).movePointLeft(2));
        values.put("T_TTC", new BigDecimal(tttc).movePointLeft(2));
        values.put("DATE", new Date());
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
    }
}

