/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserSingleton;

@ThreadSafe
public abstract class UserSingletonManager<S extends UserSingleton> {
    private final String tableName;
    @GuardedBy(value="this")
    private S instance;

    public UserSingletonManager(String tableName) {
        this.tableName = tableName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    protected abstract S createInstance(SQLTable var1);

    public synchronized S setInstanceIfNone(DBRoot root) {
        if (this.instance != null) {
            return null;
        }
        return this.setInstanceFromRoot(root);
    }

    public synchronized boolean clearInstanceIfSame(S urMngr) {
        if (this.instance == urMngr) {
            this.setInstance(null);
            return true;
        }
        return false;
    }

    public S setInstanceFromRoot(DBRoot root) {
        return this.setInstance(root.findTable(this.tableName, false));
    }

    public synchronized S setInstance(SQLTable t) {
        SQLTable currentTable;
        SQLTable sQLTable = currentTable = this.instance == null ? null : this.instance.getTable();
        if (currentTable != t) {
            if (this.instance != null) {
                this.instance.destroy();
            }
            this.instance = t == null ? null : this.createInstance(t);
        }
        return this.getInstance();
    }

    public synchronized S getInstance() {
        return this.instance;
    }
}

