/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple2;

public final class UpdateScript {
    private final SQLElement elem;
    private final Map<SQLRowValues, SQLRowValues> target2source;
    private final SQLRowValues target;
    private final SQLRowValues updateRow;
    private final Map<SQLRowValues, SQLRowValues> map;
    private final SetMap<SQLElement, SQLRow> toArchive;
    private final SetMap<SQLTable, Number> toDelete;
    private SQLRowValuesCluster.StoreResult storeResult;

    UpdateScript(SQLElement element, SQLRowValues source, SQLRowValues target) {
        if (element.getTable() != target.getTable() || element.getTable() != source.getTable()) {
            throw new IllegalArgumentException("Table mismatch");
        }
        this.elem = element;
        this.target = target;
        this.target2source = new IdentityHashMap<SQLRowValues, SQLRowValues>(8);
        this.target2source.put(target, source);
        this.updateRow = new SQLRowValues(target.getTable());
        this.map = new IdentityHashMap<SQLRowValues, SQLRowValues>();
        this.map.put(target, this.getUpdateRow());
        this.toArchive = new SetMap();
        this.toDelete = new SetMap(4);
        this.storeResult = null;
    }

    public final SQLElement getElement() {
        return this.elem;
    }

    public final boolean isDone() {
        return this.storeResult != null;
    }

    private void checkNotDone() {
        this.checkDone(false);
    }

    private void checkDone() {
        this.checkDone(true);
    }

    private void checkDone(boolean done) {
        if (this.isDone() != done) {
            throw new IllegalStateException(done ? "Not yet done" : "Already done");
        }
    }

    final SQLRowValues getTarget() {
        return this.target;
    }

    final SQLRowValues getUpdateRow() {
        return this.updateRow;
    }

    final SQLRowValues getUpdateRow(SQLRowValues v) {
        if (!this.getTarget().getGraph().getItems().contains(v)) {
            throw new IllegalArgumentException("The row wasn't passed to update()");
        }
        return this.map.get(v);
    }

    final void addToArchive(SQLElement elem, SQLRowAccessor r) {
        this.checkNotDone();
        this.toArchive.add(elem, r.asRow());
    }

    public final Map<SQLElement, TreesOfSQLRows> getTreesToArchive() {
        HashMap<SQLElement, TreesOfSQLRows> res = new HashMap<SQLElement, TreesOfSQLRows>();
        for (Map.Entry e : this.toArchive.entrySet()) {
            SQLElement elem = (SQLElement)e.getKey();
            res.put(elem, new TreesOfSQLRows(elem, (Collection)e.getValue()));
        }
        return res;
    }

    final void addToDelete(SQLRowAccessor r) {
        this.checkNotDone();
        if (!r.hasID()) {
            throw new IllegalArgumentException("Nothing to delete");
        }
        this.toDelete.add(r.getTable(), r.getIDNumber());
    }

    final void put(String field, UpdateScript s) {
        this.getUpdateRow().put(field, (Object)s.getUpdateRow());
        this.add(s);
    }

    final void add(UpdateScript s) {
        assert (s.getElement().isPrivate());
        this.checkNotDone();
        s.checkNotDone();
        this.checkGraphs(s.getTarget(), s.getUpdateRow());
        this.toArchive.merge(s.toArchive);
        this.toDelete.merge(s.toDelete);
        this.map.putAll(s.map);
        this.target2source.putAll(s.target2source);
    }

    private void checkGraphs(SQLRowValues orig, SQLRowValues v) {
        if (orig.getGraph() != this.getTarget().getGraph()) {
            throw new IllegalArgumentException("Origin row not in the same graph");
        }
        if (v.getGraph() != this.getUpdateRow().getGraph()) {
            throw new IllegalArgumentException("Update row not in the same graph");
        }
    }

    final void mapRow(SQLRowValues orig, SQLRowValues v) {
        this.checkNotDone();
        if (orig == null) {
            throw new NullPointerException();
        }
        this.checkGraphs(orig, v);
        SQLRowValues prev = this.map.put(orig, v);
        assert (prev == null);
    }

    public final SQLRowValues getSource(SQLRowValues targetRow) {
        if (targetRow.getGraph() != this.getTarget().getGraph()) {
            throw new IllegalArgumentException("The row wasn't passed to update()");
        }
        return this.target2source.get(targetRow);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getUpdateRow() + " toArchive: " + this.toArchive;
    }

    public final SQLRow exec() throws SQLException {
        this.checkNotDone();
        this.storeResult = SQLUtils.executeAtomic(this.getUpdateRow().getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<SQLRowValuesCluster.StoreResult, SQLException>(){

            @Override
            public SQLRowValuesCluster.StoreResult handle(SQLDataSource ds) throws SQLException {
                return UpdateScript.this._exec();
            }
        });
        this.checkDone();
        return this.storeResult.getStoredRow(this.getUpdateRow());
    }

    private final SQLRowValuesCluster.StoreResult _exec() throws SQLException {
        SQLRowValuesCluster.StoreResult res = this.getUpdateRow().getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT);
        for (Map.Entry e : this.toArchive.entrySet()) {
            SQLElement elem = (SQLElement)e.getKey();
            elem.archive((Collection)e.getValue());
        }
        for (Map.Entry e : this.toDelete.entrySet()) {
            SQLTable t = (SQLTable)e.getKey();
            Set ids = (Set)e.getValue();
            t.getDBSystemRoot().getDataSource().execute("DELETE FROM " + t.getSQLName() + " WHERE " + new Where(t.getKey(), ids));
            for (Number id : ids) {
                t.fireRowDeleted(id.intValue());
            }
        }
        return res;
    }

    public final Tuple2<RowModifType, SQLRowValues> getStoredValues(SQLRowValues v) {
        SQLRowValues storedVals;
        this.checkDone();
        SQLRowValues updateRow = this.getUpdateRow(v);
        RowModifType res = updateRow == null ? RowModifType.NONE : (updateRow.hasID() ? RowModifType.MODIFICATION : RowModifType.INSERTION);
        SQLRowValues sQLRowValues = storedVals = res == RowModifType.NONE ? null : this.storeResult.getStoredValues(updateRow);
        assert (res == RowModifType.NONE == (storedVals == null)) : "Stored row not found";
        return Tuple2.create(res, storedVals);
    }

    public final RowModifType getModifType(SQLRow r) {
        if (((Set)this.toDelete.getNonNull(r.getTable())).contains(r.getIDNumber())) {
            return RowModifType.DELETION;
        }
        if (((Set)this.toArchive.get(this.getElement().getElement(r.getTable()))).contains(r.asRow())) {
            return RowModifType.ARCHIVAL;
        }
        return null;
    }

    public final Map<RowModifType, Integer> getModifTypesCount() {
        return this.getModifTypesCount(true, false);
    }

    public final Map<RowModifType, Integer> getModifTypesCount(boolean includeNone, boolean includeZero) {
        HashMap<RowModifType, Integer> res = new HashMap<RowModifType, Integer>();
        res.put(RowModifType.DELETION, this.toDelete.allValues().size());
        res.put(RowModifType.ARCHIVAL, this.toArchive.allValues().size());
        res.put(RowModifType.MODIFICATION, 0);
        res.put(RowModifType.INSERTION, 0);
        if (includeNone) {
            res.put(RowModifType.NONE, 0);
        }
        for (SQLRowValues v : this.getTarget().getGraph().getItems()) {
            RowModifType m = this.getStoredValues(v).get0();
            if (!includeNone && m == RowModifType.NONE) continue;
            res.put(m, (Integer)res.get((Object)m) + 1);
        }
        if (!includeZero) {
            Iterator iter = res.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                if (!((Integer)e.getValue()).equals(0)) continue;
                iter.remove();
            }
        }
        return res;
    }

    public static final class RowModifType
    extends Enum<RowModifType> {
        public static final /* enum */ RowModifType NONE = new RowModifType(false, false);
        public static final /* enum */ RowModifType INSERTION = new RowModifType(true, false);
        public static final /* enum */ RowModifType MODIFICATION = new RowModifType(true, false);
        public static final /* enum */ RowModifType ARCHIVAL = new RowModifType(false, true);
        public static final /* enum */ RowModifType UNARCHIVAL = new RowModifType(true, false);
        public static final /* enum */ RowModifType DELETION = new RowModifType(false, true);
        private final boolean rowWasStored;
        private final boolean rowWasRemoved;
        private static final /* synthetic */ RowModifType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new RowModifType[]{NONE, INSERTION, MODIFICATION, ARCHIVAL, UNARCHIVAL, DELETION};
        }

        private RowModifType(boolean rowWasStored, boolean rowWasRemoved) {
            assert (!rowWasStored || !rowWasRemoved);
            this.rowWasStored = rowWasStored;
            this.rowWasRemoved = rowWasRemoved;
        }

        public final boolean storesRow() {
            return this.rowWasStored;
        }

        public final boolean removesRow() {
            return this.rowWasRemoved;
        }

        public static RowModifType[] values() {
            RowModifType[] rowModifTypeArray = ENUM$VALUES;
            int n = rowModifTypeArray.length;
            RowModifType[] rowModifTypeArray2 = new RowModifType[n];
            System.arraycopy(ENUM$VALUES, 0, rowModifTypeArray2, 0, n);
            return rowModifTypeArray2;
        }

        public static RowModifType valueOf(String string) {
            return Enum.valueOf(RowModifType.class, string);
        }
    }
}

