/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.supplychain.stock.element.StockRootNode;
import org.openconcerto.erp.core.supplychain.stock.element.StockTreeModel;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.JTreeTable;
import org.openconcerto.ui.table.MultiLineHeaderRenderer;

public class StockConsultPanel
extends JPanel {
    private JTable tableStock;
    private StockTreeModel stockModel;
    private JLabel code = new JLabel();
    private JLabel nom = new JLabel();
    private JLabel taille = new JLabel();
    private JLabel couleur = new JLabel();
    private final boolean hasDeclinaison;

    public StockConsultPanel(SQLElement eltArt, SQLRowAccessor sqlRowAccessor) {
        super(new GridBagLayout());
        SQLPreferences prefs = SQLPreferences.getMemCached(eltArt.getTable().getDBRoot());
        this.hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Code : ", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.code, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9signation : ", 4), c);
        c.weightx = 0.0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.nom, c);
        if (this.hasDeclinaison) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Taille : ", 4), c);
            c.weightx = 0.0;
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.taille, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Couleur : ", 4), c);
            ++c.gridx;
            c.weightx = 0.0;
            c.weightx = 1.0;
            this.add((Component)this.couleur, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        this.stockModel = new StockTreeModel(new StockRootNode(eltArt.getForeignElement("ID_STOCK")));
        this.load(sqlRowAccessor);
        this.tableStock = new JTreeTable(this.stockModel);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> e = this.tableStock.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn tableColumn = e.nextElement();
            tableColumn.setHeaderRenderer(renderer);
        }
        this.tableStock.getColumnModel().getColumn(0).setWidth(260);
        this.tableStock.getColumnModel().getColumn(0).setMinWidth(200);
        if (this.tableStock.getColumnModel().getColumnCount() > 5) {
            this.tableStock.getColumnModel().getColumn(5).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value != null) {
                        value = new SimpleDateFormat("dd/MM/yyyy").format((Date)value);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
        }
        this.add((Component)new JScrollPane(this.tableStock), c);
        c.fill = 0;
        c.anchor = 14;
        JButton close = new JButton("Fermer");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(StockConsultPanel.this)).dispose();
            }
        });
        this.add((Component)close, c);
        this.setMinimumSize(new Dimension(960, 400));
        this.setPreferredSize(new Dimension(960, 400));
    }

    public void load(SQLRowAccessor article) {
        this.code.setText(article.getString("CODE"));
        this.nom.setText(article.getString("NOM"));
        if (this.hasDeclinaison) {
            SQLRowAccessor nonEmptyForeignTaille = article.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_TAILLE");
            if (nonEmptyForeignTaille != null) {
                this.taille.setText(nonEmptyForeignTaille.getString("NOM"));
            } else {
                this.taille.setText("");
            }
            SQLRowAccessor nonEmptyForeignCouleur = article.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR");
            if (nonEmptyForeignCouleur != null) {
                this.couleur.setText(nonEmptyForeignCouleur.getString("NOM"));
            } else {
                this.couleur.setText("");
            }
        }
        this.stockModel.load(article);
    }
}

