/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesLotsAction
extends CreateFrameAbstractAction {
    private final SQLRowAccessor selectedRowAccessor;
    private final SQLElementDirectory dir;

    public ListeDesLotsAction(SQLElementDirectory sqlElementDirectory, SQLRowAccessor selectedRowAccessor) {
        this.dir = sqlElementDirectory;
        this.selectedRowAccessor = selectedRowAccessor;
    }

    public JFrame createFrame() {
        final LotSQLElement element = this.dir.getElement(LotSQLElement.class);
        SQLTableModelSourceOnline tableSource = element.createTableSource();
        if (this.selectedRowAccessor != null) {
            tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    SQLSelectJoin join = input.getJoin(element.getTable().getField("ID_STOCK"));
                    input.setWhere(new Where(join.getJoinedTable().getField("ID_ARTICLE"), "=", ListeDesLotsAction.this.selectedRowAccessor.getID()));
                    return input;
                }
            });
        }
        IListFrame frame = new IListFrame(new ListeAddPanel(tableSource.getElem(), new IListe(tableSource)));
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setModifyVisible(false);
        frame.getPanel().setDeleteVisible(false);
        return frame;
    }
}

