/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TransfertStockPanel
extends JPanel {
    private static String defaultLabel = "Transfert de stock";

    public TransfertStockPanel(Configuration instance) {
        super(new GridBagLayout());
        final JButton buttonUpdate = new JButton("Mettre \u00e0 jour");
        final ReferenceArticleSQLElement articleElt = instance.getDirectory().getElement(ReferenceArticleSQLElement.class);
        final SQLRequestComboBox comboArticle = new SQLRequestComboBox();
        ComboSQLRequest createComboRequest = articleElt.createComboRequest();
        createComboRequest.putWhere("obsolete", new Where((FieldRef)articleElt.getTable().getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        comboArticle.uiInit(createComboRequest);
        SQLElement stockElt = instance.getDirectory().getElement("DEPOT_STOCK");
        final SQLRequestComboBox comboStockDepart = new SQLRequestComboBox();
        comboStockDepart.uiInit(stockElt.createComboRequest());
        final SQLRequestComboBox comboStockArrive = new SQLRequestComboBox();
        comboStockArrive.uiInit(stockElt.createComboRequest());
        final NumericTextField fieldReel = new NumericTextField();
        fieldReel.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboArticle.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboStockArrive.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboStockDepart.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        this.add((Component)new JLabel("Intitul\u00e9"), c);
        final JTextField label = new JTextField();
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)label, c);
        label.setText(defaultLabel);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Date", 4), c);
        final JDate date = new JDate(true);
        ++c.gridx;
        this.add((Component)date, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Article", 4), c);
        ++c.gridx;
        this.add((Component)comboArticle, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9part", 4), c);
        ++c.gridx;
        this.add((Component)comboStockDepart, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Arriv\u00e9e", 4), c);
        ++c.gridx;
        this.add((Component)comboStockArrive, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Quantit\u00e9", 4), c);
        ++c.gridx;
        this.add((Component)fieldReel, c);
        ++c.gridy;
        c.gridx = 0;
        JButton buttonCancel = new JButton("Annuler");
        JPanel pButton = new JPanel();
        pButton.add(buttonCancel);
        pButton.add(buttonUpdate);
        c.gridwidth = 2;
        c.anchor = 14;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)pButton, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(TransfertStockPanel.this)).dispose();
            }
        });
        buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonUpdate.setEnabled(false);
                BigDecimal qteReel = fieldReel.getValue();
                articleElt.transfert(Arrays.asList(Tuple2.create(comboArticle.getSelectedRow(), qteReel)), comboStockDepart.getSelectedRow(), comboStockArrive.getSelectedRow(), label.getText(), date.getValue());
                ((JFrame)SwingUtilities.getRoot(TransfertStockPanel.this)).dispose();
            }
        });
    }

    private void updateButtons(JButton buttonUpdate, SQLRequestComboBox comboArticle, SQLRequestComboBox comboStockDepart, SQLRequestComboBox comboStockArrive, NumericTextField fieldReel) {
        buttonUpdate.setEnabled(fieldReel.getText().trim().length() > 0 && comboArticle.getSelectedRow() != null && comboStockArrive.getSelectedRow() != null && comboStockDepart.getSelectedRow() != null && comboStockArrive.getSelectedRow().getID() != comboStockDepart.getSelectedRow().getID());
    }
}

