/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.RubriqueSQLComponent;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.report.LignePayeSimplifieeComboBox;
import org.openconcerto.erp.core.humanresources.payroll.report.LignePayeSimplifieeRowItemView;
import org.openconcerto.erp.core.humanresources.payroll.report.LigneSimplifieeCellRenderer;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NoneSelectedButtonGroup;

public class RubriqueCotisationSQLElement
extends ComptaSQLConfElement {
    public RubriqueCotisationSQLElement(DBRoot root) {
        super(root.getTable("RUBRIQUE_COTISATION"), "une rubrique de cotisation", "rubriques de cotisation");
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource res) {
        res.init();
        res.getColumn(this.getTable().getField("LIGNE_PAYE_SIMPLIFIEE")).setRenderer(new LigneSimplifieeCellRenderer());
        super._initTableSource(res);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("LIGNE_PAYE_SIMPLIFIEE");
        l.add("ID_CAISSE_COTISATION");
        l.add("BASE");
        l.add("TX_PAT");
        l.add("TX_SAL");
        l.add("BRUT");
        l.add("ID_CODE_CAISSE_TYPE_RUBRIQUE");
        l.add("ID_CODE_BASE_ASSUJETTIE");
        l.add("ID_TYPE_COMPOSANT_BASE_ASSUJETTIE");
        l.add("ID_CODE_COTISATION_INDIVIDUELLE");
        l.add("PART_CSG");
        l.add("PART_CSG_SANS_ABATTEMENT");
        l.add("IMPOSABLE");
        l.add("PART_PAT_IMPOSABLE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new RubriqueSQLComponent(this){
            private ElementComboBox selCaisseCot;
            private SQLJavaEditor formuleBase;
            private SQLJavaEditor formuleTxSal;
            private SQLJavaEditor formuleTxPat;
            {
                this.selCaisseCot = new ElementComboBox();
            }

            @Override
            protected void addViews(GridBagConstraints c) {
                c.gridx = 0;
                JLabel labelSelCaisse = new JLabel(this.getLabelFor("ID_CAISSE_COTISATION"));
                labelSelCaisse.setHorizontalAlignment(4);
                this.add((Component)labelSelCaisse, c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.selCaisseCot, c);
                c.gridwidth = 1;
                JPanel panelCalcul = new JPanel();
                panelCalcul.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                final VariableTree tree = new VariableTree();
                JScrollPane paneTree = new JScrollPane(tree);
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.fill = 1;
                cPanel.fill = 2;
                cPanel.weighty = 0.0;
                cPanel.weightx = 0.0;
                cPanel.gridheight = 1;
                ++cPanel.gridx;
                Map<String, List<?>> mapTree = VariablePayeSQLElement.getMapTree();
                this.formuleBase = new SQLJavaEditor(mapTree);
                this.formuleBase.setVarAssign("BASE");
                final JRadioButton radioBase = new JRadioButton(this.getLabelFor("BASE"));
                panelCalcul.add((Component)radioBase, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleBase), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTxSal = new SQLJavaEditor(mapTree);
                this.formuleTxSal.setVarAssign("SAL");
                JRadioButton radioTxSal = new JRadioButton(this.getLabelFor("TX_SAL"));
                panelCalcul.add((Component)radioTxSal, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTxSal), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTxPat = new SQLJavaEditor(mapTree);
                this.formuleTxPat.setVarAssign("PAT");
                final JRadioButton radioTxPat = new JRadioButton(this.getLabelFor("TX_PAT"));
                panelCalcul.add((Component)radioTxPat, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTxPat), cPanel);
                ButtonGroup group1 = new ButtonGroup();
                group1.add(radioBase);
                group1.add(radioTxPat);
                group1.add(radioTxSal);
                radioBase.setSelected(true);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                JLabel labelSelSal = new JLabel("Salari\u00e9");
                labelSelSal.setHorizontalAlignment(4);
                panelCalcul.add((Component)labelSelSal, cPanel);
                SalarieSQLElement eltSal = this.getDirectory().getElement(SalarieSQLElement.class);
                final ElementComboBox selSalarie = new ElementComboBox(false);
                ++cPanel.gridx;
                selSalarie.init(eltSal);
                panelCalcul.add((Component)selSalarie, cPanel);
                JPanel panelProp = new JPanel();
                panelProp.setLayout(new GridBagLayout());
                cPanel.gridx = 0;
                cPanel.gridy = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridwidth = 1;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                cPanel.anchor = 18;
                cPanel.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_PERIODE_VALIDITE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_PERIODE_VALIDITE");
                cPanel.gridy = 0;
                cPanel.gridx = 0;
                cPanel.gridheight = 0;
                JPanel panelPeriodeVal = new JPanel();
                panelPeriodeVal.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de validit\u00e9"));
                panelPeriodeVal.add(eltInfosPaye);
                cPanel.fill = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 1.0;
                panelProp.add((Component)panelPeriodeVal, cPanel);
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                JLabel labelSelTypeImpression = new JLabel("Impression");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeImpression, cPanel);
                SQLRequestComboBox comboSelTypeImpression = new SQLRequestComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeImpression, cPanel);
                JLabel labelEtat = new JLabel(this.getLabelFor("LIGNE_PAYE_SIMPLIFIEE"), 4);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                cPanel.fill = 2;
                panelProp.add((Component)labelEtat, cPanel);
                LignePayeSimplifieeComboBox comboEtat = new LignePayeSimplifieeComboBox();
                ++cPanel.gridx;
                cPanel.fill = 0;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboEtat, cPanel);
                this.addView(new LignePayeSimplifieeRowItemView(comboEtat), "LIGNE_PAYE_SIMPLIFIEE", (Object)"required");
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                JCheckBox checkImpo = new JCheckBox(this.getLabelFor("IMPOSABLE"));
                panelProp.add((Component)checkImpo, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                JCheckBox checkalle = new JCheckBox(this.getLabelFor("ALLEGEMENT_COTISATION"));
                panelProp.add((Component)checkalle, cPanel);
                this.addView(checkalle, "ALLEGEMENT_COTISATION", (Object)"required");
                JLabel labelSelTypePersonnel = new JLabel("Code Type Personnel URSSAF (S21.G00.23)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypePersonnel, cPanel);
                ElementComboBox comboSelTypePersonnel = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypePersonnel, cPanel);
                this.addView(comboSelTypePersonnel, "ID_CODE_CAISSE_TYPE_RUBRIQUE");
                JLabel labelSelTypeBase = new JLabel("Code Base assujettie (S21.G00.78)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeBase, cPanel);
                ElementComboBox comboSelTypeBase = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeBase, cPanel);
                this.addView(comboSelTypeBase, "ID_CODE_BASE_ASSUJETTIE");
                JLabel labelSelTypeComposant = new JLabel("Type Composant base assujettie (S21.G00.79)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeComposant, cPanel);
                ElementComboBox comboSelTypeComposant = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeComposant, cPanel);
                this.addView(comboSelTypeComposant, "ID_TYPE_COMPOSANT_BASE_ASSUJETTIE");
                JLabel labelSelCodeInd = new JLabel("Code cotisation individuelle (S21.G00.81)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelCodeInd, cPanel);
                ElementComboBox comboSelCodeInd = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelCodeInd, cPanel);
                this.addView(comboSelCodeInd, "ID_CODE_COTISATION_INDIVIDUELLE");
                JLabel labelSelCodeEta = new JLabel("Code cotisation \u00e9tablissement (S21.G00.82.002)");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelCodeEta, cPanel);
                ElementComboBox comboSelCodeEta = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelCodeEta, cPanel);
                this.addView(comboSelCodeEta, "ID_CODE_COTISATION_ETABLISSEMENT");
                ++cPanel.gridy;
                --c.gridx;
                JCheckBox checkPartPatrImposable = new JCheckBox(this.getLabelFor("PART_PAT_IMPOSABLE"));
                panelProp.add((Component)checkPartPatrImposable, cPanel);
                ++cPanel.gridy;
                JCheckBox checkPartPatr = new JCheckBox(this.getLabelFor("PART_CSG"));
                panelProp.add((Component)checkPartPatr, cPanel);
                ++cPanel.gridy;
                JCheckBox checkPartPatrSansAbattement = new JCheckBox(this.getLabelFor("PART_CSG_SANS_ABATTEMENT"));
                panelProp.add((Component)checkPartPatrSansAbattement, cPanel);
                NoneSelectedButtonGroup group = new NoneSelectedButtonGroup();
                group.add(checkPartPatrSansAbattement);
                group.add(checkPartPatr);
                ++cPanel.gridy;
                JCheckBox checkBrut = new JCheckBox(this.getLabelFor("BRUT"));
                panelProp.add((Component)checkBrut, cPanel);
                JLabel labelTiers = new JLabel(this.getLabelFor("NUMERO_COMPTE_PCE"));
                cPanel.gridx = 1;
                ++cPanel.gridy;
                JTextField fieldCompte = new JTextField();
                this.addView(fieldCompte, "NUMERO_COMPTE_PCE");
                panelProp.add((Component)labelTiers, cPanel);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)fieldCompte, cPanel);
                cPanel.weightx = 0.0;
                JLabel labelCharge = new JLabel(this.getLabelFor("NUMERO_COMPTE_PCE_CHARGES"));
                ++cPanel.gridy;
                cPanel.gridx = 1;
                panelProp.add((Component)labelCharge, cPanel);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                JTextField fieldCompteCharge = new JTextField();
                panelProp.add((Component)fieldCompteCharge, cPanel);
                this.addView(fieldCompteCharge, "NUMERO_COMPTE_PCE_CHARGES");
                JTabbedPane tab = new JTabbedPane();
                tab.add("Calcul", new JSplitPane(1, paneTree, panelCalcul));
                tab.add("Propri\u00e9t\u00e9s", panelProp);
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)tab, c);
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            TreePath path = tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof FormuleTreeNode) {
                                FormuleTreeNode n = (FormuleTreeNode)obj;
                                if (radioBase.isSelected()) {
                                    int start = formuleBase.getSelectionStart();
                                    String tmp = formuleBase.getText();
                                    formuleBase.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioTxPat.isSelected()) {
                                    int start = formuleTxPat.getSelectionStart();
                                    String tmp = formuleTxPat.getText();
                                    formuleTxPat.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else {
                                    int start = formuleTxSal.getSelectionStart();
                                    String tmp = formuleTxSal.getText();
                                    formuleTxSal.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                }
                            }
                        }
                    }
                });
                this.addRequiredSQLObject(this.selCaisseCot, "ID_CAISSE_COTISATION");
                this.addSQLObject((JComponent)((Object)this.formuleBase), "BASE");
                this.addSQLObject((JComponent)((Object)this.formuleTxPat), "TX_PAT");
                this.addSQLObject((JComponent)((Object)this.formuleTxSal), "TX_SAL");
                this.addSQLObject(checkBrut, "BRUT");
                this.addSQLObject(checkPartPatr, "PART_CSG");
                this.addSQLObject(checkPartPatrSansAbattement, "PART_CSG_SANS_ABATTEMENT");
                this.addSQLObject(checkImpo, "IMPOSABLE");
                this.addSQLObject(checkPartPatrImposable, "PART_PAT_IMPOSABLE");
                this.addRequiredSQLObject(comboSelTypeImpression, "ID_IMPRESSION_RUBRIQUE");
                selSalarie.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        formuleBase.setSalarieID(selSalarie.getSelectedId());
                        formuleTxPat.setSalarieID(selSalarie.getSelectedId());
                        formuleTxSal.setSalarieID(selSalarie.getSelectedId());
                    }
                });
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.category.subscription";
    }
}

