/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RunnableFuture;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.RowRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.view.list.ChangeAllRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumns;
import org.openconcerto.sql.view.list.SQLTableModelSourceState;
import org.openconcerto.sql.view.list.UpdateRunnable;
import org.openconcerto.sql.view.list.search.SearchOne;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public final class UpdateQueue
extends SleepingQueue {
    private final ITableModel tableModel;
    private SQLTableModelSourceState state;
    @GuardedBy(value="itself")
    private final List<ListSQLLine> fullList;
    @GuardedBy(value="fullList")
    private SQLTableModelColumns columns;
    private final TableListener tableListener;
    private boolean alwaysUpdateAll = false;
    private final IClosure<Deque<RunnableFuture<?>>> cancelClosure;

    static boolean isUpdate(RunnableFuture<?> f) {
        return UpdateQueue.isUpdate(SearchQueue.getRunnable(f));
    }

    static boolean isUpdate(Runnable r) {
        return r instanceof UpdateRunnable;
    }

    private static boolean isCancelableUpdate(Runnable r) {
        return UpdateQueue.isUpdate(r) && !(r instanceof UpdateRunnable.RmAllRunnable);
    }

    public UpdateQueue(ITableModel model) {
        super(String.valueOf(UpdateQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
        this.fullList = new ArrayList<ListSQLLine>();
        this.cancelClosure = UpdateQueue.createCancelClosure(this, new ITransformer<RunnableFuture<?>, TaskType>(){

            @Override
            public TaskType transformChecked(RunnableFuture<?> input) {
                Runnable r = SearchQueue.getRunnable(input);
                if (UpdateQueue.isCancelableUpdate(r)) {
                    return TaskType.COMPUTE;
                }
                if (r instanceof SearchQueue.SetStateRunnable) {
                    return TaskType.SET_STATE;
                }
                return TaskType.USER;
            }
        });
        this.tableListener = new TableListener();
    }

    private final ITableModel getModel() {
        return this.tableModel;
    }

    @Override
    protected void started() {
        this.addSourceListener();
        this.stateChanged(null, this.getModel().getReq().createState());
        this.put(new SearchQueue.SetStateRunnable(){

            @Override
            public void run() {
                UpdateQueue.this.getModel().startSearchQueue();
            }
        });
    }

    @Override
    protected void dying() throws Exception {
        super.dying();
        assert (this.currentlyInQueue());
        SearchQueue searchQueue = this.getModel().getSearchQueue();
        SleepingQueue.RunningState state = searchQueue.getRunningState();
        if (state == SleepingQueue.RunningState.NEW || state == SleepingQueue.RunningState.DEAD) {
            return;
        }
        if (state == SleepingQueue.RunningState.WILL_DIE || state == SleepingQueue.RunningState.DYING) {
            throw new IllegalStateException("Someone else already called die()");
        }
        try {
            searchQueue.die().get();
        }
        catch (Exception e) {
            if (searchQueue.getRunningState() != SleepingQueue.RunningState.DEAD) {
                throw e;
            }
            Log.get().log(Level.CONFIG, "Exception while killing search queue", e);
        }
        assert (searchQueue.getRunningState().compareTo(SleepingQueue.RunningState.DYING) >= 0);
        searchQueue.join();
        assert (searchQueue.getRunningState() == SleepingQueue.RunningState.DEAD);
    }

    final List<ListSQLLine> getFullList() {
        return this.fullList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tuple2<List<ListSQLLine>, SQLTableModelColumns> copyFullList() {
        Tuple2<List<ListSQLLine>, SQLTableModelColumns> res;
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            res = Tuple2.create(new ArrayList<ListSQLLine>(fullList), this.columns);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ListSQLLine getLine(Number id) {
        ListSQLLine res;
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            res = ListSQLLine.fromID(fullList, id.intValue());
        }
        return res;
    }

    protected final Set<Integer> getAffectedLines(SQLRow r) {
        HashSet<Integer> res = new HashSet<Integer>();
        this.getAffected(r, (p, l) -> {
            boolean bl = res.add(l.getID());
        });
        return res;
    }

    protected final ListMap<Path, ListSQLLine> getAffectedPaths(SQLRow r) {
        ListMap<Path, ListSQLLine> res = new ListMap<Path, ListSQLLine>();
        this.getAffected(r, res::add);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAffected(SQLRow r, BiConsumer<Path, ListSQLLine> cons) {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            final SQLTable t = r.getTable();
            int id = r.getID();
            if (id < 0) {
                throw new IllegalArgumentException("invalid ID: " + id);
            }
            if (!fullList.isEmpty()) {
                boolean keepGraph = this.getModel().getReq().getKeepMode() == ComboSQLRequest.KeepMode.GRAPH;
                SQLRowValues proto = this.getState().getReq().getGraphToFetch();
                ArrayList pathsToT = new ArrayList();
                proto.getGraph().walk(proto, pathsToT, new ITransformer<SQLRowValuesCluster.State<List<Path>>, List<Path>>(){

                    @Override
                    public List<Path> transformChecked(SQLRowValuesCluster.State<List<Path>> input) {
                        if (input.getCurrent().getTable() == t) {
                            input.getAcc().add(input.getPath());
                        }
                        return input.getAcc();
                    }
                }, RecursionType.BREADTH_FIRST, Link.Direction.ANY);
                if (!keepGraph) {
                    RowRef idRef = r.getRowRef();
                    for (ListSQLLine line : fullList) {
                        if (!line.getPKs().contains(idRef)) continue;
                        cons.accept(null, line);
                    }
                }
                for (Path p : pathsToT) {
                    SQLRowAccessor foreign;
                    String lastReferentField = SearchQueue.getLastReferentField(p);
                    RowRef foreignRef = lastReferentField != null && r.exists() ? ((foreign = r.getNonEmptyForeign(lastReferentField)) != null ? foreign.getRowRef() : null) : null;
                    if (!keepGraph && foreignRef == null) continue;
                    for (ListSQLLine line : fullList) {
                        boolean put = false;
                        if (keepGraph) {
                            for (SQLRowValues current : line.getRow().getDistantRows(p)) {
                                if (current == null || current.getID() != id) continue;
                                put = true;
                            }
                        }
                        if (!put && foreignRef != null) {
                            if (keepGraph) {
                                for (SQLRowValues current : line.getRow().getDistantRows(p.minusLast())) {
                                    if (current.getID() != foreignRef.getID().intValue()) continue;
                                    put = true;
                                }
                            } else {
                                put = line.getPKs().contains(foreignRef);
                            }
                        }
                        if (!put) continue;
                        cons.accept(p, line);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setFullList(List<ListSQLLine> tmp, SQLTableModelColumns cols) {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            fullList.clear();
            fullList.addAll(tmp);
            Collections.sort(fullList);
            if (cols != null) {
                this.columns = cols;
            }
        }
        this.tableModel.getSearchQueue().fullListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reorder(List<Integer> idsOrder) {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            for (ListSQLLine l : fullList) {
                Integer newOrder;
                if (idsOrder == null) {
                    newOrder = null;
                } else {
                    int index = idsOrder.indexOf(l.getID());
                    if (index < 0) {
                        throw new IllegalArgumentException("Missing id " + l.getID() + " in " + idsOrder);
                    }
                    newOrder = index;
                }
                l.setOrder(newOrder);
            }
            Collections.sort(fullList);
        }
        this.tableModel.getSearchQueue().orderChanged();
    }

    final void updateLine(ListSQLLine line, Path p, int valsID, SQLRowValues vals) {
        Set<Integer> modifiedCols = line.loadAt(valsID, vals, p);
        this.tableModel.getSearchQueue().changeFullList(line.getID(), line, modifiedCols, SearchOne.Mode.CHANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListSQLLine replaceLine(int id, ListSQLLine newLine) {
        SearchOne.Mode mode;
        ListSQLLine oldLine;
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            int modifiedIndex = ListSQLLine.indexFromID(fullList, id);
            ListSQLLine listSQLLine = oldLine = modifiedIndex < 0 ? null : fullList.get(modifiedIndex);
            if (modifiedIndex < 0) {
                if (newLine != null) {
                    fullList.add(newLine);
                    Collections.sort(fullList);
                    mode = SearchOne.Mode.ADD;
                } else {
                    mode = SearchOne.Mode.NO_CHANGE;
                }
            } else if (newLine != null) {
                fullList.set(modifiedIndex, newLine);
                Collections.sort(fullList);
                mode = SearchOne.Mode.CHANGE;
            } else {
                fullList.remove(modifiedIndex);
                mode = SearchOne.Mode.REMOVE;
            }
        }
        this.tableModel.getSearchQueue().changeFullList(id, newLine, null, mode);
        return oldLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getFullListSize() {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            return fullList.size();
        }
    }

    void setAlwaysUpdateAll(boolean b) {
        this.alwaysUpdateAll = b;
    }

    void stateChanged(SQLTableModelSourceState beforeState, final SQLTableModelSourceState afterState) {
        if (afterState == null) {
            throw new NullPointerException("Null state");
        }
        this.tasksDo(new IClosure<Deque<RunnableFuture<?>>>(){

            @Override
            public void executeChecked(Deque<RunnableFuture<?>> input) {
                UpdateQueue.this.put(new SearchQueue.SetStateRunnable(){

                    @Override
                    public void run() {
                        UpdateQueue.this.setState(afterState);
                    }
                });
                UpdateQueue.this.putUpdateAll();
            }
        });
    }

    protected final void setState(SQLTableModelSourceState newState) {
        if (this.state != null) {
            this.rmTableListener();
        }
        this.state = newState;
        if (this.state != null) {
            this.addTableListener();
        }
    }

    protected final SQLTableModelSourceState getState() {
        assert (this.currentlyInQueue());
        if (this.state == null) {
            throw new IllegalStateException("Not yet started");
        }
        return this.state;
    }

    @Override
    protected void willDie() {
        this.rmTableListener();
        this.removeSourceListener();
        super.willDie();
    }

    protected final void addTableListener() {
        this.getState().getReq().addTableListener(this.tableListener);
    }

    private void addSourceListener() {
        this.tableModel.getLinesSource().addListener(this.tableListener);
    }

    protected final void rmTableListener() {
        this.getState().getReq().removeTableListener(this.tableListener);
    }

    private void removeSourceListener() {
        this.tableModel.getLinesSource().rmListener(this.tableListener);
    }

    void rowModified(SQLTableEvent evt) {
        int id = evt.getId();
        if (id < 0) {
            this.putUpdateAll();
        } else if (CollectionUtils.containsAny(this.tableModel.getReq().getLineFields(), evt.getFields())) {
            this.put(evt);
        }
    }

    final Set<SQLTable> getNotForeignTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        SQLRowValues maxGraph = this.tableModel.getReq().getMaxGraph();
        maxGraph.getGraph().walk(maxGraph, res, new ITransformer<SQLRowValuesCluster.State<Set<SQLTable>>, Set<SQLTable>>(){

            @Override
            public Set<SQLTable> transformChecked(SQLRowValuesCluster.State<Set<SQLTable>> input) {
                if (input.getPath().length() == 0 || input.isBackwards()) {
                    input.getAcc().add(input.getCurrent().getTable());
                }
                return input.getAcc();
            }
        }, RecursionType.BREADTH_FIRST, Link.Direction.ANY);
        return res;
    }

    void rowAddedOrDeleted(SQLTableEvent evt) {
        if (evt.getId() < 0) {
            this.putUpdateAll();
        } else if (this.getNotForeignTables().contains(evt.getTable())) {
            this.put(evt);
        }
    }

    public final void putExternalUpdated(final String externalID, final IPredicate<ListSQLLine> affectedPredicate) {
        this.put(new Runnable(){

            @Override
            public void run() {
                UpdateQueue.this.externalUpdated(externalID, affectedPredicate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void externalUpdated(String externalID, IPredicate<ListSQLLine> affectedPredicate) {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getFullList();
        synchronized (list) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            int i = 0;
            for (SQLTableModelColumn col : this.columns.getAllColumns()) {
                if (col.getUsedExternals().contains(externalID)) {
                    indexes.add(i);
                }
                ++i;
            }
            if (indexes.isEmpty()) {
                Log.get().log(Level.INFO, "No columns use " + externalID + " in " + this);
                return;
            }
            for (ListSQLLine line : fullList) {
                if (!affectedPredicate.evaluateChecked(line)) continue;
                this.tableModel.getSearchQueue().changeFullList(line.getID(), line, indexes, SearchOne.Mode.CHANGE);
            }
        }
    }

    private void put(SQLTableEvent evt) {
        this.put(UpdateRunnable.create(this.tableModel, evt));
    }

    public void putUpdateAll() {
        this.put(UpdateRunnable.create(this.tableModel));
    }

    void putRemoveAll() {
        if (!this.isSleeping()) {
            throw new IllegalStateException("not sleeping");
        }
        this.put(UpdateRunnable.createRmAll(this, this.tableModel));
        this.setSleeping(false);
        this.putUpdateAll();
    }

    @Override
    protected void willPut(RunnableFuture<?> qr) throws InterruptedException {
        if (SearchQueue.getRunnable(qr) instanceof ChangeAllRunnable) {
            this.tasksDo(this.cancelClosure);
        }
    }

    public static final IClosure<Deque<RunnableFuture<?>>> createCancelClosure(final SleepingQueue q, final ITransformer<? super RunnableFuture<?>, TaskType> cancelablePred) {
        return new IClosure<Deque<RunnableFuture<?>>>(){

            @Override
            public void executeChecked(Deque<RunnableFuture<?>> tasks) {
                Iterator<RunnableFuture<?>> iter = tasks.descendingIterator();
                boolean needsPrevious = false;
                while (iter.hasNext() && !needsPrevious) {
                    RunnableFuture<?> current = iter.next();
                    TaskType type = (TaskType)((Object)cancelablePred.transformChecked(current));
                    needsPrevious = type.dependsOnPrevious;
                    if (!type.cancelable) continue;
                    iter.remove();
                }
                if (!needsPrevious) {
                    if (!$assertionsDisabled && iter.hasNext()) {
                        throw new AssertionError();
                    }
                    RunnableFuture<?> br = q.getBeingRun();
                    if (br != null && ((TaskType)((Object)cancelablePred.transformChecked(br))).cancelable) {
                        br.cancel(true);
                    }
                }
            }
        };
    }

    private final class TableListener
    implements SQLTableModifiedListener,
    PropertyChangeListener {
        private TableListener() {
        }

        @Override
        public void tableModified(SQLTableEvent evt) {
            if (UpdateQueue.this.alwaysUpdateAll) {
                UpdateQueue.this.putUpdateAll();
            } else if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED) {
                UpdateQueue.this.rowModified(evt);
            } else {
                UpdateQueue.this.rowAddedOrDeleted(evt);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UpdateQueue.this.stateChanged(null, UpdateQueue.this.getModel().getReq().createState());
        }
    }

    public static enum TaskType {
        USER(false, true),
        COMPUTE(true, false),
        SET_STATE(false, false);

        private final boolean cancelable;
        private final boolean dependsOnPrevious;

        private TaskType(boolean cancelable, boolean dependsOnPrevious) {
            this.cancelable = cancelable;
            this.dependsOnPrevious = dependsOnPrevious;
        }
    }
}

