/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public class TicketSheetXML
extends AbstractListeSheetXml {
    public static final String TEMPLATE_ID = "VenteFactureTicket";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private final Ticket t;
    private final ComptaPropsConfiguration conf;
    private Date d;

    public TicketSheetXML(Ticket t, ComptaPropsConfiguration conf) {
        super(null);
        this.t = t;
        this.conf = conf;
    }

    @Override
    protected void createListeValues() {
        this.mapAllSheetValues = new HashMap();
        HashMap<String, Object> mapValues = new HashMap<String, Object>();
        SQLRow rowSociete = this.conf.getRowSociete();
        mapValues.put("SOCIETE_NOM", rowSociete.getString("NOM"));
        SQLRow foreignAdr = rowSociete.getForeign("ID_ADRESSE_COMMON");
        mapValues.put("SOCIETE_RUE", foreignAdr.getString("RUE"));
        mapValues.put("SOCIETE_CODE_POSTAL", foreignAdr.getString("CODE_POSTAL"));
        mapValues.put("SOCIETE_VILLE", foreignAdr.getString("VILLE"));
        mapValues.put("SOCIETE_CODE_POSTAL_VILLE", String.valueOf(foreignAdr.getString("CODE_POSTAL")) + " " + foreignAdr.getString("VILLE"));
        mapValues.put("SOCIETE_SIRET", rowSociete.getString("NUM_SIRET"));
        mapValues.put("SOCIETE_TEL", rowSociete.getString("NUM_TEL"));
        mapValues.put("SOCIETE_TVA", rowSociete.getString("NUM_NII"));
        mapValues.put("SOCIETE_CAPITAL", Float.valueOf(rowSociete.getFloat("CAPITAL")));
        mapValues.put("SOCIETE_MAIL", rowSociete.getString("MAIL"));
        mapValues.put("SOCIETE_TYPE", rowSociete.getString("TYPE"));
        mapValues.put("SOCIETE_TYPE_CAPITAL", String.valueOf(rowSociete.getString("TYPE")) + " au capital de " + rowSociete.getFloat("CAPITAL"));
        mapValues.put("NUMERO", this.t.getReceiptCode().getCode());
        mapValues.put("CLIENT", this.t.getClient().getFullName());
        mapValues.put("ADRESSE", this.t.getClient().getAddr());
        mapValues.put("DATE", this.t.getCreationDate());
        this.mapAllSheetValues.put(0, mapValues);
        ArrayList values = new ArrayList();
        this.listAllSheetValues.put(0, values);
        this.styleAllSheetValues = new HashMap();
        HashMap<Integer, String> styles = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, styles);
        ArrayList<TicketItem> itemsToPrint = new ArrayList<TicketItem>(this.t.getItems());
        Collections.sort(itemsToPrint, new Comparator<TicketItem>(){

            @Override
            public int compare(TicketItem o1, TicketItem o2) {
                Categorie c2;
                Article p1 = o1.getArticle();
                Article p2 = o2.getArticle();
                Categorie c1 = p1.getCategorie();
                if (c1.equals(c2 = p2.getCategorie())) {
                    return p1.getName().compareTo(p2.getName());
                }
                if (c1.isUnknown()) {
                    return -1;
                }
                if (c2.isUnknown()) {
                    return 1;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        for (TicketItem item : itemsToPrint) {
            HashMap<String, Object> mapV = new HashMap<String, Object>();
            styles.put(values.size(), "Normal");
            values.add(mapV);
            Article article = item.getArticle();
            BigDecimal nb = item.getQty();
            Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
            BigDecimal tauxTVA = BigDecimal.valueOf(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
            BigDecimal ht = article.getPriceWithoutTax(nb, false);
            BigDecimal htRemise = article.getPriceWithoutTax(nb, true);
            BigDecimal ttc = article.getPriceWithTax(nb, false);
            BigDecimal ttcRemise = article.getPriceWithTax(nb, true);
            BigDecimal totalTTC = ttc.multiply(nb, DecimalUtils.HIGH_PRECISION);
            BigDecimal totalHT = tauxTVA.signum() != 0 ? totalTTC.divide(tauxTVA, DecimalUtils.HIGH_PRECISION) : totalTTC;
            BigDecimal totalTTCRemise = ttcRemise.multiply(nb, DecimalUtils.HIGH_PRECISION);
            BigDecimal totalHTRemise = tauxTVA.signum() != 0 ? totalTTCRemise.divide(tauxTVA, DecimalUtils.HIGH_PRECISION) : totalTTCRemise;
            mapV.put("NOM", item.getArticle().getName());
            mapV.put("CODE", item.getArticle().getCode());
            mapV.put("POURCENT_REMISE", item.getArticle().getDiscountPct());
            mapV.put("QTE", nb);
            mapV.put("PV_HT", ht);
            mapV.put("PV_HT_REMISE", htRemise);
            mapV.put("PV_TTC", ttc);
            mapV.put("PV_TTC_REMISE", ttcRemise);
            mapV.put("TVA", tauxFromId);
            mapV.put("T_HT", totalHT);
            mapV.put("T_TTC", totalTTC);
            mapV.put("T_HT_REMISE", totalHTRemise);
            mapV.put("T_TTC_REMISE", totalTTCRemise);
        }
        TotalCalculator calc = this.t.getTotalCalculator();
        Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> mapHtTVARowTaux = calc.getMapHtTVARowTaux();
        int tvaIndex = 1;
        for (SQLRowAccessor row : mapHtTVARowTaux.keySet()) {
            Tuple2<BigDecimal, BigDecimal> htTVA = mapHtTVARowTaux.get(row);
            float tvaTaux = TaxeCache.getCache().getTauxFromId(row.getID()).floatValue();
            BigDecimal montantTVA = htTVA.get1();
            if (montantTVA == null || montantTVA.signum() == 0) continue;
            mapValues.put("TVA_" + tvaIndex, "TVA " + tvaTaux);
            mapValues.put("T_HT_TVA_" + tvaIndex, htTVA.get0());
            mapValues.put("T_TVA_" + tvaIndex, montantTVA);
            ++tvaIndex;
        }
        mapValues.put("T_HT", calc.getTotalHT());
        mapValues.put("T_TTC", calc.getTotalTTC());
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return "FactureTicket" + this.d.getTime();
    }
}

