/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.common.ui.TotalCalculatorParameters;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class TotalPanel
extends JPanel
implements TableModelListener {
    public static String MARGE_MARQUE = "MargeMarque";
    private RowValuesTable table;
    private DeviseField textTotalHT;
    private DeviseField textTotalHTSel;
    private DeviseField textTotalTVA;
    private DeviseField textTotalTVASel;
    private DeviseField textTotalTTC;
    private DeviseField textTotalTTCSel;
    private DeviseField textPortHT;
    private DeviseField textRemiseHT;
    private DeviseField textTotalEco;
    private DeviseField textTotalEcoSel;
    private JTextField textTVAFix;
    private JTextField textPoids;
    private DeviseField textTotalDevise;
    private DeviseField textTotalDeviseSel;
    private DeviseField textService;
    private DeviseField textServiceSel;
    private DeviseField textHA;
    private DeviseField textHASel;
    private JTextField marge;
    private JTextField margeSel;
    private DeviseField textFraisDoc;
    private DeviseField textFraisDocSel;
    private boolean gestionHA = false;
    private PropertyChangeSupport supp;
    private int columnIndexEchHT = -1;
    private int columnIndexEchTTC = -1;
    private SQLTableElement ha;
    private SQLRequestComboBox selPortTVA;
    private SQLRequestComboBox selFraisDocTVA = null;
    private AcompteField facturable;
    private boolean intraComm = false;
    private boolean interfel = false;
    AbstractArticleItemTable articleTable;
    private boolean achat = false;
    private static String CLEAR = "";
    private SwingWorker<TotalCalculator, Object> worker;
    private SQLRowAccessor defaultRowCompteProduit = null;
    private SQLRowAccessor rowCatComptable = null;

    public TotalPanel(AbstractArticleItemTable articleItemTable, DeviseField textTotalEco, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, DeviseField textTotalHA, DeviseField textTotalDevise, JTextField textTotalPoids, JPanel tableEchantillon) {
        this(articleItemTable, textTotalEco, textTotalHT, textTotalTVA, textTotalTTC, textPortHT, textRemiseHT, textService, textTotalHA, textTotalDevise, textTotalPoids, tableEchantillon, null, null);
    }

    public TotalPanel(AbstractArticleItemTable articleItemTable, DeviseField textTotalEco, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, DeviseField textTotalHA, DeviseField textTotalDevise, JTextField textTotalPoids, JPanel tableEchantillon, SQLRequestComboBox selPortTva, AcompteField facturable) {
        SQLPreferences prefs;
        boolean showEco;
        this.setOpaque(false);
        this.selPortTVA = selPortTva;
        this.facturable = facturable;
        this.articleTable = articleItemTable;
        this.supp = new PropertyChangeSupport(this);
        this.table = articleItemTable.getRowValuesTable();
        this.ha = articleItemTable.getPrebilanElement() == null ? articleItemTable.getHaElement() : articleItemTable.getPrebilanElement();
        this.gestionHA = this.ha != null && articleItemTable.getQteElement() != null;
        this.textPoids = textTotalPoids == null ? new JTextField() : textTotalPoids;
        this.textTotalHT = textTotalHT;
        this.textTotalHT.setBold();
        this.textTotalEco = textTotalEco;
        this.textTotalTVA = textTotalTVA;
        this.textTotalTTC = textTotalTTC;
        this.textPortHT = textPortHT;
        this.textRemiseHT = textRemiseHT;
        this.textService = textService;
        this.textFraisDoc = new DeviseField();
        this.textTVAFix = new DeviseField();
        this.textFraisDocSel = new DeviseField();
        this.textTotalHTSel = new DeviseField(true);
        this.textServiceSel = new DeviseField();
        this.textTotalEcoSel = new DeviseField();
        this.textTotalTTCSel = new DeviseField();
        this.textTotalTVASel = new DeviseField();
        this.textHA = textTotalHA == null ? new DeviseField() : textTotalHA;
        this.textHASel = new DeviseField();
        this.marge = new JTextField();
        this.margeSel = new JTextField();
        UserRights rights = UserRightsManager.getCurrentUserRights();
        boolean showHA = rights.haveRight("CORPS_VOIR_PRIX_ACHAT");
        this.textHA.setVisible(showHA);
        this.textHASel.setVisible(showHA);
        this.marge.setVisible(showHA);
        this.margeSel.setVisible(showHA);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            this.textTotalDevise = textTotalDevise;
            this.textTotalDeviseSel = new DeviseField();
            this.reconfigure(this.textTotalDevise);
            this.reconfigure(this.textTotalDeviseSel);
        }
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalEco);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        this.reconfigure(this.textService);
        this.reconfigure(this.textHA);
        this.reconfigure(this.marge);
        this.reconfigure(this.textTotalHTSel);
        this.reconfigure(this.textFraisDoc);
        this.reconfigure(this.textTVAFix);
        this.reconfigure(this.textFraisDocSel);
        this.reconfigure(this.textTotalEcoSel);
        this.reconfigure(this.textTotalTVASel);
        this.reconfigure(this.textTotalTTCSel);
        this.reconfigure(this.textServiceSel);
        this.reconfigure(this.textHASel);
        this.reconfigure(this.margeSel);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridheight = 1;
        c.fill = 2;
        ++c.gridx;
        this.add((Component)new JLabelBold(TM.tr((String)"TotalPanel.selection", (Object[])new Object[0])), c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        if (this.gestionHA) {
            JLabel labelMarge = new JLabel(TM.tr((String)"TotalPanel.margin", (Object[])new Object[0]));
            JLabel labelHA = new JLabel(this.ha == articleItemTable.getPrebilanElement() ? TM.tr((String)"TotalPanel.estimatedBudget", (Object[])new Object[0]) : TM.tr((String)"TotalPanel.purchaseTotal.taxExcluded", (Object[])new Object[0]));
            ++c.gridy;
            this.add((Component)labelHA, c);
            labelHA.setVisible(showHA);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHASel, c);
            ++c.gridy;
            c.gridx = 1;
            c.weightx = 0.0;
            this.add((Component)labelMarge, c);
            labelMarge.setVisible(showHA);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.margeSel, c);
            ++c.gridy;
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 1;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField(), TM.tr((String)"TotalPanel.total.taxExcluded", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalHTSel, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel(TM.tr((String)"TotalPanel.service.taxExcluded", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textServiceSel, c);
        }
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelFor(textTotalTVA.getField(), TM.tr((String)"TotalPanel.total.VAT", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTVASel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelFor(textTotalDevise.getField(), TM.tr((String)"TotalPanel.currencyTotal", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalDeviseSel, c);
        }
        if (showEco = (prefs = SQLPreferences.getMemCached(this.table.getRowValuesTableModel().getSQLElement().getTable().getDBRoot())).getBoolean(AbstractVenteArticleItemTable.SHOW_TOTAL_ECO_CONTRIBUTION, false)) {
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel(TM.tr((String)"TotalPanel.ecoTax", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalEcoSel, c);
        }
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelFor(textTotalTTC.getField(), TM.tr((String)"TotalPanel.total.taxIncluded", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTTCSel, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 0;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this.createSeparator(), c);
        c.gridheight = 1;
        c.fill = 2;
        ++c.gridx;
        this.add((Component)new JLabelBold(TM.tr((String)"TotalPanel.global", (Object[])new Object[0])), c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        if (this.gestionHA) {
            JLabel labelMarge = new JLabel(TM.tr((String)"TotalPanel.margin", (Object[])new Object[0]));
            JLabel labelHA = new JLabel(this.ha == articleItemTable.getPrebilanElement() ? TM.tr((String)"TotalPanel.estimatedBudget", (Object[])new Object[0]) : TM.tr((String)"TotalPanel.purchaseTotal.taxExcluded", (Object[])new Object[0]));
            ++c.gridy;
            this.add((Component)labelHA, c);
            labelHA.setVisible(showHA);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHA, c);
            ++c.gridy;
            c.gridx = 4;
            c.weightx = 0.0;
            this.add((Component)labelMarge, c);
            labelMarge.setVisible(showHA);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.marge, c);
            ++c.gridy;
            c.gridx = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 4;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField(), TM.tr((String)"TotalPanel.total.taxExcluded", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalHT, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabelBold(TM.tr((String)"TotalPanel.service.taxExcluded", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textService, c);
        }
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTVA.getField(), TM.tr((String)"TotalPanel.total.VAT", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalTVA, c);
        c.gridwidth = 2;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelBoldFor(textTotalDevise.getField(), TM.tr((String)"TotalPanel.currencyTotal", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            textTotalDevise.setFont(textTotalHT.getFont());
            this.add((Component)textTotalDevise, c);
        }
        if (showEco) {
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel(TM.tr((String)"TotalPanel.ecoTax", (Object[])new Object[0])), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalEco, c);
        }
        c.gridwidth = 1;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTTC.getField(), TM.tr((String)"TotalPanel.total.taxIncluded", (Object[])new Object[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        textTotalTTC.setFont(textTotalHT.getFont());
        this.add((Component)textTotalTTC, c);
        this.updateTotal();
        this.table.getRowValuesTableModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TotalPanel.this.updateTotal();
            }
        });
    }

    public void setTextFraisDoc(DeviseField textFraisDoc, SQLRequestComboBox boxTVA) {
        this.textFraisDoc = textFraisDoc;
        this.selFraisDocTVA = boxTVA;
    }

    public void setTextFixTVA(JTextField textTVAFix) {
        this.textTVAFix = textTVAFix;
    }

    public void setInterfel(boolean interfel) {
        this.interfel = interfel;
        this.updateTotal();
    }

    public void setIntraComm(boolean intraComm) {
        this.intraComm = intraComm;
        this.updateTotal();
    }

    public void setAchat(boolean b) {
        this.achat = b;
    }

    private void reconfigure(JTextField field) {
        field.setEditable(false);
        field.setHorizontalAlignment(4);
        field.setBorder(null);
        field.setColumns(11);
        field.setOpaque(false);
        field.setMinimumSize(new Dimension(150, 20));
        field.setPreferredSize(new Dimension(150, 20));
        field.setBackground(UIManager.getColor("control"));
        field.setEditable(false);
        field.setEnabled(false);
        field.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTotal();
    }

    private void clearTextField() {
        if (this.textTotalDevise != null) {
            this.textTotalDevise.setText(CLEAR);
            this.textTotalDeviseSel.setText(CLEAR);
        }
        this.textPoids.setText(CLEAR);
        this.textTotalHT.setText(CLEAR);
        this.textService.setText(CLEAR);
        this.textTotalTVA.setText(CLEAR);
        this.textTotalTTC.setText(CLEAR);
        this.textTotalHTSel.setText(CLEAR);
        this.textServiceSel.setText(CLEAR);
        this.textTotalTVASel.setText(CLEAR);
        this.textTotalTTCSel.setText(CLEAR);
        if (this.gestionHA) {
            this.textHA.setText(CLEAR);
            this.marge.setText(CLEAR);
            this.textHASel.setText(CLEAR);
            this.margeSel.setText(CLEAR);
        }
    }

    public void setDefaultCompteProduit(SQLRowAccessor row) {
        this.defaultRowCompteProduit = row;
    }

    public void setCategorieComptable(SQLRowAccessor row) {
        this.rowCatComptable = row;
    }

    public void updateTotal() {
        BigDecimal tvaFix;
        SQLRowValues rowValsFraisDoc;
        SQLRow tvafraisDoc;
        BigDecimal fraisDoc;
        SQLRowValues rowValsPort;
        SQLRow tvaPort;
        BigDecimal valPortHT;
        this.clearTextField();
        List<SQLRowValues> vals = this.articleTable.getRowValuesAtLevel(1);
        final ArrayList<SQLRowValues> list = new ArrayList<SQLRowValues>(vals.size());
        final HashMap<SQLRowValues, Integer> indexRowNiveau1 = new HashMap<SQLRowValues, Integer>();
        for (SQLRowValues sqlRowValues : vals) {
            SQLRowValues asRowValues = sqlRowValues.asRowValues();
            list.add(asRowValues);
            indexRowNiveau1.put(asRowValues, this.table.getRowValuesTableModel().row2index(sqlRowValues));
        }
        final TotalCalculatorParameters params = new TotalCalculatorParameters(list);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        final int[] selectedRows = this.table.getSelectedRows();
        final long valRemiseHT = this.textRemiseHT.getText().trim().length() > 0 ? (!this.textRemiseHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textRemiseHT.getText().trim()) : 0L) : 0L;
        params.setRemiseHT(valRemiseHT);
        if (this.textPortHT.getText().trim().length() > 0) {
            if (!this.textPortHT.getText().trim().equals("-")) {
                long p = GestionDevise.parseLongCurrency(this.textPortHT.getText().trim());
                valPortHT = new BigDecimal(p).movePointLeft(2);
            } else {
                valPortHT = BigDecimal.ZERO;
            }
        } else {
            valPortHT = BigDecimal.ZERO;
        }
        params.setPortHT(valPortHT);
        SQLRow sQLRow = tvaPort = this.selPortTVA == null ? null : this.selPortTVA.getSelectedRow();
        if (tvaPort != null && valPortHT.signum() != 0 && !tvaPort.isUndefined()) {
            rowValsPort = new SQLRowValues(this.articleTable.getSQLElement().getTable());
            rowValsPort.put(this.articleTable.getPrixTotalHTElement().getField().getName(), valPortHT);
            rowValsPort.put("QTE", 1);
            rowValsPort.put("ID_TAXE", tvaPort.getIDNumber());
            SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
            SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
            SQLRow rowDefaultCptPort = null;
            float tauxP = TaxeCache.getCache().getTauxFromId(tvaPort.getID()).floatValue();
            if (this.achat) {
                if (tauxP > 0.0f) {
                    rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_SOUMIS_ACHAT");
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortAchatSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_NON_SOUMIS_ACHAT");
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortAchatNonSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (tauxP > 0.0f) {
                rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_SOUMIS");
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_NON_SOUMIS");
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteNonSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            SQLRowValues putRowValues = rowValsPort.putRowValues("ID_ARTICLE");
            if (rowDefaultCptPort != null) {
                putRowValues.put("ID_COMPTE_PCE", rowDefaultCptPort.getID());
                putRowValues.put("ID_COMPTE_PCE_ACHAT", rowDefaultCptPort.getID());
            }
        } else {
            rowValsPort = null;
        }
        if (this.textFraisDoc.getText().trim().length() > 0) {
            if (!this.textFraisDoc.getText().trim().equals("-")) {
                long p = GestionDevise.parseLongCurrency(this.textFraisDoc.getText().trim());
                fraisDoc = new BigDecimal(p).movePointLeft(2);
            } else {
                fraisDoc = BigDecimal.ZERO;
            }
        } else {
            fraisDoc = BigDecimal.ZERO;
        }
        SQLRow sQLRow2 = tvafraisDoc = this.selFraisDocTVA == null ? null : this.selFraisDocTVA.getSelectedRow();
        if (tvafraisDoc != null && fraisDoc.signum() != 0 && !tvafraisDoc.isUndefined()) {
            rowValsFraisDoc = new SQLRowValues(this.articleTable.getSQLElement().getTable());
            rowValsFraisDoc.put(this.articleTable.getPrixTotalHTElement().getField().getName(), fraisDoc);
            rowValsFraisDoc.put("QTE", 1);
            rowValsFraisDoc.put("ID_TAXE", tvafraisDoc.getIDNumber());
            rowValsFraisDoc.put("SERVICE", Boolean.TRUE);
        } else {
            rowValsFraisDoc = null;
        }
        if (this.textTVAFix.getText().trim().length() > 0) {
            if (!this.textTVAFix.getText().trim().equals("-")) {
                long p = GestionDevise.parseLongCurrency(this.textTVAFix.getText().trim());
                tvaFix = new BigDecimal(p).movePointLeft(2);
            } else {
                tvaFix = BigDecimal.ZERO;
            }
        } else {
            tvaFix = BigDecimal.ZERO;
        }
        final Boolean isServiceActive = bServiceActive;
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<TotalCalculator, Object>(){

            @Override
            protected TotalCalculator doInBackground() throws Exception {
                BigDecimal totalHTAvtremise;
                Thread.sleep(100L);
                params.fetchArticle();
                SQLTableElement tableElementTotalDevise = TotalPanel.this.articleTable.getTableElementTotalDevise();
                String fieldDevise = tableElementTotalDevise == null ? null : tableElementTotalDevise.getField().getName();
                SQLTableElement tableElementTotalHA = TotalPanel.this.articleTable.getPrebilanElement() == null ? TotalPanel.this.articleTable.getTotalHaElement() : TotalPanel.this.articleTable.getPrebilanElement();
                String fieldHA = tableElementTotalHA == null ? null : tableElementTotalHA.getField().getName();
                SQLTableElement tableElementTotalHT = TotalPanel.this.articleTable.getPrixTotalHTElement();
                String fieldHT = tableElementTotalHT == null ? null : tableElementTotalHT.getField().getName();
                TotalCalculator calc = new TotalCalculator(fieldHA, fieldHT, fieldDevise, TotalPanel.this.achat, null, TotalPanel.this.rowCatComptable);
                calc.setIntraComm(TotalPanel.this.intraComm);
                calc.setInterfel(TotalPanel.this.interfel);
                if (TotalPanel.this.defaultRowCompteProduit != null) {
                    calc.setRowDefaultCptProduit(TotalPanel.this.defaultRowCompteProduit);
                }
                calc.setSelectedRows(selectedRows);
                int size = list.size();
                calc.setServiceActive(isServiceActive);
                if (valRemiseHT != 0L) {
                    int i = 0;
                    while (i < size) {
                        SQLRowValues rowVals = (SQLRowValues)list.get(i);
                        calc.addLine(rowVals, params.getMapArticle().get(rowVals.getForeignID("ID_ARTICLE")), i, false);
                        ++i;
                    }
                    totalHTAvtremise = calc.getTotalHT();
                } else {
                    totalHTAvtremise = BigDecimal.ZERO;
                }
                calc.initValues();
                calc.setSelectedRows(selectedRows);
                long valRemiseHTReel = valRemiseHT;
                if (TotalPanel.this.facturable != null && TotalPanel.this.facturable.getValue() != null) {
                    if (TotalPanel.this.facturable.getValue().getMontant() != null && TotalPanel.this.facturable.getValue().getMontant().signum() > 0) {
                        valRemiseHTReel = 0L;
                    } else if (TotalPanel.this.facturable.getValue().getPercent() != null && TotalPanel.this.facturable.getValue().getPercent().signum() > 0) {
                        valRemiseHTReel = TotalPanel.this.facturable.getValue().getPercent().movePointLeft(2).multiply(new BigDecimal(valRemiseHT)).setScale(0, RoundingMode.HALF_UP).longValue();
                    }
                }
                calc.setRemise(valRemiseHTReel, totalHTAvtremise);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                int rowCount = size;
                int i = 0;
                while (i < rowCount) {
                    SQLRowValues values;
                    Object id = (values = (SQLRowValues)list.get(i)).getObject("ID_ARTICLE");
                    calc.addLine(values, id == null ? null : params.getMapArticle().get(id), (Integer)indexRowNiveau1.get(values), i == rowCount - 1);
                    ++i;
                }
                if (rowValsPort != null) {
                    calc.addLine(rowValsPort, rowValsPort.getForeign("ID_ARTICLE"), -1, false);
                }
                if (rowValsFraisDoc != null) {
                    calc.addLine(rowValsFraisDoc, null, -1, false);
                }
                calc.addTVAAdjust(tvaFix);
                calc.checkResult();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                return calc;
            }

            @Override
            protected void done() {
                if (this.isCancelled() || TotalPanel.this.worker != this) {
                    return;
                }
                try {
                    TotalCalculator calc = (TotalCalculator)this.get();
                    BigDecimal totalHT = calc.getTotalHT();
                    if (TotalPanel.this.textTotalDevise != null) {
                        TotalPanel.this.textTotalDevise.setText(GestionDevise.currencyToString(calc.getTotalDevise().setScale(2, RoundingMode.HALF_UP)));
                        TotalPanel.this.textTotalDeviseSel.setText(GestionDevise.currencyToString(calc.getTotalDeviseSel().setScale(2, RoundingMode.HALF_UP)));
                    }
                    TotalPanel.this.textPoids.setText(String.valueOf(calc.getTotalPoids()));
                    TotalPanel.this.textTotalEco.setText(GestionDevise.currencyToString(calc.getTotalEco()));
                    TotalPanel.this.textTotalEcoSel.setText(GestionDevise.currencyToString(calc.getTotalEcoSel()));
                    TotalPanel.this.textTotalHT.setText(GestionDevise.currencyToString(totalHT));
                    TotalPanel.this.textService.setText(GestionDevise.currencyToString(calc.getTotalService().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTVA.setText(GestionDevise.currencyToString(calc.getTotalTVA().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTTC.setText(GestionDevise.currencyToString(calc.getTotalTTC().setScale(2, RoundingMode.HALF_UP)));
                    BigDecimal totalHTSel = calc.getTotalHTSel();
                    TotalPanel.this.textTotalHTSel.setText(GestionDevise.currencyToString(totalHTSel.setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textServiceSel.setText(GestionDevise.currencyToString(calc.getTotalServiceSel().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTVASel.setText(GestionDevise.currencyToString(calc.getTotalTVASel().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTTCSel.setText(GestionDevise.currencyToString(calc.getTotalTTCSel().setScale(2, RoundingMode.HALF_UP)));
                    if (TotalPanel.this.gestionHA) {
                        BigDecimal totalHA = calc.getTotalHA();
                        TotalPanel.this.textHA.setText(GestionDevise.currencyToString(totalHA.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal m = BigDecimal.ZERO;
                        BigDecimal d = BigDecimal.ZERO;
                        d = totalHT.subtract(totalHA);
                        if (DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) && totalHT.signum() != 0) {
                            m = d.divide(totalHT, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        } else if (totalHA.signum() != 0) {
                            m = d.divide(totalHA, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        }
                        if (d.compareTo(BigDecimal.ZERO) <= 0) {
                            TotalPanel.this.marge.setForeground(Color.red);
                            TotalPanel.this.marge.setDisabledTextColor(Color.RED);
                        } else {
                            TotalPanel.this.marge.setForeground(TotalPanel.this.textTotalTTC.getForeground());
                            TotalPanel.this.marge.setDisabledTextColor(TotalPanel.this.textTotalTTC.getForeground());
                        }
                        TotalPanel.this.marge.setText("(" + m.setScale(2, RoundingMode.HALF_UP) + "%) " + GestionDevise.currencyToString(d.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal totalHASel = calc.getTotalHASel();
                        TotalPanel.this.textHASel.setText(GestionDevise.currencyToString(totalHASel.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal m2 = BigDecimal.ZERO;
                        BigDecimal e = BigDecimal.ZERO;
                        e = totalHTSel.subtract(totalHASel);
                        if (DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) && totalHTSel.signum() != 0) {
                            m2 = e.divide(totalHTSel, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        } else if (totalHASel.signum() != 0) {
                            m2 = e.divide(totalHASel, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        }
                        TotalPanel.this.margeSel.setText("(" + m2.setScale(2, RoundingMode.HALF_UP) + "%) " + GestionDevise.currencyToString(e.setScale(2, RoundingMode.HALF_UP)));
                        if (e.compareTo(BigDecimal.ZERO) <= 0) {
                            TotalPanel.this.margeSel.setForeground(Color.red);
                            TotalPanel.this.margeSel.setDisabledTextColor(Color.RED);
                        } else {
                            TotalPanel.this.margeSel.setForeground(TotalPanel.this.textTotalTTC.getForeground());
                            TotalPanel.this.margeSel.setDisabledTextColor(TotalPanel.this.textTotalTTC.getForeground());
                        }
                    }
                    TotalPanel.this.supp.firePropertyChange("value", null, null);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("", e1);
                }
            }
        };
        this.worker.execute();
    }

    public long getTotalHT() {
        return GestionDevise.parseLongCurrency(this.textTotalHT.getText());
    }

    private static final JLabel getLabelFor(SQLField field, String defaultLabel) {
        if (field == null) {
            return new JLabel(defaultLabel);
        }
        return new JLabel(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private static final JLabel getLabelBoldFor(SQLField field, String defaultLabel) {
        if (field == null) {
            return new JLabelBold(defaultLabel);
        }
        return new JLabelBold(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    public void addValueListener(PropertyChangeListener listener) {
        this.supp.addPropertyChangeListener(listener);
    }

    public void removeValueListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }

    private final JSeparator createSeparator() {
        JSeparator sep = new JSeparator(0);
        DefaultGridBagConstraints.lockMinimumSize(sep);
        return sep;
    }
}

