/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import com.zimbra.common.util.BEncoding;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.text.CSVReader;

public class ExtractFromBEncoding {
    private static final boolean OVERWRITE_FILE = Boolean.getBoolean("overwrite");
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"", 16);
    private static final Pattern SINGLE_QUOTED_ENCODEDWORD_PATTERN = Pattern.compile("'(=\\?.+?\\?=)'");

    public static void main(String[] args) throws IOException, BEncoding.BEncodingException, ParseException {
        if (args.length == 0) {
            System.out.println("Load a CSV file and replace some {@link BEncoding zimbra benconded map} columns by some of their toplevel values");
            System.out.println("The bencoded colums are removed and the new columns are added at the end");
            System.out.println("inputFile outputFile [bencodedIndex key1:label1,key2:label2,...]...");
            System.exit(1);
        }
        Path in = Paths.get(args[0], new String[0]);
        Path out = Paths.get(args[1], new String[0]);
        if (Files.exists(out, new LinkOption[0]) && Files.isSameFile(in, out)) {
            throw new IllegalArgumentException("Same file");
        }
        ArrayList<ExtractInfo> extractInfos = new ArrayList<ExtractInfo>();
        HashSet<Integer> indexes = new HashSet<Integer>();
        int i = 2;
        while (i < args.length) {
            int index = Integer.parseInt(args[i]);
            if (!indexes.add(index)) {
                throw new IllegalArgumentException("Duplicate index " + index);
            }
            String[] keys = args[i + 1].split(",");
            extractInfos.add(new ExtractInfo(index, keys));
            i += 2;
        }
        System.out.println("From " + in + " to " + out);
        int lines = ExtractFromBEncoding.replace(in, out, extractInfos);
        System.out.println("Processed " + lines + " line(s)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int replace(Path in, Path out, List<ExtractInfo> extractInfos) throws IOException, ParseException, BEncoding.BEncodingException {
        OpenOption[] openOptionArray;
        if (extractInfos.isEmpty()) {
            CopyOption[] copyOptionArray;
            if (OVERWRITE_FILE) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            Files.copy(in, out, copyOptionArray);
            return 0;
        }
        int totalLines = 0;
        if (OVERWRITE_FILE) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.TRUNCATE_EXISTING;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[1];
            openOptionArray = openOptionArray3;
            openOptionArray3[0] = StandardOpenOption.CREATE_NEW;
        }
        OpenOption[] openOptions = openOptionArray;
        StringBuilder sb = new StringBuilder(512);
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            CSVReader r = new CSVReader(Files.newBufferedReader(in), ',', '\"', '\\', 0, true);
            try {
                try (BufferedWriter w = Files.newBufferedWriter(out, openOptions);){
                    String[] line = r.readNext();
                    int itemsCount = line.length;
                    int additionalCols = 0;
                    ArrayList<String> listToWrite = new ArrayList<String>(itemsCount);
                    listToWrite.addAll(Arrays.asList(line));
                    for (ExtractInfo e : extractInfos) {
                        listToWrite.remove(e.getFieldIndex());
                        for (String n : e.getNames()) {
                            listToWrite.add(n);
                        }
                        additionalCols += e.getKeys().size() - 1;
                    }
                    int outputColCount = itemsCount + additionalCols;
                    ExtractFromBEncoding.writeCSV(sb, listToWrite, outputColCount);
                    w.append(sb);
                    while ((line = r.readNext()) != null) {
                        ++totalLines;
                        if (itemsCount != line.length) {
                            throw new IllegalStateException("Expected " + itemsCount + " items but got " + line.length + " : " + Arrays.asList(line));
                        }
                        listToWrite.clear();
                        listToWrite.addAll(Arrays.asList(line));
                        for (ExtractInfo e : extractInfos) {
                            String item = line[e.getFieldIndex()];
                            if (item.startsWith("=?")) {
                                item = MimeUtility.decodeWord((String)item);
                            }
                            Map bdecoded = (Map)BEncoding.decode((String)item);
                            listToWrite.remove(e.getFieldIndex());
                            for (String key : e.getKeys()) {
                                String itemToWrite;
                                Object val = bdecoded.get(key);
                                if (val == null) {
                                    itemToWrite = null;
                                } else {
                                    String toParse = val.toString();
                                    if (toParse.contains("'=?")) {
                                        toParse = SINGLE_QUOTED_ENCODEDWORD_PATTERN.matcher(toParse).replaceAll("\"$1\"");
                                    }
                                    InternetAddress[] mimeDecoded = InternetAddress.parseHeader((String)toParse, (boolean)false);
                                    itemToWrite = CollectionUtils.join(Arrays.asList(mimeDecoded), ", ", InternetAddress::toUnicodeString);
                                }
                                listToWrite.add(itemToWrite);
                            }
                        }
                        ExtractFromBEncoding.writeCSV(sb, listToWrite, outputColCount);
                        w.append(sb);
                    }
                }
                if (r == null) return totalLines;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (r == null) throw throwable;
                r.close();
                throw throwable;
            }
            r.close();
            return totalLines;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void writeCSV(StringBuilder sb, List<String> l, int outputColCount) {
        if (l.size() != outputColCount) {
            throw new IllegalStateException("Wrong column count");
        }
        sb.setLength(0);
        for (String i : l) {
            if (i == null) {
                sb.append("\\N");
            } else {
                sb.append('\"');
                sb.append(DOUBLE_QUOTE_PATTERN.matcher(i).replaceAll("\"\""));
                sb.append('\"');
            }
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, '\n');
    }

    public static final class ExtractInfo {
        private final int fieldIndex;
        private final List<String> keys;
        private final List<String> names;

        public ExtractInfo(int fieldIndex, String[] keysAndNames) {
            this.fieldIndex = fieldIndex;
            ArrayList<String> keys = new ArrayList<String>(keysAndNames.length);
            ArrayList<String> names = new ArrayList<String>(keysAndNames.length);
            String[] stringArray = keysAndNames;
            int n = keysAndNames.length;
            int n2 = 0;
            while (n2 < n) {
                String kAn = stringArray[n2];
                int colonIndex = kAn.indexOf(58);
                keys.add(kAn.substring(0, colonIndex));
                names.add(kAn.substring(colonIndex + 1));
                ++n2;
            }
            this.keys = Collections.unmodifiableList(keys);
            this.names = Collections.unmodifiableList(names);
            assert (this.keys.size() > 0 && this.keys.size() == this.names.size());
        }

        public final int getFieldIndex() {
            return this.fieldIndex;
        }

        public final List<String> getKeys() {
            return this.keys;
        }

        public final List<String> getNames() {
            return this.names;
        }
    }
}

