/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.state.ListenerXMLStateManager;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JTableStateManager
extends ListenerXMLStateManager<JTable, AncestorListener> {
    private static final String VERSION = "20100810";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String MODEL_INDEX_ATTR = "modelIndex";
    private static final String SORT_ATTR = "sort";

    public JTableStateManager(JTable table) {
        this(table, (File)null);
    }

    public JTableStateManager(JTable table, File f) {
        this(table, f, f != null);
    }

    public JTableStateManager(JTable table, File f, boolean autosave) {
        super(table, f, autosave);
    }

    @Override
    protected AncestorListener createListener() {
        return new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                try {
                    JTableStateManager.this.saveState();
                }
                catch (IOException e) {
                    ExceptionHandler.handle((Component)JTableStateManager.this.getSrc(), TM.tr("saveColumnsWidth", new Object[0]), e);
                }
            }
        };
    }

    @Override
    protected void addListener(AncestorListener l) {
        ((JTable)this.getSrc()).addAncestorListener(l);
    }

    @Override
    protected void rmListener(AncestorListener l) {
        ((JTable)this.getSrc()).removeAncestorListener(l);
    }

    @Override
    protected void writeState(File out) throws IOException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Couldn't create builder", e);
        }
        Document doc = builder.newDocument();
        Element elem = doc.createElement("liste");
        elem.setAttribute("version", VERSION);
        doc.appendChild(elem);
        TableColumnModel model = ((JTable)this.getSrc()).getColumnModel();
        XTableColumnModel visibilityModel = model instanceof XTableColumnModel ? (XTableColumnModel)model : null;
        TableModel tModel = ((JTable)this.getSrc()).getModel();
        if (visibilityModel != null) {
            for (TableColumn col : visibilityModel.getColumns(false)) {
                this.writeCol(elem, col, tModel).setAttribute("visible", String.valueOf(visibilityModel.isColumnVisible(col)));
            }
        } else {
            int nCol = ((JTable)this.getSrc()).getColumnCount();
            int i = 0;
            while (i < nCol) {
                TableColumn col = model.getColumn(i);
                this.writeCol(elem, col, tModel);
                ++i;
            }
        }
        if (tModel instanceof TableSorter) {
            TableSorter sorter = (TableSorter)tModel;
            Element sortingColsElem = doc.createElement("sortingColumns");
            elem.appendChild(sortingColsElem);
            for (TableSorter.Directive d : sorter.getSortingColumns()) {
                TableColumn col;
                Element colElem = doc.createElement("sortCol");
                sortingColsElem.appendChild(colElem);
                if (visibilityModel != null) {
                    col = visibilityModel.getColumnByModelIndex(d.getColumn());
                    if (col == null) {
                        Log.get().warning("null column in visibilityModel column : " + d.getColumn());
                    }
                } else {
                    col = model.getColumn(((JTable)this.getSrc()).convertColumnIndexToView(d.getColumn()));
                    if (col == null) {
                        Log.get().warning("null column in model for : " + ((JTable)this.getSrc()).convertColumnIndexToView(d.getColumn()));
                    }
                }
                if (col == null) continue;
                colElem.setAttribute(IDENTIFIER_ATTR, String.valueOf(col.getIdentifier()));
                int status = d.getDirection();
                this.setSortAttribute(colElem, status);
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(elem), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IOException("Couldn't output " + doc, e);
        }
    }

    private Element writeCol(Element elem, TableColumn col, TableModel tModel) {
        Element res = elem.getOwnerDocument().createElement("col");
        elem.appendChild(res);
        int min = col.getMinWidth();
        int max = col.getMaxWidth();
        int width = col.getWidth();
        res.setAttribute("min", String.valueOf(min));
        res.setAttribute("max", String.valueOf(max));
        res.setAttribute("width", String.valueOf(width));
        res.setAttribute(IDENTIFIER_ATTR, String.valueOf(col.getIdentifier()));
        res.setAttribute(MODEL_INDEX_ATTR, String.valueOf(col.getModelIndex()));
        return res;
    }

    protected final void setSortAttribute(Element res, int status) {
        if (status == 1) {
            res.setAttribute(SORT_ATTR, "ascending");
        } else if (status == -1) {
            res.setAttribute(SORT_ATTR, "descending");
        }
    }

    protected final int getSortAttribute(NamedNodeMap attrs) {
        Node sortNode = attrs.getNamedItem(SORT_ATTR);
        if (sortNode != null) {
            String sort = sortNode.getNodeValue();
            if (sort.equals("ascending")) {
                return 1;
            }
            if (sort.equals("descending")) {
                return -1;
            }
            Log.get().log(Level.INFO, "ignore unknown sort value : {0}", sort);
        }
        return 0;
    }

    @Override
    protected boolean readState(Document doc) {
        NodeList listOfCol = doc.getElementsByTagName("col");
        TableColumnModel model = ((JTable)this.getSrc()).getColumnModel();
        XTableColumnModel visibilityModel = model instanceof XTableColumnModel ? (XTableColumnModel)model : null;
        List<TableColumn> uiCols = visibilityModel != null ? visibilityModel.getColumns(false) : Collections.list(model.getColumns());
        int modelColsCount = uiCols.size();
        int colsCount = listOfCol.getLength();
        String docVersion = doc.getDocumentElement().getAttribute("version");
        if (!VERSION.equals(docVersion)) {
            Log.get().info("wrong version :" + docVersion + " != " + VERSION);
        } else if (modelColsCount != colsCount) {
            Log.get().info("saved cols :" + colsCount + " != actual cols: " + modelColsCount);
        } else if (!this.checkIdentifiers(listOfCol, uiCols)) {
            Log.get().info("column identifiers differ");
        } else {
            if (visibilityModel != null) {
                int i = 0;
                while (i < colsCount) {
                    visibilityModel.setColumnVisible(visibilityModel.getColumn(i, false), true);
                    ++i;
                }
            }
            TableModel tModel = ((JTable)this.getSrc()).getModel();
            ArrayList<TableColumn> invisibleCols = new ArrayList<TableColumn>();
            int i = 0;
            while (i < colsCount) {
                NamedNodeMap attrs = listOfCol.item(i).getAttributes();
                int modelIndex = Integer.parseInt(attrs.getNamedItem(MODEL_INDEX_ATTR).getNodeValue());
                model.moveColumn(((JTable)this.getSrc()).convertColumnIndexToView(modelIndex), i);
                TableColumn modelCol = model.getColumn(i);
                String smin = attrs.getNamedItem("min").getNodeValue();
                int min = Integer.parseInt(smin);
                if (min < 10) {
                    min = 10;
                }
                modelCol.setMinWidth(min);
                String smax = attrs.getNamedItem("max").getNodeValue();
                int max = Integer.parseInt(smax);
                modelCol.setMaxWidth(max);
                String ssize = attrs.getNamedItem("width").getNodeValue();
                int size = Integer.parseInt(ssize);
                if (size < 10) {
                    size = 15;
                }
                modelCol.setWidth(size);
                modelCol.setPreferredWidth(size);
                Node visible = attrs.getNamedItem("visible");
                if (visible != null && !Boolean.parseBoolean(visible.getNodeValue())) {
                    invisibleCols.add(modelCol);
                }
                ++i;
            }
            NodeList listOfSortCol = doc.getElementsByTagName("sortCol");
            int sortColCount = listOfSortCol.getLength();
            if (tModel instanceof TableSorter && sortColCount > 0) {
                ArrayList<TableSorter.Directive> sortingCols = new ArrayList<TableSorter.Directive>();
                int i2 = 0;
                while (i2 < sortColCount) {
                    block20: {
                        int colIndex;
                        NamedNodeMap attrs = listOfSortCol.item(i2).getAttributes();
                        String colID = attrs.getNamedItem(IDENTIFIER_ATTR).getNodeValue();
                        try {
                            colIndex = model.getColumnIndex(colID);
                        }
                        catch (Exception e) {
                            Log.get().log(Level.INFO, "ignore unknown identifier : " + colID, e);
                            break block20;
                        }
                        int modelIndex = model.getColumn(colIndex).getModelIndex();
                        int direction = this.getSortAttribute(attrs);
                        if (direction == 0) {
                            Log.get().info("ignore sort value for column " + colID);
                        } else {
                            sortingCols.add(new TableSorter.Directive(modelIndex, direction));
                        }
                    }
                    ++i2;
                }
                ((TableSorter)tModel).setSortingColumns(sortingCols);
            }
            if (visibilityModel != null) {
                for (TableColumn toRm : invisibleCols) {
                    visibilityModel.setColumnVisible(toRm, false);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkIdentifiers(NodeList listOfCol, List<TableColumn> uiCols) {
        int colsCount = listOfCol.getLength();
        int i = 0;
        while (i < colsCount) {
            NamedNodeMap attrs = listOfCol.item(i).getAttributes();
            int modelIndex = Integer.parseInt(attrs.getNamedItem(MODEL_INDEX_ATTR).getNodeValue());
            String xmlID = attrs.getNamedItem(IDENTIFIER_ATTR).getNodeValue();
            String uiID = String.valueOf(uiCols.get(modelIndex).getIdentifier());
            if (!uiID.equals(xmlID)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

