/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.MultipleSQLSelectExecutor;
import org.openconcerto.utils.ExceptionHandler;

public class UndefinedRowValuesCache {
    private static final UndefinedRowValuesCache instance = new UndefinedRowValuesCache();
    private final Map<SQLTable, SQLRowValues> map = new HashMap<SQLTable, SQLRowValues>();

    public static synchronized UndefinedRowValuesCache getInstance() {
        return instance;
    }

    private final SQLElementDirectory getDirectory() {
        return Configuration.getInstance().getDirectory();
    }

    public SQLRowValues getDefaultRowValues(SQLTable t) {
        SQLRowValues rv = this.map.get(t);
        if (rv == null) {
            rv = new SQLRowValues(t);
            SQLRow undefRow = t.getRow(t.getUndefinedID());
            if (undefRow == null) {
                Log.get().warning(t.getSQLName() + " doesn't contain undef ID " + t.getUndefinedID());
            } else {
                this.getDirectory().getElement(t).loadAllSafe(rv, undefRow);
            }
            this.map.put(t, rv);
        }
        return rv;
    }

    public void setDefaultRowValues(SQLRowValues rowVals) {
        this.map.put(rowVals.getTable(), rowVals);
    }

    public void preload(List<SQLTable> tablesToCache) {
        if (tablesToCache.size() <= 0) {
            throw new IllegalArgumentException("Empty list");
        }
        ArrayList<SQLSelect> queries = new ArrayList<SQLSelect>(tablesToCache.size());
        int size = tablesToCache.size();
        int i = 0;
        while (i < size) {
            SQLTable sqlTable = tablesToCache.get(i);
            SQLSelect select = new SQLSelect(true);
            select.addSelectStar(sqlTable);
            select.setWhere(sqlTable.getKey(), "=", sqlTable.getUndefinedID());
            queries.add(select);
            ++i;
        }
        MultipleSQLSelectExecutor executor = new MultipleSQLSelectExecutor(tablesToCache.get(0).getDBSystemRoot(), queries);
        try {
            List<List<SQLRow>> l = executor.execute();
            if (l.size() != tablesToCache.size()) {
                throw new IllegalStateException("Internal SQL error while preloading");
            }
            int i2 = 0;
            while (i2 < size) {
                SQLTable sqlTable = tablesToCache.get(i2);
                List<SQLRow> rows = l.get(i2);
                if (rows.size() > 0) {
                    SQLRowValues rv = new SQLRowValues(sqlTable);
                    this.getDirectory().getElement(sqlTable).loadAllSafe(rv, rows.get(0));
                    this.map.put(sqlTable, rv);
                } else {
                    System.err.println("Warning: no undefined row in table: " + sqlTable.getName() + " id: " + sqlTable.getUndefinedID());
                }
                ++i2;
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Unable to preload tables", e);
        }
    }
}

