/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.payment.component.DepotChequeSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.DepotChequeXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.SQLRow;

public class DepotChequeSQLElement
extends ComptaSQLConfElement {
    public DepotChequeSQLElement() {
        super("DEPOT_CHEQUE", "un d\u00e9pot de ch\u00e8que", "d\u00e9pots de ch\u00e8que");
        MouseSheetXmlListeListener listener = new MouseSheetXmlListeListener((SQLElement)this, DepotChequeXmlSheet.class);
        this.getRowActions().addAll(listener.getRowActions());
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        links.get("ID_MOUVEMENT").setType(SQLElementLink.LinkType.ASSOCIATION);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_" + BanqueSQLElement.TABLENAME);
        l.add("MONTANT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new DepotChequeSQLComponent(this);
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("MONTANT");
        return s;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".depot";
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            Collection rowCheques = row.getReferentRows(this.getTable().getTable("DEPOT_CHEQUE_ELEMENT"));
            for (SQLRow depotElt : rowCheques) {
                if (depotElt.getObject("ID_CHEQUE_A_ENCAISSER") == null || depotElt.isForeignEmpty("ID_CHEQUE_A_ENCAISSER")) continue;
                depotElt.getForeign("ID_CHEQUE_A_ENCAISSER").createEmptyUpdateRow().put("ENCAISSE", Boolean.FALSE).commit();
            }
        }
        super.archive(trees, cutLinks);
    }
}

