/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.DateUtil;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.importer.Transaction;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.order.element.SaisieAchatSQLElement;
import org.openconcerto.erp.core.supplychain.supplier.element.FournisseurSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;
import org.openconcerto.ui.FrameUtil;

public class ReleveBancaireElementSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "RELEVE_BANCAIRE_ELEMENT";

    public ReleveBancaireElementSQLElement() {
        super(TABLE_NAME);
        this.getRowValuesActions().add(this.getCreateAction());
        this.getRowValuesActions().add(this.getCreateKMAction());
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("DATE_VALEUR", "TYPE", "DESCRIPTION", "MONTANT", "POINTE");
    }

    @Override
    protected SQLComponent createComponent() {
        return null;
    }

    public SQLRowValuesAction getCreateAction() {
        SQLRowValuesAction action = new SQLRowValuesAction(true, true, "purchase.create", a -> {
            try {
                List<? extends SQLRowAccessor> selectedRowAccessors = a.getSelectedRowAccessors();
                this.create(selectedRowAccessors);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }){

            @Override
            public boolean enabledFor(ListEvent evt) {
                SQLRowAccessor selectedRow;
                return evt.getSelectedRowAccessors().size() == 1 && (selectedRow = evt.getSelectedRow()).getBigDecimal("MONTANT").signum() < 0 && selectedRow.getBoolean("POINTE") == false;
            }
        };
        return action;
    }

    public SQLRowValuesAction getCreateKMAction() {
        SQLRowValuesAction actionCreateKM = new SQLRowValuesAction(true, true, "km.create", a -> {
            try {
                List<? extends SQLRowAccessor> selectedRowAccessors = a.getSelectedRowAccessors();
                this.createSaisieKM(selectedRowAccessors);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }){

            @Override
            public boolean enabledFor(ListEvent evt) {
                SQLRowAccessor selectedRow;
                return evt.getSelectedRowAccessors().size() == 1 && (selectedRow = evt.getSelectedRow()).getBoolean("POINTE") == false;
            }
        };
        return actionCreateKM;
    }

    private void createSaisieKM(List<? extends SQLRowAccessor> rows) throws Exception {
        for (SQLRowAccessor sQLRowAccessor : rows) {
            long credit5;
            long debit5;
            long credit4;
            long debit4;
            SQLRowAccessor compteTiers;
            SQLBackgroundTableCacheItem cachePrefs;
            SQLRow row = sQLRowAccessor.fetchNewRow(false);
            String type = sQLRowAccessor.getString("TYPE");
            SQLRow banque = row.getForeign("ID_RELEVE_BANCAIRE").getForeign("ID_BANQUE").fetchNew(true);
            long ttcCents = sQLRowAccessor.getBigDecimal("MONTANT").multiply(new BigDecimal("100")).longValue();
            if (ttcCents > 0L) {
                cachePrefs = SQLBackgroundTableCache.getInstance().getCacheForTable(banque.getTable().getTable("PREFS_COMPTE"));
                compteTiers = cachePrefs.getRowFromId(2).getNonEmptyForeign("ID_COMPTE_PCE_CLIENT");
                if (compteTiers == null) {
                    compteTiers = banque.getTable().getTable("PREFS_COMPTE").getRow(ComptePCESQLElement.getIdComptePceDefault("Clients"));
                }
                debit4 = 0L;
                credit4 = ttcCents;
                debit5 = ttcCents;
                credit5 = 0L;
            } else {
                cachePrefs = SQLBackgroundTableCache.getInstance().getCacheForTable(banque.getTable().getTable("PREFS_COMPTE"));
                compteTiers = cachePrefs.getRowFromId(2).getNonEmptyForeign("ID_COMPTE_PCE_FOURNISSEUR");
                if (compteTiers == null) {
                    compteTiers = banque.getTable().getTable("PREFS_COMPTE").getRow(ComptePCESQLElement.getIdComptePceDefault("Fournisseurs"));
                }
                debit4 = -ttcCents;
                credit4 = 0L;
                debit5 = 0L;
                credit5 = -ttcCents;
            }
            SQLElement element = this.getDirectory().getElement("SAISIE_KM");
            SQLRowValues rKM = new SQLRowValues(element.getTable());
            rKM.put("DATE", row.getDate("DATE").getTime());
            String desc = row.getString("DESCRIPTION");
            rKM.put("NOM", desc);
            rKM.put("ID_JOURNAL", banque.getForeignIDNumber("ID_JOURNAL"));
            SQLRowValues rKMItem4 = new SQLRowValues(element.getTable().getTable("SAISIE_KM_ELEMENT"));
            rKMItem4.put("ID_SAISIE_KM", (Object)rKM);
            rKMItem4.put("NUMERO", compteTiers.getString("NUMERO"));
            rKMItem4.put("NOM", compteTiers.getString("NOM"));
            rKMItem4.put("DEBIT", debit4);
            rKMItem4.put("CREDIT", credit4);
            rKMItem4.put("NOM_ECRITURE", desc);
            SQLRowValues rKMItem5 = new SQLRowValues(element.getTable().getTable("SAISIE_KM_ELEMENT"));
            rKMItem5.put("ID_SAISIE_KM", (Object)rKM);
            SQLRowAccessor compteBanque = ((SQLRowAccessor)banque).getForeign("ID_COMPTE_PCE");
            rKMItem5.put("NUMERO", compteBanque.getString("NUMERO"));
            rKMItem5.put("NOM", compteBanque.getString("NOM"));
            rKMItem5.put("DEBIT", debit5);
            rKMItem5.put("CREDIT", credit5);
            rKMItem5.put("NOM_ECRITURE", desc);
            EditFrame frameAchat = new EditFrame(element, EditPanel.EditMode.CREATION);
            frameAchat.getSQLComponent().select(rKM);
            FrameUtil.showPacked(frameAchat);
        }
    }

    void create(List<? extends SQLRowAccessor> rows) throws Exception {
        HashMap mapFournisseur = new HashMap();
        HashMap mapCompte = new HashMap();
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRow row = sQLRowAccessor.fetchNewRow(false);
            String type = sQLRowAccessor.getString("TYPE");
            SQLRowValues modeReglement = new SQLRowValues(this.getDirectory().getElement(ModeDeReglementSQLElement.class).getTable());
            if (type.equals("card")) {
                modeReglement.put("ID_TYPE_REGLEMENT", 3);
            } else if (type.equals("transfer")) {
                modeReglement.put("ID_TYPE_REGLEMENT", 8);
            } else if (type.equals("check")) {
                modeReglement.put("ID_TYPE_REGLEMENT", 2);
            } else if (type.equals("directdebit")) {
                modeReglement.put("ID_TYPE_REGLEMENT", 8);
            } else {
                modeReglement.put("ID_TYPE_REGLEMENT", 8);
            }
            modeReglement.put("ID_BANQUE", row.getForeign("ID_RELEVE_BANCAIRE").getForeignIDNumber("ID_BANQUE"));
            modeReglement.put("COMPTANT", Boolean.TRUE);
            modeReglement.put("DATE_FACTURE", Boolean.TRUE);
            SQLRow taxe = TaxeCache.getCache().getFirstTaxe();
            SQLRowValues rAchat = new SQLRowValues(this.getDirectory().getElement(SaisieAchatSQLElement.class).getTable());
            int ttcCents = Math.abs(sQLRowAccessor.getBigDecimal("MONTANT").multiply(new BigDecimal("100")).intValue());
            float ht = (float)ttcCents / (taxe.getFloat("TAUX") / 100.0f + 1.0f);
            int htCents = Math.round(ht);
            int tvaCents = ttcCents - htCents;
            rAchat.put("MONTANT_TTC", ttcCents);
            rAchat.put("SOURCE", "");
            rAchat.put("NOM", row.getString("DESCRIPTION"));
            rAchat.put("ID_MODE_REGLEMENT", (Object)modeReglement);
            rAchat.put("MONTANT_HT", htCents);
            rAchat.put("ID_TAXE", taxe.getID());
            rAchat.put("DATE", row.getDate("DATE").getTime());
            rAchat.put("MONTANT_TVA", tvaCents);
            EditFrame frameAchat = new EditFrame(this.getDirectory().getElement("SAISIE_ACHAT"), EditPanel.EditMode.CREATION);
            frameAchat.getSQLComponent().select(rAchat);
            FrameUtil.showPacked(frameAchat);
        }
    }

    protected Integer searchCompte(String comptePCE) {
        SQLSelect select = new SQLSelect();
        SQLTable tComptePCE = this.getDirectory().getElement(ComptePCESQLElement.class).getTable();
        select.addSelect(tComptePCE.getKey());
        select.addSelect(tComptePCE.getField("NUMERO"));
        select.setWhere(new Where((FieldRef)tComptePCE.getField("NUMERO"), "=", (Object)comptePCE));
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0).getID();
    }

    protected Integer searchFournisseur(String name) {
        SQLSelect select = new SQLSelect();
        SQLTable tFournisseur = this.getDirectory().getElement(FournisseurSQLElement.class).getTable();
        select.addSelect(tFournisseur.getKey());
        select.addSelect(tFournisseur.getField("NOM"));
        select.setWhere(new Where((FieldRef)tFournisseur.getField("NOM"), "=", (Object)name));
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0).getID();
    }

    public List<Transaction> getTransactions(int year, int month) {
        SQLSelect sel = new SQLSelect();
        SQLTable table = this.getTable();
        SQLTable tableReleve = this.getTable().getTable("RELEVE_BANCAIRE");
        sel.addSelect(table.getKey());
        sel.addSelect(table.getField("UUID"));
        sel.addSelect(table.getField("TYPE"));
        sel.addSelect(table.getField("NAME"));
        sel.addSelect(table.getField("DESCRIPTION"));
        sel.addSelect(table.getField("COMMENT"));
        sel.addSelect(table.getField("MONTANT"));
        sel.addSelect(table.getField("DATE"));
        sel.addSelect(table.getField("DATE_VALEUR"));
        sel.addJoin("LEFT", table.getField("ID_RELEVE_BANCAIRE"));
        sel.setWhere(new Where((FieldRef)tableReleve.getField("ANNEE"), "=", year).and(new Where((FieldRef)tableReleve.getField("MOIS"), "=", month)));
        List<SQLRow> rows = SQLRowListRSH.execute(sel);
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (SQLRow row : rows) {
            Transaction t = new Transaction();
            t.setUUID(row.getString("UUID"));
            t.setType(row.getString("TYPE"));
            t.setName(row.getString("NAME"));
            t.setMemo(row.getString("DESCRIPTION"));
            t.setAmount(row.getBigDecimal("MONTANT"));
            t.setComment(row.getString("COMMENT"));
            t.setDate(DateUtil.toLocalDateTime((Calendar)row.getDate("DATE")).toLocalDate());
            t.setDateValue(DateUtil.toLocalDateTime((Calendar)row.getDate("DATE_VALEUR")).toLocalDate());
            result.add(t);
        }
        return result;
    }

    @Override
    protected String createCode() {
        return "finance.accounting.bank.statement.item";
    }
}

