/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cache.LRUMap;
import org.openconcerto.utils.convertor.DateTSConvertor;
import org.openconcerto.utils.convertor.DateToSQLConvertor;
import org.openconcerto.utils.convertor.DateToTimeConvertor;
import org.openconcerto.utils.convertor.JavaTimeSQLConvertors;
import org.openconcerto.utils.convertor.NumberConvertor;
import org.openconcerto.utils.convertor.ReverseConvertor;
import org.openconcerto.utils.convertor.StringClobConvertor;
import org.openconcerto.utils.convertor.ValueConvertor;

public final class ValueConvertorFactory {
    private static final ValueConvertor IdentityConvertor = new ValueConvertor(){

        public Object convert(Object o) {
            return o;
        }

        public Object unconvert(Object o) {
            return o;
        }
    };
    private static final ValueConvertor<?, ?> MISSING_CONV = new ValueConvertor<Void, Void>(){

        @Override
        public Void convert(Void o) {
            return null;
        }

        @Override
        public Void unconvert(Void o) {
            return null;
        }
    };
    private static final List<ValueConvertor<?, ?>> STRICT_CONVERTORS;
    private static final List<ValueConvertor<?, ?>> LENIENT_CONVERTORS;
    @GuardedBy(value="self")
    private static Map<Tuple2.List2<Class<?>>, ValueConvertor<?, ?>> CACHE;
    @GuardedBy(value="self")
    private static Map<Tuple2.List2<Class<?>>, ValueConvertor<?, ?>> LENIENT_CACHE;

    static {
        CACHE = new LRUMap(512, 32);
        LENIENT_CACHE = new LRUMap(512, 32);
        LENIENT_CONVERTORS = new ArrayList();
        STRICT_CONVERTORS = new ArrayList();
        LENIENT_CONVERTORS.add(new DateTSConvertor());
        LENIENT_CONVERTORS.add(new DateToSQLConvertor());
        LENIENT_CONVERTORS.add(new DateToTimeConvertor());
        LENIENT_CONVERTORS.add(NumberConvertor.INT_TO_LONG);
        LENIENT_CONVERTORS.add(NumberConvertor.SHORT_TO_INT);
        LENIENT_CONVERTORS.add(JavaTimeSQLConvertors.LOCAL_DATE);
        LENIENT_CONVERTORS.add(JavaTimeSQLConvertors.LOCAL_TIME);
        LENIENT_CONVERTORS.add(JavaTimeSQLConvertors.LOCAL_DATETIME);
        STRICT_CONVERTORS.addAll(LENIENT_CONVERTORS);
        STRICT_CONVERTORS.add(StringClobConvertor.INSTANCE);
        STRICT_CONVERTORS.add(NumberConvertor.INT_TO_BIGDECIMAL_EXACT);
        LENIENT_CONVERTORS.add(StringClobConvertor.INSTANCE_LENIENT);
    }

    public static final <T> ValueConvertor<T, T> getIdentityConvertor() {
        return IdentityConvertor;
    }

    public static final <T, U> U convert(T o, Class<U> c2, boolean lenient) {
        if (c2.isInstance(o)) {
            return c2.cast(o);
        }
        ValueConvertor<?, U> conv = ValueConvertorFactory.find(o.getClass(), c2, lenient);
        if (conv == null) {
            throw new IllegalArgumentException("No convertor to " + c2 + " from " + o);
        }
        return conv.convert(o);
    }

    public static final <T, U> ValueConvertor<T, U> find(Class<T> c1, Class<U> c2) {
        return ValueConvertorFactory.find(c1, c2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, U> ValueConvertor<T, U> find(Class<T> c1, Class<U> c2, boolean lenient) {
        ValueConvertor<Object, Object> res;
        if (c1 == c2) {
            res = ValueConvertorFactory.getIdentityConvertor();
        } else {
            Map<Tuple2.List2<Class<?>>, ValueConvertor<?, ?>> c;
            Tuple2.List2<Class<U>> key = new Tuple2.List2<Class<U>>(c1, c2);
            Map<Tuple2.List2<Class<?>>, ValueConvertor<?, ?>> map = c = lenient ? LENIENT_CACHE : CACHE;
            synchronized (map) {
                ValueConvertor<?, ?> inCache;
                block8: {
                    inCache = c.get(key);
                    if (inCache != MISSING_CONV) break block8;
                    return null;
                }
                if (inCache != null) {
                    res = inCache;
                } else {
                    res = ValueConvertorFactory.create(c1, c2, lenient);
                    c.put(key, res == null ? MISSING_CONV : res);
                }
            }
        }
        ValueConvertor<T, T> casted = res;
        return casted;
    }

    private static final ValueConvertor<?, ?> create(Class<?> c1, Class<?> c2, boolean lenient) {
        assert (c1 != c2);
        for (ValueConvertor<?, ?> vc : lenient ? LENIENT_CONVERTORS : STRICT_CONVERTORS) {
            List<Class<?>> args = ReflectUtils.getTypeArguments(vc, ValueConvertor.class);
            if (args.size() != 2) {
                throw new IllegalStateException(vc + " don't specify type arguments");
            }
            if (args.get(0).equals(c1) && args.get(1).equals(c2)) {
                return vc;
            }
            if (!args.get(0).equals(c2) || !args.get(1).equals(c1)) continue;
            return ReverseConvertor.create(vc);
        }
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            return NumberConvertor.create(c1.asSubclass(Number.class), c2.asSubclass(Number.class), !lenient);
        }
        return null;
    }
}

