/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.SleepingQueue;

public final class MoveQueue
extends SleepingQueue {
    private final ITableModel tableModel;

    MoveQueue(ITableModel model) {
        super(String.valueOf(MoveQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
    }

    public Future<?> move(final List<? extends SQLRowAccessor> rows, final int inc) {
        if (inc == 0 || rows.size() == 0) {
            return null;
        }
        final boolean after = inc > 0;
        SQLRowAccessor outerR = null;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (outerR == null) {
                outerR = sQLRowAccessor;
                continue;
            }
            int compare = sQLRowAccessor.getOrder().compareTo(outerR.getOrder());
            if ((!after || compare <= 0) && (after || compare >= 0)) continue;
            outerR = sQLRowAccessor;
        }
        final int n = outerR.getID();
        return this.put(new Runnable(){

            @Override
            public void run() {
                final FutureTask<ListSQLLine> destID = new FutureTask<ListSQLLine>(new Callable<ListSQLLine>(){

                    @Override
                    public ListSQLLine call() {
                        return MoveQueue.this.tableModel.getDestLine(n, inc);
                    }
                });
                MoveQueue.this.tableModel.invokeLater(destID);
                try {
                    if (destID.get() != null) {
                        SQLUtils.executeAtomic(MoveQueue.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                            @Override
                            public Object handle(SQLDataSource ds) throws Exception {
                                MoveQueue.this.moveQuick(rows, after, ((ListSQLLine)destID.get()).getRowAccessor().asRow());
                                return null;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    public Future<?> moveTo(final List<? extends Number> rows, int rowIndex) {
        if (rows.size() == 0) {
            return null;
        }
        assert (rowIndex >= 0);
        assert (SwingUtilities.isEventDispatchThread());
        int rowCount = this.tableModel.getRowCount();
        final boolean after = rowIndex >= rowCount;
        int index = after ? rowCount - 1 : rowIndex;
        final SQLRowAccessor line = this.tableModel.getRow(index).getRowAccessor();
        assert (line.isFrozen()) : "row could change by the time move() is called";
        return this.put(new Runnable(){

            @Override
            public void run() {
                try {
                    SQLUtils.executeAtomic(MoveQueue.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws Exception {
                            MoveQueue.this.moveQuick(rows, after, line.asRow());
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    final void moveQuick(List<?> srcRows, boolean after, SQLRow destRow) throws SQLException {
        int rowCount = srcRows.size();
        if (rowCount < 5 && rowCount < this.tableModel.getTotalRowCount() / 3) {
            SQLTable t = this.getTable();
            String orderName = t.getOrderField().getName();
            SQLRowValues vals = new SQLRowValues(t);
            List<BigDecimal> orders = ReOrder.getFreeOrderValuesFor(rowCount, after, destRow).get0();
            int i = 0;
            while (i < rowCount) {
                Object src = srcRows.get(i);
                vals.put(orderName, orders.get(i)).update(MoveQueue.getID(src, t).intValue());
                ++i;
            }
        } else {
            MoveQueue.moveAtOnce(srcRows, rowCount, after, destRow);
        }
    }

    private static Number getID(Object o, SQLTable t) {
        Number res;
        if (o instanceof SQLRowAccessor) {
            SQLRowAccessor row = (SQLRowAccessor)o;
            if (row.getTable() != t) {
                throw new IllegalArgumentException("Not from the same table : " + row + " != " + t);
            }
            res = row.getIDNumber();
        } else {
            res = (Number)o;
        }
        return res;
    }

    private SQLTable getTable() {
        return this.tableModel.getTable();
    }

    public static void moveAtOnce(List<? extends SQLRowAccessor> srcRows, boolean after, SQLRow destRow) throws SQLException {
        MoveQueue.moveAtOnce(srcRows, srcRows.size(), after, destRow);
    }

    public static boolean moveIDsAtOnce(List<? extends Number> ids, boolean after, SQLRow destRow, boolean checkBefore) throws SQLException {
        int size = ids.size();
        if (checkBefore) {
            SQLTable table = destRow.getTable();
            SQLSelect sel = new SQLSelect(true);
            sel.addSelect(table.getKey());
            sel.addOrder(table);
            sel.setWhere(new Where(table.getKey(), ids));
            sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
            List dbOrderedIDs = table.getDBSystemRoot().getDataSource().executeCol(sel.asString());
            if (dbOrderedIDs.size() != size) {
                throw new IllegalStateException("Missing rows");
            }
            boolean orderOK = true;
            int i = 0;
            while (i < size && orderOK) {
                Number passedID = ids.get(i);
                Number dbID = (Number)dbOrderedIDs.get(i);
                orderOK = NumberUtils.areNumericallyEqual(passedID, dbID);
                ++i;
            }
            if (orderOK) {
                return false;
            }
        }
        MoveQueue.moveAtOnce(ids, size, after, destRow);
        return true;
    }

    private static void moveAtOnce(List<?> srcRows, int rowCount, boolean after, SQLRow destRow) throws SQLException {
        if (rowCount == 0) {
            return;
        }
        SQLTable t = destRow.getTable();
        List<BigDecimal> freeOrderValues = ReOrder.getFreeOrderValuesFor(rowCount, after, destRow).get0();
        ArrayList<List<String>> newOrdersAndIDs = new ArrayList<List<String>>(rowCount);
        int i = 0;
        ArrayList<Number> ids = rowCount < 10 ? new ArrayList<Number>(rowCount) : null;
        for (Object src : srcRows) {
            Number srcID = MoveQueue.getID(src, t);
            if (ids != null) {
                ids.add(srcID);
            }
            BigDecimal newOrder = freeOrderValues.get(i++);
            newOrdersAndIDs.add(Arrays.asList(srcID.toString(), newOrder.toPlainString()));
        }
        SQLSyntax syntax = SQLSyntax.get(t);
        UpdateBuilder update = new UpdateBuilder(t);
        String constantTableAlias = "newOrdersAndIDs";
        update.addVirtualJoin(syntax.getConstantTable(newOrdersAndIDs, "newOrdersAndIDs", Arrays.asList("ID", "newOrder")), "newOrdersAndIDs", true, "ID", t.getKey().getName());
        update.setFromVirtualJoinField(t.getOrderField().getName(), "newOrdersAndIDs", "newOrder");
        t.getDBSystemRoot().getDataSource().execute(update.asString());
        List<String> fieldsChanged = Collections.singletonList(t.getOrderField().getName());
        if (ids == null) {
            t.fireTableModified(-1, fieldsChanged);
        } else {
            for (Number id : ids) {
                t.fireTableModified(id.intValue(), fieldsChanged);
            }
        }
    }
}

