/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;

public class CourrierClientSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowCourrier;
    public static final String TEMPLATE_ID = "Courrier";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationCourrier";

    public CourrierClientSheet(SQLRow row) {
        this.rowCourrier = row;
        Date d = (Date)this.rowCourrier.getObject("DATE");
        String year = this.yearFormat.format(d);
        SQLRowAccessor foreignModele = this.rowCourrier.getNonEmptyForeign("ID_MODELE_COURRIER_CLIENT");
        String modele = "Courrier.odt";
        if (foreignModele != null && foreignModele.getString("TEMPLATE_NAME").trim().length() > 0) {
            modele = foreignModele.getString("TEMPLATE_NAME");
        }
        this.init(year, modele, "CourrierPrinter");
    }

    @Override
    public String getDefaultTemplateID() {
        return TEMPLATE_ID;
    }

    @Override
    public String getDefaultLocationProperty() {
        return TEMPLATE_PROPERTY_NAME;
    }

    @Override
    protected Map<String, Object> createMap() {
        SQLRowAccessor foreign;
        HashMap<String, Object> m = new HashMap<String, Object>();
        SQLRow rowModele = this.rowCourrier.getForeign("ID_MODELE_COURRIER_CLIENT");
        String contenu = rowModele.getString("CONTENU");
        m.put("Corps", contenu);
        m.put("Objet", this.rowCourrier.getString("NOM"));
        m.put("Date", this.dateFormat.format(this.rowCourrier.getDate("DATE").getTime()));
        SQLRowAccessor rowContactCom = this.rowCourrier.getNonEmptyForeign("ID_CONTACT");
        SQLRow rowClient = this.rowCourrier.getForeign("ID_CLIENT");
        if (rowContactCom != null) {
            SQLRowAccessor rowTitre = rowContactCom.getNonEmptyForeign("ID_TITRE_PERSONNEL");
            String correspondant = rowTitre.getString("NOM");
            String contact = rowTitre.getString("NOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("PRENOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("NOM");
            m.put("Correspondant", correspondant);
            m.put("Contact", contact);
            m.put("contactNom", rowContactCom.getString("NOM"));
            m.put("contactPrenom", rowContactCom.getString("PRENOM"));
            m.put("contactTelephone", rowContactCom.getString("TEL_DIRECT"));
            m.put("contactMail", rowContactCom.getString("EMAIL"));
            m.put("contactFonction", rowContactCom.getString("FONCTION"));
            if (rowTitre != null) {
                m.put("contactTitre", rowTitre.getString("NOM"));
                m.put("contactTitreCode", rowTitre.getString("CODE"));
            }
        } else {
            m.put("contactNom", rowClient.getString("RESPONSABLE"));
            m.put("contactMail", rowClient.getString("MAIL"));
            m.put("contactTelephone", rowClient.getString("TEL"));
        }
        m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
        m.put("clientSiret", rowClient.getString("SIRET"));
        m.put("clientSiren", StringUtils.limitLength(rowClient.getString("SIRET").replaceAll(" ", ""), 9));
        if (rowClient.getTable().contains("RCS")) {
            m.put("clientRcs", rowClient.getString("RCS"));
        }
        if (rowClient.getTable().contains("APE")) {
            m.put("clientApe", rowClient.getString("APE"));
        }
        if (rowClient.getTable().contains("CAPITAL")) {
            m.put("clientCapital", rowClient.getString("CAPITAL"));
        }
        m.put("clientResponsable", rowClient.getString("RESPONSABLE"));
        m.put("clientNom", rowClient.getString("NOM"));
        m.put("clientMail", rowClient.getString("MAIL"));
        m.put("clientTelephone", rowClient.getString("TEL"));
        SQLRow rowAdresseClient = rowClient.getForeignRow("ID_ADRESSE");
        m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
        m.put("clientAdresse", rowAdresseClient.getString("RUE"));
        m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
        String villeCli = rowAdresseClient.getString("VILLE");
        Object cedexCli = rowAdresseClient.getObject("CEDEX");
        boolean hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        m.put("clientVille", villeCli);
        int idAdresse = this.rowCourrier.getInt("ID_ADRESSE");
        if (idAdresse > 1) {
            rowAdresseClient = this.rowCourrier.getForeignRow("ID_ADRESSE");
            m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
            m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
            m.put("clientAdresse", rowAdresseClient.getString("RUE"));
            m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
            villeCli = rowAdresseClient.getString("VILLE");
            cedexCli = rowAdresseClient.getObject("CEDEX");
            hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
            if (hasCedexCli) {
                villeCli = String.valueOf(villeCli) + " CEDEX";
                if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                    villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
                }
            }
            m.put("clientVille", villeCli);
        }
        if (this.rowCourrier.getTable().contains("ID_COMPTEUR") && (foreign = this.rowCourrier.getNonEmptyForeign("ID_COMPTEUR")) != null) {
            m.put("compteurPDL", foreign.getString("COMPTEUR_ID"));
            m.put("compteurNom", foreign.getString("NOM"));
            m.put("compteurPTE", foreign.getString("PTE"));
            String hphS = foreign.getString("HPH");
            m.put("compteurHPH", hphS);
            m.put("compteurHPE", foreign.getString("HPE"));
            m.put("compteurHCE", foreign.getString("HCE"));
            String pcibleAmS = foreign.getString("P_CIBLE_AM");
            m.put("compteurPCibleAM", pcibleAmS);
            String pCiblePmS = foreign.getString("P_CIBLE_PM");
            m.put("compteurPCiblePM", pCiblePmS);
            String pMoyS = foreign.getString("P_MOY");
            m.put("compteurPMoy", pMoyS);
            if (hphS != null && hphS.trim().length() > 0 && pcibleAmS != null && pcibleAmS.trim().length() > 0 && pcibleAmS != null && pcibleAmS.trim().length() > 0 && pCiblePmS != null && pCiblePmS.trim().length() > 0 && pMoyS != null && pMoyS.trim().length() > 0) {
                BigDecimal hph = new BigDecimal(hphS.replaceAll(",", ".").replaceAll(" ", ""));
                BigDecimal pcibleAm = new BigDecimal(pcibleAmS.replaceAll(",", ".").replaceAll(" ", ""));
                BigDecimal pCiblePm = new BigDecimal(pCiblePmS.replaceAll(",", ".").replaceAll(" ", ""));
                BigDecimal pMoy = new BigDecimal(pMoyS.replaceAll(",", ".").replaceAll(" ", ""));
                BigDecimal add = pcibleAm.multiply(new BigDecimal(8), DecimalUtils.HIGH_PRECISION).add(pCiblePm.multiply(new BigDecimal(2), DecimalUtils.HIGH_PRECISION));
                BigDecimal pDispo = hph.subtract(add.movePointLeft(1));
                BigDecimal pFlex = pMoy.subtract(add.movePointLeft(1));
                m.put("compteurPFlex", GestionDevise.currencyToString(pFlex));
                m.put("compteurPDispo", GestionDevise.currencyToString(pDispo));
            }
        }
        System.err.println(CollectionUtils.join(m.keySet(), "\n"));
        return m;
    }

    @Override
    protected String getName() {
        return "Courrier_" + this.rowCourrier.getString("NUMERO");
    }
}

