/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.sales.pos.model.Transaction;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class Client {
    public static final Client NONE = new Client(-1, "Client inconnu", BigDecimal.ZERO);
    private int id;
    private String fullName;
    private BigDecimal solde;
    private String addr;

    public Client(int id, String fullName, BigDecimal solde) {
        this.id = id;
        this.fullName = fullName;
        if (solde == null) {
            solde = BigDecimal.ZERO;
        }
        this.solde = solde;
    }

    public int getId() {
        return this.id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public BigDecimal getSolde() {
        return this.solde;
    }

    public String getAddr() {
        return this.addr;
    }

    public void setAdresse(String string) {
        this.addr = string.trim();
    }

    public void credit(final BigDecimal amount, final int paymentType) throws Exception {
        if (amount == null || amount.longValue() <= 0L) {
            return;
        }
        SQLDataSource ds = Configuration.getInstance().getSystemRoot().getDataSource();
        SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SQLTable table = Configuration.getInstance().getRoot().findTable("COMPTE_CLIENT_TRANSACTION");
                SQLRowValues rowVals = new SQLRowValues(table);
                rowVals.put("ID_CLIENT", Client.this.getId());
                Date today = new Date();
                rowVals.put("DATE", today);
                rowVals.put("MONTANT", amount);
                SQLRowValues rowValsEltMode = rowVals.putRowValues("ID_MODE_REGLEMENT");
                if (paymentType == 3) {
                    rowValsEltMode.put("ID_TYPE_REGLEMENT", 3);
                } else if (paymentType == 2) {
                    rowValsEltMode.put("ID_TYPE_REGLEMENT", 2);
                } else if (paymentType == 1) {
                    rowValsEltMode.put("ID_TYPE_REGLEMENT", 4);
                }
                SQLRow rowTransact = rowVals.commit();
                GenerationEcritures ecr = new GenerationEcritures();
                int idMvt = ecr.getNewMouvement(table.getName(), rowTransact.getID(), 1, "Transact. " + Client.this.getFullName());
                rowTransact = rowTransact.createEmptyUpdateRow().put("ID_MOUVEMENT", idMvt).commit();
                SQLTable tableClient = table.getForeignTable("ID_CLIENT");
                SQLRow row = tableClient.getRow(Client.this.getId());
                BigDecimal solde = row.getBigDecimal("SOLDE_COMPTE");
                BigDecimal nouveauSolde = solde.add(amount);
                row.createEmptyUpdateRow().put("SOLDE_COMPTE", nouveauSolde).commit();
                long centAmountValue = amount.movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                try {
                    new GenerationReglementVenteNG("Cr\u00e9dit du solde " + Client.this.fullName, row, new PrixTTC(centAmountValue), today, rowTransact.getForeign("ID_MODE_REGLEMENT"), rowTransact, rowTransact.getForeign("ID_MOUVEMENT"), true, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SQLException(e);
                }
                Client.this.solde = nouveauSolde;
                return null;
            }
        });
    }

    public void printCredit(TicketPrinter prt, List<TicketLine> headers, int ticketWidth, BigDecimal amount, int paymentType, BigDecimal nouveauSolde) {
        prt.clearBuffer(String.valueOf(this.getFullName()) + " cr\u00e9dit");
        for (TicketLine line : headers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm", Locale.FRENCH);
        prt.addToBuffer(DefaultTicketPrinter.formatRight(ticketWidth, "Le " + df.format(new Date())));
        prt.addToBuffer("");
        prt.addToBuffer("RECU", 1);
        prt.addToBuffer("");
        String amountStr = TicketCellRenderer.centsToString(amount.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        prt.addToBuffer("Paiement de " + amountStr + " euros");
        prt.addToBuffer("En" + new Paiement(paymentType).getTypeAsString());
        prt.addToBuffer("");
        int ntotal = amount.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
        prt.addToBuffer("Nouveau solde : " + TicketCellRenderer.centsToString(ntotal) + " euros");
        prt.addToBuffer("");
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Transaction> getTransactions() {
        final SQLTable table = Configuration.getInstance().getRoot().findTable("COMPTE_CLIENT_TRANSACTION");
        SQLRowValues graph = new SQLRowValues(table);
        graph.putNulls("DATE", "MONTANT");
        graph.putRowValues("ID_MODE_REGLEMENT").putNulls("ID_TYPE_REGLEMENT");
        graph.putRowValues("ID_CLIENT");
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
        fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                return input.setWhere(table.getField("ID_CLIENT"), "=", Client.this.getId());
            }
        });
        List<SQLRowValues> values = fetcher.fetch();
        ArrayList<Transaction> l = new ArrayList<Transaction>();
        for (SQLRowValues sqlRowValues : values) {
            Date date = sqlRowValues.getDate("DATE").getTime();
            BigDecimal amount = sqlRowValues.getBigDecimal("MONTANT");
            SQLRowAccessor modeRegl = sqlRowValues.getNonEmptyForeign("ID_MODE_REGLEMENT");
            int idReglement = modeRegl == null ? -1 : modeRegl.getForeignID("ID_TYPE_REGLEMENT");
            int payment = -1;
            if (idReglement == 3) {
                payment = 3;
            } else if (idReglement == 4) {
                payment = 1;
            } else if (idReglement == 2) {
                payment = 2;
            } else if (amount.signum() == -1) {
                payment = 4;
            } else {
                ExceptionHandler.handle("unknown ID_MODE_REGLEMENT " + idReglement);
            }
            Transaction t = new Transaction(date, amount, payment);
            l.add(t);
        }
        Collections.sort(l, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction o1, Transaction o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        return l;
    }
}

