/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextCombo;

public class EcheancePanel
extends JPanel {
    private JTextField aNJours = new JTextField();
    private JTextField leNJour = new JTextField();
    private JTextField textAJours = new JTextField("30", 4);
    private JTextField textLeJours = new JTextField("15", 4);
    private ITextCombo textComboAJours = new SQLTextCombo(true);
    private JRadioButton checkLeJour;
    private JRadioButton checkFinDeMois;
    private JRadioButton checkDateFacture;
    private JRadioButton checkComptant;
    private JRadioButton checkNJours;
    private SQLTextCombo textCustom;

    public EcheancePanel() {
        this.uiInit();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.textLeJours = new JTextField("15", 3);
        this.textAJours = new JTextField("30", 3);
        this.checkComptant = new JRadioButton("paiement comptant");
        this.checkComptant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcheancePanel.this.setComptant(true);
            }
        });
        c.gridwidth = 0;
        JLabel label = new JLabel("Ech\u00e9ance : ");
        this.add(label);
        ++c.gridx;
        this.textCustom = new SQLTextCombo();
        this.add((Component)this.textCustom, c);
        label.setVisible(false);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)this.checkComptant, c);
        JLabel labelDate = new JLabel("A d\u00e9poser apr\u00e8s le");
        JDate dateDepot = new JDate(true);
        c.gridx += 3;
        c.gridwidth = 1;
        this.add((Component)labelDate, c);
        ++c.gridx;
        this.add((Component)dateDepot, c);
        c.gridwidth = 0;
        this.checkNJours = new JRadioButton("paiement \u00e0");
        this.checkNJours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        this.add((Component)this.checkNJours, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textAJours, c);
        this.textAJours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        JLabel labelAJours = new JLabel("jours, ");
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)labelAJours, c);
        this.checkFinDeMois = new JRadioButton("fin de mois");
        this.checkFinDeMois.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        this.add((Component)this.checkFinDeMois, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        JPanel pane = new JPanel(new GridLayout(1, 3));
        this.checkLeJour = new JRadioButton("le");
        this.checkLeJour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        pane.add(this.checkLeJour);
        pane.add(this.textLeJours);
        this.textLeJours.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        JLabel labelDuMois = new JLabel("du mois");
        pane.setBorder(null);
        pane.add(labelDuMois);
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 0;
        this.add((Component)pane, c);
        this.checkDateFacture = new JRadioButton("Date de facturation");
        this.checkDateFacture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcheancePanel.this.setComptant(false);
            }
        });
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        this.add((Component)this.checkDateFacture, c);
        ButtonGroup grp1 = new ButtonGroup();
        grp1.add(this.checkComptant);
        grp1.add(this.checkNJours);
        ButtonGroup grp2 = new ButtonGroup();
        grp2.add(this.checkFinDeMois);
        grp2.add(this.checkDateFacture);
        grp2.add(this.checkLeJour);
        this.checkFinDeMois.setSelected(true);
        this.leNJour.setText("31");
        this.aNJours.setText("30");
    }

    public void setComptant(boolean b) {
        if (b) {
            this.checkComptant.setSelected(true);
            this.aNJours.setText("0");
            this.textComboAJours.setValue("0");
            this.leNJour.setText("0");
            this.setEnableEcheance(false);
        } else {
            this.aNJours.setText(this.textAJours.getText());
            if (this.checkLeJour.isSelected()) {
                this.leNJour.setText(this.textLeJours.getText());
            } else if (this.checkDateFacture.isSelected()) {
                this.leNJour.setText("0");
            } else {
                this.leNJour.setText("31");
            }
            this.setEnableEcheance(true);
        }
    }

    public void fixComptant(boolean b) {
        System.err.println("Fix comptant " + b);
        if (b) {
            this.checkComptant.setSelected(true);
            this.setComptant(true);
            this.checkNJours.setEnabled(false);
        } else {
            this.checkNJours.setSelected(true);
            this.checkNJours.setEnabled(true);
            this.setComptant(false);
        }
    }

    public void setComptantEnable(boolean b) {
        this.checkComptant.setEnabled(b);
    }

    private void setEnableEcheance(boolean b) {
        this.textAJours.setEditable(b);
        this.textComboAJours.setEnabled(b);
        this.textLeJours.setEditable(b);
        this.checkFinDeMois.setEnabled(b);
        this.checkDateFacture.setEnabled(b);
        this.checkLeJour.setEnabled(b);
    }

    public void setValue(int aJour, int nJour) {
        this.textAJours.setText(String.valueOf(aJour));
        this.textComboAJours.setValue(String.valueOf(aJour));
        this.textLeJours.setText(String.valueOf(nJour));
        if (aJour == 0 && nJour == 0) {
            this.setComptant(true);
        } else {
            this.checkNJours.setEnabled(true);
            this.checkLeJour.setSelected(nJour != 31);
            this.checkNJours.setSelected(true);
            this.setComptant(false);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.textAJours.setEnabled(b);
        this.textComboAJours.setEnabled(b);
        this.textLeJours.setEnabled(b);
        this.checkLeJour.setEnabled(b);
        this.checkFinDeMois.setEnabled(b);
        this.checkComptant.setEnabled(b);
        this.checkNJours.setEnabled(b);
        this.checkDateFacture.setEnabled(b);
    }

    public JComponent getANjours() {
        return this.aNJours;
    }

    public JTextField getLeNjours() {
        return this.leNJour;
    }

    public JRadioButton getCheckNJours() {
        return this.checkNJours;
    }

    public SQLTextCombo getTextCustom() {
        return this.textCustom;
    }
}

