/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.StringUtils;

public class FixedLinesTableSetRenderer
implements TableCellRenderer {
    private int lineCount;
    final FontMetrics fontMetrics;

    public FixedLinesTableSetRenderer(int lineCount) {
        this.lineCount = lineCount;
        JLabel label1 = new JLabel("");
        this.fontMetrics = label1.getFontMetrics(label1.getFont());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            String text = value.toString();
            ArrayList<String> strs = new ArrayList<String>();
            int maxWidth = table.getColumnModel().getColumn(column).getWidth() - 10;
            if (maxWidth > 0) {
                StringUtils.wrapLineInto(text, strs, this.fontMetrics, maxWidth, this.lineCount + 1);
            }
            if (strs.isEmpty()) {
                JLabel label = new JLabel("");
                label.setOpaque(true);
                TableCellRendererUtils.setColors(label, table, isSelected);
                return label;
            }
            if (strs.size() == 1) {
                JLabel label = new JLabel((String)strs.get(0));
                label.setOpaque(true);
                TableCellRendererUtils.setColors(label, table, isSelected);
                return label;
            }
            JPanel p = new JPanel();
            p.setOpaque(true);
            p.setLayout(new GridLayout(this.lineCount, 1));
            int count = Math.min(strs.size(), this.lineCount);
            JLabel last = null;
            int i = 0;
            while (i < count) {
                last = new JLabel((String)strs.get(i));
                last.setOpaque(false);
                TableCellRendererUtils.setColors(last, table, isSelected);
                p.add(last);
                ++i;
            }
            if (last != null && strs.size() > this.lineCount) {
                last.setText(String.valueOf(last.getText()) + " " + (String)strs.get(strs.size() - 1));
            }
            TableCellRendererUtils.setColors(p, table, isSelected);
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JLabel(e.getMessage());
        }
    }
}

