/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.Set;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.IFactory;

public class UserRights {
    public static final UserRights ALLOW_ALL = new UserRights(null, -1){

        @Override
        public boolean haveRight(String code, String object, CompareUtils.Equalizer<? super String> objectMatcher) {
            return true;
        }
    };
    private final UserRightsManager manager;
    private final int userID;

    UserRights(UserRightsManager manager, int userID) {
        this.manager = manager;
        this.userID = userID;
    }

    public final int getUserID() {
        return this.userID;
    }

    public final boolean haveRight(String code) {
        return this.haveRight(code, null);
    }

    public final boolean haveRight(String code, String object) {
        return this.haveRight(code, object, CompareUtils.OBJECT_EQ);
    }

    public boolean haveRight(String code, String object, CompareUtils.Equalizer<? super String> objectMatcher) {
        return this.manager.haveRight(this.userID, code, object, objectMatcher);
    }

    public final Set<String> getObjects(String code, IFactory<Set<String>> allObjects) {
        if (this.haveRight(code)) {
            return null;
        }
        return this.manager.getObjects(this.userID, code, allObjects);
    }

    public final boolean canDelete(SQLTable table) {
        return TableAllRights.hasRight(this, "DELETE_ROW", table);
    }

    public final boolean canModify(SQLTable table) {
        return TableAllRights.hasRight(this, "UPDATE_ROW", table);
    }

    public boolean canModifyRights() {
        return this.canModify(this.manager == null ? null : this.manager.getTable());
    }

    public final boolean canAdd(SQLTable table) {
        return TableAllRights.hasRight(this, "INSERT_ROW", table);
    }

    public final boolean canView(SQLTable table) {
        return TableAllRights.hasRight(this, "SELECT_ROW", table);
    }

    public final boolean isSuperUser() {
        return this.haveRight(null);
    }
}

