/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLFunctionField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.ui.light.TableSearchMatcher;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.ui.light.TableSearchParameterType;

public class TableSearchColumnMatcher
implements TableSearchMatcher {
    private final SQLTableModelColumn col;

    public TableSearchColumnMatcher(SQLTableModelColumn col) {
        this.col = col;
    }

    @Override
    public boolean useMatch() {
        return false;
    }

    @Override
    public boolean match(SQLRowValues r, TableSearchParameterType type, String txt) {
        return true;
    }

    @Override
    public Where getWhere(SQLSelect sel, TableSearchParameterType type, String txt) {
        Set<FieldPath> fields = this.col.getPaths();
        ArrayList<Where> wFields = new ArrayList<Where>(fields.size());
        for (FieldPath fpath : fields) {
            Where w;
            if (!fpath.getField().getType().getJavaType().equals(String.class)) continue;
            FieldRef fieldRef = sel.followFieldPath(fpath);
            if (type.getType().equals("contains")) {
                w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)("%" + txt.toLowerCase() + "%"));
                wFields.add(w);
                continue;
            }
            if (type.getType().equals("starts")) {
                w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)(String.valueOf(txt.toLowerCase()) + "%"));
                wFields.add(w);
                continue;
            }
            if (!type.getType().equals("is")) continue;
            w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, fieldRef), "LIKE", (Object)txt.toLowerCase());
            wFields.add(w);
        }
        return Where.or(wFields);
    }

    @Override
    public List<FieldPath> getAdditionnalFieldsToFetch() {
        return Collections.emptyList();
    }
}

