/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.ui.light.CustomRowEditor;
import org.openconcerto.sql.ui.light.LightForeignRowValuesTableOffline;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelLinesSourceOffline;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.LightUICheckBox;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIDate;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.utils.io.JSONConverter;

public class LightEditFrame
extends LightUIFrame {
    private static final String EDIT_MODE_JSON_KEY = "edit-mode";
    private Group group;
    private SQLRowValues sqlRow;
    private EditPanel.EditMode editMode = EditPanel.EditMode.READONLY;

    public LightEditFrame() {
    }

    public LightEditFrame(JSONObject json) {
        super(json);
    }

    public LightEditFrame(LightEditFrame frame) {
        super(frame);
        this.sqlRow = frame.sqlRow;
        this.group = frame.group;
        this.editMode = frame.editMode;
    }

    public LightEditFrame(Configuration conf, Group group, SQLRowValues sqlRow, LightUIFrame parentFrame, EditPanel.EditMode editMode) {
        super(String.valueOf(group.getId()) + ".edit.frame");
        this.setType(13);
        this.setParent(parentFrame);
        this.sqlRow = sqlRow;
        this.group = group;
        this.setEditMode(editMode);
    }

    public void setEditMode(EditPanel.EditMode editMode) {
        this.editMode = editMode;
        if (editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            this.setReadOnly(true);
        } else {
            this.setReadOnly(false);
        }
    }

    public SQLRow commitSqlRow(Configuration configuration) throws SQLException {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to commit values when the frame is read only");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        return this.sqlRow.prune(sqlElement.getPrivateGraph()).commit();
    }

    public EditPanel.EditMode getEditMode() {
        return this.editMode;
    }

    public Group getGroup() {
        return this.group;
    }

    public SQLRowValues getSqlRow() {
        return this.sqlRow;
    }

    public void updateRow(Configuration configuration, String sessionSecurityToken, int userId) {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to update values when the frame is read only");
        }
        this.updateRow(configuration, this.group, sessionSecurityToken, userId);
    }

    private void updateRow(Configuration configuration, Group group, String sessionSecurityToken, int userId) {
        FieldMapper fieldMapper = configuration.getFieldMapper();
        if (fieldMapper == null) {
            throw new IllegalStateException("null field mapper");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        List<CustomRowEditor> customRowEditors = sqlElement.getCustomRowEditors(configuration, sessionSecurityToken);
        HashMap<String, CustomRowEditor> customEditors = new HashMap<String, CustomRowEditor>(customRowEditors.size());
        for (CustomRowEditor e : customRowEditors) {
            customEditors.put(e.getItemId(), e);
        }
        this.createRowValues(configuration, sqlElement, fieldMapper, this.group, customEditors);
        this.setMetaData(userId);
    }

    protected final void createRowValues(Configuration configuration, SQLElement sqlElement, FieldMapper fieldMapper, Group group, Map<String, CustomRowEditor> customEditors) {
        int itemCount = group.getSize();
        int i = 0;
        while (i < itemCount) {
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.createRowValues(configuration, sqlElement, fieldMapper, (Group)item, customEditors);
            } else {
                LightUIElement uiElement;
                SQLField field = fieldMapper.getSQLFieldForItem(item.getId());
                if (field != null) {
                    uiElement = this.findChildByID(item.getId(), LightUIElement.class);
                    if (uiElement == null) {
                        throw new IllegalArgumentException("Impossible to find UI Element with id: " + item.getId());
                    }
                    if (!uiElement.isNotSaved()) {
                        this.putValueFromUserControl(configuration, sqlElement, field, uiElement, customEditors);
                    }
                } else {
                    uiElement = this.findChildByID(item.getId(), LightUIElement.class);
                    if (uiElement == null) {
                        throw new IllegalArgumentException("Impossible to find UI Element with id: " + item.getId());
                    }
                    if (customEditors.containsKey(uiElement.getId())) {
                        CustomRowEditor customEditor = customEditors.get(uiElement.getId());
                        customEditor.store(uiElement, this.sqlRow);
                    } else {
                        Log.get().warning("No field attached to " + item.getId());
                    }
                }
            }
            ++i;
        }
    }

    protected final void putValueFromUserControl(Configuration configuration, SQLElement sqlElement, SQLField sqlField, LightUIElement uiElement, Map<String, CustomRowEditor> customEditors) {
        if (!uiElement.isNotSaved()) {
            Class<?> fieldType = sqlField.getType().getJavaType();
            if (customEditors.containsKey(uiElement.getId())) {
                CustomRowEditor customEditor = customEditors.get(uiElement.getId());
                customEditor.store(uiElement, this.sqlRow);
            } else {
                String fieldName = sqlField.getFieldName();
                if (sqlField.isKey()) {
                    if (!(uiElement instanceof LightUIComboBox)) {
                        throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is foreign key, UI Element must be a LightUIDate");
                    }
                    LightUIComboBox combo = (LightUIComboBox)uiElement;
                    if (combo.hasSelectedValue()) {
                        this.sqlRow.put(fieldName, combo.getSelectedValue().getId());
                    } else {
                        this.sqlRow.put(fieldName, null);
                    }
                } else {
                    String value = uiElement.getValue();
                    if (value == null && !sqlField.isNullable().booleanValue()) {
                        Log.get().warning("ignoring null value for not nullable field " + fieldName + " from table " + sqlField.getTable().getName());
                    } else if (fieldType.equals(String.class)) {
                        this.sqlRow.put(fieldName, value);
                    } else if (fieldType.equals(Date.class)) {
                        if (!(uiElement instanceof LightUIDate)) {
                            throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Date, UI Element must be a LightUIDate");
                        }
                        this.sqlRow.put(fieldName, ((LightUIDate)uiElement).getValueAsDate());
                    } else if (fieldType.equals(Boolean.class)) {
                        if (!(uiElement instanceof LightUICheckBox)) {
                            throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Boolean, UI Element must be a LightUICheckBox");
                        }
                        this.sqlRow.put(fieldName, ((LightUICheckBox)uiElement).isChecked());
                    } else if (fieldType.equals(Timestamp.class)) {
                        if (!(uiElement instanceof LightUIDate)) {
                            throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Date, UI Element must be a LightUIDate");
                        }
                        this.sqlRow.put(fieldName, ((LightUIDate)uiElement).getValueAsDate());
                    } else if (fieldType.equals(Integer.class)) {
                        if (value != null && !value.trim().isEmpty()) {
                            if (!value.matches("^-?\\d+$")) {
                                throw new IllegalArgumentException("Invalid value for field: " + fieldName + " value: " + value);
                            }
                            this.sqlRow.put(fieldName, Integer.parseInt(value));
                        } else {
                            this.sqlRow.put(fieldName, null);
                        }
                    } else if (fieldType.equals(Double.class) || fieldType.equals(Float.class) || fieldType.equals(BigDecimal.class)) {
                        if (value != null && !value.trim().isEmpty()) {
                            try {
                                this.sqlRow.put(fieldName, new BigDecimal(value));
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("Invalid value for field: " + fieldName + " value: " + value);
                            }
                        } else {
                            this.sqlRow.put(fieldName, null);
                        }
                    } else {
                        Log.get().warning("unsupported type " + fieldName);
                    }
                }
            }
        }
    }

    @Deprecated
    public final void saveReferentRows(Configuration configuration, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        this.saveReferentRows(configuration, this.group, parentSqlRow, customEditors, sessionSecurityToken);
    }

    @Deprecated
    private final void saveReferentRows(Configuration configuration, Group group, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        int i = 0;
        while (i < group.getSize()) {
            LightUIElement element;
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.saveReferentRows(configuration, (Group)item, parentSqlRow, customEditors, sessionSecurityToken);
            } else if (customEditors.containsKey(item.getId()) && (element = this.findChildByID(item.getId(), LightUIElement.class)) instanceof LightForeignRowValuesTableOffline) {
                LightForeignRowValuesTableOffline foreignTable = (LightForeignRowValuesTableOffline)element;
                int j = 0;
                while (j < foreignTable.getRowsCount()) {
                    ListSQLLine listLine = foreignTable.getModel().getRow(j);
                    SQLRowValues rowVals = listLine.getRow().createEmptyUpdateRow();
                    rowVals.put(foreignTable.getForeignField().getName(), parentSqlRow.getID());
                    ((SQLTableModelLinesSourceOffline)foreignTable.getModel().getLinesSource()).updateRow((Number)listLine.getID(), rowVals);
                    ++j;
                }
                Future<?> fCommit = foreignTable.commitRows();
                try {
                    fCommit.get();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            ++i;
        }
    }

    protected final void setMetaData(int userId) {
        SQLTable sqlTable = this.sqlRow.getTable();
        Date now = new Date();
        if (sqlTable.getCreationUserField() != null && (this.sqlRow.getObject(sqlTable.getCreationUserField().getName()) == null || this.sqlRow.getObject(sqlTable.getCreationDateField().getName()) == null)) {
            LightEditFrame.setFieldValue(this.sqlRow, sqlTable.getCreationUserField(), false, userId);
            LightEditFrame.setFieldValue(this.sqlRow, sqlTable.getCreationDateField(), false, now);
        }
        if (sqlTable.getModifUserField() != null) {
            LightEditFrame.setFieldValue(this.sqlRow, sqlTable.getModifUserField(), false, userId);
            LightEditFrame.setFieldValue(this.sqlRow, sqlTable.getModifDateField(), false, now);
        }
    }

    private static boolean setFieldValue(SQLRowValues vals, SQLField f, boolean remove, Object val) {
        if (f == null) {
            return false;
        }
        if (remove) {
            vals.remove(f.getName());
        } else {
            vals.put(f.getName(), val);
        }
        return true;
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    public LightUIElement clone() {
        return new LightEditFrame(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            if (this.editMode.equals((Object)EditPanel.EditMode.CREATION)) {
                json.put(EDIT_MODE_JSON_KEY, 1);
            } else if (this.editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
                json.put(EDIT_MODE_JSON_KEY, 2);
            }
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        int jsonEditMode = JSONConverter.getParameterFromJSON(json, EDIT_MODE_JSON_KEY, Integer.class, Integer.valueOf(3));
        if (jsonEditMode == 1) {
            this.editMode = EditPanel.EditMode.CREATION;
        } else if (jsonEditMode == 2) {
            this.editMode = EditPanel.EditMode.MODIFICATION;
        } else if (jsonEditMode == 3) {
            this.editMode = EditPanel.EditMode.READONLY;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            out.writeByte(0);
        } else if (this.editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
            out.writeByte(1);
        } else if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            out.writeByte(2);
        } else {
            throw new IllegalStateException("unknown mode " + (Object)((Object)this.editMode));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte mode = in.readByte();
        if (mode == 0) {
            this.editMode = EditPanel.EditMode.CREATION;
        } else if (mode == 1) {
            this.editMode = EditPanel.EditMode.MODIFICATION;
        } else if (mode == 2) {
            this.editMode = EditPanel.EditMode.READONLY;
        } else {
            throw new IllegalStateException("unknown mode " + mode);
        }
    }
}

