/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.utils.DecimalUtils;

public class RGProvider
implements SpreadSheetCellValueProvider {
    private final TypeRGProvider type;

    public RGProvider(TypeRGProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        BigDecimal total = this.type.isHt() ? new BigDecimal(context.getRow().getLong("T_HT")).movePointLeft(2) : new BigDecimal(context.getRow().getLong("T_TTC")).movePointLeft(2);
        BigDecimal pourcentRG = context.getRow().getBigDecimal("POURCENT_RG");
        BigDecimal totalRG = total.multiply(pourcentRG.movePointLeft(2), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
        if (this.type.isRestant()) {
            return total.subtract(totalRG);
        }
        return totalRG;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.rg.due", new RGProvider(TypeRGProvider.TTC_RG));
        SpreadSheetCellValueProviderManager.put("sales.total.sub.rg", new RGProvider(TypeRGProvider.TTC_RESTANT));
        SpreadSheetCellValueProviderManager.put("sales.rg.due.ht", new RGProvider(TypeRGProvider.HT_RG));
        SpreadSheetCellValueProviderManager.put("sales.total.sub.rg.ht", new RGProvider(TypeRGProvider.HT_RESTANT));
    }

    private static enum TypeRGProvider {
        HT_RESTANT(true, true),
        TTC_RESTANT(false, true),
        HT_RG(true, false),
        TTC_RG(false, false);

        private final boolean restant;
        private final boolean ht;

        private TypeRGProvider(boolean ht, boolean restant) {
            this.restant = restant;
            this.ht = ht;
        }

        public boolean isHt() {
            return this.ht;
        }

        public boolean isRestant() {
            return this.restant;
        }
    }
}

