/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class MouvementStockSQLComponent
extends BaseSQLComponent {
    public MouvementStockSQLComponent(SQLElement element) {
        super(element);
    }

    @Override
    public Set<String> getPartialResetNames() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("QTE");
        s.add("ID_ARTICLE");
        return s;
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelLib = new JLabel(this.getLabelFor("NOM"), 4);
        this.add((Component)labelLib, c);
        ++c.gridx;
        c.weightx = 1.0;
        SQLTextCombo textLib = new SQLTextCombo();
        this.add((Component)textLib, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"), 4);
        this.add((Component)labelDate, c);
        ++c.gridx;
        JDate date = new JDate(true);
        this.add((Component)date, c);
        final ElementComboBox articleSelect = new ElementComboBox();
        c.gridx = 0;
        ++c.gridy;
        JLabel labelArticle = new JLabel(this.getLabelFor("ID_ARTICLE"), 4);
        this.add((Component)labelArticle, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)articleSelect, c);
        final SQLRequestComboBox articleStock = new SQLRequestComboBox();
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        JLabel labelStock = new JLabel(this.getLabelFor("ID_STOCK"), 4);
        this.add((Component)labelStock, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)articleStock, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 13;
        JLabel labelQte = new JLabel(this.getLabelFor("QTE"), 4);
        this.add((Component)labelQte, c);
        ++c.gridx;
        c.fill = 0;
        JTextField textQte = new JTextField(6);
        c.weighty = 0.0;
        c.anchor = 18;
        this.add((Component)textQte, c);
        ++c.gridx;
        JCheckBox boxReel = new JCheckBox(this.getLabelFor("REEL"));
        this.add((Component)boxReel, c);
        this.addView(boxReel, "REEL");
        ++c.gridy;
        c.weighty = 1.0;
        JPanel comp = new JPanel();
        comp.setOpaque(false);
        this.add((Component)comp, c);
        DefaultGridBagConstraints.lockMinimumSize(textQte);
        DefaultGridBagConstraints.lockMaximumSize(textQte);
        this.addRequiredSQLObject(textQte, "QTE");
        this.addSQLObject(textLib, "NOM");
        this.addRequiredSQLObject(articleSelect, "ID_ARTICLE");
        this.addRequiredSQLObject(articleStock, "ID_STOCK");
        this.addRequiredSQLObject(date, "DATE");
        articleStock.getRequest().setWhere(Where.FALSE);
        articleSelect.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                articleStock.getRequest().setWhere(new Where((FieldRef)articleStock.getRequest().getPrimaryTable().getField("ID_ARTICLE"), "=", articleSelect.getWantedID()));
            }
        });
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("REEL", Boolean.TRUE);
        return rowVals;
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        try {
            ((MouvementStockSQLElement)this.getElement()).updateStock(Arrays.asList(this.getTable().getRow(id)), false);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Impossible de metter \u00e0 jour les stocks pour l'id " + id, e);
        }
        return id;
    }

    @Override
    public void update() {
        int id = this.getSelectedID();
        try {
            ((MouvementStockSQLElement)this.getElement()).updateStock(Arrays.asList(this.getTable().getRow(id)), true);
            super.update();
            ((MouvementStockSQLElement)this.getElement()).updateStock(Arrays.asList(this.getTable().getRow(id)), false);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Impossible de metter \u00e0 jour les stocks pour l'id " + id, e);
        }
    }
}

