/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AddressChoiceUI;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.customerrelationship.customer.ui.CategorieComptableChoiceUI;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.CommandeClientItemTable;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClientComboBox;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeRowItemView;
import org.openconcerto.erp.core.supplychain.order.table.ChiffrageCommandeTable;
import org.openconcerto.erp.core.supplychain.order.table.FacturationCommandeTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.valuewrapper.ValidatedValueWrapper;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

public class CommandeClientSQLComponent
extends TransfertBaseSQLComponent {
    private CommandeClientItemTable table;
    private FacturationCommandeTable tableFacturationItem;
    private ChiffrageCommandeTable tableChiffrageItem;
    private JUniqueTextField numeroUniqueCommande;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox comboCommercial;
    private ElementComboBox comboDevis;
    private ElementComboBox comboClient;
    private PanelOOSQLComponent panelOO;
    final JDate dateCommande = new JDate(true);
    private final boolean displayDpt;
    private final ElementComboBox comboDpt = new ElementComboBox();
    private final SQLTextCombo textObjet = new SQLTextCombo();

    public CommandeClientSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT"));
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        this.displayDpt = prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false);
    }

    @Override
    public RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }

    @Override
    public void addViews() {
        SQLPreferences prefs;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        this.numeroUniqueCommande = new JUniqueTextField(16){

            @Override
            public String getAutoRefreshNumber() {
                if (CommandeClientSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(CommandeClientSQLComponent.this.getElement().getClass(), CommandeClientSQLComponent.this.dateCommande.getDate());
                }
                return null;
            }
        };
        c.fill = 0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.numeroUniqueCommande, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.dateCommande, c);
        this.dateCommande.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CommandeClientSQLComponent.this.isFilling() && CommandeClientSQLComponent.this.dateCommande.getValue() != null) {
                    CommandeClientSQLComponent.this.table.setDateDevise(CommandeClientSQLComponent.this.dateCommande.getValue());
                }
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.comboDevis = new ElementComboBox();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        JLabel labelObjet = new JLabel(this.getLabelFor("NOM"));
        labelObjet.setHorizontalAlignment(4);
        c.weightx = 0.0;
        this.add((Component)labelObjet, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.textObjet, c);
        String field = "ID_COMMERCIAL";
        c.fill = 2;
        JLabel labelCommercial = new JLabel(this.getLabelFor(field));
        labelCommercial.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelCommercial, c);
        this.comboCommercial = new ElementComboBox(false, 25);
        this.comboCommercial.setListIconVisible(false);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 1.0;
        this.add((Component)this.comboCommercial, c);
        this.addRequiredSQLObject(this.comboCommercial, field);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ValidatedValueWrapper<Integer> clientValidatedValueWrapper = ValidatedValueWrapper.add(new ElementComboBox(), new ITransformer<Integer, ValidState>(){

            @Override
            public ValidState transformChecked(Integer t) {
                ElementComboBox boxClient = (ElementComboBox)CommandeClientSQLComponent.this.getView("ID_CLIENT").getComp();
                if (CommandeClientSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION && boxClient != null && !boxClient.isEmpty() && boxClient.getSelectedRow().getBoolean("BLOQUE").booleanValue()) {
                    return ValidState.create(false, "Les int\u00e9ractions avec ce client sont verrouill\u00e9es.");
                }
                return ValidState.getTrueInstance();
            }
        });
        this.comboClient = (ElementComboBox)clientValidatedValueWrapper.getComp();
        this.addView(new SimpleRowItemView<Integer>(clientValidatedValueWrapper), "ID_CLIENT", (Object)"required");
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.comboClient, c);
        final ElementComboBox boxTarif = new ElementComboBox();
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(CommandeClientSQLComponent.this.getMode() != SQLComponent.Mode.INSERTION && CommandeClientSQLComponent.this.isFilling() || CommandeClientSQLComponent.this.comboClient.getValue() == null)) {
                    Integer id = CommandeClientSQLComponent.this.comboClient.getValue();
                    if (id > 1) {
                        SQLRow row = CommandeClientSQLComponent.this.comboClient.getElement().getTable().getRow(id);
                        String alerte = row.getString("ALERTE");
                        if (alerte != null && alerte.trim().length() > 0) {
                            JOptionPane.showMessageDialog(CommandeClientSQLComponent.this.comboClient, alerte);
                        }
                        if (CommandeClientSQLComponent.this.comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                            SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                            if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, TM.tr((String)"apply.associated.pricelist.to.customer", (Object[])new Object[0])) != 0)) {
                                boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                            } else {
                                boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                            }
                        }
                        CommandeClientSQLComponent.this.table.setClient(row, !CommandeClientSQLComponent.this.isFilling());
                    } else if (!CommandeClientSQLComponent.this.isFilling()) {
                        CommandeClientSQLComponent.this.table.setClient(null, true);
                    }
                }
            }
        });
        if (this.displayDpt) {
            ++c.gridx;
            c.gridwidth = 1;
            JLabel labelDpt = new JLabel(this.getLabelFor("ID_CLIENT_DEPARTEMENT"));
            labelDpt.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelDpt, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)this.comboDpt, c);
            DefaultGridBagConstraints.lockMinimumSize(this.comboDpt);
            this.addSQLObject(this.comboDpt, "ID_CLIENT_DEPARTEMENT");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = CommandeClientSQLComponent.this.comboClient.getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = CommandeClientSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        CommandeClientSQLComponent.this.comboDpt.getRequest().setWhere(new Where((FieldRef)CommandeClientSQLComponent.this.comboDpt.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", rowClient.getID()));
                    } else {
                        CommandeClientSQLComponent.this.comboDpt.getRequest().setWhere(null);
                    }
                }
            });
        }
        if (this.getTable().contains("ID_CONTACT")) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"));
            labelContact.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelContact, c);
            final ElementComboBox comboContact = new ElementComboBox();
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)comboContact, c);
            final SQLElement contactElement = this.getElement().getForeignElement("ID_CONTACT");
            comboContact.init(contactElement, contactElement.getComboRequest(true));
            comboContact.getRequest().setWhere(Where.FALSE);
            DefaultGridBagConstraints.lockMinimumSize(comboContact);
            this.addView(comboContact, "ID_CONTACT");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = CommandeClientSQLComponent.this.comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = CommandeClientSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        if (rowClient.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowClient.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                            CommandeClientSQLComponent.this.table.setRowCatComptable(rowClient.getForeign("ID_CATEGORIE_COMPTABLE"));
                        } else {
                            CommandeClientSQLComponent.this.table.setRowCatComptable(null);
                        }
                        if (!rowClient.isForeignEmpty("ID_COMMERCIAL")) {
                            CommandeClientSQLComponent.this.comboCommercial.setValue(rowClient.getForeignID("ID_COMMERCIAL"));
                        }
                        int idClient = rowClient.getID();
                        comboContact.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_CLIENT"), "=", idClient));
                    } else {
                        CommandeClientSQLComponent.this.table.setRowCatComptable(null);
                        comboContact.getRequest().setWhere(Where.FALSE);
                    }
                }
            });
            if (this.getTable().contains("DATE_LIVRAISON_PREV")) {
                JLabel labelDatePrev = new JLabel(this.getLabelFor("DATE_LIVRAISON_PREV"));
                labelDatePrev.setHorizontalAlignment(4);
                c.gridx = 2;
                c.fill = 2;
                c.weightx = 0.0;
                this.add((Component)labelDatePrev, c);
                ++c.gridx;
                c.fill = 0;
                JDate datePrev = new JDate();
                this.add((Component)datePrev, c);
                this.addView(datePrev, "DATE_LIVRAISON_PREV");
            }
        }
        if ((prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.ADDRESS_SPEC, true)) {
            final SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
            final AddressChoiceUI addressUI = new AddressChoiceUI();
            addressUI.addToUI(this, c);
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = CommandeClientSQLComponent.this.comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        addressUI.getComboAdrF().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                        addressUI.getComboAdrL().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                    } else {
                        addressUI.getComboAdrF().getRequest().setWhere(Where.FALSE);
                        addressUI.getComboAdrL().getRequest().setWhere(Where.FALSE);
                    }
                }
            });
        }
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.CATEGORIE_COMPTABLE_SPEC, false)) {
            final CategorieComptableChoiceUI catUI = new CategorieComptableChoiceUI();
            catUI.addToUI(this, c);
            catUI.getCombo().addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = catUI.getCombo().getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        CommandeClientSQLComponent.this.table.setRowCatComptable(catUI.getCombo().getElement().getTable().getRow(wantedID));
                    } else {
                        CommandeClientSQLComponent.this.table.setRowCatComptable(null);
                    }
                }
            });
        }
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ORDER_PACKAGING_MANAGEMENT, true)) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("EMBALLAGE"), 4), c);
            c.fill = 2;
            ++c.gridx;
            c.weightx = 1.0;
            SQLTextCombo fieldEmballage = new SQLTextCombo();
            this.add((Component)fieldEmballage, c);
            this.addView(fieldEmballage, "EMBALLAGE");
            JLabel labelNumExp = new JLabel(this.getLabelFor("NUMERO_EXPEDITION"));
            labelNumExp.setHorizontalAlignment(4);
            c.gridx = 2;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)labelNumExp, c);
            JTextField fieldNumExp = new JTextField();
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)fieldNumExp, c);
            this.addView(fieldNumExp, "NUMERO_EXPEDITION");
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("TYPE_EXPEDITION"), 4), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.fill = 0;
            SQLTextCombo tTypeExpedition = new SQLTextCombo();
            this.add((Component)tTypeExpedition, c);
            this.addView(tTypeExpedition, "TYPE_EXPEDITION");
            JLabel labelEtat = new JLabel(this.getLabelFor("ETAT_COMMANDE"), 4);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)labelEtat, c);
            EtatCommandeClientComboBox comboEtat = new EtatCommandeClientComboBox();
            ++c.gridx;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)comboEtat, c);
            this.addView(new EtatCommandeRowItemView(comboEtat), "ETAT_COMMANDE", (Object)"required");
        }
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            c.fill = 2;
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel(this.getLabelFor("ID_TARIF"), 4), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    CommandeClientSQLComponent.this.table.setTarif(selectedRow, false);
                }
            });
            if (this.getTable().contains("DATE_LIVRAISON_REELLE")) {
                JLabel labelDatePrev = new JLabel(this.getLabelFor("DATE_LIVRAISON_REELLE"));
                labelDatePrev.setHorizontalAlignment(4);
                ++c.gridx;
                c.fill = 2;
                c.weightx = 0.0;
                this.add((Component)labelDatePrev, c);
                ++c.gridx;
                c.fill = 0;
                JDate datePrev = new JDate();
                this.add((Component)datePrev, c);
                this.addView(datePrev, "DATE_LIVRAISON_REELLE");
            }
        }
        if (this.getTable().getFieldsName().contains("ACOMPTE_COMMANDE")) {
            c.gridy = c.gridy + (this.getTable().getFieldsName().contains("ID_TARIF") ? 0 : 1);
            c.gridx = c.gridx + (this.getTable().getFieldsName().contains("ID_TARIF") ? 1 : 2);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ACOMPTE_COMMANDE"), 4), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            JTextField acompteCmd = new JTextField(15);
            DefaultGridBagConstraints.lockMinimumSize(acompteCmd);
            this.add((Component)acompteCmd, c);
            this.addView(acompteCmd, "ACOMPTE_COMMANDE");
        }
        this.table = new CommandeClientItemTable();
        this.table.getRowValuesTable().getRowValuesTableModel().setValidationField(this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT").getField("ID_COMMANDE_CLIENT_ELEMENT"));
        JTabbedPane pane = new JTabbedPane();
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        pane.add("El\u00e9ments", this.table);
        this.tableFacturationItem = new FacturationCommandeTable(this);
        pane.add("Facturation", this.tableFacturationItem);
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.CHIFFRAGE_COMMANDE_CLIENT, false)) {
            this.tableChiffrageItem = new ChiffrageCommandeTable(this);
            this.tableChiffrageItem.getRowValuesTable().setEditable(((CommandeClientSQLElement)this.getElement()).isChiffrageEditableInUI());
            pane.add("Chiffrage", this.tableChiffrageItem);
        }
        if (this.getTable().contains("INFOS_DEVIS")) {
            JPanel panelInfosDevis = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cI = new DefaultGridBagConstraints();
            cI.weightx = 1.0;
            cI.weighty = 1.0;
            cI.fill = 1;
            ITextArea infosDevis = new ITextArea();
            panelInfosDevis.add((Component)new JScrollPane(infosDevis), cI);
            this.addView(infosDevis, "INFOS_DEVIS");
            pane.add("Informations devis", panelInfosDevis);
        }
        this.add((Component)pane, c);
        DeviseField textPortHT = new DeviseField(5);
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldHA = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        fieldHT.setOpaque(false);
        fieldHA.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addSQLObject(fieldDevise, "T_DEVISE");
        this.addSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.allowEditable("T_HA", false);
            this.addSQLObject(fieldHA, "T_HA");
        }
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("T_HT", false);
        this.allowEditable("T_TVA", false);
        this.allowEditable("T_TTC", false);
        this.allowEditable("T_SERVICE", false);
        JTextField poids = new JTextField();
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldEco, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, fieldHA, fieldDevise, poids, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null, null);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 2;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, c);
        final JTextField textPoidsTotal = new JTextField(8);
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        c.fill = 2;
        panel.add((Component)new JLabel(this.getLabelFor("T_POIDS"), 4), cFrais);
        textPoidsTotal.setEnabled(false);
        textPoidsTotal.setDisabledTextColor(Color.BLACK);
        ++cFrais.gridx;
        panel.add((Component)textPoidsTotal, cFrais);
        panel.setOpaque(false);
        DefaultGridBagConstraints.lockMinimumSize(textPortHT);
        this.addSQLObject(textPortHT, "PORT_HT");
        DefaultGridBagConstraints.lockMinimumSize(textRemiseHT);
        this.addSQLObject(textRemiseHT, "REMISE_HT");
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelPortHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)textPortHT, cFrais);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelTaxeHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)boxTaxePort, cFrais);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
            boxTaxePort.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    totalTTC.updateTotal();
                }
            });
        }
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 0;
        panel.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        panel.add((Component)textRemiseHT, cFrais);
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false) && this.getTable().contains("T_ACOMPTE")) {
            ++cFrais.gridy;
            cFrais.gridx = 0;
            cFrais.weightx = 0.0;
            cFrais.weighty = 0.0;
            cFrais.gridwidth = 1;
            JLabel compAcompte = new JLabel(this.getLabelFor("T_ACOMPTE"), 4);
            panel.add((Component)compAcompte, cFrais);
            ++cFrais.gridx;
            cFrais.gridwidth = 0;
            DeviseField fieldAcompte = new DeviseField();
            fieldAcompte.setEnabled(false);
            cFrais.weightx = 1.0;
            panel.add((Component)fieldAcompte, cFrais);
            this.addView(fieldAcompte, "T_ACOMPTE");
        }
        c.gridx = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 12;
        DefaultGridBagConstraints.lockMinimumSize(panel);
        this.add((Component)panel, c);
        c.gridx = -1;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 0;
        c.weighty = 0.0;
        this.add((Component)totalTTC, c);
        this.panelOO = new PanelOOSQLComponent(this);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.gridx = 0;
        c.gridy += 3;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.add((Component)this.panelOO, c);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.addSQLObject(this.textObjet, "NOM");
        this.addSQLObject(textPoidsTotal, "T_POIDS");
        this.addRequiredSQLObject(this.dateCommande, "DATE");
        this.addRequiredSQLObject(this.numeroUniqueCommande, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        this.addSQLObject(this.comboDevis, "ID_DEVIS");
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(CommandeClientSQLComponent.this.table.getPoidsTotal()));
            }
        });
        this.addView(this.table.getRowValuesTable(), "");
        this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Integer id = CommandeClientSQLComponent.this.comboClient.getWantedID();
                if (id > 1) {
                    SQLRow rowClient = CommandeClientSQLComponent.this.comboClient.getElement().getTable().getRow(id);
                    if (rowClient.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowClient.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                        totalTTC.setCategorieComptable(rowClient.getForeign("ID_CATEGORIE_COMPTABLE"));
                        CommandeClientSQLComponent.this.table.setRowCatComptable(rowClient.getForeign("ID_CATEGORIE_COMPTABLE"));
                    } else {
                        totalTTC.setCategorieComptable(null);
                        CommandeClientSQLComponent.this.table.setRowCatComptable(null);
                    }
                }
            }
        });
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
        DefaultGridBagConstraints.lockMinimumSize(this.comboDevis);
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        DefaultGridBagConstraints.lockMaximumSize(totalTTC);
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueCommande);
    }

    @Override
    public int insert(SQLRow order) {
        int idCommande;
        String num;
        int attempt = 0;
        if (!this.numeroUniqueCommande.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.dateCommande.getDate());
                this.numeroUniqueCommande.setText(num);
                ++attempt;
                if (this.numeroUniqueCommande.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.numeroUniqueCommande.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idCommande = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            idCommande = super.insert(order);
            this.table.updateField("ID_COMMANDE_CLIENT", idCommande);
            this.tableFacturationItem.updateField("ID_COMMANDE_CLIENT", idCommande);
            if (this.tableChiffrageItem != null) {
                this.tableChiffrageItem.updateField("ID_COMMANDE_CLIENT", idCommande);
            }
            try {
                this.updateStock(idCommande);
            }
            catch (SQLException e1) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 du stock!", e1);
            }
            this.table.createArticle(idCommande, this.getElement());
            SQLRow row = this.getElement().getTable().getRow(idCommande);
            try {
                CommandeClientXmlSheet sheet = new CommandeClientXmlSheet(this.getTable().getRow(idCommande));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), row);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er la commande", e);
            }
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()).equalsIgnoreCase(this.numeroUniqueCommande.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("COMMANDE_CLIENT_START");
                rowVals.put("COMMANDE_CLIENT_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                    }
                });
            }
            ((CommandeClientSQLElement)this.getElement()).fireInsertedCmdListener(row);
        }
        return idCommande;
    }

    @Override
    public Set<String> getPartialResetNames() {
        HashSet<String> s = new HashSet<String>();
        s.add("NOM");
        s.add("NUMERO");
        s.add("INFOS");
        s.add("ID_CLIENT");
        if (this.getTable().contains("ACOMPTE_COMMANDE")) {
            s.add("ACOMPTE_COMMANDE");
        }
        return s;
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null) {
            this.table.getRowValuesTable().insertFrom(r);
            this.tableFacturationItem.getRowValuesTable().insertFrom(r);
            if (this.tableChiffrageItem != null) {
                this.tableChiffrageItem.getRowValuesTable().insertFrom(r);
            }
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueCommande.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        int id = this.getSelectedID();
        this.table.updateField("ID_COMMANDE_CLIENT", id);
        this.tableFacturationItem.updateField("ID_COMMANDE_CLIENT", id);
        if (this.tableChiffrageItem != null) {
            this.tableChiffrageItem.updateField("ID_COMMANDE_CLIENT", id);
        }
        this.table.createArticle(id, this.getElement());
        SQLRow row = this.getTable().getRow(id);
        try {
            this.updateStock(id);
        }
        catch (SQLException e1) {
            ExceptionHandler.handle("Erreur lors de la mise \u00e0 du stock!", e1);
        }
        try {
            CommandeClientXmlSheet sheet = new CommandeClientXmlSheet(row);
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), row);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er la commande", e);
        }
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Commande client N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        if (row.getInt("ETAT_COMMANDE") != EtatCommandeClient.ANNULEE.getId()) {
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return CommandeClientSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("COMMANDE_CLIENT_ELEMENT")), StockItemsUpdater.TypeStockUpdate.VIRTUAL_DELIVER);
            stockUpdater.update();
        } else {
            SQLElement eltMvtStock = this.getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l != null) {
                int i = 0;
                while (i < l.size()) {
                    Object[] tmp = (Object[])l.get(i);
                    eltMvtStock.archive(((Number)tmp[0]).intValue());
                    ++i;
                }
            }
        }
    }

    public void setDefaults() {
        this.resetValue();
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        this.table.getModel().clearRows();
    }

    public void loadDevis(int idDevis) {
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLInjector injector = SQLInjector.getInjector(devis.getTable(), this.getTable());
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idDevis);
            SQLRow rowDevis = devis.getTable().getRow(idDevis);
            String string = rowDevis.getString("OBJET");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowDevis.getString("NUMERO"));
            this.select(createRowValuesFrom);
        }
        this.loadItem(this.table, devis, idDevis, devisElt);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRow taxeDefault;
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        if (this.getTable().contains("ETAT_COMMANDE")) {
            rowVals.put("ETAT_COMMANDE", EtatCommandeClient.A_PREPARER.getId());
        }
        if (this.getTable().contains("ID_TAXE_PORT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        if (this.getTable().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_FRAIS_DOCUMENT", taxeDefault.getID());
        }
        return rowVals;
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor r) {
        if (this.dateCommande.getValue() != null && r.getObject("DATE") != null) {
            this.table.setDateDevise(r.getDate("DATE").getTime());
        }
    }

    public void loadCommandeExistant(int idCommande) {
        Collection myListItem;
        SQLElement commande = this.getElement();
        SQLElement commandeElt = this.getElement().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        if (idCommande > 1) {
            SQLRow row = this.getTable().getRow(idCommande);
            SQLRowValues rowVals = new SQLRowValues(this.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            if (row.getObject("ID_TARIF") != null && !row.isForeignEmpty("ID_TARIF")) {
                rowVals.put("ID_TARIF", row.getInt("ID_TARIF"));
            }
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
            this.select(rowVals);
        }
        if ((myListItem = this.getTable().getRow(idCommande).getReferentRows(commandeElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                if (rowVals.getTable().contains("ID_DEVIS_ELEMENT")) {
                    rowVals.putEmptyLink("ID_DEVIS_ELEMENT");
                }
                rowVals.put("QTE_LIVREE", BigDecimal.ZERO);
                rowVals.put("LIVRE", Boolean.FALSE);
                rowVals.put("LIVRE_FORCED", Boolean.FALSE);
                this.table.getModel().addRow(rowVals, false);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }
}

