/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.importer.Transaction;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLUtils;

public class ReleveBancaireSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "RELEVE_BANCAIRE";

    public ReleveBancaireSQLElement() {
        super(TABLE_NAME);
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("LABEL", "ANNEE", "MOIS", "DEBIT", "CREDIT");
    }

    @Override
    protected SQLComponent createComponent() {
        return null;
    }

    public int importReleve(int idBanque, final int month, final int year, final List<Transaction> transactions) throws SQLException {
        LocalDate min;
        if (transactions.isEmpty()) {
            return 0;
        }
        Collections.sort(transactions, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction o1, Transaction o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        Transaction.computeHashes(transactions);
        LocalDate max = min = transactions.get(0).getDateValue();
        for (Transaction t : transactions) {
            LocalDate d = t.getDateValue();
            if (d.isBefore(min)) {
                min = d;
                continue;
            }
            if (!d.isAfter(max)) continue;
            max = d;
        }
        if (min.getYear() != year) {
            throw new IllegalArgumentException("a transaction is not in the specified year (" + year + ") but is " + min.getYear());
        }
        if (max.getYear() != year) {
            throw new IllegalArgumentException("a transaction is not in the specified year (" + year + ") but is " + max.getYear());
        }
        if (min.getMonthValue() != month) {
            throw new IllegalArgumentException("a transaction is not in the specified month (" + month + ") but is " + min.getMonthValue());
        }
        if (max.getMonthValue() != month) {
            throw new IllegalArgumentException("a transaction is not in the specified month (" + month + ") but is " + max.getMonthValue());
        }
        final ReleveRef releve = this.getReleve(idBanque, month, year);
        final Set<String> existingUUIDs = this.getElementHashes(min, max);
        final SQLTable tReleve = this.getTable();
        final SQLInsert rinsert = new SQLInsert();
        rinsert.add(tReleve.getField("ID_BANQUE"), idBanque);
        rinsert.add(tReleve.getField("ANNEE"), year);
        rinsert.add(tReleve.getField("MOIS"), month);
        Object o = SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                int idReleve = releve == null ? ((Number)ds.executeScalar(rinsert.asString())).intValue() : releve.id.intValue();
                SQLTable tReleveElement = ReleveBancaireSQLElement.this.getTable().getTable("RELEVE_BANCAIRE_ELEMENT");
                ArrayList<SQLInsert> transactionsInserts = new ArrayList<SQLInsert>();
                for (Transaction t : transactions) {
                    if (existingUUIDs.contains(t.getHash())) continue;
                    SQLInsert insert = new SQLInsert();
                    insert.add(tReleveElement.getField("ID_RELEVE_BANCAIRE"), idReleve);
                    insert.add(tReleveElement.getField("UUID"), t.getUUID());
                    insert.add(tReleveElement.getField("TYPE"), t.getType());
                    String name = t.getName();
                    if (name == null) {
                        name = "";
                    }
                    insert.add(tReleveElement.getField("NAME"), name);
                    insert.add(tReleveElement.getField("DESCRIPTION"), t.getMemo());
                    insert.add(tReleveElement.getField("COMMENT"), "");
                    insert.add(tReleveElement.getField("MONTANT"), t.getAmount());
                    insert.add(tReleveElement.getField("DATE"), ReleveBancaireSQLElement.this.toTimeStamp(t.getDate()));
                    insert.add(tReleveElement.getField("DATE_VALEUR"), ReleveBancaireSQLElement.this.toTimeStamp(t.getDateValue()));
                    insert.add(tReleveElement.getField("HASH"), t.getHash());
                    transactionsInserts.add(insert);
                }
                Log.get().info("creating " + transactionsInserts + " lines for " + month + "/" + year);
                if (!transactionsInserts.isEmpty()) {
                    SQLInsert.executeSimilarInserts(ReleveBancaireSQLElement.this.getTable().getDBSystemRoot(), transactionsInserts, false);
                }
                SQLField idReleveF = tReleveElement.getField("ID_RELEVE_BANCAIRE");
                SQLSelect sel = new SQLSelect();
                sel.addSelect(idReleveF);
                sel.addSelect(tReleveElement.getField("MONTANT"), "sum", "credit");
                sel.setWhere(new Where((FieldRef)tReleveElement.getField("MONTANT"), ">", 0));
                sel.andWhere(new Where((FieldRef)idReleveF, "=", idReleve));
                sel.addGroupBy(idReleveF);
                UpdateBuilder upd = new UpdateBuilder(tReleve);
                upd.addVirtualJoin("( " + sel.asString() + " )", "sel", false, idReleveF.getName(), tReleve.getKey().getName());
                upd.setFromVirtualJoinField("CREDIT", "sel", "credit");
                ReleveBancaireSQLElement.this.getTable().getDBSystemRoot().getDataSource().execute(upd.asString());
                idReleveF = tReleveElement.getField("ID_RELEVE_BANCAIRE");
                sel = new SQLSelect();
                sel.addSelect(idReleveF);
                sel.addSelect(tReleveElement.getField("MONTANT"), "sum", "debit");
                sel.setWhere(new Where((FieldRef)tReleveElement.getField("MONTANT"), "<", 0));
                sel.andWhere(new Where((FieldRef)idReleveF, "=", idReleve));
                sel.addGroupBy(idReleveF);
                upd = new UpdateBuilder(tReleve);
                upd.addVirtualJoin("( " + sel.asString() + " )", "sel", false, idReleveF.getName(), tReleve.getKey().getName());
                upd.setFromVirtualJoinField("DEBIT", "sel", "debit");
                return transactionsInserts.size();
            }
        });
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new IllegalStateException("unknown type :" + o);
    }

    public SQLRow getRowReleve(int idBanque, int month, int year) {
        SQLTable tReleve = this.getTable();
        SQLSelect select = new SQLSelect();
        select.addSelect(tReleve.getKey());
        select.addSelect(tReleve.getField("ANNEE"));
        select.addSelect(tReleve.getField("MOIS"));
        Where w = new Where((FieldRef)tReleve.getField("ID_BANQUE"), "=", idBanque);
        w = w.and(new Where((FieldRef)tReleve.getField("ANNEE"), "=", year));
        w = w.and(new Where((FieldRef)tReleve.getField("MOIS"), " =", month));
        select.setWhere(w);
        List<SQLRow> rows = SQLRowListRSH.execute(select, false, false);
        if (rows.isEmpty()) {
            return null;
        }
        if (rows.size() > 1) {
            throw new IllegalStateException("plus d'un relev\u00e9 dans la base pour " + month + "-" + year);
        }
        return rows.get(0);
    }

    public ReleveRef getReleve(int idBanque, int month, int year) {
        SQLRow r = this.getRowReleve(idBanque, month, year);
        if (r == null) {
            return null;
        }
        ReleveRef ref = new ReleveRef();
        ref.id = r.getID();
        ref.month = r.getInt("MOIS");
        ref.year = r.getInt("ANNEE");
        return ref;
    }

    public Set<ReleveRef> getExistingReleve(int idBanque, LocalDate min, LocalDate max) {
        int minYear = min.getYear();
        int minMonth = min.getMonthValue();
        int maxYear = min.getYear();
        int maxMonth = min.getMonthValue();
        SQLTable tReleve = this.getTable();
        SQLSelect select = new SQLSelect();
        select.addSelect(tReleve.getKey());
        select.addSelect(tReleve.getField("ANNEE"));
        select.addSelect(tReleve.getField("MOIS"));
        Where w = new Where((FieldRef)tReleve.getField("ID_BANQUE"), "=", idBanque);
        w = w.and(new Where((FieldRef)tReleve.getField("ANNEE"), ">=", minYear)).and(new Where((FieldRef)tReleve.getField("ANNEE"), "<=", maxYear));
        w = w.and(new Where((FieldRef)tReleve.getField("MOIS"), ">=", minMonth)).and(new Where((FieldRef)tReleve.getField("MOIS"), "<=", maxMonth));
        select.setWhere(w);
        List<SQLRow> rows = SQLRowListRSH.execute(select, false, false);
        HashSet<ReleveRef> result = new HashSet<ReleveRef>();
        for (SQLRow r : rows) {
            ReleveRef ref = new ReleveRef();
            ref.id = r.getID();
            ref.month = r.getInt("MOIS");
            ref.year = r.getInt("ANNEE");
            result.add(ref);
        }
        return result;
    }

    private Set<String> getElementHashes(LocalDate min, LocalDate max) {
        SQLTable tReleveElement = this.getTable().getTable("RELEVE_BANCAIRE_ELEMENT");
        SQLSelect select = new SQLSelect();
        select.addSelect(tReleveElement.getKey());
        select.addSelect(tReleveElement.getField("HASH"));
        select.setWhere(new Where((FieldRef)tReleveElement.getField("DATE_VALEUR"), this.toTimeStamp(min), (Object)this.toTimeStamp(max)));
        List<SQLRow> rows = SQLRowListRSH.execute(select, false, false);
        HashSet<String> result = new HashSet<String>();
        for (SQLRow r : rows) {
            result.add(r.getString("HASH"));
        }
        return result;
    }

    private Timestamp toTimeStamp(LocalDate d) {
        Timestamp time = Timestamp.valueOf(d.atStartOfDay());
        return time;
    }

    @Override
    protected String createCode() {
        return "finance.accounting.bank.statement";
    }

    class ReleveRef {
        Number id;
        int year;
        int month;

        ReleveRef() {
        }

        public boolean equals(Object obj) {
            ReleveRef r = (ReleveRef)obj;
            return r.year == this.year && r.month == this.month;
        }

        public int hashCode() {
            return this.year * 100 + this.month;
        }
    }
}

