/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.utils.SystemUtils;
import org.openconcerto.utils.i18n.I18nUtils;

public class RuleBasedNumberFormatUtils {
    public static final String LOCALE_PROP_NAME = "locales";

    public static void main(String[] args) {
        String action;
        if (args.length == 0) {
            System.out.println("--list\tList rule names");
            System.out.println("--eval number message\tEvaluate the passed string using MessageFormat");
            System.out.println("Use locales system property to define locales to use");
            System.exit(0);
        }
        if ((action = args[0]).equals("--list")) {
            for (ULocale l : RuleBasedNumberFormatUtils.getLocales()) {
                System.out.println(I18nUtils.dumpAllRules(l));
                System.out.println();
            }
        } else if (action.equals("--eval")) {
            Object[] params = new Object[]{Long.valueOf(args[1])};
            String message = args[2];
            for (ULocale l : RuleBasedNumberFormatUtils.getLocales()) {
                System.out.println(String.valueOf(l.getName()) + ":");
                System.out.println(new MessageFormat(message, l).format(params));
                System.out.println();
            }
        } else {
            throw new IllegalArgumentException("Unknown action : " + action);
        }
    }

    private static List<ULocale> getLocales() {
        List<ULocale> res;
        List<String> pl = new SystemUtils.PropertyList(LOCALE_PROP_NAME, ",").getValues();
        if (pl == null || pl.isEmpty()) {
            res = Collections.singletonList(ULocale.getDefault());
        } else {
            res = new ArrayList<ULocale>(pl.size());
            for (String l : pl) {
                res.add(ULocale.forLanguageTag(l));
            }
        }
        return res;
    }
}

