/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringUtils;

public abstract class Change {
    public static final Properties props = new Properties();

    static {
        props.put("jdbc.connection.allowMultiQueries", "true");
    }

    protected final void exec(String ... nameNparams) throws SQLException, IOException {
        this.exec((DBStructureItem<?>)null, nameNparams);
    }

    protected final void exec(DBStructureItem<?> root, String ... nameNparams) throws SQLException, IOException {
        if (nameNparams.length == 0) {
            throw new IllegalArgumentException("usage: " + this.getClass().getName() + " changer params...");
        }
        String[] params = new String[nameNparams.length - 1];
        System.arraycopy(nameNparams, 1, params, 0, params.length);
        this.exec(root, nameNparams[0], params);
    }

    private final void exec(DBStructureItem<?> root, String changerName, String ... params) throws SQLException, IOException {
        Class<? extends Changer> changer = this.findClass(changerName);
        if (changer == null) {
            throw new IllegalArgumentException(String.valueOf(changerName) + " not found.");
        }
        if (ProductInfo.getInstance() == null) {
            ProductInfo.setInstance(new ProductInfo(changer.getName()));
        }
        if (root == null) {
            this.exec(changer, params);
        } else {
            this.exec(root, changer, params);
        }
    }

    public void exec(Class<? extends Changer> changer, String ... params) throws IOException, SQLException {
        String pathname = System.getProperty("confFile", "changeBase.properties");
        this.exec(new PropsConfiguration(new File(pathname), props).getRoot(), changer, params);
    }

    public void exec(DBStructureItem<?> root, Class<? extends Changer> changer, String ... params) throws SQLException {
        if (params.length == 0) {
            Changer.change(root, changer);
        } else {
            DBSystemRoot dBSystemRoot;
            ArrayList<SQLName> names = new ArrayList<SQLName>(params.length);
            HashSet<String> children = new HashSet<String>();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                SQLName n3 = SQLName.parse(string);
                names.add(n3);
                children.add(n3.getFirst());
                ++n2;
            }
            if (root instanceof DBSystemRoot && !(dBSystemRoot = (DBSystemRoot)root).getChildrenNames().containsAll(children)) {
                dBSystemRoot.addRoots(new ArrayList<String>(children));
            }
            for (SQLName sQLName : names) {
                Changer.change(root.getDescendant(sQLName), changer);
            }
        }
    }

    public final Class<? extends Changer> findClass(String converter) {
        if (converter.indexOf(46) > 0) {
            return this.findClassFromFullName(converter);
        }
        String normalized = StringUtils.firstUp(converter);
        Class<? extends Changer> res = null;
        for (String pkg : this.getPackages()) {
            res = this.findClass(pkg, normalized);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected List<String> getPackages() {
        ArrayList<String> res = new ArrayList<String>();
        Class<?> c = this.getClass();
        while (c != Change.class) {
            res.add(String.valueOf(c.getPackage().getName()) + "." + c.getSimpleName().toLowerCase());
            c = c.getSuperclass();
        }
        return res;
    }

    protected final Class<? extends Changer> findClass(String pkgName, String converter) {
        return this.findClassFromFullName(String.valueOf(pkgName) + '.' + converter);
    }

    protected final Class<? extends Changer> findClassFromFullName(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.asSubclass(Changer.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }
}

