/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeFichePayeAddPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class HistoriqueFichePayePanel
extends JPanel {
    private IListPanel listePanel;
    private MouseListener listener;
    private JListSQLTablePanel jListPanel;
    private final ListSelectionListener listListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectIndex = HistoriqueFichePayePanel.this.jListPanel.getSelectedIndex();
            SQLRowAccessor row = HistoriqueFichePayePanel.this.jListPanel.getModel().getRowAt(selectIndex);
            int id = -1;
            if (row != null) {
                id = row.getID();
            }
            SQLTable table = HistoriqueFichePayePanel.this.listePanel.getElement().getTable();
            Where w = new Where((FieldRef)table.getField("VALIDE"), "=", (Object)Boolean.TRUE);
            if (id > 1) {
                w = w.and(new Where((FieldRef)table.getField("ID_" + HistoriqueFichePayePanel.this.jListPanel.getModel().getTable().getName()), "=", id));
            }
            HistoriqueFichePayePanel.this.listePanel.getListe().getRequest().setWhere(w);
            HistoriqueFichePayePanel.this.listePanel.getListe().setModificationAllowed(false);
        }
    };

    public HistoriqueFichePayePanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        SQLElement e = Configuration.getInstance().getDirectory().getElement("SALARIE");
        SQLElement eltFiche = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        this.jListPanel = new JListSQLTablePanel(JListSQLTablePanel.createComboRequest(e, true), "Tous");
        SQLTableModelSourceOnline src = eltFiche.getTableSource(true);
        src.getReq().setWhere(Where.FALSE);
        this.listePanel = new ListeFichePayeAddPanel(eltFiche, new IListe(src));
        this.listePanel.setAddVisible(false);
        this.listePanel.getListe().setModificationAllowed(false);
        this.listePanel.setOpaque(false);
        this.listePanel.setBorder(null);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cRight = new DefaultGridBagConstraints();
        cRight.fill = 1;
        cRight.weightx = 1.0;
        cRight.weighty = 1.0;
        rightPanel.add((Component)this.listePanel, cRight);
        JSplitPane split = new JSplitPane(1, this.jListPanel, rightPanel);
        split.setBorder(null);
        split.setDividerLocation(275);
        this.add((Component)split, c);
        JButton buttonClose = new JButton("Fermer");
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((JFrame)SwingUtilities.getRoot(HistoriqueFichePayePanel.this)).dispose();
            }
        });
        this.listePanel.getListe().getJTable().addMouseListener(this.listener);
        this.jListPanel.addListSelectionListener(this.listListener);
    }

    public void selectIDinJList(int id) {
        int index = this.jListPanel.getModel().getIndexForId(id);
        if (index >= 0) {
            this.jListPanel.getJList().setSelectedIndex(index);
            this.jListPanel.getJList().ensureIndexIsVisible(index);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.jListPanel.addListSelectionListener(l);
    }

    public SQLRowAccessor getSelectedRow() {
        return this.jListPanel.getModel().getRowAt(this.jListPanel.getSelectedIndex());
    }
}

