/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.action;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeFichePayeAddPanel;
import org.openconcerto.erp.core.humanresources.payroll.report.FichePayeSheetXML;
import org.openconcerto.erp.core.humanresources.payroll.ui.PanelCumulsPaye;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class ListeDesFichesDePayeAction
extends CreateFrameAbstractAction {
    private EditFrame editFrame = null;

    public ListeDesFichesDePayeAction() {
        this.putValue("Name", "Liste des fiches de paye");
    }

    public JFrame createFrame() {
        final SQLElement elt = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        SQLTableModelSourceOnline src = elt.getTableSource(true);
        src.getReq().setWhere(new Where((FieldRef)elt.getTable().getField("VALIDE"), "=", (Object)Boolean.TRUE));
        ListeFichePayeAddPanel liste = new ListeFichePayeAddPanel(elt, new IListe(src));
        final IListFrame frame = new IListFrame(liste);
        frame.getPanel().getListe().setModificationAllowed(false);
        frame.getPanel().setAddVisible(false);
        final PanelCumulsPaye pCumuls = new PanelCumulsPaye();
        final PanelFrame p = new PanelFrame(pCumuls, "D\u00e9tails cumuls et variables");
        frame.getPanel().getListe().addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                pCumuls.selectFicheFromId(id);
            }
        });
        frame.getPanel().getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && frame.getPanel().getListe().getSelectedId() > 1) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    final SQLRow rowFiche = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("FICHE_PAYE").getRow(frame.getPanel().getListe().getSelectedId());
                    MouseSheetXmlListeListener l = new MouseSheetXmlListeListener(elt, FichePayeSheetXML.class);
                    for (RowAction action : l.getRowActions()) {
                        menuDroit.add(action.getAction());
                    }
                    menuDroit.add(new AbstractAction("D\u00e9tails cumuls et variables"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pCumuls.selectFiche(rowFiche);
                            p.setVisible(true);
                        }
                    });
                    menuDroit.pack();
                    menuDroit.show(mouseEvent.getComponent(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    menuDroit.setVisible(true);
                }
            }
        });
        return frame;
    }
}

