/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DurationTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = "";
        if (value != null) {
            this.setHorizontalAlignment(2);
            long seconds = ((Number)value).longValue();
            if (seconds < 60L) {
                text = String.valueOf(seconds) + "s";
            } else {
                long nbMin = seconds / 60L;
                long nbSeconds = seconds % 60L;
                text = String.valueOf(nbMin) + "min";
                if (nbSeconds > 0L) {
                    text = String.valueOf(text) + " " + nbSeconds + "s";
                }
            }
        }
        return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
    }
}

