/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public abstract class SimpleDocumentFilter
extends DocumentFilter {
    public static final String subString(Document doc, int offset) throws BadLocationException {
        return doc.getText(offset, doc.getLength() - offset);
    }

    public static String computeInsertString(DocumentFilter.FilterBypass fb, int offset, String text) throws BadLocationException {
        return String.valueOf(fb.getDocument().getText(0, offset)) + text + SimpleDocumentFilter.subString(fb.getDocument(), offset);
    }

    public static String computeRemove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        return String.valueOf(fb.getDocument().getText(0, offset)) + SimpleDocumentFilter.subString(fb.getDocument(), offset + length);
    }

    public static String computeReplace(DocumentFilter.FilterBypass fb, int offset, int length, String text) throws BadLocationException {
        return String.valueOf(fb.getDocument().getText(0, offset)) + text + SimpleDocumentFilter.subString(fb.getDocument(), offset + length);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        if (this.change(fb, SimpleDocumentFilter.computeRemove(fb, offset, length), Mode.REMOVE)) {
            super.remove(fb, offset, length);
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        if (this.change(fb, SimpleDocumentFilter.computeInsertString(fb, offset, text), Mode.INSERT)) {
            super.insertString(fb, offset, text, attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.change(fb, SimpleDocumentFilter.computeReplace(fb, offset, length, text), Mode.REPLACE)) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    protected abstract boolean change(DocumentFilter.FilterBypass var1, String var2, Mode var3) throws BadLocationException;

    public static enum Mode {
        INSERT,
        REMOVE,
        REPLACE;

    }
}

