/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.mime;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.mime.MimeType;

public class FreeDesktopMimeDetector
extends FileTypeDetector {
    public static final String DEFAULT_CACHE = "freeDesktop.mime.cache";
    public static final String DEFAULT_MODE = "freeDesktop.mime.mode";
    private static File mimeCacheFile = OSFamily.getInstance() == OSFamily.Windows ? null : new File("/usr/share/mime/mime.cache");
    private final ByteBuffer content;
    private final Mode mode;

    private static Mode getDefaultMode() {
        String m = System.getProperty(DEFAULT_MODE);
        if (m != null) {
            try {
                return Mode.valueOf(m.toUpperCase());
            }
            catch (Exception e) {
                Log.get().log(Level.CONFIG, "Ignoring invalid mode : " + m, e);
            }
        }
        return Mode.RECOMMENDED;
    }

    private static boolean canReadFile(File f, String msg) {
        boolean res;
        if (f == null) {
            return false;
        }
        boolean bl = res = f.isFile() && f.canRead();
        if (!res) {
            Log.get().config(String.valueOf(msg) + f);
        }
        return res;
    }

    private static Object getDefaultCache() {
        File f;
        String m = System.getProperty(DEFAULT_CACHE);
        File file = f = m != null ? new File(m) : null;
        if (FreeDesktopMimeDetector.canReadFile(f, "Ignoring invalid passed file : ")) {
            return f;
        }
        if (FreeDesktopMimeDetector.canReadFile(mimeCacheFile, "Ignoring invalid system file : ")) {
            return mimeCacheFile;
        }
        URL res = FreeDesktopMimeDetector.class.getResource("mime.cache");
        if (res == null) {
            throw new IllegalStateException("No mime.cache found for " + FreeDesktopMimeDetector.class);
        }
        return res;
    }

    public FreeDesktopMimeDetector() throws IOException {
        this(FreeDesktopMimeDetector.getDefaultCache(), FreeDesktopMimeDetector.getDefaultMode());
    }

    public FreeDesktopMimeDetector(File mimeCacheFile, Mode mode) throws IOException {
        this((Object)mimeCacheFile, mode);
    }

    public FreeDesktopMimeDetector(InputStream is, Mode mode) throws IOException {
        this((Object)is, mode);
    }

    /*
     * Unable to fully structure code
     */
    private FreeDesktopMimeDetector(Object cache, Mode mode) throws IOException {
        super();
        if (cache instanceof File || cache instanceof FileInputStream) {
            var3_3 = null;
            var4_6 = null;
            try {
                is = cache instanceof FileInputStream != false ? (FileInputStream)cache : new FileInputStream((File)cache);
                try {
                    rCh = is.getChannel();
                    try {
                        this.content = rCh.map(FileChannel.MapMode.READ_ONLY, 0L, rCh.size());
                    }
                    finally {
                        if (rCh != null) {
                            rCh.close();
                        }
                    }
                    if (is == null) ** GOTO lbl57
                }
                catch (Throwable var4_7) {
                    if (var3_3 == null) {
                        var3_3 = var4_7;
                    } else if (var3_3 != var4_7) {
                        var3_3.addSuppressed(var4_7);
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw var3_3;
                }
                is.close();
            }
            catch (Throwable var4_8) {
                if (var3_3 == null) {
                    var3_3 = var4_8;
                } else if (var3_3 != var4_8) {
                    var3_3.addSuppressed(var4_8);
                }
                throw var3_3;
            }
        } else {
            out = new ByteArrayOutputStream(256000);
            var4_9 = null;
            var5_12 = null;
            try {
                is = cache instanceof URL != false ? ((URL)cache).openStream() : (InputStream)cache;
                try {
                    StreamUtils.copy(is, out);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable var5_13) {
                if (var4_9 == null) {
                    var4_9 = var5_13;
                } else if (var4_9 != var5_13) {
                    var4_9.addSuppressed(var5_13);
                }
                throw var4_9;
            }
            this.content = ByteBuffer.wrap(out.toByteArray());
        }
lbl57:
        // 3 sources

        this.mode = mode;
    }

    @Override
    public String probeContentType(Path path) throws IOException {
        Collection<String> col;
        switch (this.mode) {
            case RECOMMENDED: {
                col = this.getMimeTypesFile(path.toFile());
                break;
            }
            case DATA_ONLY: {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(path.toFile()));){
                    col = this.getMimeTypesInputStream(is);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            case NAME_ONLY: {
                col = this.getMimeTypesFileName(path.getFileName().toString());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode : " + (Object)((Object)this.mode));
            }
        }
        return CollectionUtils.getFirst(col);
    }

    public Collection<String> getMimeTypesFileName(String fileName) {
        ArrayList<WeightedMimeType> mimeTypes = new ArrayList<WeightedMimeType>();
        this.lookupMimeTypesForGlobFileName(fileName, mimeTypes);
        return this.normalizeWeightedMimeList(mimeTypes);
    }

    public Collection<String> getMimeTypesFile(File file) throws IOException {
        Collection<String> mimeTypes = this.getMimeTypesFileName(file.getName());
        if (!file.exists()) {
            return mimeTypes;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            return this._getMimeTypes(mimeTypes, is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Collection<String> getMimeTypesInputStream(InputStream in) throws IOException {
        return this.lookupMimeTypesForMagicData(in);
    }

    public Collection<String> getMimeTypesByteArray(byte[] data) {
        return this.lookupMagicData(data);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " using the mime.cache file version [" + this.getMajorVersion() + "." + this.getMinorVersion() + "].";
    }

    public String dump() {
        return "{MAJOR_VERSION=" + this.getMajorVersion() + " MINOR_VERSION=" + this.getMinorVersion() + " ALIAS_LIST_OFFSET=" + this.getAliasListOffset() + " PARENT_LIST_OFFSET=" + this.getParentListOffset() + " LITERAL_LIST_OFFSET=" + this.getLiteralListOffset() + " REVERSE_SUFFIX_TREE_OFFSET=" + this.getReverseSuffixTreeOffset() + " GLOB_LIST_OFFSET=" + this.getGlobListOffset() + " MAGIC_LIST_OFFSET=" + this.getMagicListOffset() + " NAMESPACE_LIST_OFFSET=" + this.getNameSpaceListOffset() + " ICONS_LIST_OFFSET=" + this.getIconListOffset() + " GENERIC_ICONS_LIST_OFFSET=" + this.getGenericIconListOffset() + "}";
    }

    private Collection<String> lookupMimeTypesForMagicData(InputStream in) throws IOException {
        int offset = 0;
        int len = this.getMaxExtents();
        byte[] data = new byte[len];
        in.mark(len);
        try {
            int restBytesToRead = len;
            while (restBytesToRead > 0) {
                int bytesRead = in.read(data, offset, restBytesToRead);
                if (bytesRead < 0) {
                    break;
                }
                offset += bytesRead;
                restBytesToRead -= bytesRead;
            }
        }
        finally {
            in.reset();
        }
        return this.lookupMagicData(data);
    }

    private Collection<String> lookupMagicData(byte[] data) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        int listOffset = this.getMagicListOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 8);
        int i = 0;
        while (i < numEntries) {
            int matchOffset = offset + 16 * i;
            String mimeType = this.compareToMagicData(matchOffset, data);
            if (mimeType != null) {
                mimeTypes.add(mimeType);
            } else {
                String nonMatch = this.getMimeType(this.content.getInt(matchOffset + 4));
                mimeTypes.remove(nonMatch);
            }
            ++i;
        }
        return mimeTypes;
    }

    private String compareToMagicData(int offset, byte[] data) {
        int mimeOffset = this.content.getInt(offset + 4);
        int numMatches = this.content.getInt(offset + 8);
        int matchletOffset = this.content.getInt(offset + 12);
        int i = 0;
        while (i < numMatches) {
            if (this.matchletMagicCompare(matchletOffset + i * 32, data)) {
                return this.getMimeType(mimeOffset);
            }
            ++i;
        }
        return null;
    }

    private boolean matchletMagicCompare(int offset, byte[] data) {
        int n_children = this.content.getInt(offset + 24);
        int child_offset = this.content.getInt(offset + 28);
        if (this.magic_matchlet_compare_to_data(offset, data)) {
            if (n_children == 0) {
                return true;
            }
            int i = 0;
            while (i < n_children) {
                if (this.matchletMagicCompare(child_offset + 32 * i, data)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean magic_matchlet_compare_to_data(int offset, byte[] data) {
        int rangeStart = this.content.getInt(offset);
        int rangeLength = this.content.getInt(offset + 4);
        int dataLength = this.content.getInt(offset + 12);
        int dataOffset = this.content.getInt(offset + 16);
        int maskOffset = this.content.getInt(offset + 20);
        int i = rangeStart;
        while (i <= rangeStart + rangeLength) {
            int j;
            boolean validMatch = true;
            if (i + dataLength > data.length) {
                return false;
            }
            if (maskOffset != 0) {
                j = 0;
                while (j < dataLength) {
                    if ((this.content.get(dataOffset + j) & this.content.get(maskOffset + j)) != (data[j + i] & this.content.get(maskOffset + j))) {
                        validMatch = false;
                        break;
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < dataLength) {
                    if (this.content.get(dataOffset + j) != data[j + i]) {
                        validMatch = false;
                        break;
                    }
                    ++j;
                }
            }
            if (validMatch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void lookupGlobLiteral(String fileName, Collection<WeightedMimeType> mimeTypes) {
        int listOffset = this.getLiteralListOffset();
        int numEntries = this.content.getInt(listOffset);
        int min = 0;
        int max = numEntries - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            String literal = this.getString(this.content.getInt(listOffset + 4 + 12 * mid));
            int cmp = literal.compareTo(fileName);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            String mimeType = this.getMimeType(this.content.getInt(listOffset + 4 + 12 * mid + 4));
            int weight = this.content.getInt(listOffset + 4 + 12 * mid + 8);
            mimeTypes.add(new WeightedMimeType(mimeType, literal, weight));
            return;
        }
    }

    private void lookupGlobFileNameMatch(String fileName, Collection<WeightedMimeType> mimeTypes) {
        int listOffset = this.getGlobListOffset();
        int numEntries = this.content.getInt(listOffset);
        int entriesOffset = listOffset + 4;
        int i = 0;
        while (i < numEntries) {
            int entryOffset = entriesOffset + 12;
            int offset = this.content.getInt(entryOffset);
            int mimeTypeOffset = this.content.getInt(entryOffset + 4);
            int weightNFlags = this.content.getInt(entryOffset + 8);
            int weight = weightNFlags & 0xFF;
            boolean cs = (weightNFlags & 0x100) != 0;
            Pattern pattern = Pattern.compile(this.getString(offset, true), !cs ? 66 : 0);
            if (pattern.matcher(fileName).matches()) {
                String mimeType = this.getMimeType(mimeTypeOffset);
                String globPattern = this.getString(offset, false);
                mimeTypes.add(new WeightedMimeType(mimeType, globPattern, weight));
            }
            ++i;
        }
    }

    private Collection<String> normalizeWeightedMimeList(Collection<WeightedMimeType> weightedMimeTypes) {
        if (weightedMimeTypes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<WeightedMimeType> mimeTypes = new LinkedHashSet<WeightedMimeType>();
        Collections.sort((List)weightedMimeTypes, new Comparator<WeightedMimeType>(){

            @Override
            public int compare(WeightedMimeType obj1, WeightedMimeType obj2) {
                return obj1.weight - obj2.weight;
            }
        });
        int weight = 0;
        int patternLen = 0;
        for (WeightedMimeType mw : weightedMimeTypes) {
            if (weight < mw.weight) {
                weight = mw.weight;
            }
            if (weight < mw.weight) continue;
            if (mw.pattern.length() > patternLen) {
                patternLen = mw.pattern.length();
            }
            mimeTypes.add(mw);
        }
        for (WeightedMimeType mw : weightedMimeTypes) {
            if (mw.pattern.length() >= patternLen) continue;
            mimeTypes.remove(mw);
        }
        HashSet<String> _mimeTypes = new HashSet<String>();
        for (WeightedMimeType mw : mimeTypes) {
            _mimeTypes.add(mw.toString());
        }
        return _mimeTypes;
    }

    private void lookupMimeTypesForGlobFileName(String fileName, Collection<WeightedMimeType> mimeTypes) {
        if (fileName == null) {
            return;
        }
        this.lookupGlobLiteral(fileName, mimeTypes);
        if (!mimeTypes.isEmpty()) {
            return;
        }
        int len = fileName.length();
        this.lookupGlobSuffix(fileName, false, len, mimeTypes);
        if (mimeTypes.isEmpty()) {
            this.lookupGlobSuffix(fileName, true, len, mimeTypes);
        }
        if (mimeTypes.isEmpty()) {
            this.lookupGlobFileNameMatch(fileName, mimeTypes);
        }
    }

    private void lookupGlobSuffix(String fileName, boolean ignoreCase, int len, Collection<WeightedMimeType> mimeTypes) {
        int listOffset = this.getReverseSuffixTreeOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 4);
        this.lookupGlobNodeSuffix(fileName, numEntries, offset, ignoreCase, len, mimeTypes, new StringBuffer());
    }

    private void lookupGlobNodeSuffix(String fileName, int numEntries, int offset, boolean ignoreCase, int len, Collection<WeightedMimeType> mimeTypes, StringBuffer pattern) {
        char character;
        char c = character = ignoreCase ? fileName.toLowerCase().charAt(len - 1) : fileName.charAt(len - 1);
        if (character == '\u0000') {
            return;
        }
        int min = 0;
        int max = numEntries - 1;
        while (max >= min && len >= 0) {
            int mid = (min + max) / 2;
            char matchChar = (char)this.content.getInt(offset + 12 * mid);
            if (ignoreCase) {
                matchChar = Character.toLowerCase(matchChar);
            }
            if (matchChar < character) {
                min = mid + 1;
                continue;
            }
            if (matchChar > character) {
                max = mid - 1;
                continue;
            }
            int numChildren = this.content.getInt(offset + 12 * mid + 4);
            int firstChildOffset = this.content.getInt(offset + 12 * mid + 8);
            if (--len > 0) {
                pattern.append(matchChar);
                this.lookupGlobNodeSuffix(fileName, numChildren, firstChildOffset, ignoreCase, len, mimeTypes, pattern);
            }
            if (mimeTypes.isEmpty()) {
                int i = 0;
                while (i < numChildren) {
                    boolean cs;
                    int childOffset = firstChildOffset + 12 * i;
                    if (this.content.getInt(childOffset) != 0) break;
                    int mimeOffset = this.content.getInt(childOffset + 4);
                    int weightNFlags = this.content.getInt(childOffset + 8);
                    int weight = weightNFlags & 0xFF;
                    boolean bl = cs = (weightNFlags & 0x100) != 0;
                    if (!cs || !ignoreCase) {
                        mimeTypes.add(new WeightedMimeType(this.getMimeType(mimeOffset), pattern.toString(), weight));
                    }
                    ++i;
                }
            }
            return;
        }
    }

    private int getMaxExtents() {
        return this.content.getInt(this.getMagicListOffset() + 4);
    }

    private String aliasLookup(String alias) {
        int aliasListOffset = this.getAliasListOffset();
        int min = 0;
        int max = this.content.getInt(aliasListOffset) - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            int aliasOffset = this.content.getInt(aliasListOffset + 4 + mid * 8);
            int mimeOffset = this.content.getInt(aliasListOffset + 4 + mid * 8 + 4);
            int cmp = this.getMimeType(aliasOffset).compareTo(alias);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            return this.getMimeType(mimeOffset);
        }
        return null;
    }

    private String unaliasMimeType(String mimeType) {
        String lookup = this.aliasLookup(mimeType);
        return lookup == null ? mimeType : lookup;
    }

    private boolean isMimeTypeSubclass(String mimeType, String subClass) {
        String umimeType = this.unaliasMimeType(mimeType);
        String usubClass = this.unaliasMimeType(subClass);
        MimeType _mimeType = new MimeType(umimeType);
        MimeType _subClass = new MimeType(usubClass);
        if (umimeType.compareTo(usubClass) == 0) {
            return true;
        }
        if (this.isSuperType(usubClass) && _mimeType.getMediaType().equals(_subClass.getMediaType())) {
            return true;
        }
        if (usubClass.equals("text/plain") && _mimeType.getMediaType().equals("text")) {
            return true;
        }
        if (usubClass.equals("application/octet-stream")) {
            return true;
        }
        int parentListOffset = this.getParentListOffset();
        int numParents = this.content.getInt(parentListOffset);
        int min = 0;
        int max = numParents - 1;
        while (max >= min) {
            int med = (min + max) / 2;
            int offset = this.content.getInt(parentListOffset + 4 + 8 * med);
            String parentMime = this.getMimeType(offset);
            int cmp = parentMime.compareTo(umimeType);
            if (cmp < 0) {
                min = med + 1;
                continue;
            }
            if (cmp > 0) {
                max = med - 1;
                continue;
            }
            offset = this.content.getInt(parentListOffset + 4 + 8 * med + 4);
            int _numParents = this.content.getInt(offset);
            int i = 0;
            while (i < _numParents) {
                int parentOffset = this.content.getInt(offset + 4 + 4 * i);
                if (this.isMimeTypeSubclass(this.getMimeType(parentOffset), usubClass)) {
                    return true;
                }
                ++i;
            }
            break block0;
        }
        return false;
    }

    private boolean isSuperType(String mimeType) {
        return mimeType.endsWith("/*");
    }

    private int getGenericIconListOffset() {
        return this.content.getInt(36);
    }

    private int getIconListOffset() {
        return this.content.getInt(32);
    }

    private int getNameSpaceListOffset() {
        return this.content.getInt(28);
    }

    private int getMagicListOffset() {
        return this.content.getInt(24);
    }

    private int getGlobListOffset() {
        return this.content.getInt(20);
    }

    private int getReverseSuffixTreeOffset() {
        return this.content.getInt(16);
    }

    private int getLiteralListOffset() {
        return this.content.getInt(12);
    }

    private int getParentListOffset() {
        return this.content.getInt(8);
    }

    private int getAliasListOffset() {
        return this.content.getInt(4);
    }

    private short getMinorVersion() {
        return this.content.getShort(2);
    }

    private short getMajorVersion() {
        return this.content.getShort(0);
    }

    private String getMimeType(int offset) {
        return this.getString(offset);
    }

    private String getString(int offset) {
        return this.getString(offset, false);
    }

    private String getString(int offset, boolean regularExpression) {
        int position = this.content.position();
        this.content.position(offset);
        StringBuffer buf = new StringBuffer();
        char c = '\u0000';
        while ((c = (char)this.content.get()) != '\u0000') {
            if (regularExpression) {
                switch (c) {
                    case '.': {
                        buf.append("\\");
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        buf.append(".");
                    }
                }
            }
            buf.append(c);
        }
        this.content.position(position);
        if (regularExpression) {
            buf.insert(0, '^');
            buf.append('$');
        }
        return buf.toString();
    }

    private Collection<String> _getMimeTypes(Collection<String> mimeTypes, InputStream in) throws IOException {
        Collection<String> _mimeTypes;
        if ((mimeTypes.isEmpty() || mimeTypes.size() > 1) && !(_mimeTypes = this.getMimeTypesInputStream(in)).isEmpty()) {
            if (!mimeTypes.isEmpty()) {
                for (String mimeType : mimeTypes) {
                    if (_mimeTypes.contains(mimeType)) {
                        mimeTypes.add(mimeType);
                    }
                    for (String _mimeType : _mimeTypes) {
                        if (!this.isMimeTypeSubclass(mimeType, _mimeType)) continue;
                        mimeTypes.add(mimeType);
                    }
                }
            } else {
                return _mimeTypes;
            }
        }
        return mimeTypes;
    }

    public static enum Mode {
        RECOMMENDED,
        DATA_ONLY,
        NAME_ONLY;

    }

    static class WeightedMimeType
    extends MimeType {
        private static final long serialVersionUID = 1L;
        String pattern;
        int weight;

        WeightedMimeType(String mimeType, String pattern, int weight) {
            super(mimeType);
            this.pattern = pattern;
            this.weight = weight;
        }
    }
}

